$(document).ready(function() {
    $("#resultados").load("../ajax/tmp_pos.php");
    $("#pos").load("../ajax/mis_pos.php");
    $("#total_pos").load("../ajax/carga_total_pos.php");
    $("#f_resultado").load("../ajax/incrementa_factura.php");
    $("#resultados2").load("../ajax/carga_caja.php");
    $("#resultados3").load("../ajax/carga_resibido.php");
    $("#resultados4").load("../ajax/tipo_doc.php");
    $("#resultados5").load("../ajax/carga_num_trans.php");
    $("#resultados6").load("../ajax/carga_comprobantes.php");
    $("#resultados7").load("../ajax/carga_cierre.php");
    $("#total").load("../ajax/carga_total_venta.php");
    $("#outer_comprobante").load("../ajax/carga_correlativoDefault.php");
    $("#datos_factura").load();
    $("#barcode").focus();
    load(1);
});

function load(page) {
    var linea_id=$("#linea_id").val();
    var q = $("#q").val();
    $(".loader").fadeIn('slow');
    $.ajax({
        url: '../ajax/productos_pos.php?action=ajax&page=' + page + '&q=' + q + '&linea_id=' + linea_id,
        beforeSend: function(objeto) {
            $('.loader').html('<img src="../../img/ajax-loader.gif"> Cargando...');
        },
        success: function(data) {
            $(".outer_div").html(data).fadeIn('slow');
            $('.loader').html('');
        }
    })
}

function agregar(id) {
    var precio_venta = document.getElementById('precio_venta_' + id).value;
    var cantidad = document.getElementById('cantidad_' + id).value;
    //Inicia validacion
    if (isNaN(cantidad)) {
        $.Notification.notify('error', 'bottom center', 'NOTIFICACIÓN', 'LA CANTIDAD NO ES UN NUMERO, INTENTAR DE NUEVO')
        document.getElementById('cantidad_' + id).focus();
        return false;
    }
    if (isNaN(precio_venta)) {
        $.Notification.notify('error', 'bottom center', 'NOTIFICACIÓN', 'EL PRECIO NO ES UN NUMERO, INTENTAR DE NUEVO')
        document.getElementById('precio_venta_' + id).focus();
        return false;
    }
    //Fin validacion
    $.ajax({
        type: "POST",
        url: "../ajax/tmp_pos.php",
        data: "id=" + id + "&precio_venta=" + precio_venta + "&cantidad=" + cantidad + "&operacion=" + 2,
        beforeSend: function(objeto) {
            $("#resultados").html('<img src="../../img/ajax-loader.gif"> Cargando...');
        },
        success: function(datos) {
            $("#resultados").html(datos);
            $("#total").load("../ajax/carga_total_venta.php");
            $("#total_pos").load("../ajax/carga_total_pos.php");
        }
    });
}


function eliminar(id) {
    $.ajax({
        type: "GET",
        url: "../ajax/tmp_pos.php",
        data: "id=" + id,
        beforeSend: function(objeto) {
            $("#resultados").html('<img src="../../img/ajax-loader.gif"> Cargando...');
        },
        success: function(datos) {
            $("#resultados").html(datos);
            $("#total").load("../ajax/carga_total_venta.php");
            $("#total_pos").load("../ajax/carga_total_pos.php");
        }
    });
}

//GUARDAMOS LOS PEDIDOS DEL POS
$("#btn_pos").off("click");
$("#btn_pos").on("click", function(e) {
    $('#btn_pos').attr("disabled", true);
    var id_cliente = $("#id_cliente").val();
    if (id_cliente == "") {
        $.Notification.notify('warning', 'bottom center', 'NOTIFICACIÓN', 'DEBE SELECCIONAR UN CLIENTE VALIDO')
        $("#nombre_cliente").focus();
        $('#guardar_pos').attr("disabled", false);
        return false;
    }
    parametros = {
        'id_cliente': id_cliente
    };
    $.ajax({
        type: "POST",
        url: "../ajax/guardar_pos.php",
        data: parametros,
        beforeSend: function(objeto) {
            $("#resultados_ajaxf").html('<img src="../../img/ajax-loader.gif"> Cargando...');
        },
        success: function(datos) {
            $("#resultados_ajaxf").html(datos);
            $('#btn_pos').attr("disabled", false);
            $("#nombre_cliente").val('');
            $("#resultados").load("../ajax/tmp_pos.php"); // carga los datos nuevamente
            $("#f_resultado").load("../ajax/incrementa_factura.php"); // carga la caja de incrementar la factura
            $("#resultados2").load("../ajax/carga_caja.php"); // carga la caja total del dia
            $("#pos").load("../ajax/mis_pos.php");
            $("#total_pos").load("../ajax/carga_total_pos.php");
            load(1);
                    //desaparecer la alerta
                    $(".alert-success").delay(400).show(10, function() {
                        $(this).delay(2000).hide(10, function() {
                            $(this).remove();
                        });
                    }); // /.alert
                }
            });
    event.preventDefault();
});

$("#guardar_cliente").submit(function(event) {
    $('#guardar_datos').attr("disabled", true);
    var parametros = $(this).serialize();
    $.ajax({
        type: "POST",
        url: "../ajax/nuevo_cliente.php",
        data: parametros,
        beforeSend: function(objeto) {
            $("#resultados_ajax").html('<img src="../../img/ajax-loader.gif"> Cargando...');
        },
        success: function(datos) {
            $("#resultados_ajax").html(datos);
            $('#guardar_datos').attr("disabled", false);
            //resetea el formulario
            $("#guardar_cliente")[0].reset();
            //desaparecer la alerta
            $(".alert-success").delay(400).show(10, function() {
                $(this).delay(2000).hide(10, function() {
                    $(this).remove();
                });
            }); // /.alert
            load(1);
        }
    });
    event.preventDefault();
})
$("#guardar_producto").submit(function(event) {
    $('#guardar_datos').attr("disabled", true);
    var parametros = $(this).serialize();
    $.ajax({
        type: "POST",
        url: "../ajax/nuevo_producto.php",
        data: parametros,
        beforeSend: function(objeto) {
            $("#resultados_ajax_productos").html('<img src="../../img/ajax-loader.gif"> Cargando...');
        },
        success: function(datos) {
            $("#resultados_ajax_productos").html(datos);
            $('#guardar_datos').attr("disabled", false);
            //resetea el formulario
            $("#guardar_producto")[0].reset();
            //desaparecer la alerta
            $(".alert-success").delay(400).show(10, function() {
                $(this).delay(2000).hide(10, function() {
                    $(this).remove();
                });
            }); // /.alert
            load(1);
        }
    });
    event.preventDefault();
})

$('#dataDelete').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget) // Botón que activó el modal
            var id = button.data('id') // Extraer la información de atributos de datos
            var modal = $(this)
            modal.find('#id_orden').val(id)
        })
        $("#eliminarDatos").submit(function(event) {
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "../ajax/eliminar_orden.php",
                data: parametros,
                beforeSend: function(objeto) {
                    $(".datos_ajax_delete").html('<img src="../../img/ajax-loader.gif"> Cargando...');
                },
                success: function(datos) {
                    $(".datos_ajax_delete").html(datos);
                    $('#dataDelete').modal('hide');
                    $("#pos").load("../ajax/mis_pos.php");
                    load(1);
                    //desaparecer la alerta
                    window.setTimeout(function() {
                        $(".alert").fadeTo(200, 0).slideUp(200, function() {
                            $(this).remove();
                        });
                    }, 2000);
                }
            });
            event.preventDefault();
        });

function imprimir_factura(user_id) {
    VentanaCentrada('../pdf/documentos/corte_caja.php?user_id=' + user_id, 'Corte', '', '724', '568', 'true');
}