<?php
include 'is_logged.php';
require_once "../db.php";
require_once "../php_conexion.php";
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Categorias";
permisos($modulo, $cadena_permisos);
require_once "../funciones.php";
$id_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);

$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    $q = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $sTable = "tmp_comandas tc";
    $sWhere = "LEFT JOIN mesas m ON tc.mesa_comanda = m.id_mesa ORDER BY tc.id_comanda DESC";
    include 'pagination.php';

    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable $sWhere");
    $row = mysqli_fetch_array($count_query);
    $numrows = $row['numrows'];

    $reload = '../html/control_comandas.php';
    $sql = "SELECT tc.*, m.nombre_mesa, m.id_mesa FROM $sTable $sWhere LIMIT 20";
    $query = mysqli_query($conexion, $sql);

    if ($numrows > 0) {
        ?>
        <div class="row">
           <?php
            $last_comanda_query = mysqli_query($conexion, "SELECT MAX(id_comanda) as last_id FROM tmp_comandas");     
            $last_comanda = mysqli_fetch_array($last_comanda_query);
            $last_comanda_id = $last_comanda['last_id'];
            
            $comandas_con_productos = 0; // Contador de comandas con productos

            while ($row = mysqli_fetch_array($query)) {
                $id_comanda = $row['id_comanda'];
                $mesa_comanda = $row['mesa_comanda'];
                $mesa_id = $row['id_mesa'];
                $mesa_nombre = $row['nombre_mesa'];
                $mesa = ($mesa_comanda == '') ? $row['num_pedido'] : $mesa_nombre;
                $mesa_id = ($mesa_comanda == '') ? $row['num_pedido'] : $mesa_comanda;
                $texto = ($mesa_comanda == '') ? 'PEDIDO #'.$mesa : ''.$mesa;
                $bg = ($row['estado_comanda'] == 1) ? 'background-color: #D4EFDF' : 'background-color: #FADBD8';
                $is_new = ($id_comanda > ($last_comanda_id - 5)) ? 'nueva-comanda' : '';

                // Verificar si hay productos en tmp_mesa para esta comanda
                $mesa_valida = null;
                $countProductos = 0;
                
                // 1. Buscar por mesa_comanda
                if ($mesa_comanda != '') {
                    $orderSql = "SELECT COUNT(*) as total FROM tmp_mesa WHERE mesa_tmp = '$mesa_comanda'";
                    $orderQuery = $conexion->query($orderSql);
                    $result = $orderQuery->fetch_assoc();
                    $countProductos = $result['total'];
                    if ($countProductos > 0) {
                        $mesa_valida = $mesa_comanda;
                    }
                }
                
                // 2. Si no hay por mesa_comanda, buscar por num_pedido
                if ($countProductos == 0 && !empty($row['num_pedido'])) {
                    $orderSql = "SELECT COUNT(*) as total FROM tmp_mesa WHERE mesa_tmp = '".$row['num_pedido']."'";
                    $orderQuery = $conexion->query($orderSql);
                    $result = $orderQuery->fetch_assoc();
                    $countProductos = $result['total'];
                    if ($countProductos > 0) {
                        $mesa_valida = $row['num_pedido'];
                    }
                }
                
                // 3. Si aún no hay, buscar por id_comanda
                if ($countProductos == 0) {
                    $orderSql = "SELECT COUNT(*) as total FROM tmp_mesa WHERE mesa_tmp = '$id_comanda'";
                    $orderQuery = $conexion->query($orderSql);
                    $result = $orderQuery->fetch_assoc();
                    $countProductos = $result['total'];
                    if ($countProductos > 0) {
                        $mesa_valida = $id_comanda;
                    }
                }
                
                // Solo mostrar la comanda si hay productos en tmp_mesa
                if ($countProductos > 0) {
                    $comandas_con_productos++;
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="widget-simple text-center card-box" style="<?php echo $bg; ?>">
                            <h3 class="font-bold mt-0">Pedido: <?php echo $id_comanda; ?></h3>
                            <h5 class="font-bold mt-0"><?php echo $texto; ?></h5>
                            <table style="width:100%; font-size:13px; font-family:'Lucida Sans Unicode', 'Lucida Grande', sans-serif" border="0">
                                <tr><td colspan="3"><center><hr style="margin:5px 0; border-top:1px solid #ddd;"></center></td></tr>
                                <tr>
                                    <td width="15%">Cant.</td>
                                    <td width="45%">Descripción</td>
                                    <td width="40%" align="left">Notas</td>
                                </tr>
                                <tr><td colspan="3"><center><hr style="margin:5px 0; border-top:1px solid #ddd;"></center></td></tr>
                                <?php
                                $sql_principal = mysqli_query($conexion, "SELECT DISTINCT identificativo FROM tmp_mesa WHERE mesa_tmp = '$mesa_valida'");
                                while ($rw = mysqli_fetch_array($sql_principal)) {
                                    $identificativo = $rw['identificativo'];
                                    ?>
                                    <tr><td colspan="3" align="left"><b>Cuenta: <?php echo $identificativo; ?></b></td></tr>
                                    <?php
                                    $sql_secundaria = "SELECT tm.*, p.nombre_producto 
                                                       FROM tmp_mesa tm
                                                       JOIN productos p ON p.id_producto = tm.producto_tmp 
                                                       WHERE tm.mesa_tmp = '$mesa_valida' 
                                                       AND tm.identificativo = '$identificativo'";
                                    $sql_secundaria_result = mysqli_query($conexion, $sql_secundaria);
                                    
                                    while ($producto = mysqli_fetch_array($sql_secundaria_result)) {
                                        $color = ($producto['status_tmp'] != 1) ? 'table-danger' : '';
                                        $badge = ($producto['status_tmp'] != 1) ? 'danger' : 'purple';
                                        $img = ($producto['new_cant'] > 0) ? '<img src="../../img/gif.gif" width="20%">' : '';
                                        $vista = ($producto['new_cant'] > 0) ? $producto['new_cant'] : '';
                                        $hasDetail = !empty($producto['detalle']);
                                        ?>
                                        <tr class="<?php echo $color; ?>">
                                            <td><span class="badge badge-pill badge-<?php echo $badge; ?>"><?php echo $producto['cant_tmp']; ?></span></td>
                                            <td align="left">
                                                <?php echo $producto['nombre_producto']; ?> 
                                                <?php echo $img; ?>
                                                <?php if($vista != ''): ?>
                                                    <span class="badge badge-pill badge-danger"><?php echo $vista; ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td align="left">
                                                <?php if($hasDetail): ?>
                                                    <small style="color: #555; font-style: italic; display: block; text-align: left;"><?php echo htmlspecialchars($producto['detalle']); ?></small>
                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                }
                                ?>
                                <tr><td colspan="3"><center><hr style="margin:5px 0; border-top:1px solid #ddd;"></center></td></tr>
                                <tr>
                                    <td align="center" colspan="3">TOTAL ITEMS: <span class="badge badge-pill badge-purple"><?php echo $countProductos; ?></span></td>
                                </tr>
                            </table>
                            <button type="button" class="btn btn-block btn--md btn-danger waves-effect waves-light" onclick="estado_tmp('<?php echo $mesa_id; ?>');">Procesar Pedido</button>
                        </div>
                    </div>
                    <?php
                }
            }
            
            // Si no hay comandas con productos
            if ($comandas_con_productos == 0) {
                ?>
                <div class="col-12">
                    <div class="alert alert-warning alert-dismissible" role="alert" align="center">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <strong>Aviso!</strong> No hay pedidos con productos registrados
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
        <?php
    } else {
        ?>
        <div class="alert alert-warning alert-dismissible" role="alert" align="center">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <strong>Aviso!</strong> No hay Registro de Pedidos
        </div>
        <?php
    }
}
?>