<?php
/*-------------------------
Autor: Delmar Lopez
Web: www.softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Ventas";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q      = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $sTable = "facturas_cot, clientes, users";
    $sWhere = "";
    $sWhere .= " WHERE facturas_cot.id_cliente=clientes.id_cliente and facturas_cot.id_vendedor=users.id_users";
    if ($_GET['q'] != "") {
        $sWhere .= " and  (clientes.nombre_cliente like '%$q%' or facturas_cot.numero_factura like '%$q%')";

    }

    $sWhere .= " order by facturas_cot.id_factura desc";
    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 10; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../reportes/facturas.php';
    //main query to fetch the data
    $sql   = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    //loop through fetched data
    if ($numrows > 0) {
        echo mysqli_error($conexion);
        ?>
        <div class="table-responsive">
          <table class="table table-sm table-striped">
             <tr  class="info">
                <th>#PEDIDO</th>
                <th>DETALLE</th>
                <th class='text-center'>TOTAL</th>
                <th>HORA ENTREGA</th>
                <th>CLIENTE</th>
                <th>USUARIO</th>
                <th>ENTREGA</th>
                <th>METODO DE PAGO</th>
                <th>FACTURADO</th>
                <th></th>

            </tr>
            <?php
while ($row = mysqli_fetch_array($query)) {
            $id_factura       = $row['id_factura'];
            $numero_factura   = $row['numero_factura'];
            $fecha            = date("d/m/Y", strtotime($row['fecha_factura']));
            $nombre_cliente   = $row['nombre_cliente'];
            $id_cliente       = $row['id_cliente'];
            $telefono_cliente = $row['telefono_cliente'];
            $email_cliente    = $row['email_cliente'];
            $nombre_vendedor  = $row['nombre_users'] . " " . $row['apellido_users'];
            $estado_factura   = $row['estado_factura'];
            $condiciones      = $row['condiciones'];
            $estado_pedido    = $row['est_cot'];
            $start            = $row['start_cot'];
            $end              = $row['end_cot'];
            $total_venta      = $row['monto_factura'];
             // Array para mapear los valores a sus nombres
             $nombreCondiciones = [
                1 => 'Efectivo',
                2 => 'Cheque',
                3 => 'Transferencia bancaria',
                4 => 'Crédito',
                5 => 'Pedidos ya'
            ];

            // Obtener el nombre correspondiente, o 'Desconocido' si no existe
            $nombreCondicion = $nombreCondiciones[$condiciones] ?? 'Desconocido';
            if ($estado_pedido == 2) {
                $btn  = 'disabled';
                $text = 'PROCESADO';
            } else {
                $btn  = '';
                $text = 'FACTURAR';
            }

            if ($estado_factura == 1) {
                $text_estado = "CONTADO";
                $label_class = 'badge-success';} else {
                $text_estado = "CREDITO";
                $label_class = 'badge-danger';}

            $simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
            ?>
            <input type="hidden" value="<?php echo $id_cliente; ?>" id="id_cliente<?php echo $id_factura; ?>">
            <input type="hidden" value="<?php echo $id_factura; ?>" id="id_fact<?php echo $id_factura; ?>">
            <input type="hidden" value="<?php echo $condiciones; ?>" id="condiciones<?php echo $id_factura; ?>">
            <input type="hidden" value="0" id="resibido<?php echo $id_factura; ?>">
            <input type="hidden" value="<?php echo $total_venta; ?>" id="total_ft<?php echo $id_factura; ?>">
                        <tr>
                         <td><label class='badge badge-purple'><?php echo $numero_factura; ?></label></td>
                         <?php
$result = mysqli_query($conexion, "SELECT cantidad, nombre_producto FROM detalle_fact_cot, productos WHERE detalle_fact_cot.id_producto = productos.id_producto AND id_factura = '$id_factura'");

echo '<td style="background-color: #F2D7D5; font-size: 11px;">';
while ($roww = mysqli_fetch_array($result)) {
    echo $roww['cantidad'] . ' - ' . $roww['nombre_producto'] . '<br>'; // Muestra cantidad antes del nombre
}
echo '</td>';
?>

<td class='text-left'><b><?php echo $simbolo_moneda . '' . number_format($total_venta, 2); ?></b></td>
                         <td><?php echo $end; ?></td>
                         <td><?php echo $nombre_cliente; ?></td>
                         <td><?php echo $nombre_vendedor; ?></td>
                          <td><?php echo estado_res($estado_pedido); ?></td>

                         <td><?php echo $nombreCondicion; ?></td>

<td><button type="button" class="btn btn-success btn-sm waves-effect waves-light" data-toggle="modal" data-target="#facturarPed" onclick="obtener_datos('<?php echo $id_factura; ?>');" <?php echo $btn; ?>><?php echo $text; ?></button></td>
                         <td class="text-center">
                          <div class="btn-group dropdown">
                            <button type="button" class="btn btn-warning btn-sm dropdown-toggle waves-effect waves-light" data-toggle="dropdown" aria-expanded="false"> <i class='fa fa-cog'></i> <i class="caret"></i> </button>
                            <div class="dropdown-menu dropdown-menu-right">
                               <?php if ($permisos_editar == 1) {?>
                               <a class="dropdown-item" href="editar_cotizacion.php?id_factura=<?php echo $id_factura; ?>"><i class='fa fa-edit'></i> Ver</a>
                               <a class="dropdown-item" href="#" onclick="printOrder('<?php echo $id_factura; ?>');"><i class='fa fa-print'></i> Imprimir</a>
                               <?php }
            if ($permisos_eliminar == 1) {?>
                               <!--<a class="dropdown-item" href="#" data-toggle="modal" data-target="#dataDelete" data-id="<?php echo $row['id_factura']; ?>"><i class='fa fa-trash'></i> Eliminar</a>-->
                               <?php }?>


                           </div>
                       </div>

                   </td>


               </tr>
               <?php
}
        ?>
           <tr>
              <td colspan=10><span class="pull-right"><?php
echo paginate($reload, $page, $total_pages, $adjacents);
        ?></span></td>
            </tr>
        </table>
    </div>
    <?php
}
//Este else Fue agregado de Prueba de prodria Quitar
    else {
        ?>
    <div class="alert alert-warning alert-dismissible" role="alert" align="center">
      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <strong>Aviso!</strong> No hay Registro de Cotizaciones
  </div>
  <?php
}
// fin else
}
?>