<?php
include 'is_logged.php'; // Verifica si el usuario está logueado

// Iniciar la sesión
$session_id = session_id();

// Conectar a la base de datos
require_once "../db.php";
require_once "../php_conexion.php";

// Obtener el número de mesa de la sesión
$numero_mesa = $_SESSION['numero_mesa'];

// Consultar la base de datos para obtener los identificativos
$sql_ident = "SELECT identificativo, id_tmp FROM tmp_mesa WHERE mesa_tmp = $numero_mesa";
$query_ident = mysqli_query($conexion, $sql_ident);

// Crear un array para agrupar las mesas por identificativo
$mesas_agrupadas = array();

// Iterar sobre los resultados y agrupar las mesas por identificativo
while ($rw = mysqli_fetch_array($query_ident)) {
    $identificativo = $rw['identificativo'];
    $id_tmp = $rw['identificativo'];
    $mesas_agrupadas[$identificativo][] = $id_tmp;
}
?>

<select class="form-control UpperCase" id="identificativoSelect" name="identificativoSelect">
    <option value="">Todo</option>
    <?php
    // Iterar sobre el array de mesas agrupadas y generar las opciones del select
    foreach ($mesas_agrupadas as $identificativo => $ids) {
        // Solo se muestra un identificativo por opción
        echo '<option value="' . reset($ids) . '">' . $identificativo . '</option>';
    }
    ?>
</select>

<script>
    $(document).ready(function() {
        // Función para manejar el envío del formulario
        function submitForm(event) {
            event.preventDefault(); // Prevenir el envío del formulario por defecto
            var formData = $(this).serialize(); // Obtener datos del formulario
            $.ajax({
                type: 'POST',
                url: '../ajax/agregar_mesa_tmp.php',
                data: formData,
                success: function(response) {
                    // Actualizar la tabla con la respuesta del servidor
                    $('#resultados').html(response);
                }
            });
        }

        // Manejar el cambio en el select
        $('#identificativoSelect').change(function() {
            $('#barcode_form').submit(); // Envía el formulario cuando cambia el select
        });

        // Manejar el envío del formulario
        $('#barcode_form').submit(submitForm);
    });
</script>

