<?php
// eliminar_combo.php

// Verificar si se recibió el ID del combo
if (isset($_POST['id_combo_producto'])) {
    $id_combo_producto = $_POST['id_combo_producto'];

   
    /* Connect To Database*/
    require_once "../db.php";
    require_once "../php_conexion.php";

   // Preparar la consulta para eliminar el combo
   $query = "DELETE FROM combo_productos WHERE id_combo_producto = ?";
   $stmt = $conexion->prepare($query);

   if ($stmt) {
       // Vincular el parámetro
       $stmt->bind_param("i", $id_combo_producto);

       // Ejecutar la consulta
       if ($stmt->execute()) {
           echo json_encode(["success" => true, "message" => "Combo eliminado correctamente."]);
       } else {
           echo json_encode(["success" => false, "message" => "Error al eliminar el combo: " . $stmt->error]);
       }

       // Cerrar la declaración
       $stmt->close();
   } else {
       echo json_encode(["success" => false, "message" => "Error al preparar la consulta: " . $conexion->error]);
   }

   // Cerrar la conexión
   $conexion->close();
} else {
   echo json_encode(["success" => false, "message" => "ID del combo no proporcionado."]);
}
?>