<?php
include 'is_logged.php'; // Verifica que el usuario está logueado
require_once "../db.php";
require_once "../php_conexion.php";

// Validaciones básicas
if (empty($_POST['codigo'])) {
    $errors[] = "Código vacío";
} else {
    // Datos generales del combo
    $codigo          = mysqli_real_escape_string($conexion, trim($_POST["codigo"]));
    $nombre          = mysqli_real_escape_string($conexion, trim($_POST["nombre"]));
    $descripcion     = mysqli_real_escape_string($conexion, trim($_POST["descripcion"]));
    $linea           = intval($_POST['linea']);
    $estado          = intval($_POST['estado']);
    $impuesto        = intval($_POST['impuesto']);
    $costo           = floatval($_POST['costo']);
    $precio_venta    = floatval($_POST['precio']);
    $stock           = floatval($_POST['stock']);
    $stock_minimo    = floatval($_POST['minimo']);
    $date_added      = date("Y-m-d H:i:s");
    $vista           = intval($_POST['vista']);
    $combo           = 'si';

    // Verificar si el combo ya existe
    $sql_check = "SELECT id_producto FROM productos WHERE codigo_producto = '$codigo'";
    $query_check = mysqli_query($conexion, $sql_check);
    $row = mysqli_fetch_assoc($query_check);
    $id_combo = $row['id_producto'] ?? null;

    if ($id_combo) {
        // Si ya existe, actualizamos
        $sql_update = "UPDATE productos SET 
                        nombre_producto='$nombre', 
                        descripcion_producto='$descripcion',
                        id_linea_producto='$linea',
                        iva_producto='$impuesto',
                        estado_producto='$estado',
                        costo_producto='$costo',
                        valor1_producto='$precio_venta',
                        stock_producto='$stock',
                        stock_min_producto='$stock_minimo',
                        vista='$vista'
                        WHERE id_producto='$id_combo'";
        $query_update = mysqli_query($conexion, $sql_update);
    } else {
        // Si no existe, lo insertamos
        $sql_insert = "INSERT INTO productos 
                        (codigo_producto, nombre_producto, descripcion_producto, id_linea_producto, 
                        iva_producto, estado_producto, costo_producto, valor1_producto, stock_producto, 
                        stock_min_producto, date_added, vista, combo)
                        VALUES 
                        ('$codigo', '$nombre', '$descripcion', '$linea', '$impuesto', '$estado', '$costo', 
                        '$precio_venta', '$stock', '$stock_minimo', '$date_added', '$vista', '$combo')";
        $query_insert = mysqli_query($conexion, $sql_insert);

        // Obtener el ID del combo insertado
        if ($query_insert) {
            $id_combo = mysqli_insert_id($conexion);
        }
    }

    if ($id_combo) {
        // Primero, eliminamos los productos anteriores del combo si es una actualización
        mysqli_query($conexion, "DELETE FROM combo_productos WHERE id_combo = '$id_combo'");

        // Insertar productos en la tabla combo_productos
        if (!empty($_POST['producto']) && is_array($_POST['producto'])) {
            foreach ($_POST['producto'] as $index => $producto_id) {
                $cantidad = intval($_POST['cantidad'][$index]);
                if (!empty($producto_id) && $cantidad > 0) {
                    $sql_insert_combo = "INSERT INTO combo_productos (id_combo, id_producto, cantidad) 
                                         VALUES ('$id_combo', '$producto_id', '$cantidad')";
                    mysqli_query($conexion, $sql_insert_combo);
                }
            }
        }
    }

    if ($query_insert || $query_update) {
        $messages[] = "El combo ha sido guardado correctamente.";
    } else {
        $errors[] = "Hubo un error al guardar el combo. " . mysqli_error($conexion);
    }
}

// Mensajes de error o éxito
if (isset($errors)) {
    echo '<div class="alert alert-danger"><strong>Error!</strong> ' . implode("<br>", $errors) . '</div>';
}

if (isset($messages)) {
    echo '<div class="alert alert-success"><strong>¡Bien hecho!</strong> ' . implode("<br>", $messages) . '</div>';
}


?>