<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
    header("location: ../../login.php");
    exit;
}
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Comandas";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$title  = "Comandas";
$ventas = 1;
?>

<?php require 'includes/header_start.php';?>

<?php require 'includes/header_end.php';?>

<!-- Begin page -->
<div id="wrapper" class="forced enlarged"> <!-- DESACTIVA EL MENU -->

	<?php require 'includes/menu.php';?>

	<!-- ============================================================== -->
	<!-- Start right Content here -->
	<!-- ============================================================== -->
	<div class="content-page">
		<!-- Start content -->
		<div class="content">
			<div class="container">
				<?php if ($permisos_ver == 1) {
    ?>
					<div class="col-lg-12">
						<div class="portlet">
							<div class="portlet-heading bg-primary">
								<h3 class="portlet-title">
									Bítocora de Comandas
								</h3>
								<div class="portlet-widgets">
									<a href="javascript:;" data-toggle="reload"><i class="ion-refresh"></i></a>
									<span class="divider"></span>
									<a data-toggle="collapse" data-parent="#accordion1" href="#bg-primary"><i class="ion-minus-round"></i></a>
									<span class="divider"></span>
									<a href="#" data-toggle="remove"><i class="ion-close-round"></i></a>
								</div>
								<div class="clearfix"></div>
							</div>
							<div id="bg-primary" class="panel-collapse collapse show">
								<div class="portlet-body">
									<?php
include "../modal/eliminar_factura.php";
    ?>
									<div class="row">
										<div class="col-lg-7">
											<div class="card-box">

												<div class="datos_ajax_delete"></div><!-- Datos ajax Final -->
												<div class='outer_div'></div><!-- Carga los datos ajax -->



											</div>
										</div>
										<div class="col-lg-5">
											<div class="card-box">
												<div class='detalle'></div><!-- Carga los datos ajax -->
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php
} else {
    ?>
					<section class="content">
						<div class="alert alert-danger" align="center">
							<h3>Acceso denegado! </h3>
							<p>No cuentas con los permisos necesario para acceder a este módulo.</p>
						</div>
					</section>
					<?php
}
?>

			</div>
			<!-- end container -->
		</div>
		<!-- end content -->

		<?php require 'includes/pie.php';?>

	</div>
	<!-- ============================================================== -->
	<!-- End Right content here -->
	<!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui-->
<!-- ============================================================== -->
<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<script type="text/javascript" src="../../js/bitacora_comandas.js"></script>
<script>
	function estado_tmp(numero_mesa)
	{

		$(".outer_div").load("../ajax/actualiza_pedido.php?numero_mesa=" + numero_mesa);
		$(".detalle").load("../ajax/detalle_pedido.php?numero_mesa=");
	}
</script>
<script>
	function filtrarPedidos(numero_mesa, vista, tipo = '') {
    $(".detalle").load("../ajax/detalle_pedido.php?numero_mesa=" + numero_mesa + "&vista=" + vista + "&tipo=" + tipo);
}
</script>
<script>
$(document).ready(function() {
      var refreshId =  setInterval( function(){
    load(1);//actualizas el div
   }, 20000 );//actualiza 20 segundos las comandas
});

</script>
<script>
// print order function
function printDetalle(id_factura, vista) {
	$('#modal_vuelto').modal('hide'); // CIERRA LA MODAL
	if (id_factura) {
		$.ajax({
			url: '../pdf/documentos/imprimir_detalleCocina.php',
			type: 'post',
			data: {
				id_factura: id_factura,
				vista: vista
			},
			dataType: 'text',
			success: function(response) {
				var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
				mywindow.document.write('<html><head><title>Facturación</title>');
				mywindow.document.write('</head><body>');
				mywindow.document.write(response);
				mywindow.document.write('</body></html>');
				mywindow.document.close(); // nécessaire pour IE >= 10
				mywindow.focus(); // nécessaire pour IE >= 10
				mywindow.print();
				mywindow.close();
			} // /success function
		}); // /ajax function to fetch the printable order
	} // /if orderId
} // /print order function
</script>

<?php require 'includes/footer_end.php'
?>

