<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
    header("location: ../../login.php");
    exit;
}

/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Caja";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$Caja = 1;
$fecha_actual = date('Y-m-d');
$hora_actual = date('H:i');
?>
<?php require 'includes/header_start.php';?>

<?php require 'includes/header_end.php';?>

<!-- Begin page -->
<div id="wrapper" class="forced enlarged"> <!-- DESACTIVA EL MENU -->

	<?php require 'includes/menu.php';?>

	<!-- ============================================================== -->
	<!-- Start right Content here -->
	<!-- ============================================================== -->
	<div class="content-page">
		<!-- Start content -->
		<div class="content">
			<div class="container">
				<?php if ($permisos_ver == 1) {
    ?>
					<div class="col-lg-12">
						<div class="portlet">
							<div class="portlet-heading bg-primary">
								<h3 class="portlet-title">
Apertura/Cierre de Caja
								</h3>
								<div class="portlet-widgets">
									<a href="javascript:;" data-toggle="reload"><i class="ion-refresh"></i></a>
									<span class="divider"></span>
									<a data-toggle="collapse" data-parent="#accordion1" href="#bg-primary"><i class="ion-minus-round"></i></a>
									<span class="divider"></span>
									<a href="#" data-toggle="remove"><i class="ion-close-round"></i></a>
								</div>
								<div class="clearfix"></div>
							</div>
							<div id="bg-primary" class="panel-collapse collapse show">
								<div class="portlet-body">
									<?php
if ($permisos_editar == 1) {
        include '../modal/apertura_caja.php';
        include "../modal/cerrar_caja.php";
        include "../modal/corte_caja.php";
        //include "../modal/egresos_caja.php";
        //include "../modal/eliminar_marca.php";
    }
    ?>
            <div class="row">
				<div class="col-lg-3">
                <div class="widget-bg-color-icon card-box">
													<div class="text-center">
														<?php if ($permisos_editar == 1) {?>
															<button type="button" class="btn btn-success btn-block btn-lg waves-effect waves-light" href="#" data-toggle="modal" data-target="#nuevaCaja" data-toggle="tooltip" title="Apertura de Caja" style="text-align: center;font-size: 15px;"><span class="fa fa-sign-in"></span> Apertura de Caja</button>
                                                            <?php }
    if ($permisos_eliminar == 1) {?>
															
														<?php }?>
													</div>
													<div class="clearfix"></div>
												</div>

                </div>
                <div class="col-lg-9">
									<form class="form-horizontal" role="form" id="datos_cotizacion">

										<div class="form-group row">

											<div class="col-xs-6">
												<div class="input-group">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control daterange pull-right" value="<?php echo "01" . date('/m/Y') . ' - ' . date('d/m/Y'); ?>" id="range" readonly>
                                                    <span class="input-group-btn">
														<button class="btn btn-primary" type="button" onclick='load(1);'><i class='fa fa-search'></i></button>
													</span>
												</div><!-- /input-group -->
											</div>
											<div class="col-xs-1">
												<div id="loader" class="text-center"></div>
											</div>
										</div>
									</form>
                        
									<div class="datos_ajax_delete"></div><!-- Carga los datos ajax -->
									<div class='outer_div'></div><!-- Carga los datos ajax -->

                </div>
                </div>
								</div>
							</div>
						</div>
					</div>

					<?php
} else {
    ?>
					<section class="content">
						<div class="alert alert-danger" align="center">
							<h3>Acceso denegado! </h3>
							<p>No cuentas con los permisos necesario para acceder a este módulo.</p>
						</div>
					</section>
					<?php
}
?>


			</div>
			<!-- end container -->
		</div>
		<!-- end content -->

		<?php require 'includes/pie.php';?>

	</div>
	<!-- ============================================================== -->
	<!-- End Right content here -->
	<!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui -->
<!-- ============================================================== -->
<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<script type="text/javascript" src="../../js/cierre_caja.js"></script>
<script>
//Date range picker
$('.daterange').daterangepicker({
	buttonClasses: ['btn', 'btn-sm'],
	applyClass: 'btn-success',
	cancelClass: 'btn-default',
	locale: {
		format: "DD/MM/YYYY",
		separator: " - ",
		applyLabel: "Aplicar",
		cancelLabel: "Cancelar",
		fromLabel: "Desde",
		toLabel: "Hasta",
		customRangeLabel: "Custom",
		daysOfWeek: [
		"Do",
		"Lu",
		"Ma",
		"Mi",
		"Ju",
		"Vi",
		"Sa"
		],
		monthNames: [
		"Enero",
		"Febrero",
		"Marzo",
		"Abril",
		"Mayo",
		"Junio",
		"Julio",
		"Agosto",
		"Septiembre",
		"Octubre",
		"Noviembre",
		"Diciembre"
		],
		firstDay: 1
	},
	opens: "right"

});
</script>
<script>
  // print order function
function print_corte(caja_id) {
	if (caja_id) {
		//$('#cerrarCaja').modal('hide');
		//$('#modal_vuelto').modal('hide');//CIERRA LA MODAL
		$.ajax({
			url: '../pdf/documentos/imprimir_xz.php',
			type: 'post',
			data: {
				caja_id: caja_id
			},
			dataType: 'text',
			success: function(response) {
				var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
				mywindow.document.write('<html><head><title>Corte Caja</title>');
				mywindow.document.write('</head><body>');
				mywindow.document.write(response);
				mywindow.document.write('</body></html>');
                mywindow.document.close(); // necessary for IE >= 10
                mywindow.focus(); // necessary for IE >= 10
                mywindow.print();
                mywindow.close();
				//window.location.href = '../html/control_mesas.php';
            } // /success function

        }); // /ajax function to fetch the printable order
    } // /if orderId
} // /print order function
</script>
<script>
// print order function
function print_stock(caja_id) {
	if (fecha) {
		//$('#cerrarCaja').modal('hide');
		//$('#modal_vuelto').modal('hide');//CIERRA LA MODAL
		$.ajax({
			url: '../pdf/documentos/imprimir_stock.php',
			type: 'post',
			data: {
				caja_id: caja_id
			},
			dataType: 'text',
			success: function(response) {
				var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
				mywindow.document.write('<html><head><title>Inventario</title>');
				mywindow.document.write('</head><body>');
				mywindow.document.write(response);
				mywindow.document.write('</body></html>');
                mywindow.document.close(); // necessary for IE >= 10
                mywindow.focus(); // necessary for IE >= 10
                mywindow.print();
                mywindow.close();
				//window.location.href = '../html/control_mesas.php';
            } // /success function

        }); // /ajax function to fetch the printable order
    } // /if orderId
} // /print order function

// print order function
function print_cant_venta(caja_id) {
	if (fecha) {
		//$('#cerrarCaja').modal('hide');
		//$('#modal_vuelto').modal('hide');//CIERRA LA MODAL
		$.ajax({
			url: '../pdf/documentos/imprimir_stockVentas.php',
			type: 'post',
			data: {
				caja_id: caja_id
			},
			dataType: 'text',
			success: function(response) {
				var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
				mywindow.document.write('<html><head><title>Inventario</title>');
				mywindow.document.write('</head><body>');
				mywindow.document.write(response);
				mywindow.document.write('</body></html>');
                mywindow.document.close(); // necessary for IE >= 10
                mywindow.focus(); // necessary for IE >= 10
                mywindow.print();
                mywindow.close();
				//window.location.href = '../html/control_mesas.php';
            } // /success function

        }); // /ajax function to fetch the printable order
    } // /if orderId
} // /print order function


</script>


<?php require 'includes/footer_end.php'
?>

