<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
    header("location: ../../login.php");
    exit;
}
if (!isset($_SESSION['start_time'])) {
  $_SESSION['start_time'] = time(); // Guarda el tiempo de inicio en segundos
}

/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Inicio";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$title  = "Inicio";
$Inicio = 1;
//Archivo de funciones PHP
require_once "../funciones.php";
$usu                   = $_SESSION['id_users'];
// Consulta para obtener los datos del usuario
$query = "SELECT usuario_users, cargo_users, nombre_users, apellido_users, email_users FROM users WHERE id_users = '$usu'";

// Ejecutar la consulta
$result = mysqli_query($conexion, $query);

// Verificar si se encontraron datos
if ($result && mysqli_num_rows($result) > 0) {
    $usuario = mysqli_fetch_assoc($result);
    
    $users_users    = $usuario['usuario_users'];
    $cargo_users    = $usuario['cargo_users'];
    $nombre_users   = $usuario['nombre_users'];
    $apellido_users = $usuario['apellido_users'];
    $email_users    = $usuario['email_users'];
} else {
    // Si no se encuentran resultados, asignar valores por defecto
    $users_users    = 'N/A';
    $cargo_users    = 'N/A';
    $nombre_users   = 'N/A';
    $apellido_users = 'N/A';
    $email_users    = 'N/A';
}
$logo = get_row('perfil', 'logo_url', 'id_perfil', 1);
$now_date              = date("Y-m-d");
$sql                   = "SELECT * FROM detalle_caja WHERE fecha ='" . $now_date . "' and empleado_id= '" . $usu . "' and estado_caja = 1;";
$query_check_user_name = mysqli_query($conexion, $sql);
$query_check_user      = mysqli_num_rows($query_check_user_name);
//$vista                 = 'modal_vuelto';
/*if ($query_check_user == true) {
    $vista = 'modal_inactiva';
} else {
    $vista = 'modal_vuelto';
}*/
// Consulta para obtener los productos más vendidos
$sql = "SELECT p.nombre_producto, SUM(d.cantidad) as total_vendido 
        FROM detalle_fact_ventas d 
        INNER JOIN productos p ON d.id_producto = p.id_producto 
        GROUP BY d.id_producto 
        ORDER BY total_vendido DESC";
$result = mysqli_query($conexion, $sql);

// Preparar los datos para el gráfico
$labels = []; // Nombres de los productos
$data = [];   // Cantidades vendidas

while ($row = mysqli_fetch_assoc($result)) {
    $labels[] = $row['nombre_producto'];
    $data[] = $row['total_vendido'];
}
// Obtener el tiempo de inicio de sesión de la sesión
$start_time = $_SESSION['start_time'];
$current_time = time(); // Obtiene la hora actual
$session_duration = $current_time - $start_time; // Calcula la duración en segundos

// Calcula horas, minutos y segundos
$hours = floor($session_duration / 3600);
$minutes = floor(($session_duration % 3600) / 60);
$seconds = $session_duration % 60;

?>
<?php require 'includes/header_start.php';?>
<!-- grafico -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script src="https://www.gstatic.com/charts/loader.js"></script>

<script>
  $(document).ready(function () {
    $("#modal_vuelto").modal("show");
  });
</script>
<?php require 'includes/header_end.php';?>
<style>
   /* Estilos generales */
body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background-color:rgb(240, 238, 238);
    color: #333;
}

/* Asegura que las tarjetas siempre se alineen en filas de 4 */
.row {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between; /* Distribución uniforme */
    margin-bottom: 30px;
}

/* Ajustar tamaño de columnas correctamente */
.col-md-3 {
    flex: 1 1 25%; /* 4 columnas en pantallas grandes */
    max-width: 25%;
    padding: 10px; /* Espaciado interno */
}

@media (max-width: 768px) {
    .col-md-3 {
        flex: 1 1 50%; /* 2 columnas por fila en pantallas medianas */
        max-width: 50%;
    }
}

@media (max-width: 576px) {
    .col-md-3 {
        flex: 1 1 100%; /* 1 tarjeta por fila en pantallas pequeñas */
        max-width: 100%;
    }
}

/* Estilo de las tarjetas */
.widget-bg-color-icon {
    background: linear-gradient(135deg, #ffffff, #f8f9fa);
    border-radius: 12px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    padding: 25px;
    text-align: center;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    min-height: 120px; /* Para que todas tengan el mismo tamaño */
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
}

.widget-bg-color-icon:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
}

/* Estilos de los iconos */
.bg-icon {
    display: inline-flex;
    justify-content: center;
    align-items: center;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    color: white;
    font-size: 1.5rem;
}

/* Colores de los iconos */
.bg-icon-caja { background-color: #28a745; } /* Verde */
.bg-icon-mesas { background-color: #007bff; } /* Azul */
.bg-icon-inventario { background-color: #ffc107; } /* Amarillo */
.bg-icon-compra { background-color: #dc3545; } /* Rojo */

.text-muted {
    color: #6c757d;
    font-size: 18px;
    text-align: center;
    font-weight: bold;
}

/* Estilos de las tarjetas */
.custom-card {
    background: #ffffff;
    border-radius: 15px;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    padding: 20px;
    transition: all 0.3s ease-in-out;
    text-align: center;
}

.custom-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
}

/* Estilos del select */
.custom-select {
    width: 100%;
    padding: 10px;
    border-radius: 8px;
    border: 1px solid #ddd;
    font-size: 16px;
}

/* Logo */
.logo-img {
    max-width: 150px;
    border-radius: 10px;
    margin-bottom: 10px;
}

/* Contenedores de gráficos */
.chart-container {
    height: 300px;
    margin-top: 20px;
}

/* Responsividad */
@media (max-width: 768px) {
    .col-md-4 {
        width: 100%;
        margin-bottom: 20px;
    }
}

#session-time {
    font-size: 0.9em;
    font-weight: bold;
    padding: 5px 10px;
    background-color: #28a745; /* Verde */
    color: white;
    border-radius: 10px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

</style>

<!-- Begin page -->
<div id="wrapper">

  <?php require 'includes/menu.php';?>




  <!-- ============================================================== -->
  <!-- Start right Content here -->
  <!-- ============================================================== -->
  <div class="content-page">
    <!-- Start content -->
    <div class="content">
      <div class="container">
        <?php if ($permisos_ver == 1) {
    ?>
   <div class="row g-3">
    <div class="col-md-3 col-lg-3 col-xl-3">
        <a href="control_caja.php">
            <div class="widget-bg-color-icon card-box">
                <div class="bg-icon bg-icon-caja">
                    <i class="fa fa-money"></i> <!-- Icono de caja -->
                </div>
                <div class="text-right">
                    <p class="text-muted mb-0">Caja</p>
                </div>
            </div>
        </a>
    </div>

    <div class="col-md-3 col-lg-3 col-xl-3">
        <a href="control_mesas.php">
            <div class="widget-bg-color-icon card-box">
                <div class="bg-icon bg-icon-mesas">
                    <i class="fa fa-server"></i> <!-- Icono de mesas -->
                </div>
                <div class="text-right">
                    <p class="text-muted mb-0">Mesas</p>
                </div>
            </div>
        </a>
    </div>

    <div class="col-md-3 col-lg-3 col-xl-3">
        <a href="productos.php">
            <div class="widget-bg-color-icon card-box">
                <div class="bg-icon bg-icon-inventario">
                    <i class="fa fa-inbox"></i> <!-- Icono de inventario -->
                </div>
                <div class="text-right">
                    <p class="text-muted mb-0">Inventario</p>
                </div>
            </div>
        </a>
    </div>

    <div class="col-md-3 col-lg-3 col-xl-3">
        <a href="new_compra.php">
            <div class="widget-bg-color-icon card-box">
                <div class="bg-icon bg-icon-compra">
                    <i class="fa fa-shopping-basket"></i> <!-- Icono de compra -->
                </div>
                <div class="text-right">
                    <p class="text-muted mb-0">Compra</p>
                </div>
            </div>
        </a>
    </div>
</div>


<div class="container text-center mt-4">
    <div class="row justify-content-center">
        <!-- Tarjeta 1: Gráfico de Barras -->
        <div class="col-md-4">
            <div class="card custom-card">
                <div class="card-body">
                    <h5 class="card-title">Selección de Período</h5>
                    <div class="row">
                        <div class="col-md-12">
                            <select class="form-control custom-select" id="periodo" onchange="drawVisualization();">
                                <?php
                                for ($anio = (date("Y")); 2016 <= $anio; $anio--) {
                                    echo "<option value='$anio'>Período: $anio</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div id="chart_div" class="chart-container"></div>
                </div>
            </div>
        </div>

       <!-- Tarjeta 2: Bienvenida -->
       <div class="col-md-4">
    <div class="card custom-card">
        <div class="card-body text-center">
            <img src="../../img/logo.png" alt="Logo" class="img-fluid logo-img">
            <h2 class="mt-3">Bienvenido, <?php echo "$nombre_users $apellido_users"; ?>!</h2>
            <p class="lead">Esperamos que tengas un excelente día de trabajo.</p>
            <p class="lead">
    <strong>Tiempo conectado:</strong>
    <span id="session-time" class="badge bg-info">
        <?php echo "{$hours} horas, {$minutes} minutos, {$seconds} segundos"; ?>
    </span>
</p>

        </div>
    </div>
</div>

        <!-- Tarjeta 3: Gráfico de Pastel -->
        <div class="col-md-4">
            <div class="card custom-card">
                <div class="card-body">
                    <h5 class="card-title">Análisis de Datos</h5>
                    <canvas id="pieChart" class="chart-container"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

        
            
            <!-- Incluir Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Datos para el gráfico
    const labels = <?php echo json_encode($labels); ?>; // Nombres de los productos
    const data = <?php echo json_encode($data); ?>;     // Cantidades vendidas

    // Configuración del gráfico
    const config = {
        type: 'pie', // Tipo de gráfico (pastel)
        data: {
            labels: labels, // Etiquetas (nombres de los productos)
            datasets: [{
                label: 'Productos vendidos',
                data: data, // Datos (cantidades vendidas)
                backgroundColor: [
                    '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0', '#9966FF', '#FF9F40', '#C9CBCF'
                ], // Colores para cada porción
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom', // Posición de la leyenda
                },
                title: {
                    display: true,
                    text: 'Productos más vendidos' // Título del gráfico
                }
            }
        }
    };

    // Renderizar el gráfico
    const pieChart = new Chart(document.getElementById('pieChart'), config);
</script>

         






          <?php
} else {
    ?>
          <section class="content">
            <div class="alert alert-danger" align="center">
              <h3>Acceso denegado! </h3>
              <p>No cuentas con los permisos necesario para acceder a este módulo.</p>
            </div>
          </section>
          <?php
}
?>
      </div>
      <!-- end container -->
    </div>
    <!-- end content -->

    <?php require 'includes/pie.php';?>

  </div>
  <!-- ============================================================== -->
  <!-- End Right content here -->
  <!-- ============================================================== -->

</div>
<!-- END wrapper -->


<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui-->
<!-- ============================================================== -->
<script>
  google.charts.load('current', {'packages':['corechart']});
  google.charts.setOnLoadCallback(drawVisualization);

  function errorHandler(errorMessage) {
            //curisosity, check out the error in the console
            console.log(errorMessage);
            //simply remove the error, the user never see it
            google.visualization.errors.removeError(errorMessage.id);
          }

          function drawVisualization() {
        // Some raw data (not necessarily accurate)
    var periodo=$("#periodo").val();//Datos que enviaremos para generar una consulta en la base de datos
    var jsonData= $.ajax({
      url: 'chart.php',
      data: {'periodo':periodo,'action':'ajax'},
      dataType: 'json',
      async: false
    }).responseText;

    var obj = jQuery.parseJSON(jsonData);
    var data = google.visualization.arrayToDataTable(obj);



    var options = {
      title : 'VENTAS VS COMPRAS'+periodo,
      vAxis: {title: 'Monto'},
      hAxis: {title: 'Meses'},
      seriesType: 'bars',
      series: {5: {type: 'line'}}
    };

    var chart = new google.visualization.ComboChart(document.getElementById('chart_div'));
    google.visualization.events.addListener(chart, 'error', errorHandler);
    chart.draw(data, options);
  }

  // Haciendo los graficos responsivos
  jQuery(document).ready(function(){
    jQuery(window).resize(function(){
     drawVisualization();
   });
  });

</script>
<script>
$("#guardar_caja").submit(function(event) {
      $('#guardar_datos').attr("disabled", true);
      var valor = $("#valor").val();
      var parametros = $(this).serialize();
      if (isNaN(valor)) {
        $.Notification.notify('error','bottom center','NOTIFICACIÓN', 'CAJA INICIAL NO ES UN VALOR VALIDO, INTENTAR DE NUEVO')
        $("#valor").val('');
        $("#valor").focus();
        $('#guardar_datos').attr("disabled", false);
        return false;
      }
      $.ajax({
        type: "POST",
        url: "../ajax/guardar_caja.php",
        data: parametros,
        beforeSend: function(objeto) {
          $("#resultados_ajax").html('<img src="../../img/ajax-loader.gif"> Cargando...');
        },
        success: function(datos) {
          $("#resultados_ajax").html(datos);
          $('#guardar_datos').attr("disabled", false);
          $('#modal_vuelto').modal('hide'); //CIERRA LA MODAL
                //resetea el formulario
                $("#guardar_caja")[0].reset();
                $("#valor").focus();
                //desaparecer la alerta
                $.Notification.notify('success','bottom center','NOTIFICACIÓN', 'CAJA APERTURADA CON EXITO')
                window.setTimeout(function() {
                  $(".alert").fadeTo(200, 0).slideUp(200, function() {
                    $(this).remove();
                  });
                }, 2000);
            }
        });
      event.preventDefault();
    })
</script>
<script type="text/javascript">
    $(function(){

  $('.number-only').keyup(function(e) {
        if(this.value!='-')
          while(isNaN(this.value))
            this.value = this.value.split('').reverse().join('').replace(/[\D]/i,'')
                                   .split('').reverse().join('');
    })
    .on("cut copy paste",function(e){
        e.preventDefault();
    });

});
  </script>

<script>
    function updateTime() {
        let startTime = <?php echo $start_time; ?>; // Hora de inicio en JavaScript
        let currentTime = Math.floor(Date.now() / 1000); // Hora actual en segundos
        let sessionDuration = currentTime - startTime; // Duración en segundos

        let hours = Math.floor(sessionDuration / 3600);
        let minutes = Math.floor((sessionDuration % 3600) / 60);
        let seconds = sessionDuration % 60;

        // Mostrar el tiempo en el DOM
        document.getElementById("session-time").innerText = hours + " horas, " + minutes + " minutos, " + seconds + " segundos";
    }

    // Actualizar el tiempo cada segundo
    setInterval(updateTime, 1000);
</script>


<?php require 'includes/footer_end.php'
?>