<?php
include '../../ajax/is_logged.php'; //Archivo verifica que el usuario que intenta acceder a la URL está logueado
?>
<style type="text/css">
    @page {
        margin: 0;
    }

    .ticket-container {
    width: 175px;
    font-size: 8px;
    font-family: 'Courier New', monospace;
}


    .business-info {
        text-align: center;
        font-size: 11px;
    }

    .business-info strong {
        display: block;
    }

    .business-info .sub-info {
        font-size: 11px;
    }

    .divider {
        text-align: center;
    }

    .order-info {
        text-align: left;
        margin-top: 5px;
    }

    .item-row {
    display: flex;
    justify-content: space-between;
    text-align: center; /* Alineación centrada */
}

    .item-row .item-name {
        flex: 1;
    }

    .item-row .item-total {
        flex: 1;
        text-align: right;
    }

    .subtotal {
        text-align: right;
    }

    .subtotal strong {
        display: block;
    }

    .footer-info {
        text-align: center;
        margin-top: 5px;
    }

    

    .divider {
        text-align: center;
    }

    .divider::after {
        content: "---------------------------------------------";
        display: block;
        width: 100%; /* Ajusta el ancho al 100% del contenedor */
        white-space: nowrap; /* Evita que el contenido se divida en varias líneas */
        overflow: hidden; /* Oculta cualquier contenido que desborde del contenedor */
    }

    .footer-info strong {
        display: block;
    }

    .footer-info .note {
        margin-top: 5px;
    }
    .totals {
        text-align: right; /* Alinea todo el contenido a la derecha */
    }

    .totals .total-row {
        display: flex;
        justify-content: space-between; /* Espacio entre los elementos para alinear a la derecha */
    }

    .totals .total-row .label {
        flex: 1; /* Ocupa el espacio disponible para expandirse */
        text-align: left; /* Alinea el texto de la etiqueta a la izquierda dentro del espacio disponible */
    }

    .totals .total-row .value {
        flex: 1; /* Ocupa el espacio disponible para expandirse */
        text-align: right; /* Alinea el texto del valor a la derecha dentro del espacio disponible */
    }

</style>
<?php
/* Connect To Database */
require_once "../../db.php"; // Contiene las variables de configuración para conectar a la base de datos
require_once "../../php_conexion.php"; // Contiene función que conecta a la base de datos
// Archivo de funciones PHP
include "../../funciones.php";
$simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
$numero_mesa = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST["numero_mesa"], ENT_QUOTES)));
$identificativoSeleccionado = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST["identificativoSeleccionado"], ENT_QUOTES)));
if (isset($identificativoSeleccionado)) {
    $cliente = $identificativoSeleccionado;
    if (empty($cliente)) {
        $cliente = "General";
    }
} else {
    $cliente = "General";
}
/* Datos de la empresa */
$sql = mysqli_query($conexion, "SELECT * FROM perfil");
$rw = mysqli_fetch_array($sql);
$moneda = $rw["moneda"];
$bussines_name = $rw["nombre_empresa"];
$giro = $rw["giro_empresa"];
$fiscal = $rw["fiscal_empresa"];
$address = $rw["direccion"];
$city = $rw["ciudad"];
$state = $rw["estado"];
$postal_code = $rw["codigo_postal"];
$phone = $rw["telefono"];
$email = $rw["email"];
$logo_url = $rw["logo_url"];
$users = intval($_SESSION['id_users']);
$fecha = date("d-m-Y H:i:s");
$sql    = mysqli_query($conexion, "select nombre_users, apellido_users from users WHERE id_users  ='" . $users . "'");
$rw             = mysqli_fetch_array($sql);
$nom_users = $rw['nombre_users'];

// Obtener configuración de propina (podemos asumir un valor por defecto si no existe)
$porcentaje_propina = get_row('perfil', 'propina', 'id_perfil', 1);
if(empty($porcentaje_propina)) {
    $porcentaje_propina = 10; // Porcentaje predeterminado si no está definido en la BD
}
?>

<page pageset='new' backtop='10mm' backbottom='10mm' backleft='20mm' backright='20mm' footer='page'>
    <div class="ticket-container">
        <div class="business-info">
            <strong><?php echo $bussines_name; ?></strong>
            <div class="sub-info"><?php echo $giro; ?></div>
            <div class="sub-info">RUC: <?php echo $fiscal; ?></div>
            <div class="sub-info"><?php echo $address; ?></div>
            <div class="sub-info"><?php echo $city . ' ' . $state; ?></div>
            <div class="sub-info">Tel: <?php echo $phone; ?></div>
        </div>

        <div class="divider"></div>

        <div class="order-info">
            <div>Mesa: <?php echo $numero_mesa; ?></div>
            <div>Cuenta: <?php echo $cliente; ?></div>
            <div>Usuario: <?php echo $nom_users; ?></div>
            <div>Fecha: <?php echo $fecha; ?></div>
        </div>

        <div class="divider"></div>

        <div class="item-row">
            <div>Cant.</div>
            <div class="item-name">Descrip.</div>
            <div class="item-total">Total</div>
        </div>

        <div class="divider"></div>

        <?php
        $nums = 1;
        $impuesto = get_row('perfil', 'impuesto', 'id_perfil', 1);
        $sumador_total = 0;
        $sum_total = 0;
        $sum_total = 0;
        $descuentot = 0;
        $t_iva = 0;

        // Ajustar la consulta SQL para incluir $identificativoSeleccionado solo si no está vacío
if (!empty($identificativoSeleccionado)) {
    $sql = "SELECT * FROM productos, tmp_mesa WHERE productos.id_producto=tmp_mesa.producto_tmp AND tmp_mesa.mesa_tmp='" . $numero_mesa . "' AND tmp_mesa.identificativo ='" . $identificativoSeleccionado . "'";
} else {
    $sql = "SELECT * FROM productos, tmp_mesa WHERE productos.id_producto=tmp_mesa.producto_tmp AND tmp_mesa.mesa_tmp='" . $numero_mesa . "'";
}

$result = mysqli_query($conexion, $sql);

while ($row = mysqli_fetch_array($result)) {
            $id_producto = $row["id_producto"];
            $codigo_producto = $row['codigo_producto'];
            $cantidad = $row['cant_tmp'];
            $desc_tmp = $row['desc_tmp'];
            $nombre_producto = $row['nombre_producto'];
            $p_venta = $row['precio_tmp'];
            $importe = ($cantidad * $p_venta) - $desc_tmp;
            $descuentot += $desc_tmp;

            if ($row['iva_producto'] == 0) {
                $p_venta_f = number_format($p_venta, 2);
                $p_venta_r = str_replace(",", "", $p_venta_f);
                $p_total = $p_venta_r * $cantidad;
                $f_items = rebajas($p_total, $desc_tmp);
                $p_total_f = number_format($importe, 2);
                $p_total_r = str_replace(",", "", $p_total_f);
                $sum_total += $p_total_r;
                $t_iva = ($sum_total * $impuesto) / 100;
                $t_iva = number_format($t_iva, 2, '.', '');
            }

            $precio_venta = $row['precio_tmp'];
            $precio_venta_f = number_format($precio_venta, 2);
            $precio_venta_r = str_replace(",", "", $precio_venta_f);
            $precio_total = $precio_venta_r * $cantidad;
            $final_items = rebajas($precio_total, $desc_tmp);
            $precio_total_f = number_format($importe, 2);
            $precio_total_r = str_replace(",", "", $precio_total_f);
            $sumador_total += $precio_total_r;

            if ($nums % 2 == 0) {
                $clase = "clouds";
            } else {
                $clase = "silver";
            }
        ?>
            <div class="item-row <?php echo $clase; ?>">
                <div><?php echo $cantidad; ?></div>
                <div class="item-name"><?php echo $nombre_producto; ?></div>
                <div class="item-total"><?php echo $simbolo_moneda . ' ' . number_format($importe, 2); ?></div>
            </div>
        <?php
            $nums++;
        }
        $subtotal = number_format($sumador_total, 2, '.', '');
        $total_iva = ($subtotal * $impuesto) / 100;
        $total_iva = number_format($total_iva, 2, '.', '') - number_format($t_iva, 2, '.', '');
        $total_factura = $subtotal + $total_iva;
        
        // Calcular propina
        $propina = ($total_factura * $porcentaje_propina) / 100;
        $propina = number_format($propina, 2, '.', '');
        
        // Calcular total con propina
        $total_con_propina = $total_factura + $propina;
        $total_con_propina = number_format($total_con_propina, 2, '.', '');
        ?>
        <div class="divider"></div>

        <div class="totals">
            <div class="total-row">
                <div class="label">Descuento:</div>
                <div class="value"><?php echo $simbolo_moneda . ' ' . number_format($descuentot, 2); ?></div>
            </div>
            <div class="total-row">
                <div class="label">Subtotal:</div>
                <div class="value"><?php echo $simbolo_moneda . ' ' . number_format($total_factura, 2); ?></div>
            </div>
            <div class="total-row">
                <div class="label">Propina (<?php echo $porcentaje_propina; ?>%):</div>
                <div class="value"><?php echo $simbolo_moneda . ' ' . $propina; ?></div>
            </div>
            <div class="total-row">
                <div class="label"><strong>Total con propina:</strong></div>
                <div class="value"><strong><?php echo $simbolo_moneda . ' ' . $total_con_propina; ?></strong></div>
            </div>
        </div>

        <div class="divider"></div>

        <div class="footer-text">
            <center>*DETALLE DE PEDIDO*</center>
        </div>
    </div>
</page>