<?php
include '../../ajax/is_logged.php'; // Verifica que el usuario está logueado
require_once "../../db.php"; 
require_once "../../php_conexion.php"; 
include "../../funciones.php";

$moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
$id_caja = intval($_REQUEST['caja_id']);

/* Datos de la empresa */
$sql = mysqli_query($conexion, "SELECT * FROM perfil");
$rw = mysqli_fetch_array($sql);
$bussines_name = $rw["nombre_empresa"];
$giro = $rw["giro_empresa"];
$fiscal = $rw["fiscal_empresa"];
$address = $rw["direccion"];
$city = $rw["ciudad"];
$state = $rw["estado"];
$phone = $rw["telefono"];

/* Datos de caja */
$query = "SELECT * FROM detalle_caja WHERE caja_id = '$id_caja'";
$result = $conexion->query($query);
$row = $result->fetch_assoc();
$fecha = $row["fecha"];
$hora_ap = $row["hora_ap"];
$empleado_id = $row["empleado_id"];
$estado_caja = ($row["estado_caja"] > 0) ? 'CERRADA' : 'APERTURADA';
$usuario = get_row('users', 'usuario_users', 'id_users', $empleado_id);

?>
<!DOCTYPE html>
<html>
<head>
    <title>Ticket de Corte de Caja</title>
    <style>
        @page { margin: 0; }
        body { font-family: 'Courier New', monospace; font-size: 10px; }
        .ticket-container { width: 180px; padding: 5px; }
        .text-center { text-align: center; }
        .divider { border-top: 1px dashed black; margin: 5px 0; }
        .totals, .footer-info { text-align: right; margin-top: 5px; }
        .total-row { display: flex; justify-content: space-between; }
    </style>
</head>
<body>
<div class="ticket-container">
    <div class="text-center">
        <strong><?php echo strtoupper($bussines_name); ?></strong><br>
        <?php echo $giro; ?><br>
        RUC: <?php echo $fiscal; ?><br>
        <?php echo $address . ', ' . $city . ', ' . $state; ?><br>
        Tel: <?php echo $phone; ?>
    </div>
    <div class="divider"></div>

    <div class="totals">
        <div class="total-row"><span>Fecha:</span> <span><?php echo $fecha; ?></span></div>
        <div class="total-row"><span>Hora Apertura:</span> <span><?php echo $hora_ap; ?></span></div>
        <div class="total-row"><span>Usuario:</span> <span><?php echo $usuario; ?></span></div>
    </div>
    <div class="divider"></div>

    <div class="text-center"><strong>DETALLE DE VENTA DEL DIA</strong></div>
    <table style="width:100%; font-size: 10px;">
        <tr><th>Producto</th><th>Cnt.</th><th>Precio</th><th>Total</th></tr>
        <?php
        $totalGeneral = 0;
        $query = "SELECT nombre_producto, valor1_producto, cantidad FROM detalle_fact_ventas
                  JOIN productos ON productos.id_producto = detalle_fact_ventas.id_producto
                  WHERE control_caja = $id_caja";
        $resultado = $conexion->query($query);
        while ($fila = $resultado->fetch_assoc()) {
            $cantidad = $fila['cantidad'];
            $total = $fila['valor1_producto'] * $cantidad;
            $totalGeneral += $total;
            echo "<tr>
                    <td>{$fila['nombre_producto']}</td>
                    <td>{$cantidad}</td>
                    <td>{$moneda}".number_format($fila['valor1_producto'], 2) . "</td>
            <td>{$moneda}".number_format($total, 2) . "</td>
                  </tr>";
        }
        ?>
    </table>
    <div class="divider"></div>

    <div class="totals">
        <div class="total-row"><strong>Total General:</strong> <strong><?php echo $moneda . ' ' . number_format($totalGeneral, 2); ?></strong></div>
    </div>

    <div class="divider"></div>
    <div class="footer-info">
        <strong>Estado de Caja: <?php echo $estado_caja; ?></strong>
    </div>
</div>
</body>
</html>
