<?php
// Configuración y seguridad
include 'is_logged.php';
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";

// Control de permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
permisos("Ventas", $cadena_permisos);

// Procesar acción
if ($_REQUEST['action'] ?? '' == 'ajax') {
    $q = mysqli_real_escape_string($conexion, strip_tags($_REQUEST['q'] ?? '', ENT_QUOTES));
    
    // Consulta sin paginación
    $sql = "SELECT * FROM tmp_comandas ORDER BY id_comanda DESC";
    $query = mysqli_query($conexion, $sql);
    
    if (mysqli_num_rows($query) > 0) {
        mostrarTablaPedidos($query);
    } else {
        mostrarMensajeSinDatos();
    }
}

// Funciones auxiliares
function mostrarTablaPedidos($query) {
    ?>
    <div class="table-responsive">
        <table class="table table-sm table-striped">
            <tr class="info">
                <th>ID COMANDA</th>
                <th>MESA/PEDIDOS</th>
                <th>ESTADO</th>
                <th class='text-center'>Acciones</th>
            </tr>
            <?php while ($row = mysqli_fetch_array($query)): 
                $estado = [
                    'text' => $row['estado_comanda'] == 1 ? "PROCESADA" : "PENDIENTE",
                    'class' => $row['estado_comanda'] == 1 ? 'badge-success' : 'badge-danger'
                ];

                // Mostrar mesa_comanda o num_pedido si está vacío
                $mesa = !empty($row['mesa_comanda']) ? $row['mesa_comanda'] : $row['num_pedido'];
            ?>
                <tr>
                    <td><label class='badge badge-purple'><?= $row['id_comanda'] ?></label></td>
                    <td style="font-size:25px;"><b class="counter text-purple"><?= $mesa ?></b></td>
                    <td><span class="badge <?= $estado['class'] ?>"><?= $estado['text'] ?></span></td>
                    <td class="text-center">
                        <button type="button" class="btn btn-md btn-danger waves-effect waves-light" 
                            onclick="estado_tmp('<?= $mesa ?>');">
                            Procesar Pedido
                        </button>

                        <?= generarBotonesFiltro($row['mesa_comanda'], $row['num_pedido']) ?>
                    </td>
                </tr>
            <?php endwhile; ?>
        </table>
    </div>
    <?php
}

function generarBotonesFiltro($mesa_comanda, $num_pedido) {
    // Usar num_pedido si mesa_comanda está vacío
    $mesa = !empty($mesa_comanda) ? $mesa_comanda : $num_pedido;

    $botones = [
        ['tipo' => 'todos', 'titulo' => 'Todos', 'clase' => 'btn-success', 'icono' => 'fa-tasks', 'vista' => 0],
        ['tipo' => 'bebidas', 'titulo' => 'Bebidas', 'clase' => 'btn-primary', 'icono' => 'fa-glass', 'vista' => 1],
        ['tipo' => 'comida', 'titulo' => 'Comida', 'clase' => 'btn-info', 'icono' => 'fa-cutlery', 'vista' => 2]
    ];
    
    $html = '';
    foreach ($botones as $boton) {
        $html .= sprintf(
            '<button type="button" title="%s" class="btn %s waves-effect waves-light" 
             data-toggle="modal" data-target="#buscar" 
             onclick="filtrarPedidos(\'%s\', \'%s\', \'%s\');">
                <span class="fa %s"></span>
            </button>',
            $boton['titulo'],
            $boton['clase'],
            $mesa,
            $boton['vista'],
            $boton['tipo'],
            $boton['icono']
        );
    }
    return $html;
}

function mostrarMensajeSinDatos() {
    ?>
    <div class="alert alert-warning alert-dismissible" role="alert" align="center">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        <strong>Aviso!</strong> No hay Registro de Facturas
    </div>
    <?php
}
?>
