<?php

/*-------------------------
Autor: Delmar Lopez
Web: softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php";
require_once "../php_conexion.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Categorias";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
//Archivo de funciones PHP
require_once "../funciones.php";
$id_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);

$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q        = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $aColumns = array('nombre_mesa'); //Columnas de busqueda
    $sTable   = "mesas";
    $sWhere   = "";
    if ($_GET['q'] != "") {
        $sWhere = "WHERE (";
        for ($i = 0; $i < count($aColumns); $i++) {
            $sWhere .= $aColumns[$i] . " LIKE '%" . $q . "%' OR ";
        }
        $sWhere = substr_replace($sWhere, "", -3);
        $sWhere .= ')';
    }
    $sWhere .= " order by id_mesa";
    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 24; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../html/control_mesas.php';
    //main query to fetch the data
    $sql   = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    //loop through fetched data
    if ($numrows > 0) {

        ?>
        <div class="row">
        <?php
$nums = 1;
        while ($row = mysqli_fetch_array($query)) {
            $id_mesa     = $row['id_mesa'];
            $nombre_mesa = $row['nombre_mesa'];
            $status_mesa = $row['status_mesa'];
            $usuario_mesa = $row['users_id'];
            $sql = mysqli_query($conexion, "SELECT usuario_users FROM users WHERE id_users = $usuario_mesa");
            $rrw = mysqli_fetch_array($sql);
            $nom_users = isset($rrw['usuario_users']) ? $rrw['usuario_users'] : '';
            
            if ($row['status_mesa'] != 1) {
                $color  = 'success';
                $col    = 'default';
                $titles = 'Activar mesa';
                $alerta = 'DISPONIBLE';
            } else {
                $color  = 'danger';
                $col    = 'info';
                $alerta = 'OCUPADA';
                $titles = $nom_users;
            }
            $orderSql       = "SELECT * FROM tmp_mesa where mesa_tmp='$id_mesa'";
            $orderQuery     = $conexion->query($orderSql);
            $countProductos = $orderQuery->num_rows;
            ?>
            <!--<a tabindex="-1" href="" data-toggle="modal" data-target="#control">
                <div class="col-sm-6 col-lg-2">
                    <div class="widget-simple text-center card-box bg-<?php echo $color; ?>">
                        <h4 class="text-white counter"><?php echo $nombre_mesa; ?></h4>
                        <p class="text-white"><?php echo $alerta; ?></p>
                    </div>
                </div>
            </a>-->
                <div class="col-lg-2 col-md-6">
                <a href="detalle_mesa.php?numero_mesa=<?php echo $id_mesa; ?>" data-toggle="tooltip" title="<?php echo $titles; ?>">
                    <div class="widget-simple text-center card-box bg-<?php echo $color; ?>">
                        <h5 class="text-white font-bold mt-0"><?php echo $nombre_mesa; ?></h5>
                        <p class="text-white mb-0 font-bold"><?php echo $alerta; ?> <span class="badge badge-pill badge-<?php echo $col; ?>"><?php echo $countProductos; ?></span></p>

                    </div>
                    </a>
                </div>

            <?php
}
        ?>
        </div>
            <!-- end row -->
        <span class="pull-center">
            <?php
echo paginate($reload, $page, $total_pages, $adjacents);
        ?></span>


            <?php
}
//Este else Fue agregado de Prueba de prodria Quitar
    else {
        ?>
            <div class="alert alert-warning alert-dismissible" role="alert" align="center">
              <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              <strong>Aviso!</strong> No hay Registro de Mesas
          </div>
          <?php
}
// fin else
}
?>