<?php

/*-------------------------
Autor: Delmar Lopez
Web: softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php";
require_once "../php_conexion.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Categorias";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
//Archivo de funciones PHP
require_once "../funciones.php";
$id_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);

$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q         = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $daterange = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['range'], ENT_QUOTES)));
    $sTable    = "reservas, clientes, salones";
    $sWhere    = "";
    $sWhere .= " WHERE reservas.id_cliente_res=clientes.id_cliente and reservas.id_salon_res=salones.id_salon";
    if ($_GET['q'] != "") {
        $sWhere .= " and  (clientes.nombre_cliente like '%$q%')";

    }
    if (!empty($daterange)) {
        list($f_inicio, $f_final)                    = explode(" - ", $daterange); //Extrae la fecha inicial y la fecha final en formato espa?ol
        list($dia_inicio, $mes_inicio, $anio_inicio) = explode("/", $f_inicio); //Extrae fecha inicial
        $fecha_inicial                               = "$anio_inicio-$mes_inicio-$dia_inicio 00:00:00"; //Fecha inicial formato ingles
        list($dia_fin, $mes_fin, $anio_fin)          = explode("/", $f_final); //Extrae la fecha final
        $fecha_final                                 = "$anio_fin-$mes_fin-$dia_fin 23:59:59";

        $sWhere .= " and reservas.fecha_res between '$fecha_inicial' and '$fecha_final'  ";
    }
    $sWhere .= " order by reservas.id_reserva desc";
    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 10; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../html/reservas.php';
    //main query to fetch the data
    $sql   = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    //loop through fetched data
    if ($numrows > 0) {

        ?>
        <div class="table-responsive">
            <table class="table table-sm table-striped">
                <tr  class="info">
                    <th>Id</th>
                    <th>Cliente</th>
                    <th>Salón</th>
                    <th>Fecha Reserva</th>
                    <th>Hora</th>
                    <th>Estado</th>
                    <th class='text-right'>Acciones</th>

                </tr>
                <?php
while ($row = mysqli_fetch_array($query)) {
            $id_reserva      = $row['id_reserva'];
            $id_salon_res    = $row['id_salon_res'];
            $id_cliente_res  = $row['id_cliente_res'];
            $telefono_res    = $row['telefono_res'];
            $cantidad_res    = $row['cantidad_res'];
            $fecha_res       = $row['fecha_res'];
            $hora_inicio_res = $row['hora_inicio_res'];
            $hora_fin_res    = $row['hora_fin_res'];
            $obs_res         = $row['obs_res'];
            $estado_res      = $row['estado_res'];
            //datos de salon y cliente
            $nombre_cliente = $row['nombre_cliente'];
            $nombre_salon   = $row['nombre_salon'];
            $hora           = $row['hora_inicio_res'] . ' a ' . $row['hora_fin_res'];
            ?>

    <input type="hidden" value="<?php echo $id_salon_res; ?>" id="id_salon_res<?php echo $id_reserva; ?>">
    <input type="hidden" value="<?php echo $id_cliente_res; ?>" id="id_cliente_res<?php echo $id_reserva; ?>">
    <input type="hidden" value="<?php echo $telefono_res; ?>" id="telefono_res<?php echo $id_reserva; ?>">
    <input type="hidden" value="<?php echo $cantidad_res; ?>" id="cantidad_res<?php echo $id_reserva; ?>">
    <input type="hidden" value="<?php echo $fecha_res; ?>" id="fecha_res<?php echo $id_reserva; ?>">
    <input type="hidden" value="<?php echo $hora_inicio_res; ?>" id="hora_inicio_res<?php echo $id_reserva; ?>">
    <input type="hidden" value="<?php echo $hora_fin_res; ?>" id="hora_fin_res<?php echo $id_reserva; ?>">
    <input type="hidden" value="<?php echo $obs_res; ?>" id="obs_res<?php echo $id_reserva; ?>">
    <input type="hidden" value="<?php echo $estado_res; ?>" id="estado_res<?php echo $id_reserva; ?>">


    <tr>
        <td><span class="badge badge-purple"><?php echo $id_reserva; ?></span></td>
        <td><?php echo $nombre_cliente; ?></td>
        <td><?php echo $nombre_salon; ?></td>
        <td><?php echo fecha($fecha_res); ?></td>
        <td><?php echo $hora; ?></td>
        <td><?php echo estado_res($estado_res); ?></td>
        <td >
            <div class="btn-group dropdown">
                <button type="button" class="btn btn-warning btn-sm dropdown-toggle waves-effect waves-light" data-toggle="dropdown" aria-expanded="false"> <i class='fa fa-cog'></i> <i class="caret"></i> </button>
                <div class="dropdown-menu dropdown-menu-right">
                   <?php if ($permisos_editar == 1) {?>
                   <a class="dropdown-item" href="#" data-toggle="modal" data-target="#editarReserva" onclick="obtener_datos('<?php echo $id_reserva; ?>');"><i class='fa fa-edit'></i> Editar</a>
                   <?php }
            if ($permisos_eliminar == 1) {?>
                   <a class="dropdown-item" href="#" data-toggle="modal" data-target="#dataDelete" data-id="<?php echo $id_reserva; ?>"><i class='fa fa-trash'></i> Borrar</a>
                   <?php }
            ?>


               </div>
           </div>

       </td>

   </tr>
   <?php
}
        ?>
<tr>
    <td colspan="7">
        <span class="pull-right">
            <?php
echo paginate($reload, $page, $total_pages, $adjacents);
        ?></span>
        </td>
    </tr>
</table>
</div>
<?php
}
//Este else Fue agregado de Prueba de prodria Quitar
    else {
        ?>
    <div class="alert alert-warning alert-dismissible" role="alert" align="center">
      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <strong>Aviso!</strong> No hay Registro de Salón
  </div>
  <?php
}
// fin else
}
?>