<?php
include "is_logged.php"; //Archivo comprueba si el usuario esta logueado
/* Connect To Database*/
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";
$session_id     = session_id();
$comp_id        = get_row('perfil', 'comp_id', 'id_perfil', 1);
$simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
$propina        = get_row('perfil', 'propina', 'id_perfil', 1);
$sumador_total  = 0;
$t_iva          = 0;
$total_impuesto = 0;
$total_factura  = 0;
$numero_mesa    = $_SESSION['numero_mesa'];

// Verificar que la variable de sesión número_mesa existe
if (!isset($numero_mesa) || empty($numero_mesa)) {
    echo "Error: No se ha seleccionado una mesa.";
    exit;
}

// Consulta principal de productos en la mesa
$sql = mysqli_query($conexion, "SELECT * FROM productos, tmp_mesa WHERE productos.id_producto=tmp_mesa.producto_tmp AND tmp_mesa.mesa_tmp='" . $numero_mesa . "'");

// Verificar si la consulta fue exitosa
if (!$sql) {
    echo "Error en la consulta: " . mysqli_error($conexion);
    exit;
}

// Verificar si hay productos en la mesa
if (mysqli_num_rows($sql) == 0) {
    echo "No hay productos en esta mesa.";
    // Puedes decidir si quieres salir aquí o mostrar un total de 0
}

// Procesar cada producto en la mesa
while ($row = mysqli_fetch_array($sql)) {
    $id_tmp          = $row["id_tmp"];
    $id_producto     = $row['producto_tmp'];
    $codigo_producto = $row['codigo_producto'];
    $cantidad        = $row['cant_tmp'];
    $desc_tmp        = $row['desc_tmp'];
    $nombre_producto = $row['nombre_producto'];
    
    // Control del impuesto por productos
    $precio_venta    = $row['precio_tmp'];
    $importe         = ($cantidad * $precio_venta) - $desc_tmp;
    $precio_venta_f  = formato($precio_venta); // Formateo variables
    $precio_venta_r  = str_replace(",", "", $precio_venta_f); // Reemplazo las comas
    $precio_total    = $precio_venta_r * $cantidad;
    $final_items     = rebajas($precio_total, $desc_tmp); // Aplicando el descuento
    
    // Precio total formateado
    $precio_total_f  = formato($importe);
    $precio_total_r  = str_replace(",", "", $precio_total_f); // Reemplazo las comas
    $sumador_total  += $precio_total_r; // Sumador
}

// Calcular subtotal primero
$subtotal = $sumador_total;

// Calcular impuesto (segundo cálculo separado para mayor claridad)
$sql_impuesto = mysqli_query($conexion, "SELECT * FROM productos, tmp_mesa WHERE productos.id_producto=tmp_mesa.producto_tmp AND tmp_mesa.mesa_tmp='" . $numero_mesa . "'");
while ($row_imp = mysqli_fetch_array($sql_impuesto)) {
    $cantidad   = $row_imp['cant_tmp'];
    $desc_tmp   = $row_imp['desc_tmp'];
    $precio_venta = $row_imp['precio_tmp'];
    
    if ($row_imp['iva_producto'] == 1) {
        $total_iva = iva($precio_venta);
        $total_impuesto += rebajas($total_iva, $desc_tmp) * $cantidad;
    }
}

// Calcular propina y total final
$total_propina = $subtotal * $propina / 100;
$total_factura = $subtotal + $total_impuesto + $total_propina;

// Formatear total para mostrar
$total_factura_formateado = formato($total_factura);
?>
<input style="background-color:#AED6F1; border-radius: 5px; border: 1px solid #39c; text-align: center; font-size: 50px; height: 75px" 
       type="text" 
       class="form-control resibido" 
       autocomplete="off" 
       id="total_ft" 
       required 
       name="total_ft" 
       value="<?php echo $total_factura_formateado; ?>" 
       readonly>