<?php
include "is_logged.php"; //Archivo comprueba si el usuario esta logueado
/* Connect To Database*/
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";

// Validar y sanitizar el valor recibido
$identificativoSeleccionado = isset($_GET['identificativoSeleccionado']) ? mysqli_real_escape_string($conexion, $_GET['identificativoSeleccionado']) : "";

// Determinar el nombre del cliente
if (!empty($identificativoSeleccionado)) {
    $cliente = $identificativoSeleccionado;
} else {
    $cliente = "General";
}

// Verificar sesión y obtener datos necesarios
if (!isset($_SESSION['numero_mesa'])) {
    echo "<div class='alert alert-danger'>No se ha seleccionado una mesa.</div>";
    exit;
}

$session_id     = session_id();
$comp_id        = get_row('perfil', 'comp_id', 'id_perfil', 1);
$simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
$propina        = get_row('perfil', 'propina', 'id_perfil', 1);
$numero_mesa    = $_SESSION['numero_mesa'];

// Inicializar variables de cálculo
$sumador_total  = 0;
$total_impuesto = 0;
$total_factura  = 0;

// Construir la consulta SQL según el identificativo
if (!empty($identificativoSeleccionado)) {
    $sql = "SELECT * FROM productos, tmp_mesa 
            WHERE productos.id_producto=tmp_mesa.producto_tmp 
            AND tmp_mesa.mesa_tmp='" . $numero_mesa . "' 
            AND tmp_mesa.identificativo ='" . $identificativoSeleccionado . "'";
} else {
    $sql = "SELECT * FROM productos, tmp_mesa 
            WHERE productos.id_producto=tmp_mesa.producto_tmp 
            AND tmp_mesa.mesa_tmp='" . $numero_mesa . "'";
}

// Ejecutar la consulta y verificar resultados
$result = mysqli_query($conexion, $sql);
if (!$result) {
    echo "<div class='alert alert-danger'>Error en la consulta: " . mysqli_error($conexion) . "</div>";
    exit;
}

// Verificar si hay productos
if (mysqli_num_rows($result) == 0) {
    // No hay productos, mostrar cuenta con valor cero
    $sumador_total = 0;
    $total_impuesto = 0;
    $total_propina = 0;
    $total_factura = 0;
} else {
    // Calcular subtotal primero
    while ($row = mysqli_fetch_array($result)) {
        $id_tmp          = $row["id_tmp"];
        $id_producto     = $row['producto_tmp'];
        $codigo_producto = $row['codigo_producto'];
        $cantidad        = $row['cant_tmp'];
        $desc_tmp        = $row['desc_tmp'];
        $nombre_producto = $row['nombre_producto'];
        $precio_venta    = $row['precio_tmp'];
        
        // Calcular el importe con descuento
        $importe = ($cantidad * $precio_venta) - $desc_tmp;
        
        // Formatear para cálculos
        $precio_venta_f = formato($precio_venta);
        $precio_venta_r = str_replace(",", "", $precio_venta_f);
        $precio_total_f = formato($importe);
        $precio_total_r = str_replace(",", "", $precio_total_f);
        
        // Acumular al subtotal
        $sumador_total += $precio_total_r;
    }
    
    // Reiniciar el puntero de resultado para el segundo cálculo
    mysqli_data_seek($result, 0);
    
    // Segundo paso: calcular impuestos
    while ($row = mysqli_fetch_array($result)) {
        $cantidad     = $row['cant_tmp'];
        $desc_tmp     = $row['desc_tmp'];
        $precio_venta = $row['precio_tmp'];
        
        // Calcular impuesto solo si el producto tiene IVA
        if ($row['iva_producto'] == 1) {
            $total_iva = iva($precio_venta);
            $total_impuesto += rebajas($total_iva, $desc_tmp) * $cantidad;
        }
    }
    
    // Calcular propina y total final
    $total_propina = $sumador_total * $propina / 100;
    $total_factura = $sumador_total + $total_impuesto + $total_propina;
}

// Formatear para mostrar
$subtotal_formateado = formato($sumador_total);
$total_factura_formateado = formato($total_factura);
//echo $total_factura_formateado;//ELIMINAR ESTO
?>

<input style="background-color:#FDFEFE; border-radius: 5px; text-align: center; font-size: 25px; height: 50px" 
       type="text" 
       class="form-control resibido" 
       autocomplete="off" 
       id="et" 
       required 
       name="et" 
       value="Cuenta: <?php echo htmlspecialchars($cliente); ?>" 
       readonly><br>

<input style="background-color:#A3E4D7; border-radius: 5px; border: 1px solid #39c; text-align: center; font-size: 50px; height: 75px" 
       type="text" 
       class="form-control resibido" 
       autocomplete="off" 
       id="total_ft4" 
       required 
       name="total_ft4" 
       value="<?php echo $total_factura_formateado; ?>" 
       readonly>

<input type="hidden" 
       class="form-control" 
       id="identificativo" 
       name="identificativo" 
       value="<?php echo htmlspecialchars($identificativoSeleccionado); ?>">