<?php
include 'is_logged.php';
require_once "../db.php";
require_once "../php_conexion.php";

if (!isset($_REQUEST['numero_mesa'])) {
    echo "<script>$.Notification.notify('error','bottom center','ERROR', 'Faltan parámetros requeridos')</script>";
    exit;
}

// Sanitizar entradas
$mesa_comanda = mysqli_real_escape_string($conexion, strip_tags($_REQUEST['numero_mesa'], ENT_QUOTES));
$vista = isset($_REQUEST['vista']) ? intval($_REQUEST['vista']) : 0;

function imprimirProductos($conexion, $mesa_comanda, $identificativo, $vista) {
    $query = "SELECT tmp_mesa.*, productos.nombre_producto, productos.vista 
              FROM tmp_mesa 
              JOIN productos ON productos.id_producto = tmp_mesa.producto_tmp 
              WHERE tmp_mesa.mesa_tmp = '$mesa_comanda' 
              AND tmp_mesa.identificativo = '$identificativo'";
    
    if ($vista != 0) {
        $query .= " AND productos.vista = '$vista'";
    }
    
    $query .= " ORDER BY productos.nombre_producto ASC";
    $result = mysqli_query($conexion, $query);
    
    if (mysqli_num_rows($result) == 0) {
        echo '<tr><td colspan="3" class="text-center py-2 text-muted">No hay productos en esta categoría</td></tr>';
        return;
    }
    
    while ($row = mysqli_fetch_assoc($result)) {
        $estadoClass = ($row['status_tmp'] != 1) ? 'text-danger' : '';
        $detalle = !empty($row['detalle']) ? htmlspecialchars($row['detalle']) : '';
        
        // Mostrar solo si hay nueva cantidad
        if ($row['new_cant'] > 0) {
            echo '<tr class="'.$estadoClass.'">
                    <td class="text-center align-middle">
                        <span class="badge badge-primary badge-pill" style="font-size:1em; min-width:30px;">'.$row['new_cant'].'</span>
                    </td>
                    <td class="pl-3">
                        <div class="d-flex align-items-center">
                            <span>'.$row['nombre_producto'].'</span>
                            <span class="text-warning ml-2"><i class="fa fa-bell"></i></span>
                        </div>
                    </td>
                    <td class="text-right">
                        <small class="text-muted font-italic">'.$detalle.'</small>
                    </td>
                  </tr>';
        }
    }
}
?>

<div class="container-fluid p-3">
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
            <h5 class="m-0 text-primary">
                <i class="fa fa-utensils mr-2"></i>Detalle de Pedido - Mesa <?php echo htmlspecialchars($mesa_comanda); ?>
            </h5>
            <button type="button" class="btn btn-success btn-sm" onclick="printDetalle('<?php echo htmlspecialchars($mesa_comanda, ENT_QUOTES); ?>', '<?php echo $vista; ?>')">
                <i class="fa fa-print mr-1"></i> Imprimir
            </button>
        </div>
        
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead class="thead-light">
                        <tr>
                            <th class="text-center" style="width: 50px;">Cantidad</th>
                            <th>Producto</th>
                            <th class="text-center" style="width: 40%;">Notas</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sqlCuentas = "SELECT DISTINCT identificativo FROM tmp_mesa WHERE mesa_tmp = '$mesa_comanda'";
                        $resultCuentas = mysqli_query($conexion, $sqlCuentas);
                        
                        if (mysqli_num_rows($resultCuentas) > 0) {
                            while ($cuenta = mysqli_fetch_assoc($resultCuentas)) {
                                echo '<tr class="bg-light">
                                        <td colspan="3" class="font-weight-bold">
                                            <i class="fa fa-user-circle mr-2 text-secondary"></i>Cuenta: '.htmlspecialchars($cuenta['identificativo']).'
                                        </td>
                                      </tr>';
                                imprimirProductos($conexion, $mesa_comanda, $cuenta['identificativo'], $vista);
                            }
                        } else {
                            echo '<tr><td colspan="3" class="text-center py-4 text-muted">No hay productos registrados</td></tr>';
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="card-footer bg-white border-0 text-right">
            <small class="text-muted">Actualizado: <?php echo date('d/m/Y H:i:s'); ?></small>
        </div>
    </div>
</div>

<style>
    .table-hover tbody tr:hover {
        background-color: rgba(0, 123, 255, 0.05);
    }
    .badge-pill {
        border-radius: 10rem;
    }
    .text-muted.font-italic {
        color: #6c757d;
        font-style: italic;
    }
</style>