<?php
include 'is_logged.php'; // Verifica que el usuario está logueado

if (empty($_POST['id_cliente'])) {
    $errors[] = "ID vacío";
} else {
    require_once "../db.php";
    require_once "../php_conexion.php";
    require_once "../funciones.php";

    $session_id     = session_id();
    $simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);

    // Verifica si hay productos en la tabla temporal
    $sql_count = mysqli_query($conexion, "SELECT * FROM tmp_cotizacion WHERE session_id='$session_id'");
    if (mysqli_num_rows($sql_count) == 0) {
        echo "<script>
            swal({
              title: 'No hay productos agregados en la factura',
              text: 'Intentar nuevamente',
              type: 'error',
              confirmButtonText: 'ok'
          });
          </script>";
        exit;
    }

    $id_cliente     = intval($_POST['id_cliente']);
    $id_vendedor    = intval($_SESSION['id_users']);
    $users          = intval($_SESSION['id_users']);
    $condiciones    = mysqli_real_escape_string($conexion, strip_tags($_REQUEST['condiciones'], ENT_QUOTES));
    $start          = mysqli_real_escape_string($conexion, strip_tags($_REQUEST["start"], ENT_QUOTES));
    $numero_factura = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST["factura"], ENT_QUOTES)));
    $est            = intval($_POST['est']);
    $date_added     = date("Y-m-d H:i:s");

    // Define el estado en función de las condiciones
    $estado = ($condiciones == 4) ? 2 : 1;
    // write new user's data into database
    $insert_tmp_comanda = mysqli_query($conexion, "INSERT INTO tmp_comandas (mesa_comanda,estado_comanda,session_id,num_pedido)
    VALUES ('','$numero_factura','$session_id','$numero_factura')");
    // Obtiene el último número de factura y lo incrementa
    $query_id = mysqli_query($conexion, "SELECT RIGHT(numero_factura,6) as factura FROM facturas_cot ORDER BY id_factura DESC LIMIT 1");
    $data_id = mysqli_fetch_assoc($query_id);
    $factura = isset($data_id['factura']) ? $data_id['factura'] + 1 : 1;
    $factura = "PED-" . str_pad($factura, 6, "0", STR_PAD_LEFT);

    // Calcula el total de la factura
    $sumador_total = 0;
    $total_impuesto = 0;
    $sql = mysqli_query($conexion, "SELECT * FROM productos, tmp_cotizacion WHERE productos.id_producto=tmp_cotizacion.id_producto AND tmp_cotizacion.session_id='$session_id'");
    while ($row = mysqli_fetch_array($sql)) {
        $id_producto = $row['id_producto'];
        $cantidad = $row['cantidad_tmp'];
        $desc_tmp = $row['desc_tmp'];
        $precio_venta_r = str_replace(",", "", number_format($row['precio_tmp'], 2));
        $precio_total_r = $precio_venta_r * $cantidad;
        $final_items = rebajas($precio_total_r, $desc_tmp);
        $sumador_total += $final_items;
        if ($row['iva_producto'] == 1) {
            $total_iva = iva($row['precio_tmp']);
            $total_impuesto += rebajas($total_iva, $desc_tmp) * $cantidad;
        }
    }

    $total_factura = $sumador_total + $total_impuesto;

    // Inserta en la tabla `facturas_cot`
    $insert = mysqli_query($conexion, "INSERT INTO facturas_cot VALUES (NULL,'$factura','$date_added','$id_cliente','$id_vendedor','$condiciones','$total_factura','$estado','$users','', '$start','','$est','1')");

    // Obtiene el último `id_factura` insertado
    $id_factura = mysqli_insert_id($conexion);

    // Inserta detalles de la factura
    $sql = mysqli_query($conexion, "SELECT * FROM productos, tmp_cotizacion WHERE productos.id_producto=tmp_cotizacion.id_producto AND tmp_cotizacion.session_id='$session_id'");
    while ($row = mysqli_fetch_array($sql)) {
        $id_producto = $row['id_producto'];
        $cantidad = $row['cantidad_tmp'];
        $desc_tmp = $row['desc_tmp'];
        $precio_venta_r = str_replace(",", "", number_format($row['precio_tmp'], 2));
        $identificativo = $row['identificativo'];
        mysqli_query($conexion, "INSERT INTO detalle_fact_cot VALUES (NULL,'$id_factura','$factura','$id_producto','$cantidad','$desc_tmp','$precio_venta_r','$identificativo')");
        //Gurdamos para los detalles de la comanda
        $insert_tmp = mysqli_query($conexion, "INSERT INTO tmp_mesa (mesa_tmp,producto_tmp,cant_tmp,precio_tmp,desc_tmp,session_id,identificativo)
                                                              VALUES ('$numero_factura','$id_producto','$cantidad','$precio_venta_r','0','$session_id','$identificativo')");
    }

    // Limpia la tabla temporal
    mysqli_query($conexion, "DELETE FROM tmp_cotizacion WHERE session_id='$session_id'");

    // Mensajes de éxito o error
    if ($insert) {
        echo "<script>$('#modal_cot').modal('show');</script>";
    } else {
        $errors[] = "Lo siento, algo salió mal. Intente nuevamente." . mysqli_error($conexion);
    }
}

if (isset($errors)) {
    echo "<div class='alert alert-danger'><strong>Error!</strong> " . implode("<br>", $errors) . "</div>";
}
?>

<!-- Modal -->
<div class="modal fade" id="modal_cot" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel"><i class='fa fa-edit'></i> INFORMACIÓN</h4>
            </div>
            <div class="modal-body" align="center">
                <strong><h3>NO. PEDIDO</h3></strong>
                <div class="alert alert-info" align="center">
                    <strong><h1>
                        <?php echo $factura; ?>
                    </h1></strong>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" id="imprimir2" class="btn btn-success btn-block btn-lg waves-effect waves-light" onclick="printFactura('<?php echo $factura; ?>');" accesskey="p"><span class="fa fa-print"></span> IMPRIMIR</button>
            </div>
        </div>
    </div>
</div>