<?php
// guardar_producto.php
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
// Verificar si se recibieron los datos del formulario
if (isset($_POST['id_producto']) && isset($_POST['cantidad'])) {
    $id_producto = $_POST['id_producto'];
    $cantidad = $_POST['cantidad'];

    $id_combog = $_SESSION['id'];

    // Conexión a la base de datos
    require_once "../db.php";
    require_once "../php_conexion.php";

    // Verificar errores de conexión
    if ($conexion->connect_error) {
        die(json_encode(["success" => false, "message" => "Error de conexión: " . $conexion->connect_error]));
    }

    // Obtener el nombre del producto para mostrarlo en la tabla
    $query_nombre = "SELECT nombre_producto FROM productos WHERE id_producto = ?";
    $stmt_nombre = $conexion->prepare($query_nombre);
    $stmt_nombre->bind_param("i", $id_producto);
    $stmt_nombre->execute();
    $stmt_nombre->bind_result($nombre_producto);
    $stmt_nombre->fetch();
    $stmt_nombre->close();

    // Preparar la consulta para insertar el nuevo producto
    $query = "INSERT INTO combo_productos (id_combo, id_producto, cantidad) VALUES (?, ?, ?)";
    $stmt = $conexion->prepare($query);

    if ($stmt) {
        // Vincular los parámetros
        $stmt->bind_param("iii",$id_combog, $id_producto, $cantidad);

        // Ejecutar la consulta
        if ($stmt->execute()) {
            // Obtener el ID del combo recién insertado
            $id_comp = $stmt->insert_id;
            echo json_encode([
                "success" => true,
                "message" => "Producto agregado correctamente.",
                "id_comp" => $id_comp,
                "nombre_producto" => $nombre_producto
            ]);
        } else {
            echo json_encode(["success" => false, "message" => "Error al agregar el producto: " . $stmt->error]);
        }

        // Cerrar la declaración
        $stmt->close();
    } else {
        echo json_encode(["success" => false, "message" => "Error al preparar la consulta: " . $conexion->error]);
    }

    // Cerrar la conexión
    $conexion->close();
} else {
    echo json_encode(["success" => false, "message" => "Datos del formulario no proporcionados."]);
}
?>