<?php
include 'is_logged.php'; // Archivo que verifica que el usuario que intenta acceder a la URL está logueado

/* Inicia validación del lado del servidor */
if (empty($_POST['id_cliente'])) {
    $errors[] = "ID VACIO";
} else if (!empty($_POST['id_cliente'])) {
    /* Connect To Database */
    require_once "../db.php";
    require_once "../php_conexion.php";
    // Archivo de funciones PHP
    require_once "../funciones.php";

    $session_id     = session_id();
    $simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);

    // Comprobamos si hay archivos en la tabla temporal
    $sql_count = mysqli_query($conexion, "SELECT * FROM tmp_ventas WHERE session_id='" . $session_id . "'");
    $count     = mysqli_num_rows($sql_count);

    if ($count == 0) {
        echo "<script>
        swal({
          title: 'No hay Productos agregados en la factura',
          text: 'Intentar nuevamente',
          type: 'error',
          confirmButtonText: 'ok'
      })</script>";
        exit;
    }

    // Escaping, adicionalmente eliminando todo lo que podría ser código (html/javascript)
    $id_cliente     = intval($_POST['id_cliente']);
    $id_vendedor    = intval($_SESSION['id_users']);
    $users          = intval($_SESSION['id_users']);
    $condiciones    = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['condiciones'], ENT_QUOTES)));
    $numero_factura = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST["factura"], ENT_QUOTES)));
    $resibido       = floatval($_POST['resibido']);
    $total_ft       = floatval($_POST['total_ft']);
    $date_added     = date("Y-m-d H:i:s");

    // Operación de Créditos
    if ($condiciones == 4) {
        $estado = 2;
    } else {
        $estado = 1;
    }

    if ($condiciones == 5) {
        $py = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST["py"], ENT_QUOTES)));
    } else {
        $py = '';
    }

    if ($resibido < $total_ft && $condiciones != 4) {
        echo "<script>
          $.Notification.notify('error', 'bottom center', 'NOTIFICACIÓN', 'EL DINERO RECIBIDO ES MENOR AL TOTAL DE LA FACTURA')
            </script>";
        exit;
    }

    // Seleccionamos el último campo numero_factura y aumentamos uno
    $sql        = mysqli_query($conexion, "SELECT LAST_INSERT_ID(id_factura) as last FROM facturas_ventas ORDER BY id_factura DESC LIMIT 1");
    $rw         = mysqli_fetch_array($sql);
    $id_factura = $rw['last'] + 1;

    // Control de Caja
    $caja = mysqli_query($conexion, "SELECT LAST_INSERT_ID(caja_id) as last_id, estado_caja FROM detalle_caja WHERE estado_caja = 0");
    $rw = mysqli_fetch_array($caja);
    $id_caja = $rw['last_id'];

    // Control de la numero_factura y aumentamos uno
    $query_id = mysqli_query($conexion, "SELECT RIGHT(numero_factura,6) as factura FROM facturas_ventas ORDER BY factura DESC LIMIT 1")
    or die('error ' . mysqli_error($conexion));
    $count = mysqli_num_rows($query_id);

    if ($count != 0) {
        $data_id = mysqli_fetch_assoc($query_id);
        $factura = $data_id['factura'] + 1;
    } else {
        $factura = 1;
    }

    $buat_id = str_pad($factura, 6, "0", STR_PAD_LEFT);
    $factura = "CFF-$buat_id";

    // Consulta principal
    $nums           = 1;
    $impuesto       = get_row('perfil', 'impuesto', 'id_perfil', 1);
    $propina        = 0;
    $sumador_total  = 0;
    $total_impuesto = 0;
    $sum_total      = 0;
    $t_iva          = 0;

    $sql = mysqli_query($conexion, "SELECT * FROM productos, tmp_ventas WHERE productos.id_producto=tmp_ventas.id_producto AND tmp_ventas.session_id='" . $session_id . "'");

    while ($row = mysqli_fetch_array($sql)) {
        $id_tmp          = $row["id_tmp"];
        $id_producto     = $row['id_producto'];
        $codigo_producto = $row['codigo_producto'];
        $cantidad_tmp    = $row['cantidad_tmp']; // Cantidad del producto vendido
        $desc_tmp        = $row['desc_tmp'];
        $nombre_producto = $row['nombre_producto'];

        $precio_venta   = $row['precio_tmp'];
        $precio_venta_f = number_format($precio_venta, 2); // Formateo variables
        $precio_venta_r = str_replace(",", "", $precio_venta_f); // Reemplazo las comas
        $precio_total   = $precio_venta_r * $cantidad_tmp;
        $final_items    = rebajas($precio_total, $desc_tmp); // Aplicando el descuento

        $precio_total_f = number_format($final_items, 2); // Precio total formateado
        $precio_total_r = str_replace(",", "", $precio_total_f); // Reemplazo las comas
        $sumador_total += $precio_total_r; // Sumador
        $subtotal = number_format($sumador_total, 2, '.', '');

        if ($row['iva_producto'] == 1) {
            $total_iva = iva($precio_venta);
        } else {
            $total_iva = 0;
        }

        $total_impuesto += rebajas($total_iva, $desc_tmp) * $cantidad_tmp;

        // Comprobamos que el dinero recibido no sea menor al Total de la factura
        if ($resibido < $sumador_total && $condiciones != 4) {
            echo "<script>
            swal({
              title: 'DINERO RECIBIDO ES MENOR AL MONTO TOTAL',
              text: 'Intentar Nuevamente',
              type: 'error',
              confirmButtonText: 'ok'
          })</script>";
            exit;
        }

       // Insertar en la tabla detalle_factura
    $insert_detail = mysqli_query($conexion, "INSERT INTO detalle_fact_ventas VALUES (NULL, '$id_factura', '$factura', '$id_producto', '$cantidad_tmp', '$desc_tmp', '$precio_venta_r', '$precio_total', '$date_added', '$id_caja')");

    // Verificar si el producto es un combo
    $sql_check_combo = mysqli_query($conexion, "SELECT combo FROM productos WHERE id_producto='" . $id_producto . "'");
    $row_combo = mysqli_fetch_array($sql_check_combo);

    if ($row_combo['combo'] == 'si') {
        // Obtener los productos relacionados en el combo
        $sql_combo_products = mysqli_query($conexion, "SELECT id_producto, cantidad FROM combo_productos WHERE id_combo='" . $id_producto . "'");

        while ($row_combo_product = mysqli_fetch_array($sql_combo_products)) {
            $id_combo_producto = $row_combo_product['id_producto'];
            $cantidad_combo_product = $row_combo_product['cantidad'];

            // Calcular la cantidad total a descontar (cantidad del combo * cantidad vendida)
            $cantidad_total_descontar = $cantidad_combo_product * $cantidad_tmp;

            // Obtener el stock actual del producto relacionado
            $sql_stock = mysqli_query($conexion, "SELECT stock_producto FROM productos WHERE id_producto='" . $id_combo_producto . "'");
            $row_stock = mysqli_fetch_array($sql_stock);
            $old_qty = $row_stock['stock_producto'];

            // Calcular el nuevo stock
            $new_qty = $old_qty - $cantidad_total_descontar;

            // Actualizar el stock del producto relacionado
            $update_stock = mysqli_query($conexion, "UPDATE productos SET stock_producto='" . $new_qty . "' WHERE id_producto='" . $id_combo_producto . "'");

            // Actualizar el stock en la tabla stock si es necesario
            $sql_stock_table = mysqli_query($conexion, "SELECT stock_final FROM stock WHERE id_producto_stock='" . $id_combo_producto . "'");
            $row_stock_table = mysqli_fetch_array($sql_stock_table);

            if ($row_stock_table != null) {
                $old_qtys = $row_stock_table['stock_final'];
                $new_qtys = $old_qtys + $cantidad_total_descontar;
                $update_stock_table = mysqli_query($conexion, "UPDATE stock SET stock_final='" . $new_qtys . "' WHERE id_producto_stock='" . $id_combo_producto . "' AND control_caja='" . $id_caja . "'");
            }
        }
    } else {
        // Si no es un combo, actualizar solo el stock del producto individual
        $sql2 = mysqli_query($conexion, "SELECT stock_producto FROM productos WHERE id_producto='" . $id_producto . "'");
        $rw = mysqli_fetch_array($sql2);
        $old_qty = $rw['stock_producto'];
        $new_qty = $old_qty - $cantidad_tmp; // Descuento basado en la cantidad vendida
        $update = mysqli_query($conexion, "UPDATE productos SET stock_producto='" . $new_qty . "' WHERE id_producto='" . $id_producto . "' AND inv_producto=0");

        // Actualizar el stock en la tabla stock si es necesario
        $sql3 = mysqli_query($conexion, "SELECT stock_final FROM stock WHERE id_producto_stock='" . $id_producto . "'");
        $rw = mysqli_fetch_array($sql3);

        if ($rw != null) {
            $old_qtys = $rw['stock_final'];
            $new_qtys = $old_qtys + $cantidad_tmp;
            $update = mysqli_query($conexion, "UPDATE stock SET stock_final='" . $new_qtys . "' WHERE id_producto_stock='" . $id_producto . "' AND control_caja='" . $id_caja . "'");
        }
    }
    }

    // Fin de la consulta Principal
    $total_propina = $subtotal * $propina / 100;
    $total_factura = $subtotal + $total_impuesto + $total_propina;
   $cambio        = $resibido - $total_factura;
    $saldo_credito = $total_factura - $resibido;

    if ($condiciones == 4) {
        $insert_prima = mysqli_query($conexion, "INSERT INTO creditos VALUES (NULL,'$factura','$date_added','$id_cliente','$id_vendedor','$total_factura','$saldo_credito','1','$users','1','$cuenta_id')");
        $insert_abono = mysqli_query($conexion, "INSERT INTO creditos_abonos VALUES (NULL,'$factura','$date_added','$id_cliente','$total_factura','$resibido','$saldo_credito','$users','1','CREDITO INICIAL','$cuenta_id')");
        $insert_detalle = mysqli_query($conexion, "INSERT INTO facturas_creditos VALUES (NULL,'$cuenta_id','$factura','0','$saldo_credito','1')");
    }

    $insert     = "INSERT INTO facturas_ventas VALUES (NULL,'$factura','$date_added','$id_cliente','$id_vendedor','$condiciones','$total_factura','$propina','$estado','$users','$resibido','1','$id_caja','$py')";
    $factura_id = '';

    if ($conexion->query($insert) === true) {
        $factura_id          = $conexion->insert_id;
        $valid['id_factura'] = $factura_id;
    }

    $delete = mysqli_query($conexion, "DELETE FROM tmp_ventas WHERE session_id='" . $session_id . "'");

    // SI TODO ESTA CORRECTO
    if ($condiciones == 4) {
        echo "<script>
        swal({
          title: 'VENTA AL CREDITO GUARDADA CON EXITO CON ANTICIPO DE: $simbolo_moneda $resibido',
          text: 'Factura: $factura',
          type: 'success',
          confirmButtonText: 'ok'
      })
  </script>";
        exit;
    }

    if ($insert_detail) {
        echo "<script>
    $('#modal_vuelto').modal('show');
</script>";
    } else {
        $errors[] = "Lo siento algo ha salido mal intenta nuevamente." . mysqli_error($conexion);
    }
} else {
    $errors[] = "Error desconocido.";
}

if (isset($errors)) {
    ?>
    <div class="alert alert-danger" role="alert">
        <strong>Error!</strong>
        <?php
    foreach ($errors as $error) {
        echo $error;
    }
    ?>
    </div>
    <?php
}

if (isset($messages)) {
    ?>
    <div class="alert alert-success" role="alert">
        <strong>¡Bien hecho!</strong>
        <?php
    foreach ($messages as $message) {
        echo $message;
    }
    ?>
    </div>
    <?php
}
?>

<!-- Modal -->
<div class="modal fade" id="modal_vuelto" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel"><i class='fa fa-edit'></i> FACTURA1: <?php echo $factura; ?></h4>
            </div>
            <div class="modal-body" align="center">
                <strong><h3>CAMBIO</h3></strong>
                <div class="alert alert-info" align="center">
                    <strong><h1>
                        <?php echo $simbolo_moneda . ' ' . number_format($cambio, 2); ?>
                    </h1></strong>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="imprimir" class="btn btn-primary btn-block btn-lg waves-effect waves-light" onclick="printOrder('<?php echo $factura_id; ?>');" accesskey="t" ><span class="fa fa-print"></span> Ticket</button><br>
                <!--<button type="button" id="imprimir2" class="btn btn-success btn-block btn-lg waves-effect waves-light" onclick="printFactura('<?php echo $factura_id; ?>');" accesskey="p"><span class="fa fa-print"></span> Factura</button>-->
            </div>
        </div>
    </div>
</div>