<?php
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/*Inicia validacion del lado del servidor*/
if (empty($_POST['id_cliente2'])) {
    $errors[] = "ID VACIO";
} else if (!empty($_POST['id_cliente2'])) {
    /* Connect To Database*/
    require_once "../db.php";
    require_once "../php_conexion.php";
    //Archivo de funciones PHP
    require_once "../funciones.php";
    $session_id     = session_id();
    $numero_mesa    = $_SESSION['numero_mesa'];
    $simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
    //Comprobamos si hay archivos en la tabla temporal
    $sql_count = mysqli_query($conexion, "select * from tmp_mesa where mesa_tmp='" . $numero_mesa . "'");
    $count     = mysqli_num_rows($sql_count);
    if ($count == 0) {
        echo "<script>
        swal({
          title: 'No hay Productos agregados en la factura',
          text: 'Intentar nuevamente',
          type: 'error',
          confirmButtonText: 'ok'
      })</script>";
        exit;
    }
    // escaping, additionally removing everything that could be (html/javascript-) code
    $id_cliente     = intval($_POST['id_cliente2']);
    $id_vendedor    = intval($_SESSION['id_users']);
    $users          = intval($_SESSION['id_users']);
    $condiciones    = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['condiciones2'], ENT_QUOTES)));
    $numero_factura = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST["factura"], ENT_QUOTES)));
    $total_ft       = floatval($_POST['total_ft4']);
    $identificativo = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST["identificativo"], ENT_QUOTES)));
    $resibido       = floatval($_POST['resibidocobros']);
    $date_added     = date("Y-m-d H:i:s");
   
    
    // Calcular propina y total factura
    $impuesto       = get_row('perfil', 'impuesto', 'id_perfil', 1);
    $propina        = get_row('perfil', 'propina', 'id_perfil', 1);
    $total_propina  = $total_ft * $propina / 100;
    $total_factura  = $total_ft + $total_propina;
    $cambio         = $resibido - $total_ft;

    //echo $total_ft;
    
    //Operacion de Creditos
    if ($condiciones == 4) {
        $estado = 2;
        $saldo_credito = $total_ft - $resibido; // Saldo pendiente para crédito
    } else {
        $estado = 1;
        // Validar que el dinero recibido sea suficiente
        if ($resibido < $total_ft) {
            echo "<script>
              $.Notification.notify('error', 'bottom center', 'NOTIFICACIÓN', 'EL DINERO RESIBIDO ES MENOR AL TOTAL DE LA FACTURA')
                </script>";
            exit;
        }
    }
    
    //Seleccionamos el ultimo compo numero_fatura y aumentamos una
    $sql = mysqli_query($conexion, "SELECT LAST_INSERT_ID(id_factura) AS last FROM facturas_ventas ORDER BY id_factura DESC LIMIT 0,1");

    // Verificar si la consulta se ejecutó correctamente
    if ($sql) {
        // Verificar si se obtuvieron resultados
        if (mysqli_num_rows($sql) > 0) {
            // Obtener el resultado de la consulta
            $rw = mysqli_fetch_array($sql);

            // Verificar si se obtuvo el valor 'last'
            if ($rw && isset($rw['last'])) {
                $id_factura = $rw['last'] + 1;
            } else {
                // No se obtuvo el valor 'last', asignar un valor por defecto
                $id_factura = 1;
            }
        } else {
            // No se obtuvieron resultados, asignar un valor por defecto
            $id_factura = 1;
        }
    } else {
        // La consulta no se ejecutó correctamente, manejar el error según corresponda
        $errors[] = "Error al obtener el ID de factura: " . mysqli_error($conexion);
        $id_factura = 1;
    }

    /* ULTIMA CUENTA DEL CREDITO*/
    $sql_cr = mysqli_query($conexion, "select LAST_INSERT_ID(cuenta_id) as last from creditos order by cuenta_id desc limit 0,1 ");
    $rwc = mysqli_fetch_array($sql_cr);
    $cuenta_id = isset($rwc['last']) ? ($rwc['last'] + 1) : 1;
    
    /* Control de Caja */
    $caja = mysqli_query($conexion, "select LAST_INSERT_ID(caja_id) as last_id, estado_caja from detalle_caja where estado_caja = 0");
    $rw = mysqli_fetch_array($caja);
    $id_caja = $rw ? $rw['last_id'] : 0;
    //$s_inicial = $rw['s_inicial'];
    /*fin */
    
    //Control de la  numero_fatura y aumentamos una
    $query_id = mysqli_query($conexion, "SELECT RIGHT(numero_factura,6) as factura FROM facturas_ventas ORDER BY factura DESC LIMIT 1")
    or die('error ' . mysqli_error($conexion));
    $count = mysqli_num_rows($query_id);

    if ($count != 0) {
        $data_id = mysqli_fetch_assoc($query_id);
        $factura = $data_id['factura'] + 1;
    } else {
        $factura = 1;
    }

    $buat_id = str_pad($factura, 6, "0", STR_PAD_LEFT);
    $factura = "CFF-$buat_id";
    
    // consulta principal
    $nums           = 1;
    $sumador_total  = 0;
    $sum_total      = 0;
    $total_impuesto = 0;
    $t_iva          = 0;
    
    // Ajustar la consulta SQL para incluir identificativo solo si no está vacío
    if (!empty($identificativo)) {
        $sql = "SELECT * FROM productos, tmp_mesa WHERE productos.id_producto=tmp_mesa.producto_tmp AND tmp_mesa.mesa_tmp='" . $numero_mesa . "' AND tmp_mesa.identificativo ='" . $identificativo . "'";
    } else {
        $sql = "SELECT * FROM productos, tmp_mesa WHERE productos.id_producto=tmp_mesa.producto_tmp AND tmp_mesa.mesa_tmp='" . $numero_mesa . "'";
    }
    
    $result = mysqli_query($conexion, $sql);
    
    if ($result) {
        while ($row = mysqli_fetch_array($result)) {
            // Aquí comienza el código del bucle
            $id_tmp = $row["id_tmp"];
            $id_producto = $row['producto_tmp'];
            $codigo_producto = $row['codigo_producto'];
            $cantidad_tmp = $row['cant_tmp'];
            $desc_tmp = $row['desc_tmp'];
            $nombre_producto = $row['nombre_producto'];
    
            $precio_venta = $row['precio_tmp'];
            $importe = ($cantidad_tmp * $precio_venta) - $desc_tmp;
            $precio_venta_f = number_format($precio_venta, 2);
            $precio_venta_r = str_replace(",", "", $precio_venta_f);
            $precio_total = $precio_venta_r * $cantidad_tmp;
            $final_items = rebajas($precio_total, $desc_tmp);
    
            $precio_total_f = number_format($importe, 2);
            $precio_total_r = str_replace(",", "", $precio_total_f);
            $sumador_total += $precio_total_r;
            $subtotal = number_format($sumador_total, 2, '.', '');
    
            if ($row['iva_producto'] == 1) {
                $total_iva = iva($precio_venta);
            } else {
                $total_iva = 0;
            }
            $total_impuesto += rebajas($total_iva, $desc_tmp) * $cantidad_tmp;
    
            // Insertar en la tabla detalle_factura
            $insert_detail = mysqli_query($conexion, "INSERT INTO detalle_fact_ventas VALUES (NULL, '$id_factura', '$factura', '$id_producto', '$cantidad_tmp', '$desc_tmp', '$precio_venta_r', '$precio_total', '$date_added', '$id_caja')");
            
            if (!$insert_detail) {
                $errors[] = "Error al insertar detalle de factura: " . mysqli_error($conexion);
                continue;
            }

            // Verificar si el producto es un combo
            $sql_check_combo = mysqli_query($conexion, "SELECT combo FROM productos WHERE id_producto='" . $id_producto . "'");
            $row_combo = mysqli_fetch_array($sql_check_combo);

            if ($row_combo && $row_combo['combo'] == 'si') {
                // Obtener los productos relacionados en el combo
                $sql_combo_products = mysqli_query($conexion, "SELECT id_producto, cantidad FROM combo_productos WHERE id_combo='" . $id_producto . "'");

                while ($row_combo_product = mysqli_fetch_array($sql_combo_products)) {
                    $id_combo_producto = $row_combo_product['id_producto'];
                    $cantidad_combo_product = $row_combo_product['cantidad'];

                    // Calcular la cantidad total a descontar (cantidad del combo * cantidad vendida)
                    $cantidad_total_descontar = $cantidad_combo_product * $cantidad_tmp;

                    // Obtener el stock actual del producto relacionado
                    $sql_stock = mysqli_query($conexion, "SELECT stock_producto FROM productos WHERE id_producto='" . $id_combo_producto . "'");
                    $row_stock = mysqli_fetch_array($sql_stock);
                    $old_qty = $row_stock['stock_producto'];

                    // Calcular el nuevo stock
                    $new_qty = $old_qty - $cantidad_total_descontar;

                    // Actualizar el stock del producto relacionado
                    $update_stock = mysqli_query($conexion, "UPDATE productos SET stock_producto='" . $new_qty . "' WHERE id_producto='" . $id_combo_producto . "'");

                    // Actualizar el stock en la tabla stock si es necesario
                    $sql_stock_table = mysqli_query($conexion, "SELECT stock_final FROM stock WHERE id_producto_stock='" . $id_combo_producto . "'");
                    $row_stock_table = mysqli_fetch_array($sql_stock_table);

                    if ($row_stock_table != null) {
                        $old_qtys = $row_stock_table['stock_final'];
                        $new_qtys = $old_qtys + $cantidad_total_descontar;
                        $update_stock_table = mysqli_query($conexion, "UPDATE stock SET stock_final='" . $new_qtys . "' WHERE id_producto_stock='" . $id_combo_producto . "' AND control_caja='" . $id_caja . "'");
                    }
                }
            } else {
                // Si no es un combo, actualizar solo el stock del producto individual
                $sql2 = mysqli_query($conexion, "SELECT stock_producto FROM productos WHERE id_producto='" . $id_producto . "'");
                $rw = mysqli_fetch_array($sql2);
                $old_qty = $rw['stock_producto'];
                $new_qty = $old_qty - $cantidad_tmp; // Descuento basado en la cantidad vendida
                $update = mysqli_query($conexion, "UPDATE productos SET stock_producto='" . $new_qty . "' WHERE id_producto='" . $id_producto . "' AND inv_producto=0");

                // Actualizar el stock en la tabla stock si es necesario
                $sql3 = mysqli_query($conexion, "SELECT stock_final FROM stock WHERE id_producto_stock='" . $id_producto . "'");
                $rw = mysqli_fetch_array($sql3);

                if ($rw != null) {
                    $old_qtys = $rw['stock_final'];
                    $new_qtys = $old_qtys + $cantidad_tmp;
                    $update = mysqli_query($conexion, "UPDATE stock SET stock_final='" . $new_qtys . "' WHERE id_producto_stock='" . $id_producto . "' AND control_caja='" . $id_caja . "'");
                }
            }
        }
    } else {
        // Manejar el caso donde la consulta SQL no se ejecuta correctamente
        $errors[] = "Error al obtener detalles de productos: " . mysqli_error($conexion);
    }
    
    // Insertar factura principal
    $insert = "INSERT INTO facturas_ventas VALUES (NULL,'$factura','$date_added','$id_cliente','$id_vendedor','$condiciones','$total_ft','$propina','$estado','$users','$resibido','1','$id_caja','')";
    $factura_id = '';
    if ($conexion->query($insert) === true) {
        $factura_id = $conexion->insert_id;
        $valid['id_factura'] = $factura_id;
    } else {
        $errors[] = "Error al insertar factura principal: " . mysqli_error($conexion);
    }
    
    // Manejo de créditos si es venta a crédito
    if ($condiciones == 4) {
        $insert_prima = mysqli_query($conexion, "INSERT INTO creditos VALUES (NULL,'$factura','$date_added','$id_cliente','$id_vendedor','$total_ft','$saldo_credito','1','$users','1','$cuenta_id')");
        if (!$insert_prima) {
            $errors[] = "Error al crear registro de crédito: " . mysqli_error($conexion);
        }
        
        $insert_abono = mysqli_query($conexion, "INSERT INTO creditos_abonos VALUES (NULL,'$factura','$date_added','$id_cliente','$total_ft','$resibido','$saldo_credito','$users','1','CREDITO INICIAL','$cuenta_id')");
        if (!$insert_abono) {
            $errors[] = "Error al crear abono inicial: " . mysqli_error($conexion);
        }
        
        $insert_detalle = mysqli_query($conexion, "INSERT INTO facturas_creditos VALUES (NULL,'$cuenta_id','$factura','0','$saldo_credito','1')");
        if (!$insert_detalle) {
            $errors[] = "Error al crear detalle de crédito: " . mysqli_error($conexion);
        }
    }
    
    // Eliminar los productos de la mesa temporal
    if (!empty($identificativo)) {
        $delete = mysqli_query($conexion, "DELETE FROM tmp_mesa WHERE mesa_tmp='" . $numero_mesa . "' AND identificativo ='" . $identificativo . "' ");
    } else {
        $delete = mysqli_query($conexion, "DELETE FROM tmp_mesa WHERE mesa_tmp='" . $numero_mesa . "'");
    }
    
    if (!$delete) {
        $errors[] = "Error al limpiar mesa temporal: " . mysqli_error($conexion);
    }
    
    // SI TODO ESTA CORRECTO
    // ACTIVA LA MESA YA NO TIENE PRODUCTOS
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM tmp_mesa where mesa_tmp='" . $numero_mesa . "'");
    $row = mysqli_fetch_array($count_query);
    $numrows = $row['numrows'];
    if ($numrows == 0) {
        $update = actualizar_mesa($numero_mesa);
        $del = elimina_comanda($numero_mesa);
    }
    
    // Mostrar mensajes según el tipo de venta
    if ($condiciones == 4) {
        echo "<script>
        swal({
          title: 'VENTA AL CRÉDITO GUARDADA CON ÉXITO CON ANTICIPO DE: $simbolo_moneda $resibido',
          text: 'Factura: $factura',
          type: 'success',
          confirmButtonText: 'ok'
      })
      </script>";
        exit;
    }
    
    if (!isset($errors) || count($errors) == 0) {
        echo "<script>
        $('#modal_vuelto').modal('show');
        $('#resultado').load('../ajax/agregar_mesa_tmp.php');
        $('#carga_totales').load('../ajax/cuentas_tmp_mesas.php');
        </script>";
    }
} else {
    $errors[] = "Error desconocido.";
}

// Mostrar errores si existen
if (isset($errors) && count($errors) > 0) {
    ?>
    <div class="alert alert-danger" role="alert">
        <strong>Error!</strong>
        <?php
        foreach ($errors as $error) {
            echo $error;
        }
        ?>
    </div>
    <?php
}

// Mostrar mensajes de éxito si existen
if (isset($messages) && count($messages) > 0) {
    ?>
    <div class="alert alert-success" role="alert">
        <strong>¡Bien hecho!</strong>
        <?php
        foreach ($messages as $message) {
            echo $message;
        }
        ?>
    </div>
    <?php
}
?>
<!-- Modal -->
<div class="modal fade" id="modal_vuelto" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel"><i class='fa fa-edit'></i> FACTURA4: <?php echo $factura; ?></h4>
            </div>
            <div class="modal-body" align="center">
                <strong><h3>CAMBIO</h3></strong>
                <div class="alert alert-info" align="center">
                    <strong><h1>
                        <?php echo $simbolo_moneda . ' ' . number_format($cambio, 2); ?>
                    </h1></strong>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="imprimir" class="btn btn-primary btn-block btn-lg waves-effect waves-light" onclick="confirmPrint('<?php echo $factura_id; ?>', '<?php echo $identificativo; ?>');"><span class="fa fa-print"></span> Ticket</button><br>
                <!--<button type="button" id="imprimir2" class="btn btn-success btn-block btn-lg waves-effect waves-light" onclick="printFactura('<?php echo $factura_id; ?>');" accesskey="p"><span class="fa fa-print"></span> Factura</button>-->
            </div>
        </div>
    </div>
</div>