<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
    header("location: ../../login.php");
    exit;
}
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Productos";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$title     = "Productos";
$Productos = 1;
if (isset($_GET['id'])) {
    $id_combog  = intval($_GET['id']);
    $sql_producto = mysqli_query($conexion, "select * from productos where id_producto='$id_combog'");
    $count        = mysqli_num_rows($sql_producto);
    if ($count == 1) {
        $rw_factura     = mysqli_fetch_array($sql_producto);
        $image_path           = $rw_factura['image_path'];
        $_SESSION['id'] = $id_combog;
    } else {
        header("location: ../html/productos.php");
        exit;
    }
} else {
    header("location: ../html/productos.php");
    exit;
}
$query = "SELECT cp.id_combo_producto, p.nombre_producto AS producto, cp.cantidad 
          FROM combo_productos cp
          JOIN productos p ON cp.id_producto = p.id_producto
          WHERE cp.id_combo = $id_combog
          ORDER BY cp.id_combo_producto DESC";

$resultado = $conexion->query($query);

if (!$resultado) {
    die("Error en la consulta: " . $conexion->error);
}

$combos = [];

while ($fila = $resultado->fetch_assoc()) {
    $id_combo = $fila['id_combo_producto'];
    
    if (!isset($combos[$id_combo])) {
        $combos[$id_combo] = [
            'productos' => []
        ];
    }
    
    $combos[$id_combo]['productos'][] = [
        'producto' => $fila['producto'],
        'cantidad' => $fila['cantidad']
    ];
}

$query = "SELECT id_producto, nombre_producto FROM productos";
$resultado = $conexion->query($query);

$productos_options = "";
while ($fila = $resultado->fetch_assoc()) {
    $productos_options .= "<option value='{$fila['id_producto']}'>{$fila['nombre_producto']}</option>";
}
?>

<?php require 'includes/header_start.php';?>

<?php require 'includes/header_end.php';?>

<!-- Begin page -->
<div id="wrapper">

	<?php require 'includes/menu.php';?>

	<!-- ============================================================== -->
	<!-- Start right Content here -->
	<!-- ============================================================== -->
	<div class="content-page">
		<!-- Start content -->
		<div class="content">
			<div class="container">
				<?php if ($permisos_ver == 1) {
    ?>
					<div class="col-lg-12">
						<div class="portlet">
							<div class="portlet-heading bg-primary">
								<h3 class="portlet-title">
									Gestion de Combo
								</h3>
								<div class="portlet-widgets">
									<a href="javascript:;" data-toggle="reload"><i class="ion-refresh"></i></a>
									<span class="divider"></span>
									<a data-toggle="collapse" data-parent="#accordion1" href="#bg-primary"><i class="ion-minus-round"></i></a>
									<span class="divider"></span>
									<a href="#" data-toggle="remove"><i class="ion-close-round"></i></a>
								</div>
								<div class="clearfix"></div>
							</div>
							<div id="bg-primary" class="panel-collapse collapse show">
								<div class="portlet-body">
									<div class="row">
										<div class="col-lg-4">

										<div class="col-lg-12 col-md-6">
											<div class="widget-bg-color-icon card-box">
                                            <div class="bg-icon pull-left">
    <?php
        if ($image_path == null) {
            echo '<img src="../../img/productos/default.jpg" class="rounded" width="150" height="100">';
        } else {
            echo '<img src="' . $image_path . '" class="rounded" width="150" height="100">';
        }
    ?>
</div>

												<div class="text-center">
													<p class="text-muted m-b-5 font-16 font-bold text-uppercase"><?php echo $rw_factura['nombre_producto']; ?></p>
													<p class="text-muted m-b-5 font-14 font-bold text-uppercase"><b class="counter">CODIGO: <?php echo $rw_factura['codigo_producto']; ?></b></p>
													<a class='btn btn-primary waves-effect waves-light btn-sm m-b-5' href="combos.php" title="Regresar al listado de Productos"><i class="fa fa-reply"></i> Regresar
													</a>
												</div>
												<div class="clearfix"></div>
											</div>
										</div>
										<div class="col-lg-12 col-md-6">
											<div class="card-box widget-icon">
												<div>
													<i class="mdi mdi-briefcase-check text-info"></i>
													<div class="wid-icon-info text-center">
														<p class="text-muted m-b-5 font-14 font-bold text-uppercase">EXISTENCIA INVENTARIO</p>
														<p class="m-t-0 m-b-5 counter font-18 font-bold text-primary"><?php echo stock($rw_factura['stock_producto']); ?></p>
													</div>
												</div>
											</div>
										</div>

										<div class="col-lg-12 col-md-6">
											<div class="widget-bg-color-icon card-box">
                                                <form id="formAgregarProducto">
                                                <div class="row">
                                                        <div class="form-group col-md-12">
                                                            <label for="producto">Producto</label>
                                                            <select class="form-control select2" id="producto" name="producto" required>
                                                                <option value="">Seleccione un producto</option>
                                                                <?php echo $productos_options; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="form-group col-md-6">
                                                            <label for="cantidad">Cantidad</label>
                                                            <input type="number" class="form-control" id="cantidad" name="cantidad" value="1" required>
                                                        </div>
                                                        <div class="form-group col-md-6 d-flex align-items-end">
                                                        <button type="submit" class="btn btn-primary btn-block">
                                                            <i class="fa fa-plus"></i> Agregar
                                                        </button>

                                                        </div>
                                                    </div>
                                                </form>
													
											</div>
										</div>
									</div>

									<div class="col-lg-8">
										<div class="panel panel-color panel-info">
											<div class="panel-body">
                                                <div class="container mt-4">
    <h4 class="mb-4">Productos Disponibles en Combo</h4>
    <!-- Tabla de productos -->
    <?php if (empty($combos)): ?>
        <div class="alert alert-info">No hay combos disponibles.</div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="thead-dark">
                    <tr>
                        <th>Producto</th>
                        <th>Cantidad</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($combos as $id_combo => $combo): ?>
                        <?php foreach ($combo['productos'] as $index => $producto): ?>
                            <tr id="combo-<?php echo $id_combo; ?>">
                                <td><?php echo $producto['producto']; ?></td>
                                <td><?php echo $producto['cantidad']; ?></td>
                                <?php if ($index === 0): ?>
                                    <td rowspan="<?php echo count($combo['productos']); ?>">
                                        <button class="btn btn-danger btn-sm" onclick="eliminarCombo(<?php echo $id_combo; ?>)">
                                            Eliminar
                                        </button>
                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>
											</div>
										</div>
									</div>
								</div>

							</div>
						</div>
					</div>
				</div>
				<?php
} else {
    ?>
				<section class="content">
					<div class="alert alert-danger" align="center">
						<h3>Acceso denegado! </h3>
						<p>No cuentas con los permisos necesario para acceder a este módulo.</p>
					</div>
				</section>
				<?php
}
?>

		</div>
		<!-- end container -->
	</div>
	<!-- end content -->

	<?php require 'includes/pie.php';?>

</div>
<!-- ============================================================== -->
<!-- End Right content here -->
<!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui -->
<!-- ============================================================== -->
<script type="text/javascript" src="../../js/ver_historial.js"></script>
<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<script>
	$(document).ready( function () {
		$(".UpperCase").on("keypress", function () {
			$input=$(this);
			setTimeout(function () {
				$input.val($input.val().toUpperCase());
			},50);
		})
	})
</script>
<script>
	$(function() {
		load(1);

//Date range picker
$('.daterange').daterangepicker({
	buttonClasses: ['btn', 'btn-sm'],
	applyClass: 'btn-success',
	cancelClass: 'btn-default',
	locale: {
		format: "DD/MM/YYYY",
		separator: " - ",
		applyLabel: "Aplicar",
		cancelLabel: "Cancelar",
		fromLabel: "Desde",
		toLabel: "Hasta",
		customRangeLabel: "Custom",
		daysOfWeek: [
		"Do",
		"Lu",
		"Ma",
		"Mi",
		"Ju",
		"Vi",
		"Sa"
		],
		monthNames: [
		"Enero",
		"Febrero",
		"Marzo",
		"Abril",
		"Mayo",
		"Junio",
		"Julio",
		"Agosto",
		"Septiembre",
		"Octubre",
		"Noviembre",
		"Diciembre"
		],
		firstDay: 1
	},
	opens: "right"

});
});
</script>
<script>
	function reporte() {
		var daterange = $("#range").val();
		var tipo = $("#tipo").val();
		VentanaCentrada('../pdf/documentos/rep_historial.php?daterange=' + daterange + "&tipo=" + tipo, 'Reporte', '', '800', '600', 'true');
	}
</script>
<script>
function eliminarCombo(id_combo) {
    if (confirm("¿Estás seguro de que deseas eliminar este combo?")) {
        // Crear un objeto FormData para enviar los datos
        const formData = new FormData();
        formData.append('id_combo_producto', id_combo);

        // Enviar una solicitud AJAX al servidor
        fetch('../ajax/eliminar_combo.php', {
            method: 'POST',
            body: formData // Enviar FormData en lugar de JSON
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.message);
                // Eliminar la fila de la tabla
                document.getElementById(`combo-${id_combo}`).remove();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error("Error:", error);
            alert("Ocurrió un error al eliminar el combo.");
        });
    }
}
</script>
<script>
    // Manejar el envío del formulario
    document.getElementById('formAgregarProducto').addEventListener('submit', function (event) {
        event.preventDefault(); // Evitar que el formulario se envíe de forma tradicional

        // Obtener los datos del formulario
        const id_producto = document.getElementById('producto').value;
        const cantidad = document.getElementById('cantidad').value;

        // Validar que se haya seleccionado un producto
        if (!id_producto) {
            alert("Por favor, seleccione un producto.");
            return;
        }

        // Crear un objeto FormData para enviar los datos
        const formData = new FormData();
        formData.append('id_producto', id_producto);
        formData.append('cantidad', cantidad);

        // Enviar una solicitud AJAX al servidor
        fetch('../ajax/guardar_producto.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.message);
                // Agregar la nueva fila a la tabla
                agregarFilaTabla(data.id_combo, data.nombre_producto, cantidad);
                // Limpiar el formulario
                document.getElementById('formAgregarProducto').reset();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error("Error:", error);
            alert("Ocurrió un error al guardar el producto.");
        });
    });

    // Función para agregar una nueva fila a la tabla
    function agregarFilaTabla(id_combo, nombre_producto, cantidad) {
        const tbody = document.querySelector('table tbody');
        const nuevaFila = document.createElement('tr');

        nuevaFila.innerHTML = `
            <td>${nombre_producto}</td>
            <td>${cantidad}</td>
            <td>
                <button class="btn btn-danger btn-sm" onclick="eliminarCombo(${id_combo})">
                    Eliminar
                </button>
            </td>
        `;

        tbody.appendChild(nuevaFila);
    }
</script>
<script>
    // Inicializar Select2 en el campo de selección
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: "Buscar producto...", // Texto de placeholder
            allowClear: true, // Permitir borrar la selección
            width: '100%' // Ajustar el ancho al 100%
        });
    });
</script>
<?php require 'includes/footer_end.php'
?>

