<?php
include '../ajax/is_logged.php'; // Archivo que verifica que el usuario esté logueado
include_once('libs/fpdf.php'); // Incluye la clase FPDF

// Aquí incluyes la conexión y la consulta a la base de datos
require_once "../db.php";
require_once "../php_conexion.php";
// Incluir archivo de funciones PHP
require_once '../funciones.php';
// Obtener el ID del gestor de la sesión actual
$id_gestor = $_SESSION['id_gestor'];
// Obtener la URL del logo del perfil
$logo = get_row('perfil', 'logo_url', 'id_perfil', 1);
// Consulta SQL para obtener el nombre del empleador
$sql_empleador = "SELECT nom_gestor, ape_gestor FROM gestores WHERE id_gestor = $id_gestor";
$resultado_empleador = $conexion->query($sql_empleador);

// Verificar si se encontró el empleador
if ($resultado_empleador->num_rows > 0) {
    $fila_empleador = $resultado_empleador->fetch_assoc();
    $nombre_empleador = utf8_decode($fila_empleador['nom_gestor'] . ' ' . $fila_empleador['ape_gestor']);
} else {
    $nombre_empleador = "Nombre del Empleador Desconocido"; // Si no se encuentra el empleador, se asigna un valor predeterminado
}


class PDF extends FPDF {
    private $empleador;
    private $logo;

    function __construct($empleador, $logo) {
        parent::__construct();
        $this->empleador = $empleador;
        $this->logo = $logo;
    }

    function Header() {
        // Insertar el logo con coordenadas
        $this->Image($this->logo, 10, 2, 30); // Utilizar $this->logo para acceder al logo
        $this->SetFont('Arial', 'B', 12);
        $this->SetX(30); // Ajustar la posición horizontal del texto
        $this->Cell(0, 10, utf8_decode('ASOCIACIÓN NACIONAL DE GESTORES DE ENCOMIENDAS Y CULTURA'), 0, 1, 'C');
        $this->Cell(0, 10, utf8_decode('CALIDAD DE EMPLEADO'), 0, 1, 'C');
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 10, $this->empleador, 0, 1, 'C');
        $this->Ln(0);
    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Página ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }

    function TablaEncabezado() {
        // Establecer el color de fondo
        $this->SetFillColor(200, 200, 200); // Gris claro
        // Establecer la fuente para el encabezado
        $this->SetFont('Arial', 'B', 10);
        // Encabezado de la tabla
        $this->Cell(20, 10, 'ID', 1, 0, 'C', true); // Agregar el encabezado para el ID
        $this->Cell(60, 10, 'Empreador', 1, 0, 'C', true);
        $this->Cell(30, 10, 'Inicio Contrato', 1, 0, 'C', true);
        $this->Cell(30, 10, 'Fin Contrato', 1, 0, 'C', true);
        $this->Cell(40, 10, 'Solicitud', 1, 1, 'C', true);
        // Restaurar la fuente
        $this->SetFont('Arial', '', 10);
    }
    
}

$pdf = new PDF($nombre_empleador, $logo);
    $pdf->AliasNbPages();
    $pdf->AddPage();
    
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->TablaEncabezado(); // Agregar el encabezado de la tabla con fondo gris claro

// Consulta SQL para obtener los datos de calidad_miembro
$sql_calidad_miembro = "SELECT calidad_miembro.*, 
                               calidad_miembro.id_calidad,
                               gestores_asociado.nom_gestor AS nombre_asociado,
                               gestores_asociado.ape_gestor AS apellido_asociado
                        FROM calidad_miembro 
                        INNER JOIN gestores AS gestores_asociado ON gestores_asociado.id_gestor = calidad_miembro.nombre_asociado 
                        WHERE calidad_miembro.empleador = $id_gestor";

$resultado_calidad_miembro = $conexion->query($sql_calidad_miembro);

// Verificar si hay resultados
if ($resultado_calidad_miembro->num_rows > 0) {
    // Iterar sobre cada fila de resultados
    while ($fila = $resultado_calidad_miembro->fetch_assoc()) {
        // Aquí agregas cada fila al reporte PDF
        $pdf->Cell(20,10, $fila['id_calidad'],1,0,'C'); // Agregar el ID de la tabla
        $asociado = utf8_decode($fila['nombre_asociado'] . ' ' . $fila['apellido_asociado']);
        $pdf->Cell(60,10, $asociado,1,0,'C');
        $pdf->Cell(30,10, $fila['fecha_inicio_contrato'],1,0,'C');
        $pdf->Cell(30,10, $fila['fecha_finalizacion_contrato'],1,0,'C');
        $pdf->MultiCell(40,10, utf8_decode($fila['solicitud']),1,'C');
    }
}

$pdf->Output();
?>
