<?php
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";
// Obtener la URL del logo del perfil
$logo = get_row('perfil', 'logo_url', 'id_perfil', 1);
$estado  = isset($_REQUEST['estado']) ? intval($_REQUEST['estado']) : 0;
    $linea   = isset($_REQUEST['linea']) ? intval($_REQUEST['linea']) : 0;
    $destino = isset($_REQUEST['destino']) ? intval($_REQUEST['destino']) : 0;
    $ciudad  = isset($_REQUEST['ciudad']) ? intval($_REQUEST['ciudad']) : 0;
    
    $tables  = "gestores LEFT JOIN selecciones ON gestores.id_gestor = selecciones.gestor_id";
    $campos  = "gestores.*, selecciones.estado_id, selecciones.ciudad_id";
    
    $sWhere  = "1"; // Esto asegura que siempre habrá una condición en el WHERE
    
    if ($estado > 0) {
        $sWhere .= " AND gestores.estado_gestor = " . $estado;
    }
    
    if ($linea > 0) {
        $sWhere .= " AND gestores.aerolinea_gestor = " . $linea;
    }
    
    if ($destino > 0) { // Verificar que destino sea mayor que 0
        $sWhere .= " AND selecciones.estado_id = " . $destino;
    }
    
    if ($ciudad > 0) { // Verificar que ciudad sea mayor que 0
        $sWhere .= " AND selecciones.ciudad_id = " . $ciudad;
    }
    
    $sWhere .= " ORDER BY gestores.nom_gestor ASC";

$query = mysqli_query($conexion, "SELECT $campos FROM  $tables where $sWhere ");

include_once('libs/fpdf.php'); // Incluye la clase FPDF

class PDF extends FPDF
{
    private $logo;

    function __construct($logo) {
        parent::__construct('L'); // Establece la orientación horizontal
        $this->logo = $logo;
    }

    function Header()
    {
       // Insertar el logo con coordenadas
       $this->Image($this->logo, 10, 2, 30); // Utilizar $this->logo para acceder al logo
       $this->SetFont('Arial', 'B', 12);
       $this->SetX(30); // Ajustar la posición horizontal del texto
       $this->Cell(0, 10, utf8_decode('ASOCIACIÓN NACIONAL DE GESTORES DE ENCOMIENDAS Y CULTURA'), 0, 1, 'C');
       $this->Cell(0, 10, utf8_decode('Reporte de Gestores'), 0, 1, 'C');
       $this->SetFont('Arial', '', 10);
       $this->Ln(0);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}

$pdf = new PDF($logo); // Pasa la URL del logo al constructor de PDF
$pdf->AliasNbPages();
$pdf->AddPage();

$pdf->SetFont('Arial','B',9);

// Encabezados con fondo gris claro
$pdf->SetFillColor(211, 211, 211);
$pdf->Cell(15,10,'ID',1,0,'C',true);
$pdf->Cell(80,10,'Nombre del Gestor',1,0,'C',true);
$pdf->Cell(25,10,'DUI',1,0,'C',true);
$pdf->Cell(40,10,'Aerolinea',1,0,'C',true);
$pdf->Cell(90,10,'Destino',1,0,'C',true);
$pdf->Cell(18,10,'Ciudad',1,1,'C',true);

while ($row = mysqli_fetch_array($query)) {
    $id_gestor       = $row['id_gestor'];
    $gestor_fullname = utf8_decode($row['nom_gestor']) . ' ' . utf8_decode($row['ape_gestor']);
    $dui             = $row['dui_gestor'];
    $id_aerolinea    = $row['aerolinea_gestor'];
    $estado_gestor   = $row['estado_gestor'];

    // Obtener el nombre de la aerolínea
    $sql = mysqli_query($conexion, "SELECT nom_aerolinea FROM aerolineas WHERE id_aerolinea='$id_aerolinea'");
    if ($sql && mysqli_num_rows($sql) > 0) {
        $rw = mysqli_fetch_array($sql);
        $nombre_aerolinea = utf8_decode($rw['nom_aerolinea']);
    } else {
        $nombre_aerolinea = "Aerolínea no encontrada";
    }

    // Consulta para obtener los nombres de los estados y ciudades
    $estado_ciudad_query = mysqli_query($conexion, "SELECT estados.nombre AS nombre_estado, ciudades.nombre AS nombre_ciudad 
                                                    FROM selecciones 
                                                    INNER JOIN estados ON selecciones.estado_id = estados.id 
                                                    INNER JOIN ciudades ON selecciones.ciudad_id = ciudades.id 
                                                    WHERE selecciones.gestor_id='$id_gestor'");
    $estado_ciudad_nombres = array();
    while ($row_estado_ciudad = mysqli_fetch_array($estado_ciudad_query)) {
        $estado_ciudad_nombres[] = utf8_decode($row_estado_ciudad['nombre_estado']) . '-' . utf8_decode($row_estado_ciudad['nombre_ciudad']);
    }
    $estado_ciudad_str = implode(', ', $estado_ciudad_nombres);

    // Determinar el estado del gestor
    $text_estado = ($estado_gestor == 1) ? "Activo" : "Inactivo";
    $pdf->SetFont('Arial','',9);
    $pdf->Cell(15,10,$id_gestor,1,0,'C');
    $pdf->Cell(80,10,$gestor_fullname,1,0,'L');
    $pdf->Cell(25,10,$dui,1,0,'L');
    $pdf->Cell(40,10,utf8_decode($nombre_aerolinea),1,0,'L');
    $pdf->Cell(90,10,$estado_ciudad_str,1,0,'L');
    $pdf->Cell(18,10,$text_estado,1,1,'C');
}

$pdf->Output();
?>
