<?php
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";
require_once "libs/fpdf.php"; // Incluye la clase FPDF

// Obtener la URL del logo del perfil
$logo = get_row('perfil', 'logo_url', 'id_perfil', 1);
$q = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
$daterange = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['range'], ENT_QUOTES)));

$tables = "remesas, bancos, cuentas";
$campos = "*";
$sWhere = "remesas.banco_remesa=bancos.id_banco and cuentas.id_cuenta=remesas.cuenta_remesa";

if (!empty($q)) {
    $sWhere .= " and (remesas.numero_remesa like '%$q%' or bancos.nombre_banco like '%$q%' or cuentas.numero_cuenta like '%$q%')";
}

if (!empty($daterange)) {
    list($f_inicio, $f_final) = explode(" - ", $daterange);
    list($dia_inicio, $mes_inicio, $anio_inicio) = explode("/", $f_inicio);
    $fecha_inicial = "$anio_inicio-$mes_inicio-$dia_inicio 00:00:00";
    list($dia_fin, $mes_fin, $anio_fin) = explode("/", $f_final);
    $fecha_final = "$anio_fin-$mes_fin-$dia_fin 23:59:59";

    $sWhere .= " and remesas.fecha_added between '$fecha_inicial' and '$fecha_final'";
}

$sWhere .= " order by remesas.id_remesa ASC";

$query = mysqli_query($conexion, "SELECT $campos FROM $tables where $sWhere");

// Definir la ruta del logotipo
$logo = $logo; // Reemplaza con la ruta correcta de tu logotipo

// Crear el PDF
$pdf = new FPDF();
$pdf->AddPage();

// Encabezado de la asociación
$pdf->Image($logo, 10, 10, 18); // Insertar logotipo
$pdf->SetFont('Arial', 'B', 12); // Establecer fuente en negrita y tamaño 12
$pdf->SetX(180); // Ajustar la posición horizontal del texto
//$pdf->Cell(0, 5, utf8_decode('No. '.$codigo_formatado.''), 0, 1);
$pdf->SetX(30); // Ajustar la posición horizontal del texto
$pdf->Cell(0, 15, utf8_decode('ASOCIACIÓN NACIONAL DE GESTORES DE ENCOMIENDAS Y CULTURA'), 0, 1, 'L'); // Texto del encabezado
$pdf->SetX(30); // Ajustar la posición horizontal del texto
$pdf->SetFont('Arial', '', 10); // Restaurar fuente normal
$pdf->Cell(0, -5, utf8_decode('San Miguel, ' . date('d') . ' de ' . date('F') . ' de ' . date('Y')), 0, 1);
$pdf->Ln(10); // Salto de línea después del encabezado

$pdf->SetFont('Arial', '', 10);

// Fecha
$pdf->Cell(0, 10, 'Fecha: ' . $daterange, 0, 1);

// Encabezado de tabla con color gris claro
$pdf->SetFillColor(211, 211, 211); // Gris claro
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(10, 7, 'ID', 1, 0, 'C', true);
$pdf->Cell(40, 7, 'Banco', 1, 0, 'C', true);
$pdf->Cell(40, 7, 'Cuenta', 1, 0, 'C', true);
$pdf->Cell(30, 7, 'Numero', 1, 0, 'C', true);
$pdf->Cell(40, 7, 'Fecha', 1, 0, 'C', true);
$pdf->Cell(30, 7, 'Monto', 1, 0, 'C', true);
$pdf->Ln();

$pdf->SetFont('Arial', '', 10);

$sumador_total = 0;

while ($row = mysqli_fetch_array($query)) {
    $id_remesa = $row['id_remesa'];
    $nombre_banco = $row['nombre_banco'];
    $numero_cuenta = $row['numero_cuenta'];
    $numero_remesa = $row['numero_remesa'];
    $monto_remesa = $row['monto_remesa'];
    $fecha_remesa = date('d/m/Y', strtotime($row['fecha_added']));

    $sumador_total += $monto_remesa;

    $pdf->Cell(10, 6, $id_remesa, 1);
    $pdf->Cell(40, 6, $nombre_banco, 1);
    $pdf->Cell(40, 6, $numero_cuenta, 1);
    $pdf->Cell(30, 6, $numero_remesa, 1);
    $pdf->Cell(40, 6, $fecha_remesa, 1);
    $pdf->Cell(30, 6, '$' . number_format($monto_remesa, 2), 1);
    $pdf->Ln();
}

// Total
$pdf->Cell(160, 7, 'Total:', 1, 0, 'R');
$pdf->Cell(30, 7, '$' . number_format($sumador_total, 2), 1, 0, 'L');

// Salida del PDF
$pdf->Output();
?>
