<?php
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";
require_once "libs/fpdf.php";

// Check if range and estado_factura are set
if (!isset($_REQUEST['range']) || !isset($_REQUEST['estado_factura'])) {
    exit('Missing parameters');
}

// Get logo URL
$logo = get_row('perfil', 'logo_url', 'id_perfil', 1);

// Get range and estado_factura
$range = mysqli_real_escape_string($conexion, strip_tags($_REQUEST['range'], ENT_QUOTES));
$estado_factura = intval($_REQUEST['estado_factura']);

// Construct SQL query
$tables = "facturas_ventas, users";
$campos = "*";
$sWhere = "users.id_users=facturas_ventas.id_users_factura";

if ($estado_factura > 0) {
    $sWhere .= " and facturas_ventas.id_vendedor = '" . $estado_factura . "' ";
}

if (!empty($range)) {
    list($f_inicio, $f_final) = explode(" - ", $range);
    list($dia_inicio, $mes_inicio, $anio_inicio) = explode("/", $f_inicio);
    $fecha_inicial = "$anio_inicio-$mes_inicio-$dia_inicio 00:00:00";
    list($dia_fin, $mes_fin, $anio_fin) = explode("/", $f_final);
    $fecha_final = "$anio_fin-$mes_fin-$dia_fin 23:59:59";

    $sWhere .= " and facturas_ventas.fecha_factura between '$fecha_inicial' and '$fecha_final' ";
}

$sWhere .= " order by facturas_ventas.id_factura";
$query = mysqli_query($conexion, "SELECT $campos FROM  $tables where $sWhere ");

// Create PDF
class PDF extends FPDF
{
    function Header()
    {
        global $logo;
        $this->Image($logo, 10, 10, 18);
        $this->SetFont('Arial', 'B', 14);
        $this->Cell(0, 10, 'REPORTE DE VENTAS', 0, 1, 'C');
        $this->SetX(30); // Ajustar la posición horizontal del texto
        $this->SetFont('Arial', '', 10); // Restaurar fuente normal
        $this->Cell(0, -5, utf8_decode( date('d') . ' de ' . date('F') . ' de ' . date('Y')), 0, 1, 'R');
        $this->Ln(15);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Page ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }
}

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

// Table header
$pdf->SetFont('Arial', 'B', 10);
$pdf->SetFillColor(211, 211, 211); // Color gris claro
$pdf->Cell(30, 10, 'Factura No', 1, 0, 'C', true); // El parámetro true indica que se debe llenar con el color de fondo
$pdf->Cell(70, 10, 'Cliente', 1, 0, 'C', true);
$pdf->Cell(30, 10, 'Fecha', 1, 0, 'C', true);
$pdf->Cell(30, 10, 'Estado', 1, 0, 'C', true);
$pdf->Cell(30, 10, 'Monto', 1, 1, 'C', true);

// Variable para almacenar el total general
$total_general = 0;

// Table content
while ($row = mysqli_fetch_array($query)) {
    // Retrieve data
    $numero_factura = $row['numero_factura'];
    $nombre_cliente = get_row('clientes', 'nombre_cliente', 'id_cliente', $row['id_cliente']);
    $fecha = date('d/m/Y', strtotime($row['fecha_factura']));
    $estado = ($row['estado_factura'] != 2) ? 'Pagado' : 'Pendiente';
    $monto = number_format($row['monto_factura'], 2);

    // Sumar al total general
    $total_general += $row['monto_factura'];

    // Add row
    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(30, 10, $numero_factura, 1, 0, 'C');
    $pdf->Cell(70, 10, utf8_decode($nombre_cliente), 1, 0, 'L');
    $pdf->Cell(30, 10, $fecha, 1, 0, 'C');
    $pdf->Cell(30, 10, $estado, 1, 0, 'C');
    $pdf->Cell(30, 10, '$' . number_format($monto, 2), 1);
    $pdf->Ln(); // Saltar a la siguiente línea después de imprimir una fila
}

// Total general row
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(160, 10, 'Total General:', 1, 0, 'R');
$pdf->Cell(30, 10, '$' . number_format($total_general, 2), 1, 1, 'F');

$pdf->Output();

?>
