$(document).ready(function () {
  load(1);
  $("#resultados").load("../ajax/editar_tmp_traslado.php");
  $("#resultados3").load("../ajax/carga_resibido.php");
  $("#resultados4").load("../ajax/tipo_doc.php");
  $("#resultados5").load("../ajax/carga_num_trans.php");
  $(".total").load("../ajax/carga_total_cot.php");
});

function load(page) {
  var q = $("#q").val();
  var id_sucursal = $("#id_sucursal").val();
  var categoria = $("#categoria").val();
  $("#loader").fadeIn("slow");
  $.ajax({
    url:
      "../ajax/productos_modal_ventas.php?action=ajax&page=" +
      page +
      "&q=" +
      q +
      "&id_sucursal=" +
      id_sucursal +
      "&categoria=" +
      categoria,
    beforeSend: function (objeto) {
      $("#loader").html('<img src="../../img/ajax-loader.gif"> Cargando...');
    },
    success: function (data) {
      $(".outer_div").html(data).fadeIn("slow");
      $("#loader").html("");
    },
  });
}

function agregar(id) {
  var precio_venta = document.getElementById("precio_venta_" + id).value;
  var cantidad = document.getElementById("cantidad_" + id).value;
  //Inicia validacion
  if (isNaN(cantidad)) {
    $.Notification.notify(
      "error",
      "bottom center",
      "NOTIFICACIÓN",
      "LA CANTIDAD NO ES UN NUMERO. INTENTELO DE NUEVO"
    );
    document.getElementById("cantidad_" + id).focus();
    return false;
  }
  if (isNaN(precio_venta)) {
    $.Notification.notify(
      "error",
      "bottom center",
      "NOTIFICACIÓN",
      "ESTO NO ES UN NUMERO. INTENTELO DE NUEVO"
    );
    document.getElementById("precio_venta_" + id).focus();
    return false;
  }
  //Fin validacion
  $.ajax({
    type: "POST",
    url: "../ajax/editar_tmp_modaltraslado.php",
    data:
      "id=" + id + "&precio_venta=" + precio_venta + "&cantidad=" + cantidad,
    beforeSend: function (objeto) {
      $("#resultados").html(
        '<img src="../../img/ajax-loader.gif"> Cargando...'
      );
    },
    success: function (datos) {
      $.Notification.notify(
        "success",
        "bottom center",
        "NOTIFICACIÓN",
        "PRODUCTO AGREGADO A LA FACTURA CORRECTAMENTE"
      );
      $("#resultados").html(datos);
      $(".total").load("../ajax/carga_total.php");
    },
  });
}

function eliminar(id) {
  $.ajax({
    type: "GET",
    url: "../ajax/editar_tmp_traslado.php",
    data: "id=" + id,
    beforeSend: function (objeto) {
      $("#resultados").html(
        '<img src="../../img/ajax-loader.gif"> Cargando...'
      );
    },
    success: function (datos) {
      $.Notification.notify(
        "warning",
        "bottom center",
        "NOTIFICACIÓN",
        "PRODCUTO ELIMINADO DE LA DATA"
      );
      $("#resultados").html(datos);
      $(".total").load("../ajax/carga_total_cot.php");
    },
  });
}
//GUARDAMOS LA ACTUALIZACION DEL CLIENTE
$("#btn_actualizar").off("click");
$("#btn_actualizar").on("click", function (e) {
  $("#btn_actualizar").attr("disabled", true);
  var id_cliente = $("#id_cliente").val();
  var condiciones = $("#condiciones").val();
  var validez = $("#validez").val();
  var id_vendedor = $("#id_vendedor").val();
  if (id_cliente == "") {
    $.Notification.notify(
      "error",
      "bottom center",
      "NOTIFICACIÓN",
      "SELECCIONAR UN CLIENTE VALIDO"
    );
    $("#nombre_cliente").focus();
    return false;
  }
  parametros = {
    id_cliente: id_cliente,
    condiciones: condiciones,
    validez: validez,
    id_vendedor: id_vendedor,
  };
  $.ajax({
    type: "POST",
    url: "../ajax/editar_fact_traslado.php",
    data: parametros,
    beforeSend: function (objeto) {
      $(".editar_factura").html(
        '<img src="../../img/ajax-loader.gif"> Cargando...'
      );
    },
    success: function (datos) {
      $(".editar_factura").html(datos);
      $("#btn_actualizar").attr("disabled", false);
      $("#resultados").load("../ajax/editar_tmp_cot.php"); // carga los datos nuevamente
      $("#barcode").focus();
      $(".total").load("../ajax/carga_total_cot.php");
      load(1);
      //desaparecer la alerta
      $(".alert-success")
        .delay(400)
        .show(10, function () {
          $(this)
            .delay(2000)
            .hide(10, function () {
              $(this).remove();
            });
        }); // /.alert
    },
  });
  event.preventDefault();
});
//CONTROLA EL FORMULARIO DEL CODIGO DE BARRA
$("#barcode_form").submit(function (event) {
  var id = $("#barcode").val();
  var cantidad = $("#barcode_qty").val();
  var id_factura = $("#factura").val();
  var id_sucursal = 0;
  //Inicia validacion
  if (isNaN(cantidad)) {
    swal(
      "Oops...",
      "La Cantidad no es un numero. Inténtalo de nuevo!",
      "error"
    );
    $("#barcode_qty").focus();
    $("#btn_guardar").attr("disabled", false);
    return false;
  }
  //Fin validacion
  parametros = {
    id: id,
    id_sucursal: id_sucursal,
    cantidad: cantidad,
  };
  $.ajax({
    type: "POST",
    url: "../ajax/editar_tmp_traslado.php",
    data: parametros,
    beforeSend: function (objeto) {
      $("#resultados").html(
        '<img src="../../img/ajax-loader.gif"> Cargando...'
      );
    },
    success: function (datos) {
      $("#resultados").html(datos);
      $(".total").load("../ajax/carga_total_cot.php");
      $("#id").val("");
      $("#id").focus();
      $("#barcode").val("");
    },
  });
  event.preventDefault();
});
//COVERTIMOS LA COTIZACION A VENTA
$("#btn_guardar").off("click");
$("#btn_guardar").on("click", function (e) {
  $("#btn_guardar").attr("disabled", true);
  var id_sucursal1 = $("#id_sucursal1").val();
  var id_sucursal2 = $("#id_sucursal2").val();
  var id_factura = $("#id_factura").val();
  var estado_factura = $("#estado_factura").val();
  var factura = $("#factura").val();
  var total_ft = $("#total_ft").val();
  if (id_sucursal1 == "") {
    $.Notification.notify(
      "error",
      "bottom center",
      "NOTIFICACIÓN",
      "SELECCIONAR UNA SUCURSAL VALIDA"
    );
    $("#nombre_cliente").focus();
    $("#btn_guardar").attr("disabled", false);
    return false;
  }
  parametros = {
    id_sucursal1: id_sucursal1,
    id_sucursal2: id_sucursal2,
    id_factura: id_factura,
    factura: factura,
    estado_factura: estado_factura,
    total_ft: total_ft,
  };
  $.ajax({
    type: "POST",
    url: "../ajax/guardar_venta_traslado.php",
    data: parametros,
    beforeSend: function (objeto) {
      $("#resultados_ajaxf").html(
        '<img src="../../img/ajax-loader.gif"> Cargando...'
      );
    },
    success: function (datos) {
      $("#resultados_ajaxf").html(datos);
      $("#btn_guardar").attr("disabled", false);
      $("#resultados").load("../ajax/editar_tmp_traslado.php"); // carga los datos nuevamente
      $("#barcode").focus();
      load(1);
      //desaparecer la alerta
      $(".alert-success")
        .delay(400)
        .show(10, function () {
          $(this)
            .delay(2000)
            .hide(10, function () {
              $(this).remove();
            });
        }); // /.alert
    },
  });
  event.preventDefault();
});

function imprimir_factura(id_factura) {
  VentanaCentrada(
    "../pdf/documentos/ver_factura.php?id_factura=" + id_factura,
    "Factura",
    "",
    "724",
    "568",
    "true"
  );
}
