<?php
/*-------------------------
Autor: Delmar Lopez
Web: wwww.softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php';
$session_id = session_id();
$sucursal_users = $_SESSION['sucursal_users'];

if (isset($_POST['id'])) {
    $id = $_POST['id'];
}

if (isset($_POST['cantidad'])) {
    $cantidad = $_POST['cantidad'];
}

/* Connect To Database*/
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";

if (!empty($id) and !empty($cantidad)) {
    $id_producto = get_row('productos', 'id_producto', 'codigo_producto', $id);
    $costo_producto = get_row('productos', 'costo_producto', 'id_producto', $id_producto);
    
    $query = mysqli_query($conexion, "select codigo_producto, sucursal_id from productos where codigo_producto = '$id' and sucursal_id = '$sucursal_users'");
    $rw = mysqli_fetch_array($query);

    $comprobar = mysqli_query($conexion, "select * from tmp_compra where id_producto='" . $id_producto . "' and session_id='" . $session_id . "' and sucursal_id = '$sucursal_users'");
    
    if ($row = mysqli_fetch_array($comprobar)) {
        $cant = $row['cantidad_tmp'] + $cantidad;
        $sql = "UPDATE tmp_compra SET cantidad_tmp='" . $cant . "' WHERE id_producto='" . $id_producto . "' and session_id='" . $session_id . "' and sucursal_id = '$sucursal_users'";
        $query_update = mysqli_query($conexion, $sql);
    } else {
        $insert_tmp = mysqli_query($conexion, "INSERT INTO tmp_compra (id_producto,cantidad_tmp,costo_tmp,session_id,sucursal_tmp) VALUES ('$id_producto','$cantidad','$costo_producto','$session_id','$sucursal_users')");
    }
}

if (isset($_GET['id'])) {
    $id_tmp = intval($_GET['id']);
    $delete = mysqli_query($conexion, "DELETE FROM tmp_compra WHERE id_tmp='" . $id_tmp . "'");
}

$simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
$impuesto = get_row('perfil', 'impuesto', 'id_perfil', 1);
$nom_impuesto = get_row('perfil', 'nom_impuesto', 'id_perfil', 1);
?>

<div class="table-responsive">
    <table class="table table-sm">
        <thead style="background-color:#9E9E9E;" class="thead-black">
            <tr>
                <th class='text-center'>CODIGO</th>
                <th class='text-center'>CANTIDAD</th>
                <th>PRODUCTO</th>
                <th class='text-center'>COSTO UNI.</th>
                <th class='text-right'>TOTAL</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sumador_subtotal = 0;
            $sumador_iva = 0;
            $sumador_total = 0;
            
            $sql = mysqli_query($conexion, "select * from productos, tmp_compra where productos.id_producto=tmp_compra.id_producto and tmp_compra.session_id='" . $session_id . "' and sucursal_tmp='" . $sucursal_users . "'");
            
            while ($row = mysqli_fetch_array($sql)) {
                $id_tmp = $row["id_tmp"];
                $codigo_producto = $row['codigo_producto'];
                $cantidad = $row['cantidad_tmp'];
                $nombre_producto = $row['nombre_producto'];
                $precio_costo = $row['costo_tmp'];
                
                // Formateo de valores
                $precio_costo_f = number_format($precio_costo, 2);
                $precio_costo_r = str_replace(",", "", $precio_costo_f);
                
                // Cálculos (asumiendo que costo_tmp ya es sin IVA)
                $precio_sin_iva = $precio_costo_r;
                $iva_producto = ($precio_sin_iva * $impuesto) / 100;
                $precio_con_iva = $precio_sin_iva + $iva_producto;
                
                // Cálculos totales
                $total_sin_iva = $precio_sin_iva * $cantidad;
                $total_iva = $iva_producto * $cantidad;
                $total_con_iva = $precio_sin_iva * $cantidad;
                
                // Acumuladores
                $sumador_subtotal += $total_sin_iva;
                $sumador_iva += $total_iva;
                $sumador_total += $total_con_iva;
            ?>
                <tr>
                    <td class='text-center'><?php echo $codigo_producto; ?></td>
                    <td class='text-center' width="15%">
                        <input style="background-color:#A9DFBF; border-radius: 5px; border: 1px solid #39c; text-align: center" 
                               type="text" class="form-control txt_cant" value="<?php echo $cantidad; ?>" id="<?php echo $id_tmp; ?>">
                    </td>
                    <td><?php echo $nombre_producto; ?></td>
                    <td align="right" width="15%">
                        <input type="text" class="form-control txt_costo" value="<?php echo number_format($precio_costo, 2); ?>" id="<?php echo $id_tmp; ?>">
                    </td>
                    <td class='text-right'><?php echo $simbolo_moneda . ' ' . number_format($total_con_iva, 2); ?></td>
                    <td class='text-center'>
                        <a href="#" class='btn btn-danger btn-sm waves-effect waves-light' onclick="eliminar('<?php echo $id_tmp ?>')">
                            <i class="fa fa-remove"></i>
                        </a>
                    </td>
                </tr>
            <?php
            }
            
            // Formateo de totales
            $subtotal_f = number_format($sumador_subtotal, 2);
            $iva_f = number_format($sumador_iva, 2);
            $total_f = number_format($sumador_total+$iva_f, 2);
            ?>
            
            <tr>
                <td class='text-right' colspan=4>SUBTOTAL <?php echo $simbolo_moneda; ?></td>
                <td class='text-right'><b><?php echo $subtotal_f; ?></b></td>
                <td></td>
            </tr>
            <tr>
                <td class='text-right' colspan=4><?php echo $impuesto; ?>% <?php echo $nom_impuesto; ?></td>
                 <td class='text-right' style="width: 15%;"><input type="text" style="text-align: right;" class="form-control"  value="<?php echo number_format($iva_f, 2); ?>" id="iva" name="iva" readonly></td>
                <!--<td class='text-right'><?php echo $simbolo_moneda . ' ' . $iva_f; ?></b></td>-->
                <td></td>
            </tr>
            <tr>
                <td style="font-size: 14pt;" class='text-right' colspan=4><b>TOTAL <?php echo $simbolo_moneda; ?></b></td>
                <td style="font-size: 14pt;" class='text-right'><b><?php echo $total_f; ?></b></td>
                <td></td>
            </tr>
        </tbody>
    </table>
</div>

<script>
    $(document).ready(function() {
        // Función para actualizar costos
        $('.txt_costo').off('blur').on('blur', function() {
            var id_tmp = $(this).attr("id");
            var costo = $(this).val();
            
            if (isNaN(costo)) {
                $.Notification.notify('error', 'bottom center', 'ERROR!', 'EL COSTO DIGITADO NO ES UN FORMATO VALIDO');
                $(this).focus();
                return false;
            }
            
            $.ajax({
                type: "POST",
                url: "../ajax/editar_costo_compra.php",
                data: {id_tmp: id_tmp, costo: costo},
                success: function(datos) {
                    $("#resultados").load("../ajax/agregar_tmp_compraCredito.php");
                    $.Notification.notify('success', 'bottom center', 'EXITO!', 'COSTO ACTUALIZADO CORRECTAMENTE');
                },
                error: function() {
                    $.Notification.notify('error', 'bottom center', 'ERROR', 'NO SE PUDO ACTUALIZAR EL COSTO');
                }
            });
        });

        // Función para actualizar cantidades
        $(".txt_cant").off("blur").on("blur", function() {
            var id_tmp = $(this).attr("id");
            var cant = $(this).val();
            
            if (isNaN(cant)) {
                $.Notification.notify('error', 'bottom center', 'ERROR', 'DIGITAR LA CANTIDAD');
                $(this).focus();
                return false;
            }
            
            $.ajax({
                type: "POST",
                url: "../ajax/editar_cant_compra.php",
                data: {id_tmp: id_tmp, cant: cant},
                success: function(datos) {
                    $("#resultados").load("../ajax/agregar_tmp_compraCredito.php");
                    $.Notification.notify('success', 'bottom center', 'EXITO!', 'CANTIDAD ACTUALIZADA CORRECTAMENTE');
                },
                error: function() {
                    $.Notification.notify('error', 'bottom center', 'ERROR', 'NO SE PUDO ACTUALIZAR LA CANTIDAD');
                }
            });
        });
    });

    function eliminar(id) {
        if (confirm('¿Está seguro de eliminar este producto?')) {
            $("#resultados").load("../ajax/agregar_tmp_compra.php?id=" + id);
        }
    }
</script>