<?php
/*-------------------------
Autor: Delmar Lopez
Web: www.softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
$simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
get_cadena($user_id);
$modulo = "Ventas";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q      = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $id_suc = intval($_REQUEST['id_sucursal']);
    $daterange      = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['range'], ENT_QUOTES)));
    if ($cargo_users == 1) {
        $id_suc = intval($_REQUEST['id_sucursal']);
    }else {
        $id_suc = $sucursal_users;
    }
    $sTable = "facturas_compras, proveedores, users";
    $sWhere = "";
    $sWhere .= " WHERE facturas_compras.id_proveedor=proveedores.id_proveedor and facturas_compras.id_vendedor=users.id_users";
    if ($id_suc > 0) {
        $sWhere .= " and id_sucursal = '" . $id_suc . "' ";
    }
    if ($_GET['q'] != "") {
        $sWhere .= " and  (proveedores.nombre_proveedor like '%$q%' or facturas_compras.numero_factura like '%$q%' or facturas_compras.ref_factura like '%$q%')";

    }
    if (!empty($daterange)) {
        list($f_inicio, $f_final)                    = explode(" - ", $daterange); //Extrae la fecha inicial y la fecha final en formato espa?ol
        list($dia_inicio, $mes_inicio, $anio_inicio) = explode("/", $f_inicio); //Extrae fecha inicial
        $fecha_inicial                               = "$anio_inicio-$mes_inicio-$dia_inicio 00:00:00"; //Fecha inicial formato ingles
        list($dia_fin, $mes_fin, $anio_fin)          = explode("/", $f_final); //Extrae la fecha final
        $fecha_final                                 = "$anio_fin-$mes_fin-$dia_fin 23:59:59";

        $sWhere .= " and facturas_compras.fecha_factura between '$fecha_inicial' and '$fecha_final' ";
    }


    $sWhere .= " order by facturas_compras.id_factura desc";
    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 10; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../html/bitacoras_compras.php';
    //main query to fetch the data
    $sql   = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    //loop through fetched data
    if ($numrows > 0) {
        echo mysqli_error($conexion);
        ?>
        <div class="table-responsive">
          <table class="table table-sm table-striped">
             <tr  class="info">
                <th>FACTURA</th>
                <th>REFERENCIA</th>
                <th>FECHA</th>
                <th>T.COMPRA</th>
                <th>PROVEEDOR</th>
                <th>ESTADO</th>
                <th>EMPLEADO</th>
                <th class='text-center'>COSTO TOTAL</th>
                <th class='text-center'>TIPO FACTURA</th>
                <th class='text-center'>ACCIONES</th>
            </tr>
            <?php
            $total_gen =0;
while ($row = mysqli_fetch_array($query)) {
            $id_factura         = $row['id_factura'];
            $numero_factura     = $row['numero_factura'];
            $ref_factura     = $row['ref_factura'];
            $fecha              = date("d/m/Y", strtotime($row['fecha_factura']));
            $nombre_proveedor   = $row['nombre_proveedor'];
            $condiciones        = $row['condiciones'];
            $telefono_proveedor = $row['telefono_proveedor'];
            $email_proveedor    = $row['email_proveedor'];
            $contacto_proveedor = $row['contacto_proveedor'];
            $nombre_vendedor    = $row['nombre_users'] . " " . $row['apellido_users'];
            $estado_factura     = $row['estado_factura'];
            $sucursal   = $row['id_sucursal'];
            $total_venta    = $row['monto_factura'];
            $total_gen = $total_gen + $total_venta;
            if ($estado_factura == 1) {
                $text_estado = "Pagada";
                $label_class = 'badge-success';} else {
                $text_estado = "Pendiente";
                $label_class = 'badge-warning';}
            if ($condiciones != 4) {
                $tipo = "CONTADO";
            } else {
                $tipo = "CREDITO";
            }
             if ($row['tipo_factura'] == 'cf') {
                $factura = "Consumidor Final";
            } else {
                $factura = "Credito Fiscal";
            }
            $sql_suc = mysqli_query($conexion, "select nombre_sucursal from sucursales where id_sucursal='$sucursal'");
            $rw  = mysqli_fetch_array($sql_suc);
                $nombre_sucursal = $rw['nombre_sucursal'] ;
            ?>
                        <tr>
                         <td><label class='badge badge-purple'><?php echo $numero_factura; ?></label></td>
                         <td><?php echo $ref_factura; ?></td>
                         <td><?php echo $fecha; ?></td>
                         <td><?php echo $tipo; ?></td>
                         <td><?php echo $nombre_proveedor; ?></td>
                         <td><span class="badge <?php echo $label_class; ?>"><?php echo $text_estado; ?></span></td>
                         <td><?php echo $nombre_vendedor; ?></td>
                         <td class='text-left'><b><?php echo $simbolo_moneda . '' . number_format($total_venta, 2); ?></b></td>
                         <td><?php echo $factura; ?></td>
                         <td class="text-center">
                          <div class="btn-group dropdown">
                            <button type="button" class="btn btn-warning btn-sm dropdown-toggle waves-effect waves-light" data-toggle="dropdown" aria-expanded="false"> <i class='fa fa-cog'></i> <i class="caret"></i> </button>
                            <div class="dropdown-menu dropdown-menu-right">
                               <?php if ($permisos_editar == 1) {?>
                               <!--<a class="dropdown-item" href="editar_compra.php?id_factura=<?php echo $id_factura; ?>"><i class='fa fa-edit'></i> Editar</a>
                               <a class="dropdown-item" href="#" onclick="printOrder('<?php echo $row['id_factura']; ?>')"><i class='fa fa-print'></i> Imprimir</a>-->
                               <a class="dropdown-item" href="#" onclick="imprimir_factura('<?php echo $id_factura; ?>');"><i class='fa fa-download'></i> Imprimir</a>
                               <?php }
            if ($permisos_eliminar == 1) {?>
                               <!--<a class="dropdown-item" href="#" data-toggle="modal" data-target="#dataDelete" data-id="<?php echo $row['id_factura']; ?>"><i class='fa fa-trash'></i> Eliminar</a>-->
                               <?php }?>


                           </div>
                       </div>

                   </td>

               </tr>
               <?php
}
        ?>
           <tr>
              <td colspan=10><span class="pull-right"><?php
echo paginate($reload, $page, $total_pages, $adjacents);
        ?></span></td>
            </tr>
        </table>
    </div>
    <div class="alert alert-info alert-dismissible" role="alert" align="center">
      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <strong> <h3> TOTAL COMPRAS: <?php echo $simbolo_moneda.' '. number_format($total_gen, 2) ?> </h3></strong>
  </div>
    <?php
}
//Este else Fue agregado de Prueba de prodria Quitar
    else {
        ?>
    <div class="alert alert-warning alert-dismissible" role="alert" align="center">
      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <strong>Aviso!</strong> No hay Registro de Facturas
  </div>
  <?php
}
// fin else
}
?>