<?php

/*-------------------------
Autor: Delmar Lopez
Web: softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php";
require_once "../php_conexion.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Clientes";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q        = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $aColumns = array('nom_empleado', 'dui_empleado', 'cod_empleado'); //Columnas de busqueda
    $sTable   = "empleados";
    $sWhere   = "";
    if ($_GET['q'] != "") {
        $sWhere = "WHERE (";
        for ($i = 0; $i < count($aColumns); $i++) {
            $sWhere .= $aColumns[$i] . " LIKE '%" . $q . "%' OR ";
        }
        $sWhere = substr_replace($sWhere, "", -3);
        $sWhere .= ')';
    }
    $sWhere .= " order by nom_empleado";
    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 10; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../html/clientes.php';
    //main query to fetch the data
    $sql   = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    //loop through fetched data
    if ($numrows > 0) {

?>
        <div class="table-responsive">
            <table class="table table-sm table-striped">
                <tr class="info">
                    <th>ID</th>
                    <th>NOMBRE</th>
                    <th>CODIGO EMPLEADO</th>
                    <th>TELEFONO</th>
                    <th>NIT</th>
                    <th>ESTADO</th>
                    <th class='text-right'>ACCIONES</th>
                </tr>
                <?php
                while ($row = mysqli_fetch_array($query)) {
                    $id_mecanico       = $row['id_empleado'];
                    $nombre_mecanico   = $row['nom_empleado'];
                    $nit_mecanico    = $row['dui_empleado'];
                    $tel_mecanico  = $row['tel_empleado'];
                    $dir_mecanico = $row['dir_empleado'];
                    $status_mecanico    = $row['estado_empleado'];
                    $sucursal_id    = $row['sucursal_id'];
                    $com_mecanico    = $row['com_empleado'];
                    $cod_mecanico    = $row['cod_empleado'];
                    if ($status_mecanico == 1) {
                        $estado = "<span class='badge badge-success'>Activo</span>";
                    } else {
                        $estado = "<span class='badge badge-danger'>Inactivo</span>";
                    }

                ?>

                    <input type="hidden" value="<?php echo $nombre_mecanico; ?>" id="nombre_mecanico<?php echo $id_mecanico; ?>">
                    <input type="hidden" value="<?php echo $nit_mecanico; ?>" id="nit_mecanico<?php echo $id_mecanico; ?>">
                    <input type="hidden" value="<?php echo $tel_mecanico; ?>" id="tel_mecanico<?php echo $id_mecanico; ?>">
                    <input type="hidden" value="<?php echo $dir_mecanico; ?>" id="dir_mecanico<?php echo $id_mecanico; ?>">
                    <input type="hidden" value="<?php echo $status_mecanico; ?>" id="status_mecanico<?php echo $id_mecanico; ?>">
                    <input type="hidden" value="<?php echo $sucursal_id; ?>" id="sucursal_id<?php echo $id_mecanico; ?>">
                    <input type="hidden" value="<?php echo $com_mecanico; ?>" id="com_mecanico<?php echo $id_mecanico; ?>">
                    <input type="hidden" value="<?php echo $cod_mecanico; ?>" id="cod_mecanico<?php echo $id_mecanico; ?>">
                    <tr>
                        <td><span class="badge badge-purple"><?php echo $id_mecanico; ?></span></td>
                        <td><?php echo $nombre_mecanico; ?></td>
                        <td><?php echo $cod_mecanico; ?></td>
                        <td><?php echo $tel_mecanico; ?></td>
                        <td><?php echo $nit_mecanico; ?></td>
                        <td><?php echo $estado; ?></td>

                        <td>
                            <div class="btn-group dropdown pull-right">
                                <button type="button" class="btn btn-warning btn-rounded btn-sm waves-effect waves-light" data-toggle="dropdown" aria-expanded="false"> <i class='fa fa-cog'></i> <i class="caret"></i> </button>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <?php if ($permisos_editar == 1) { ?>
                                        <a class="dropdown-item" href="#" data-toggle="modal" data-target="#editarEmpleado" onclick="obtener_datos('<?php echo $id_mecanico; ?>');"><i class='fa fa-edit'></i> Editar</a>
                                    <?php }
                                    if ($permisos_eliminar == 1) { ?>
                                        <a class="dropdown-item" href="#" data-toggle="modal" data-target="#dataDelete" data-id="<?php echo $id_mecanico; ?>"><i class='fa fa-trash'></i> Borrar</a>
                                    <?php } ?>


                                </div>
                            </div>

                        </td>

                    </tr>
                <?php
                }
                ?>
                <tr>
                    <td colspan="8">
                        <span class="pull-right">
                            <?php
                            echo paginate($reload, $page, $total_pages, $adjacents);
                            ?></span>
                    </td>
                </tr>
            </table>
        </div>
    <?php
    }
    //Este else Fue agregado de Prueba de prodria Quitar
    else {
    ?>
        <div class="alert alert-warning alert-dismissible" role="alert" align="center">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <strong>Aviso!</strong> No hay Registro de Mecanicos
        </div>
<?php
    }
    // fin else
}
?>