<?php
include "is_logged.php"; //Archivo comprueba si el usuario esta logueado
/* Connect To Database*/
require_once "../db.php";
require_once "../php_conexion.php";
#require_once "../libraries/inventory.php"; //Contiene funcion que controla stock en el inventario
//Inicia Control de Permisos
include "../permisos.php";
//Archivo de funciones PHP
require_once "../funciones.php";
$user_id = $_SESSION['id_users'];
$action  = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    $daterange      = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['range'], ENT_QUOTES)));
    $employee_id    = intval($_REQUEST['employee_id']);
    $tables         = "log_ordenes,  users";
    $campos         = "*";
    $sWhere         = "users.id_users=log_ordenes.user_id";
    if ($employee_id > 0) {
        $sWhere .= " and log_ordenes.user_id = '" . $employee_id . "' ";
    }
    if (!empty($daterange)) {
        list($f_inicio, $f_final)                    = explode(" - ", $daterange); //Extrae la fecha inicial y la fecha final en formato espa?ol
        list($dia_inicio, $mes_inicio, $anio_inicio) = explode("/", $f_inicio); //Extrae fecha inicial
        $fecha_inicial                               = "$anio_inicio-$mes_inicio-$dia_inicio 00:00:00"; //Fecha inicial formato ingles
        list($dia_fin, $mes_fin, $anio_fin)          = explode("/", $f_final); //Extrae la fecha final
        $fecha_final                                 = "$anio_fin-$mes_fin-$dia_fin 23:59:59";

        $sWhere .= " and log_ordenes.fecha_added between '$fecha_inicial' and '$fecha_final' ";
    }
    $sWhere .= " order by log_ordenes.id_log DESC";

    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 100; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $tables where $sWhere ");
    if ($row = mysqli_fetch_array($count_query)) {
        $numrows = $row['numrows'];
    } else {
        echo mysqli_error($conexion);
    }
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../rep_ventas.php';
    //main query to fetch the data
    $query = mysqli_query($conexion, "SELECT $campos FROM  $tables where $sWhere LIMIT $offset,$per_page");
    //loop through fetched data

    if ($numrows > 0) {
?>

        <div class="table-responsive">
            <table class="table table-condensed table-hover table-striped table-sm">
                <tr>
                    <th class='text-center'>LOG</th>
                    <th>USUARIO</th>
                    <th>ACCION </th>
                    <th>DETALLE </th>
                    <th>SERVICIO</th>
                    <th>FECHA Y HORA</th>
                    <th class='text-left'>MONTO</th>
                    <th>ORDEN</th>
                </tr>
                <?php
                $finales = 0;
                while ($row = mysqli_fetch_array($query)) {
                    $log_id           = $row['id_log'];
                    $user_fullname     = $row['nombre_users'] . ' ' . $row['apellido_users'];
                    $acciones        = $row['acciones'];
                    $detalle        = $row['detalle'];
                    $servicio        = $row['servicio'];
                    $precio        = $row['precio'];
                    $total             = $row['total'];
                    $orden             = $row['orden'];
                    $fecha        = $row['fecha_added'];
                    $subtotal          = $row['total'];

                    $finales++;
                    $simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);

                ?>
                    <tr>
                        <td class='text-center'><label class='badge badge-purple'><?php echo $log_id; ?></label></td>
                        <td><?php echo $user_fullname; ?></td>
                        <td><?php echo $acciones; ?></td>
                        <td style=" background-color:#FFF176;"><?php echo $detalle; ?></td>
                        <td style=" background-color:#FFAB91;"><?php echo $servicio; ?> ( <?php echo $simbolo_moneda . '' . number_format($precio, 2); ?>)</td>
                        <td><?php echo $fecha; ?></td>
                        <td class='text-left'><b><?php echo $simbolo_moneda . '' . number_format($total, 2); ?></b></td>
                        <td><?php echo $orden; ?></td>
                    </tr>
                <?php } ?>
            </table>
        </div>

        <div class="box-footer clearfix" align="right">

            <?php
            $inicios = $offset + 1;
            $finales += $inicios - 1;
            echo "Mostrando $inicios al $finales de $numrows registros";
            echo paginate($reload, $page, $total_pages, $adjacents); ?>

        </div>

<?php
    }
}
?>