<?php
/*-------------------------
Punto de Ventas
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Ventas";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q      = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $sTable = "facturas_orden, clientes, users";
    $sWhere = "";
    $sWhere .= " WHERE facturas_orden.id_cliente=clientes.id_cliente and facturas_orden.id_vendedor=users.id_users";
    if ($_GET['q'] != "") {
        $sWhere .= " and  (clientes.nombre_cliente like '%$q%' or facturas_orden.numero_factura like '%$q%')";

    }

    $sWhere .= " order by facturas_orden.id_factura desc";
    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 10; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../reportes/facturas.php';
    //main query to fetch the data
    $sql   = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    //loop through fetched data
    if ($numrows > 0) {
        echo mysqli_error($conexion);
        ?>
        <div class="table-responsive">
          <table class="table table-sm table-striped">
             <tr  class="info">
                <th>No. Factura</th>
                <th>Fecha</th>
                <th>Cliente</th>
                <th>Vendedor</th>
                <th>Pago</th>                
                <th class='text-center'>Total</th>
                <th class='text-right'>Garantía</th>
                <th class='text-center'>Factura Venta</th>
                <th></th>

            </tr>
            <?php
while ($row = mysqli_fetch_array($query)) {
            $id_factura       = $row['id_factura'];
            $numero_factura   = $row['numero_factura'];
            $fecha            = date("d/m/Y", strtotime($row['fecha_factura']));
            $nombre_cliente   = $row['nombre_cliente'];
            $telefono_cliente = $row['telefono_cliente'];
            $email_cliente    = $row['email_cliente'];
            $nombre_vendedor  = $row['nombre_users'] . " " . $row['apellido_users'];
            $estado_factura   = $row['estado_factura'];
            $garantia         = $row['validez'];
            $detalles         = $row['detalles'];
            $fact_venta       = $row['numero_factura_venta'];
            if ($estado_factura == 1) {
                $text_estado = "CONTADO";
                $label_class = 'badge-success';} else {
                $text_estado = "CREDITO";
                $label_class = 'badge-danger';}
            $total_venta    = $row['monto_factura'];
            $total_venta_edit = 0;
            $simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
            ?>
                        <tr>
                         <td>
                        <a href="#" data-toggle="tooltip" data-placement="top" title="
                            Información de Cliente:<br>
                            <i class='glyphicon glyphicon-phone'></i> <?php echo $telefono_cliente; ?><br>
                            <i class='glyphicon glyphicon-envelope'></i> <?php echo $email_cliente; ?><br>
                            <i class='glyphicon glyphicon-car'></i> <?php echo $detalles; ?><br>
                            <i class='glyphicon glyphicon-car'></i> <?php echo '--HISTORIAL DE CAMBIOS--'; ?><br>
                            
                            <?php
                                $sql_   = "SELECT * FROM facturas_orden_historico where numero_factura='$numero_factura'";
                                $query_ = mysqli_query($conexion, $sql_);
                                while ($row = mysqli_fetch_array($query_)) {
                            ?>
                                    <i class='glyphicon glyphicon-car'></i> <?php echo $row['fecha_factura'] . ' | ' . $row['id_vendedor'] . ' | ' . $row['monto_factura']; ?><br>
                            <?php
                                }
                            ?>
                            <i class='glyphicon glyphicon-car'></i> <?php echo '----'?>">
                            <span class="badge badge-purple"><?php echo $numero_factura; ?></span>
                        </a>
                        </td>
                         <td><?php echo $fecha; ?></td>
                         <td><?php echo $nombre_cliente; ?></td>
                         <td><?php echo $nombre_vendedor; ?></td>
                         <td><span class="badge <?php echo $label_class; ?>"><?php echo $text_estado; ?></span></td>
                         <td class='text-right'><b><?php echo $simbolo_moneda . '' . number_format($total_venta, 2); ?></b></td>
                         <td class='text-right'><?php echo $garantia . ' DIAS'; ?></td>
                         <td class='text-center'><?php echo $fact_venta; ?></td>
                         <td class="text-center">
                          <div class="btn-group dropdown">
                            <button type="button" class="btn btn-warning btn-sm dropdown-toggle waves-effect waves-light" data-toggle="dropdown" aria-expanded="false"> <i class='fa fa-cog'></i> <i class="caret"></i> </button>
                            <div class="dropdown-menu dropdown-menu-right">
                               <?php if ($permisos_editar == 1 and $fact_venta=='') {?>
                               <a class="dropdown-item" href="editar_orden.php?id_factura=<?php echo $id_factura; ?>"><i class='fa fa-edit'></i> Editar | Facturar</a>
                               <?php }
                                    if ($permisos_editar == 1 or $fact_venta != '') {?>
                               <a class="dropdown-item" href="#" onclick="imprimir_factura('<?php echo $id_factura; ?>');"><i class='fa fa-print'></i> Imprimir</a>
                               <?php }?>


                           </div>
                       </div>

                   </td>

               </tr>
               <?php
}
        ?>
           <tr>
              <td colspan=7><span class="pull-right"><?php
echo paginate($reload, $page, $total_pages, $adjacents);
        ?></span></td><td></td><td></td>
            </tr>
        </table>
    </div>
    <?php
}
//Este else Fue agregado de Prueba de prodria Quitar
    else {
        ?>
    <div class="alert alert-warning alert-dismissible" role="alert" align="center">
      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <strong>Aviso!</strong> No hay Registro de Ordenes
  </div>
  <?php
}
// fin else
}
?>