<?php
/*-------------------------
Autor: Delmar Lopez
Web: www.softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
get_cadena($user_id);
$modulo = "Ventas";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q      = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $id_suc = intval($_REQUEST['id_sucursal']);
    $daterange      = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['range'], ENT_QUOTES)));
    if ($cargo_users == 1) {
        $id_suc = intval($_REQUEST['id_sucursal']);
    } else {
        $id_suc = $sucursal_users;
    }
    $sTable = "facturas_ordenes, clientes, users";
    $sWhere = "";
    $sWhere .= " WHERE facturas_ordenes.id_cliente=clientes.id_cliente and facturas_ordenes.id_vendedor=users.id_users";
    if ($id_suc > 0) {
        $sWhere .= " and id_sucursal = '" . $id_suc . "' ";
    }
    if ($_GET['q'] != "") {
        $sWhere .= " and  (clientes.nombre_cliente like '%$q%' or facturas_ordenes.numero_factura like '%$q%')";
    }
    if (!empty($daterange)) {
        list($f_inicio, $f_final)                    = explode(" - ", $daterange); //Extrae la fecha inicial y la fecha final en formato espa?ol
        list($dia_inicio, $mes_inicio, $anio_inicio) = explode("/", $f_inicio); //Extrae fecha inicial
        $fecha_inicial                               = "$anio_inicio-$mes_inicio-$dia_inicio 00:00:00"; //Fecha inicial formato ingles
        list($dia_fin, $mes_fin, $anio_fin)          = explode("/", $f_final); //Extrae la fecha final
        $fecha_final                                 = "$anio_fin-$mes_fin-$dia_fin 23:59:59";

        $sWhere .= " and facturas_ordenes.fecha_factura between '$fecha_inicial' and '$fecha_final' ";
    }

    $sWhere .= " order by facturas_ordenes.id_factura desc";
    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 10; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../reportes/facturas.php';
    //main query to fetch the data
    $sql   = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    //loop through fetched data
    if ($numrows > 0) {
        echo mysqli_error($conexion);
?>
        <div class="table-responsive">
            <table class="table table-sm table-striped">
                <tr class="table-info">
                    <th>ORDEN</th>
                    <th>FECHA</th>
                    <th>CLIENTE</th>
                    <th>EMPLEADO</th>
                    <th>SERVICIO</th>
                    <th>DESCRIPCION</th>
                    <th>MONTO</th>
                    <th>ESTADO</th>
                    <th>FACTURA</th>
                    <th></th>

                </tr>
                <?php
                $total_gen = 0;
                while ($row = mysqli_fetch_array($query)) {
                    $id_factura       = $row['id_factura'];
                    $numero_factura   = $row['numero_factura'];
                    $fecha            = date("d/m/Y", strtotime($row['fecha_factura']));
                    $nombre_cliente   = $row['nombre_cliente'];
                    $telefono_cliente = $row['telefono_cliente'];
                    $email_cliente    = $row['email_cliente'];
                    $nombre_vendedor  = $row['nombre_users'] . " " . $row['apellido_users'];
                    $estado_factura   = $row['estado_factura'];
                    $status   = $row['status_orden'];
                    $factura_venta   = $row['factura_venta'];
                    $vehiculo   = $row['detalle_vehiculo'];
                    $servicio   = $row['servicio'];
                    $sucursal   = $row['id_sucursal'];
                    $validez          = $row['validez'];
                    $total_venta    = $row['monto_factura'];

                    $total_gen = $total_gen + $total_venta;
                    if ($estado_factura == 1) {
                        $text_estado = "CONTADO";
                        $label_class = 'badge-success';
                    } else {
                        $text_estado = "CREDITO";
                        $label_class = 'badge-danger';
                    }
                    if ($status == 1) {
                        $text_ = "PENDIENTE";
                        $label_ = 'badge badge-danger';
                        $vista = '';
                    } else {
                        $text_ = "FACTURADO";
                        $label_ = 'badge badge-success';
                        $vista = 'display: none;';
                    }
                    $sql_suc = mysqli_query($conexion, "select nombre_sucursal from sucursales where id_sucursal='$sucursal'");
                    $rw  = mysqli_fetch_array($sql_suc);
                    $nombre_sucursal = $rw['nombre_sucursal'];
                ?>
                    <tr>
                        <td><label class='badge badge-purple'><?php echo $numero_factura; ?></label></td>
                        <td><?php echo $fecha; ?></td>
                        <td><?php echo $nombre_cliente; ?></td>
                        <td><?php echo $nombre_vendedor; ?></td>
                        <th style=" background-color:#FFF9C4;"><?php echo $vehiculo; ?></th>
                        <th style=" background-color:#F7E4E0;font-size: 10px;width: 20%; ">
                            <?php
                            $sub_consulta = mysqli_query($conexion, "SELECT id_factura, id_producto, descripcion_d, precio_venta, cantidad, descripcion_d FROM  detalle_fact_ordenes where id_factura = $id_factura");
                            while ($roww = mysqli_fetch_array($sub_consulta)) {
                                $id_producto     = $roww['id_producto'];
                                $nombre_producto = $roww['descripcion_d'];
                                if ($roww['descripcion_d'] == '') {
                                    $nombre_producto = get_row('productos', 'nombre_producto', 'id_producto', $id_producto);
                                    $codigo_producto = get_row('productos', 'codigo_producto', 'id_producto', $id_producto);
                                }
                                echo '
                            <ul>
  <li><span class="badge badge-pill badge-primary">' . $roww['cantidad'] . '</span> ' . $nombre_producto . ' (' . $simbolo_moneda . ' ' . number_format($roww['precio_venta'], 2) . ')</li>
</ul>
                            ';
                            }
                            ?>
                        </th>
                        <td class='text-left'><b><?php echo $simbolo_moneda . '' . number_format($total_venta, 2); ?></b></td>
                        <td><span class='<?php echo $label_ ?>'><?php echo $text_  ?></span></td>
                        <td><span class='badge badge-pink'><?php echo $factura_venta ?></span></td>
                        <td class="text-center">
                            <div class="btn-group dropdown">
                                <button type="button" class="btn btn-warning btn-sm dropdown-toggle waves-effect waves-light" data-toggle="dropdown" aria-expanded="false"> <i class='fa fa-cog'></i> <i class="caret"></i> </button>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <?php if ($permisos_editar == 1) { ?>
                                        <di style="<?php echo $vista; ?>">
                                            <a class="dropdown-item" href="editar_ordenes.php?id_factura=<?php echo $id_factura; ?>"><i class='fa fa-edit'></i> Editar</a>
                                        </di>
                                        <a class="dropdown-item" href="#" onclick="imprimir_factura('<?php echo $id_factura; ?>');"><i class='fa fa-print'></i> Imprimir</a>
                                    <?php }
                                    if ($permisos_eliminar == 1) { ?>
                                        <a class="dropdown-item" href="#" data-toggle="modal" data-target="#dataDelete" data-id="<?php echo $id_factura; ?>"><i class='fa fa-trash'></i> Anular Orden</a>
                                        <!--<a class="dropdown-item" href="#" data-toggle="modal" data-target="#dataDelete" data-id="<?php echo $row['id_factura']; ?>"><i class='fa fa-trash'></i> Eliminar</a>-->
                                    <?php } ?>


                                </div>
                            </div>

                        </td>

                    </tr>
                <?php
                }
                ?>
                <tr>
                    <td colspan=10><span class="pull-right"><?php
                                                            echo paginate($reload, $page, $total_pages, $adjacents);
                                                            ?></span></td>
                </tr>
            </table>
        </div>
    <?php
    }
    //Este else Fue agregado de Prueba de prodria Quitar
    else {
    ?>
        <div class="alert alert-warning alert-dismissible" role="alert" align="center">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <strong>Aviso!</strong> No hay Registro de Ordenes/Servicios
        </div>
<?php
    }
    // fin else
}
?>