<?php

include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php";
require_once "../php_conexion.php";
//Archivo de funciones PHP
include "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
//Datos de del Usuario de inicio se sesion.
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
get_cadena($user_id);
$modulo = "Productos";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$sucursal_id = get_row('users', 'sucursal_users', 'id_users', $user_id);
$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    $q = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $linea_id = intval($_REQUEST['categoria']);
    if ($cargo_users == 1) {
        $id_suc = intval($_REQUEST['id_sucursal']);
    } else {
        $id_suc = $sucursal_users;
    }
    $sTable   = "productos, lineas";
    $sWhere   = "";
    $sWhere .= " WHERE lineas.id_linea=productos.id_linea_producto and productos.estado_producto = 1";
    if ($linea_id > 0) {
        $sWhere .= " and productos.id_linea_producto = '" . $linea_id . "' ";
    }
    if ($_GET['q'] != "") {
        $sWhere .= " and  (productos.codigo_producto like '%$q%' or productos.nombre_producto like '%$q%' or productos.cod_oem like '%$q%')";
    }
    if ($id_suc > 0) {
        $sWhere .= " and productos.sucursal_id = '" . $id_suc . "' ";
    }
    $sWhere .= " order by productos.nombre_producto asc";
    include 'pagination.php'; //include pagination file
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 20;
    $adjacents = 4;
    $offset    = ($page - 1) * $per_page;
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../html/productos.php';
    $sql   = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);

    if ($numrows > 0) {
        $simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
?>
        <div class="table-responsive">
            <table class="table table-sm table-striped">
                <tr class="info">
                    <th>ID</th>
                    <th></th>
                    <th>CODIGO</th>
                    <th>PRODUCTO</th>
                    <th class='text-center'>EXIST.</th>
                    <?php if ($permisos_ver == 1) { ?>
                                          
                                    <?php }
                                    if ($permisos_eliminar == 1) { ?>
                    <th class='text-left'>C.PROM</th>
                     <?php } ?>
                    <th class='text-left'>P.VENTA</th>
                    <!--<th class='text-left'>P.VENTA 2</th>
                    <th class='text-left'>P.VENTA 3</th>-->
                    <th class='text-left'>UBICACION</th>
                    <th>ESTADO</th>
                    <th class='text-right'>ACCIONES</th>
                </tr>
                <?php
                while ($row = mysqli_fetch_array($query)) {
                    $id_producto          = $row['id_producto'];
                    $codigo_producto      = $row['codigo_producto'];
                    $cod_oem              = $row['cod_oem'];
                    $nombre_producto      = $row['nombre_producto'];
                    $descripcion_producto = $row['descripcion_producto'];
                    $linea_producto       = $row['id_linea_producto'];
                    $linea2_producto      = $row['id_linea2_producto'];
                    $proveedor_producto   = $row['id_proveedor'];
                    $inv_producto         = $row['inv_producto'];
                    $impuesto_producto    = $row['iva_producto'];
                    $costo_producto       = $row['costo_producto'];
                    $utilidad_producto    = $row['utilidad_producto'];
                    $precio_producto      = $row['valor1_producto'];
                    $precio_mayoreo       = $row['valor2_producto'];
                    $precio_especial      = $row['valor3_producto'];
                    $precio_proyecto      = $row['valor4_producto'];
                    $stock_producto       = $row['stock_producto'];
                    $stock_min_producto   = $row['stock_min_producto'];
                    $status_producto      = $row['estado_producto'];
                    $ubicacion_producto   = $row['ubicacion_producto'];
                    $date_added           = date('d/m/Y', strtotime($row['date_added']));
                    $image_path           = $row['image_path'];
                    $sucursal             = $row['sucursal_id'];

                    // Obtener costo promedio desde kardex (último movimiento)
                    $sql_kardex = mysqli_query($conexion, "SELECT costo_saldo 
                        FROM kardex 
                        WHERE producto_kardex='$id_producto' 
                        ORDER BY id_kardex DESC 
                        LIMIT 1");

                    if ($row_kardex = mysqli_fetch_array($sql_kardex)) {
                        $costo_promedio = $row_kardex['costo_saldo'];
                    } else {
                        $costo_promedio = $costo_producto;
                    }

                    if ($status_producto == 1) {
                        $estado = "<span class='badge badge-success'>Activo</span>";
                    } else {
                        $estado = "<span class='badge badge-danger'>Inactivo</span>";
                    }
                    $sql_suc = mysqli_query($conexion, "select nombre_sucursal from sucursales where id_sucursal='$sucursal'");
                    $rw  = mysqli_fetch_array($sql_suc);
                    $nombre_sucursal = $rw['nombre_sucursal'];
                ?>

                    <input type="hidden" value="<?php echo $codigo_producto; ?>" id="codigo_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $cod_oem; ?>" id="cod_oem<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $nombre_producto; ?>" id="nombre_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $descripcion_producto; ?>" id="descripcion_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $linea_producto; ?>" id="linea_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $linea2_producto; ?>" id="linea2_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $inv_producto; ?>" id="inv_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $impuesto_producto; ?>" id="impuesto_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $stock_producto; ?>" id="stock_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $stock_min_producto; ?>" id="stock_min_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $status_producto; ?>" id="estado<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo number_format($costo_producto, 2, '.', ''); ?>" id="costo_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $utilidad_producto; ?>" id="utilidad_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo number_format($precio_producto, 2, '.', ''); ?>" id="precio_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo number_format($precio_mayoreo, 2, '.', ''); ?>" id="precio_mayoreo<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo number_format($precio_especial, 2, '.', ''); ?>" id="precio_especial<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo number_format($precio_proyecto, 2, '.', ''); ?>" id="precio_proyecto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $sucursal; ?>" id="sucursal<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $ubicacion_producto; ?>" id="ubicacion_producto<?php echo $id_producto; ?>">
                    <input type="hidden" value="<?php echo $proveedor_producto; ?>" id="proveedor_producto<?php echo $id_producto; ?>">

                    <tr>
                        <td><span class="badge badge-purple"><?php echo $id_producto; ?></span></td>
                        <td class='text-center'>
                            <?php
                            if ($image_path == null) {
                                echo '<img src="../../img/productos/default.jpg" class="" width="60">';
                            } else {
                                echo '<img src="' . $image_path . '" class="" width="60">';
                            }
                            ?>
                        </td>
                        <td><?php echo $codigo_producto; ?></td>
                        <td><?php echo $nombre_producto; ?></td>
                        <td class='text-center'><?php echo stock($stock_producto); ?></td>
                        <?php if ($permisos_ver == 1) { ?>
                                          
                                    <?php }
                                    if ($permisos_eliminar == 1) { ?>
                                     <td><span class='pull-left'><?php echo $simbolo_moneda . '' . number_format($costo_promedio, 2); ?></span></td>
                                    <?php } ?>
                        
                        <td><span class='pull-left'><?php echo $simbolo_moneda . '' . number_format($precio_producto, 2); ?></span></td>
                        <!--<td><span class='pull-left'><?php echo $simbolo_moneda . '' . number_format($precio_mayoreo, 2); ?></span></td>
                        <td><span class='pull-left'><?php echo $simbolo_moneda . '' . number_format($precio_especial, 2); ?></span></td>-->
                        <td><?php echo $ubicacion_producto; ?></td>
                        <td><?php echo $estado; ?></td>
                        <td>
                            <div class="btn-group dropdown pull-right">
                                <button type="button" class="btn btn-warning btn-rounded waves-effect waves-light" data-toggle="dropdown" aria-expanded="false"> 
                                    <i class='fa fa-cog'></i> <i class="caret"></i> 
                                </button>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <?php if ($permisos_ver == 1) { ?>
                                        <a class="dropdown-item" href="#" data-toggle="modal" data-target="#editarProducto" onclick="obtener_datos('<?php echo $id_producto; ?>');carga_img('<?php echo $id_producto; ?>');"><i class='fa fa-edit'></i> Editar</a>
                                    <?php }
                                    if ($permisos_editar == 1) { ?>
                                        <a class="dropdown-item" href="historial.php?id=<?php echo $id_producto; ?>"><i class='fa fa-exchange'></i> Ajustes Inv.</a>
                                        <a class="dropdown-item" href="kardex.php?id=<?php echo $id_producto; ?>"><i class='fa fa-calendar'></i> Kardex</a>
                                        <a class="dropdown-item" href="#" data-toggle="modal" data-target="#dataDelete" data-id="<?php echo $id_producto; ?>"><i class='fa fa-trash'></i> Borrar</a>
                                    <?php } ?>
                                    
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php
                }
                ?>
                <tr>
                    <td colspan=12><span class="pull-right">
                            <?php
                            echo paginate($reload, $page, $total_pages, $adjacents);
                            ?></span></td>
                </tr>
            </table>
        </div>
    <?php
    } else {
    ?>
        <div class="alert alert-warning alert-dismissible" role="alert" align="center">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <strong>Aviso!</strong> No hay Registro de Producto
        </div>
<?php
    }
}
?>
