<?php
/*-------------------------
Autor: Delmar Lopez
Web: www.softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
get_cadena($user_id);
$modulo = "Ventas";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q      = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $id_sucursal = intval($_REQUEST['id_sucursal']);
    $daterange      = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['range'], ENT_QUOTES)));
    if ($cargo_users == 1) {
        $id_suc = intval($_REQUEST['id_sucursal']);
    } else {
        $id_suc = $sucursal_users;
    }

    // TABLAS con JOIN incluyendo catalogo_forma_pago
    $sTable = "facturas_ventas 
               INNER JOIN clientes ON facturas_ventas.id_cliente = clientes.id_cliente 
               INNER JOIN users ON facturas_ventas.id_vendedor = users.id_users
               INNER JOIN catalogo_forma_pago fp ON facturas_ventas.pago_codigo = fp.codigo";

    $sWhere = " WHERE 1=1 ";

    if ($id_sucursal > 0) {
        $sWhere .= " and id_sucursal2 = '" . $id_suc . "' ";
    }
    if ($_GET['q'] != "") {
        $sWhere .= " and  (clientes.nombre_cliente like '%$q%' or facturas_ventas.numero_factura like '%$q%')";
    }
    if (!empty($daterange)) {
        list($f_inicio, $f_final)                    = explode(" - ", $daterange); //Extrae la fecha inicial y la fecha final en formato espa?ol
        list($dia_inicio, $mes_inicio, $anio_inicio) = explode("/", $f_inicio); //Extrae fecha inicial
        $fecha_inicial                               = "$anio_inicio-$mes_inicio-$dia_inicio 00:00:00"; //Fecha inicial formato ingles
        list($dia_fin, $mes_fin, $anio_fin)          = explode("/", $f_final); //Extrae la fecha final
        $fecha_final                                 = "$anio_fin-$mes_fin-$dia_fin 23:59:59";

        $sWhere .= " and facturas_ventas.fecha_factura between '$fecha_inicial' and '$fecha_final' ";
    }

    $sWhere .= " and estado_factura <>3 order by facturas_ventas.id_factura desc";
    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 500; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../reportes/facturas.php';
    //main query to fetch the data
    $sql   = "SELECT facturas_ventas.*, 
                     clientes.nombre_cliente, clientes.telefono_cliente, clientes.email_cliente,
                     users.nombre_users, users.apellido_users,
                     fp.descripcion AS forma_pago
              FROM $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    //loop through fetched data
    if ($numrows > 0) {
        echo mysqli_error($conexion);
?>
        <div class="table-responsive">
            <table class="table table-sm table-striped">
                <tr class="info">
                    <th>FACTURA</th>
                    <th>FECHA</th>
                    <th>TIPO PAGO</th>
                    <th>CLIENTE</th>
                    <th>ESTADO</th>
                    <th>EMPLEADO</th>
                    <th class='text-center'>IMPORTE</th>
                    <th>SUCURSAL</th>
                    <th class='text-center'>ACCIONES</th>
                </tr>
                <?php
                $total_gen = 0;
                while ($row = mysqli_fetch_array($query)) {
                    $id_factura       = $row['id_factura'];
                    $numero_factura   = $row['numero_factura'];
                    $fecha            = date("d/m/Y", strtotime($row['fecha_factura']));
                    $nombre_cliente   = $row['nombre_cliente'];
                    $telefono_cliente = $row['telefono_cliente'];
                    $email_cliente    = $row['email_cliente'];
                    $nombre_vendedor  = $row['nombre_users'] . " " . $row['apellido_users'];
                    $estado_factura   = $row['estado_factura'];
                    $tip              = $row['forma_pago']; // 👈 descripción desde catalogo_forma_pago
                    $sucursal         = $row['id_sucursal2'];
                    $total_venta      = $row['monto_factura'];
                    $tipo_comp        = $row['id_comp_factura'];
                    $total_gen        = $total_gen + $total_venta;

                    if ($estado_factura == 1) {
                        $text_estado = "Pagada";
                        $label_class = 'badge-success';
                    } else {
                        $text_estado = "Pendiente";
                        $label_class = 'badge-danger';
                    }

                    //imprimir por el tipo de comprobante
                    if ($tipo_comp == 1) {
                        $imprimir = "printFactura('$id_factura')";
                        $titulo   = "Consumidor Final";
                    } elseif ($tipo_comp == 2) {
                        $imprimir = "printFactura2('$id_factura')";
                        $titulo   = "Credito Fiscal";
                    } else {
                        $imprimir = "printOrder('$id_factura')";
                        $titulo   = "Ticket";
                    }
                    $sql_suc = mysqli_query($conexion, "select nombre_sucursal from sucursales where id_sucursal='$sucursal'");
                    $rw  = mysqli_fetch_array($sql_suc);
                    $nombre_sucursal = $rw['nombre_sucursal'];
                ?>
                    <tr>
                        <td><label class='badge badge-purple'><?php echo $numero_factura; ?></label></td>
                        <td><?php echo $fecha; ?></td>
                        <td><?php echo $tip; ?></td>
                        <td><?php echo $nombre_cliente; ?></td>
                        <td><span class="badge <?php echo $label_class; ?>"><?php echo $text_estado; ?></span></td>
                        <td><?php echo $nombre_vendedor; ?></td>
                        <td class='text-left'><b><?php echo $simbolo_moneda . '' . number_format($total_venta, 2); ?></b></td>
                        <td><span class='badge badge-pink'><?php echo $nombre_sucursal ?></span></td>
                        <td class="text-center">
                            <div class="btn-group dropdown">
                           <button type="button" class="btn btn-warning btn-sm dropdown-toggle waves-effect waves-light" data-toggle="dropdown" aria-expanded="false"> 
    <i class='fa fa-cog'></i> <i class="caret"></i> 
</button>
<div class="dropdown-menu dropdown-menu-right">
    <?php if ($permisos_editar == 1) { ?>
        <a class="dropdown-item" href="#" onclick="<?php echo $imprimir; ?>">
            <i class='fa fa-print'></i> Detalle
        </a>
        <a class="dropdown-item text-primary font-weight-bold" 
           href="#" 
           onclick="openTicketPopup('<?php echo $id_factura; ?>')">
            <i class='fa fa-ticket'></i> Reimprimir Ticket
        </a>

        <!-- Botn Enviar por WhatsApp -->
        <?php
        $telefono = $row['telefono_cliente']; // asegrate de tener este campo
        $nombre_cliente = $row['nombre_cliente']; // asegrate de tener este campo
        $factura  = $numero_factura;
        $total_venta    = number_format($row['monto_factura'], 2);
        $fecha    = date("d-m-Y", strtotime($row['fecha_factura']));
        
        $mensaje = "Hola $nombre_cliente, su Tickete $factura ha sido emitido
        %0AFecha: $fecha
        %0ATotal: $$total_venta
        %0AGracias por preferirnos.";
        $link_whatsapp = "https://wa.me/$telefono?text=$mensaje";
        ?>
        <a class="dropdown-item text-success font-weight-bold" 
           href="<?php echo $link_whatsapp; ?>" 
           target="_blank">
            <i class='fa fa-whatsapp'></i> Enviar WhatsApp
        </a>
    <?php }
    if ($permisos_eliminar == 1) { ?>
        <a class="dropdown-item text-danger" href="#" data-toggle="modal" data-target="#dataDelete" data-id="<?php echo $row['id_factura']; ?>">
            <i class='fa fa-trash'></i> Anular Factura
        </a>
    <?php } ?>
</div>

                        </td>
                    </tr>
                <?php
                }
                ?>
                <tr>
                    <td colspan=9><span class="pull-right"><?php
                                                            echo paginate($reload, $page, $total_pages, $adjacents);
                                                            ?></span></td>
                </tr>
            </table>
        </div>
        <div class="alert alert-info alert-dismissible" role="alert" align="center">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <strong>
                <h3> TOTAL VENTAS: <?php echo $simbolo_moneda . ' ' . number_format($total_gen, 2) ?> </h3>
            </strong>
        </div>
    <?php
    } else {
    ?>
        <div class="alert alert-warning alert-dismissible" role="alert" align="center">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <strong>Aviso!</strong> No hay Registro de Facturas
        </div>
<?php
    }
}
?>
<script>
function openTicketPopup(id_factura) {
    var url = "ticket.php?id_factura=" + id_factura;
    var opciones = "width=400,height=600,scrollbars=no,menubar=no,status=no,resizable=no,top=100,left=100";
    window.open(url, "Ticket", opciones);
}
</script>
