<?php
include 'is_logged.php';
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";

$errors = [];
$messages = [];

if (empty($_POST['id_caja'])) {
    $errors[] = "ID de caja vacío";
} else {
    $id_caja         = intval($_POST['id_caja']);
    $fecha           = mysqli_real_escape_string($conexion, $_POST['fecha']);
    $hora            = mysqli_real_escape_string($conexion, $_POST['hora']);
    $efectivo        = floatval($_POST['efectivo_usuario']);
    $user_id         = intval($_SESSION['id_users']);

    // ========== Datos dinámicos ya calculados =============
    $saldo_inicial   = floatval($_POST['saldo_inicial'] ?? 0);
    $total_ventas    = floatval($_POST['total_ventas'] ?? 0);
    $total_compras   = floatval($_POST['total_compras'] ?? 0);
    $total_egresos   = floatval($_POST['total_egresos'] ?? 0);
    $total_real      = floatval($_POST['total_real'] ?? 0); // total esperado calculado desde backend
    $faltante        = $total_real - $efectivo;

    // ========== Actualizar la tabla detalle_caja =============
    $sql = "UPDATE detalle_caja SET
                ing_efectivo = ?,
                total_caja = ?,
                egresos = ?,
                compras = ?,
                h_cierre = ?,
                estado_caja = 2,
                faltante = ?
            WHERE caja_id = ?";

    $stmt = $conexion->prepare($sql);
    $stmt->bind_param("dddssdi", $efectivo, $total_real, $total_egresos, $total_compras, $hora, $faltante, $id_caja);
    $success = $stmt->execute();

    if ($success) {
        // ========== Guardar desglose de formas de pago =============
        $conexion->query("DELETE FROM detalle_caja_pagos WHERE caja_id = $id_caja");

        if (isset($_POST['pagos']) && is_array($_POST['pagos'])) {
            foreach ($_POST['pagos'] as $pago) {
                $codigo_pago = $pago['codigo'];
                $descripcion = $pago['descripcion'];
                $monto       = floatval($pago['monto']);

                $stmtPago = $conexion->prepare("INSERT INTO detalle_caja_pagos (caja_id, codigo_pago, descripcion_pago, monto) VALUES (?, ?, ?, ?)");
                $stmtPago->bind_param("issd", $id_caja, $codigo_pago, $descripcion, $monto);
                $stmtPago->execute();
            }
        }

        $messages[] = "Cierre de caja exitoso.";

        echo '<script>$("#cerrarCaja").modal("hide");</script>';
    } else {
        $errors[] = "Error al cerrar caja: " . $conexion->error;
    }
}

if (!empty($errors)) {
    echo '<div class="alert alert-danger"><strong>Error:</strong><br>' . implode("<br>", $errors) . '</div>';
}

if (!empty($messages)) {
    echo '<div class="alert alert-success"><strong>Correcto:</strong><br>' . implode("<br>", $messages) . '</div>';
}
?>
