<?php
/*-------------------------
Autor: Delmar Lopez
Web: www.softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
$id_factura     = $_SESSION['id_factura'];
$sucursal_users = $_SESSION['sucursal_users'];
$numero_factura = $_SESSION['numero_factura'];
$date_added = date("Y-m-d H:i:s");
if (isset($_POST['id'])) {
    $id = intval($_POST['id']);
}
if (isset($_POST['cantidad'])) {
    $cantidad = intval($_POST['cantidad']);
}
if (isset($_POST['precio_venta'])) {
    $precio_venta = floatval($_POST['precio_venta']);
}

/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
include "../funciones.php";
$orden        = get_row('facturas_ordenes', 'numero_factura', 'id_factura', $id_factura);
$precio_servicio        = get_row('facturas_ordenes', 'precio_servicio', 'id_factura', $id_factura);
if (!empty($id) and !empty($cantidad) and !empty($precio_venta)) {
    // consulta para comparar el stock con la cantidad resibida
    $query = mysqli_query($conexion, "select stock_producto, inv_producto from productos where id_producto = '$id' and sucursal_id='" . $sucursal_users . "'");
    $rw    = mysqli_fetch_array($query);
    $stock = $rw['stock_producto'];
    $inv   = $rw['inv_producto'];

    //Cmprobamos si agregamos un producto a la tabla tmp_compra
    $comprobar = mysqli_query($conexion, "select * from detalle_fact_ordenes where id_producto='" . $id . "' and id_factura='" . $id_factura . "' and sucursal_id='" . $sucursal_users . "'");
    if ($row = mysqli_fetch_array($comprobar)) {
        $cant = $row['cantidad'] + $cantidad;
        // condicion si el stock e menor que la cantidad requerida
        if ($cant > $stock and $inv == 0) {
            echo "<script>swal('LA CANTIDAD SUPERA AL STOCK!', 'INTENTAR NUEVAMENTE', 'error')</script>";
        } else {
            $sql          = "UPDATE detalle_fact_ordenes SET cantidad='" . $cant . "' WHERE id_producto='" . $id . "' and id_factura='" . $id_factura . "'";
            $query_update = mysqli_query($conexion, $sql);
        }
        // fin codicion cantidad

    } else {
        // condicion si el stock e menor que la cantidad requerida
        if ($cantidad > $stock and $inv == 0) {
            echo "<script>swal('LA CANTIDAD SUPERA AL STOCK!', 'INTENTAR NUEVAMENTE', 'error')</script>";
        } else {
            $insert_tmp = mysqli_query($conexion, "INSERT INTO detalle_fact_ordenes (id_factura,numero_factura, id_producto,cantidad,precio_venta,sucursal_id) VALUES ('$id_factura','$numero_factura','$id','$cantidad','$precio_venta','$sucursal_users')");
        }
        // fin codicion cantaidad
    }
}
if (isset($_GET['id'])) //codigo elimina un elemento del array

{
    $id_detalle = intval($_GET['id']);
    $id_prod    = get_row('detalle_fact_ordenes', 'id_producto', 'id_detalle', $id_detalle);
    $quantity   = get_row('detalle_fact_ordenes', 'cantidad', 'id_detalle', $id_detalle);
    $update     = agregar_stock($id_prod, $quantity, $sucursal_users); //Vuelve agregar al inventario
    $delete     = mysqli_query($conexion, "DELETE FROM detalle_fact_ordenes WHERE id_detalle='" . $id_detalle . "'");
}
$simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
$pv             = get_row('perfil', 'precio_venta', 'id_perfil', 1);
if ($pv == 0) {
    $ok = 'disabled';
} else {
    $ok = '';
}
?>
<div class="table-responsive">
    <table class="table table-sm">
        <thead class="thead-default">
            <tr>
                <th class='text-center'>COD</th>
                <th class='text-center'>CANT.</th>
                <th class='text-center'>DESCRIP.</th>
                <th class='text-center'>PRECIO <?php echo $simbolo_moneda; ?></th>
                <th class='text-right'>TOTAL</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php
            $impuesto       = get_row('perfil', 'impuesto', 'id_perfil', 1);
            $nom_impuesto   = get_row('perfil', 'nom_impuesto', 'id_perfil', 1);
            $sumador_total  = 0;
            $total_iva      = 0;
            $subtotal       = 0;
            $total_impuesto = 0;
            $sql            = mysqli_query($conexion, "select * from productos, facturas_ordenes, detalle_fact_ordenes where facturas_ordenes.id_factura=detalle_fact_ordenes.id_factura and  facturas_ordenes.id_factura='$id_factura' and productos.id_producto=detalle_fact_ordenes.id_producto and  detalle_fact_ordenes.sucursal_id='" . $sucursal_users . "'");
            while ($row = mysqli_fetch_array($sql)) {
                $id_detalle      = $row["id_detalle"];
                $id_producto     = $row["id_producto"];
                $codigo_producto = $row['codigo_producto'];
                $cantidad        = $row['cantidad'];
                $desc_tmp        = $row['desc_venta'];
                $nombre_producto = $row['nombre_producto'];

                $precio_venta   = $row['precio_venta'];
                $precio_venta_f = number_format($precio_venta, 2); //Formateo variables
                $precio_venta_r = str_replace(",", "", $precio_venta_f); //Reemplazo las comas
                $precio_total   = $precio_venta_r * $cantidad;
                $final_items    = rebajas($precio_total, $desc_tmp); //Aplicando el descuento
                /*--------------------------------------------------------------------------------*/
                $precio_total_f = number_format($final_items, 2); //Precio total formateado
                $precio_total_r = str_replace(",", "", $precio_total_f); //Reemplazo las comas
                $sumador_total += $precio_total_r; //Sumador
                $subtotal = number_format($sumador_total, 2, '.', '');
                if ($row['iva_producto'] == 1) {
                    $total_iva = iva($precio_venta);
                } else {
                    $total_iva = 0;
                }
                $total_impuesto += rebajas($total_iva, $desc_tmp) * $cantidad;
                //$total_iva_full = rebajas($total_impuesto, $desc_tmp);
                $t = $subtotal * 0.01;
            ?>
                <tr>
                    <td class='text-center'><?php echo $codigo_producto; ?></td>
                    <td class='text-center' width="15%">
                        <input style=" background-color:#A9DFBF; border-radius: 5px; border: 1px solid #39c; text-align: center" type="text" class="form-control txt_cant" value="<?php echo $cantidad; ?>" id="<?php echo $id_detalle; ?>" onClick="this.select()">
                    </td>
                    <td><?php echo $nombre_producto; ?></td>
                    <td class='text-center'>
                        <?php echo $simbolo_moneda . ' ' . number_format($precio_venta, 4); ?>
                    </td>
                    <td class='text-right'><?php echo $simbolo_moneda . ' ' . number_format($final_items, 4); ?></td>
                    <td class='text-center'>
                        <a href="#" class='btn btn-danger btn-sm waves-effect waves-light' onclick="eliminar('<?php echo $id_detalle ?>')"><i class="fa fa-remove"></i>
                        </a>
                    </td>
                </tr>
            <?php
            }

            $total_factura = $subtotal + $total_impuesto;
            if ($total_factura == 0) {
                $tt =  get_row('facturas_ordenes', 'precio_servicio', 'id_factura', $id_factura);
            } else {
                $tt = $total_factura + $precio_servicio;
            }
            $log     = mysqli_query($conexion, "INSERT INTO log_ordenes VALUES (NULL,'$sucursal_users','Agrego Productos a la Orden .' '.$orden','Modificado','Modificado','','$tt','$orden','$date_added')");
            $update_fact = mysqli_query($conexion, "update facturas_ordenes set monto_factura='$tt' where id_factura='$id_factura'");

            ?>
            <tr>
                <td style="font-size: 14pt;" class='text-right' colspan=4><b>SUBTOTAL <?php echo $simbolo_moneda; ?></b></td>
                <td style="font-size: 14pt; background: #F5B7B1;" class='text-right'><b><?php echo number_format($total_factura, 4); ?></b></td>
                <td></td>
            </tr>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function() {
        $('.txt_desc').off('blur');
        $('.txt_desc').on('blur', function(event) {
            var keycode = (event.keyCode ? event.keyCode : event.which);
            // if(keycode == '13'){
            id_detalle = $(this).attr("id");
            desc = $(this).val();
            //Inicia validacion
            if (isNaN(desc)) {
                $.Notification.notify('error', 'bottom center', 'ERROR', 'DIGITAR UN DESCUENTO VALIDO')
                $(this).focus();
                return false;
            }
            //Fin validacion
            $.ajax({
                type: "POST",
                url: "../ajax/editar_desc_cot.php",
                data: "id_detalle=" + id_detalle + "&desc=" + desc,
                success: function(datos) {
                    $("#resultados").load("../ajax/editar_tmp_cot.php");
                    $.Notification.notify('success', 'bottom center', 'EXITO!', 'DESCUENTO ACTUALIZADO CORRECTAMENTE')
                }
            });
            // }
        });
        $(".employee_id").on("change", function(event) {
            id_detalle = $(this).attr("id");
            precio = $(this).val();
            $.ajax({
                type: "POST",
                url: "../ajax/editar_precio_cot2.php",
                data: "id_tmp=" + id_tmp + "&precio=" + precio,
                success: function(datos) {
                    $("#resultados").load("../ajax/editar_tmp_cot.php");
                    $.Notification.notify('success', 'bottom center', 'EXITO!', 'PRECIO ACTUALIZADO CORRECTAMENTE')
                }
            });
        });
        $(".txt_cant").on("blur", function(event) {
            id_detalle = $(this).attr("id");
            cant = $(this).val();
            //Inicia validacion
            if (isNaN(cant)) {
                $.Notification.notify('error', 'bottom center', 'ERROR', 'DIGITAR LA CANTIDAD')
                $(this).focus();
                return false;
            }
            $.ajax({
                type: "POST",
                url: "../ajax/editar_cant_cot2.php",
                data: "id_detalle=" + id_detalle + "&cant=" + cant,
                success: function(datos) {
                    $("#resultados").load("../ajax/editar_tmp_cot.php");
                    $.Notification.notify('success', 'bottom center', 'EXITO!', 'CANTIDAD ACTUALIZADA CORRECTAMENTE')
                }
            });
        });

    });
</script>