<?php
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/*Inicia validacion del lado del servidor*/
$errors = [];
$messages = [];

if (empty($_POST['codigo'])) {
    $errors[] = "Código vacío";
} else if (!empty($_POST['codigo'])) {
    /* Connect To Database*/
    require_once "../db.php";
    require_once "../php_conexion.php";
    require_once "../funciones.php";

    // escaping + trim
    $codigo           = mysqli_real_escape_string($conexion, trim(strip_tags($_POST["codigo"], ENT_QUOTES)));
    $oem              = mysqli_real_escape_string($conexion, trim(strip_tags($_POST["oem"] ?? '', ENT_QUOTES)));
    $nombre           = mysqli_real_escape_string($conexion, trim(strip_tags($_POST["nombre"] ?? '', ENT_QUOTES)));
    $descripcion      = mysqli_real_escape_string($conexion, trim(strip_tags($_POST["descripcion"] ?? '', ENT_QUOTES)));
    $linea            = intval($_POST['linea'] ?? 0);
    $estado           = intval($_POST['estado'] ?? 0);
    $impuesto         = intval($_POST['impuesto'] ?? 0);
    $inv              = intval($_POST['inv'] ?? 0);
    $costo            = floatval($_POST['costo'] ?? 0);
    $utilidad         = floatval($_POST['utilidad'] ?? 0);
    $precio_venta     = floatval($_POST['precio'] ?? 0);
    $precio_mayoreo   = floatval($_POST['preciom'] ?? 0);
    $precio_especial  = floatval($_POST['precioe'] ?? 0);
    $stock            = floatval($_POST['stock'] ?? 0);
    $stock_minimo     = floatval($_POST['minimo'] ?? 0);
    $date_added       = date("Y-m-d H:i:s");
    $users            = intval($_SESSION['id_users'] ?? 0);
    $sucursal         = 1; // mantuve tu valor; ajusta si usas otra lógica
    $proveedor        = intval($_POST['proveedor'] ?? 0);
    $ubicacion        = mysqli_real_escape_string($conexion, trim(strip_tags($_POST["ubicacion"] ?? '', ENT_QUOTES)));

    // Prepara valor OEM para INSERT: NULL si vacío
    $oem_valor = ($oem !== '') ? "'$oem'" : "NULL";

    // Función pequeña para construir y ejecutar la verificación (evita duplicar código)
    function existe_codigo_oem($conexion, $codigo, $oem) {
        $sql = "SELECT id_producto FROM productos WHERE codigo_producto='$codigo'";
        if ($oem !== '') {
            $sql .= " OR cod_oem='$oem'";
        }
        $sql .= " LIMIT 1";
        $q = mysqli_query($conexion, $sql);
        if ($q === false) {
            return ['error' => mysqli_error($conexion), 'exists' => null, 'sql' => $sql];
        }
        return ['error' => null, 'exists' => (mysqli_num_rows($q) > 0), 'sql' => $sql];
    }

    //Multiplica los productos de acuerdo al numero de las sucursales
    if ($sucursal == 0) {
        $result = mysqli_query($conexion, "SELECT id_sucursal, nombre_sucursal FROM sucursales;");
        while ($fila = mysqli_fetch_array($result)) {
            $sucursal_id = $fila['id_sucursal'];

            // Validamos que no se repita ni el código ni el OEM (usando la función)
            $check = existe_codigo_oem($conexion, $codigo, $oem);
            if ($check['error']) {
                $errors[] = "Error en verificación: " . $check['error'];
                break; // salir del while si hay error de consulta
            }
            if ($check['exists']) {
                $errors[] = "El código o el OEM ya existe en la base de datos, verifica los datos.";
            } else {
                $sql = "INSERT INTO productos 
                        (codigo_producto, cod_oem, nombre_producto, descripcion_producto, 
                        id_linea_producto, id_proveedor, inv_producto, iva_producto, 
                        estado_producto, costo_producto, utilidad_producto, valor1_producto,
                        valor2_producto, valor3_producto, stock_producto, stock_min_producto, 
                        date_added, sucursal_id, ubicacion_producto) 
                        VALUES 
                        ('$codigo', $oem_valor, '$nombre', '$descripcion', '$linea', '$proveedor',
                        '$inv', '$impuesto', '$estado', '$costo', '$utilidad', '$precio_venta',
                        '$precio_mayoreo', '$precio_especial', '$stock', '$stock_minimo',
                        '$date_added', '$sucursal_id', '$ubicacion')";
                $insert = mysqli_query($conexion, $sql);
                if (!$insert) {
                    $errors[] = "Error insertando producto (sucursal $sucursal_id): " . mysqli_error($conexion);
                }
            }
        }
    } else {
        //validación de código y OEM (AHORA condicionada)
        $check = existe_codigo_oem($conexion, $codigo, $oem);
        if ($check['error']) {
            $errors[] = "Error en verificación: " . $check['error'];
        } else if ($check['exists']) {
            $errors[] = "El código o el OEM ya existe en la base de datos, verifica los datos.";
        } else {
            $sql = "INSERT INTO productos 
                    (codigo_producto, cod_oem, nombre_producto, descripcion_producto, 
                    id_linea_producto, id_proveedor, inv_producto, iva_producto, 
                    estado_producto, costo_producto, utilidad_producto, valor1_producto,
                    valor2_producto, valor3_producto, stock_producto, stock_min_producto, 
                    date_added, sucursal_id, ubicacion_producto) 
                    VALUES 
                    ('$codigo', $oem_valor, '$nombre', '$descripcion', '$linea', '$proveedor',
                    '$inv', '$impuesto', '$estado', '$costo', '$utilidad', '$precio_venta',
                    '$precio_mayoreo', '$precio_especial', '$stock', '$stock_minimo',
                    '$date_added', '$sucursal', '$ubicacion')";
            $insert = mysqli_query($conexion, $sql);

            if ($insert) {
                //Seleccionamos el último id con la función correcta
                $id_producto = mysqli_insert_id($conexion);

                // Guardamos las entradas en el KARDEX
                $saldo_total    = $stock * $costo;
                $sql_kardex     = mysqli_query($conexion, "SELECT * FROM kardex WHERE producto_kardex='$id_producto' ORDER BY id_kardex DESC LIMIT 1");
                $rww            = mysqli_fetch_array($sql_kardex);
                $cant_saldo     = (isset($rww['cant_saldo']) ? $rww['cant_saldo'] : 0) + $stock;
                $saldo_full     = (isset($rww['total_saldo']) ? $rww['total_saldo'] : 0) + $saldo_total;
                $costo_promedio = $cant_saldo > 0 ? $saldo_full / $cant_saldo : $costo;
                $tipo           = 5;

                guardar_entradas($date_added, $id_producto, $stock, $costo, $saldo_total, $cant_saldo, $costo_promedio, $saldo_full, $date_added, $users, $tipo);

                $messages[] = "Producto ha sido ingresado satisfactoriamente.";
            } else {
                $errors[] = "Lo siento, algo ha salido mal. Intenta nuevamente. " . mysqli_error($conexion);
            }
        }
    }
} else {
    $errors[] = "Error desconocido.";
}

if (isset($errors) && count($errors) > 0) {
?>
    <div class="alert alert-danger" role="alert">
        <strong>Error!</strong>
        <?php foreach ($errors as $error) {
            echo $error . "<br>";
        } ?>
    </div>
<?php
}
if (isset($messages) && count($messages) > 0) {
?>
    <div class="alert alert-success" role="alert">
        <strong>¡Bien hecho!</strong>
        <?php foreach ($messages as $message) {
            echo $message . "<br>";
        } ?>
    </div>
<?php
}
?>
