<?php
/*-------------------------
Autor: Delmar Lopez
Web: www.softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; //Archivo verifica que el usario que intenta acceder a la URL esta logueado
/* Connect To Database*/
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q        = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $linea_id = intval($_REQUEST['categoria']);
    if ($cargo_users == 1) {
        $id_suc = intval($_REQUEST['id_sucursal']);
    } else {
        $id_suc = $sucursal_users;
    }
    $sTable   = "productos, lineas";
    $sWhere   = "";
    $sWhere .= " WHERE lineas.id_linea=productos.id_linea_producto and productos.estado_producto = 1";
    if ($linea_id > 0) {
        $sWhere .= " and productos.id_linea_producto = '" . $linea_id . "' ";
    }
    if ($_GET['q'] != "") {
        $sWhere .= " and  (productos.codigo_producto like '%$q%' or productos.nombre_producto like '%$q%' or productos.cod_oem like '%$q%')";
    }
    if ($id_suc > 0) {
        $sWhere .= " and productos.sucursal_id = '" . $id_suc . "' ";
    }
    $sWhere .= " order by productos.nombre_producto asc";
    include 'pagination.php'; //include pagination file
    //pagination variables
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 5; //how much records you want to show
    $adjacents = 4; //gap between pages after number of adjacents
    $offset    = ($page - 1) * $per_page;
    //Count the total number of row in your table*/
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row         = mysqli_fetch_array($count_query);
    $numrows     = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload      = '../venta/prueba.php';
    //main query to fetch the data
    $sql   = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    //loop through fetched data
    if ($numrows > 0) {
        $pv = get_row('perfil', 'precio_venta', 'id_perfil', 1);
        if ($pv == 0) {
            $ok = 'disabled';
        } else {
            $ok = '';
        }

?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm">
                <tr class="info">
                    <th></th>
                    <th>COD.</th>
                    <th class='text-center'>PRODUCTOS</th>
                    <th class='text-center'>STOCK</th>
                    <th class='text-center'>CANT</th>
                    <th class='text-center'>PRECIO</th>
                    <th class='text-center' style="width: 36px;"></th>
                </tr>
                <?php
                while ($row = mysqli_fetch_array($query)) {
                    $id_producto     = $row['id_producto'];
                    $codigo_producto = $row['codigo_producto'];
                    $nombre_producto = $row['nombre_producto'];
                    $stock_producto  = $row['stock_producto'];
                    $precio_venta    = $row["valor1_producto"];
                    $precio_venta    = number_format($precio_venta, 2, '.', '');
                    $image_path      = $row['image_path'];
                    $sucursal      = $row['sucursal_id'];
                    $sql_suc = mysqli_query($conexion, "select nombre_sucursal from sucursales where id_sucursal='$sucursal'");
                    $rw  = mysqli_fetch_array($sql_suc);
                    $nombre_sucursal = $rw['nombre_sucursal'];
                ?>
                    <tr>
                        <td class='text-center'>
                            <?php
                            if ($image_path == null) {
                                echo '<img src="../../img/productos/default.jpg" class="" width="60">';
                            } else {
                                echo '<img src="' . $image_path . '" class="" width="60">';
                            }

                            ?>
                            <!--<img src="<?php echo $image_path; ?>" alt="Product Image" class='rounded-circle' width="60">-->
                        </td>
                        <td><?php echo $codigo_producto; ?></td>
                        <td><?php echo $nombre_producto; ?> </td>
                        <td class="text-center"><?php echo stock($stock_producto); ?></td>
                        <td class='col-xs-1' width="15%">
                            <div class="pull-right">
                                <input type="text" class="form-control" style="text-align:center" id="cantidad_<?php echo $id_producto; ?>" value="1">
                            </div>
                        </td>
                        <td class='col-xs-2' width="15%">
    <div class="pull-right">
        <div class="input-group">
            <input type="text" class="form-control" style="text-align:right" id="precio_venta_<?php echo $id_producto; ?>" value="<?php echo $precio_venta; ?>" <?php echo $ok; ?>>
            <div class="input-group-btn">
                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu dropdown-menu-right">
                    <li><a href="#" onclick="document.getElementById('precio_venta_<?php echo $id_producto; ?>').value='<?php echo number_format($row['valor1_producto'], 2, '.', ''); ?>'; return false;">Precio 1: <?php echo number_format($row['valor1_producto'], 2); ?></a></li>
                    <li><a href="#" onclick="document.getElementById('precio_venta_<?php echo $id_producto; ?>').value='<?php echo number_format($row['valor2_producto'], 2, '.', ''); ?>'; return false;">Precio 2: <?php echo number_format($row['valor2_producto'], 2); ?></a></li>
                    <li><a href="#" onclick="document.getElementById('precio_venta_<?php echo $id_producto; ?>').value='<?php echo number_format($row['valor3_producto'], 2, '.', ''); ?>'; return false;">Precio 3: <?php echo number_format($row['valor3_producto'], 2); ?></a></li>
                    <!--<li><a href="#" onclick="document.getElementById('precio_venta_<?php echo $id_producto; ?>').value='<?php echo number_format($row['valor4_producto'], 2, '.', ''); ?>'; return false;">Precio 4: <?php echo number_format($row['valor4_producto'], 2); ?></a></li>-->
                </ul>
            </div>
        </div>
    </div>
</td>
                        <td class='text-center'>
                            <a class='btn btn-success' href="#" title="Agregar a Factura" onclick="agregar('<?php echo $id_producto ?>')"><i class="fa fa-plus"></i>
                            </a>
                        </td>
                    </tr>
                <?php
                }
                ?>
                <tr>
                    <td colspan=7><span class="pull-right">
                            <?php
                            echo paginate($reload, $page, $total_pages, $adjacents);
                            ?></span></td>
                </tr>
            </table>
        </div>
    <?php
    }
    //Este else Fue agregado de Prueba de prodria Quitar
    else {
    ?>
        <div class="alert alert-warning alert-dismissible" role="alert" align="center">
            <strong>Aviso!</strong> No hay Registro de Producto
        </div>
<?php
    }
    // fin else
}
?>