<?php
include "is_logged.php"; // Verifica que el usuario está logueado
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";
include "../permisos.php";

$user_id = $_SESSION['id_users'];
$action  = (isset($_REQUEST['action']) && !empty($_REQUEST['action'])) ? $_REQUEST['action'] : '';

if ($action == 'ajax') {
    $daterange = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['range'], ENT_QUOTES)));
    $categoria = intval($_REQUEST['categoria']);

    $tables = "detalle_fact_ventas d
               INNER JOIN productos p ON d.id_producto = p.id_producto
               INNER JOIN facturas_ventas f ON d.id_factura = f.id_factura";
    $sWhere = "1=1";

    if ($categoria > 0) {
        $sWhere .= " AND p.id_linea_producto = '$categoria'";
    }

    if (!empty($daterange)) {
        list($f_inicio, $f_final) = explode(" - ", $daterange);
        list($dia_inicio, $mes_inicio, $anio_inicio) = explode("/", $f_inicio);
        list($dia_fin, $mes_fin, $anio_fin) = explode("/", $f_final);
        $fecha_inicial = "$anio_inicio-$mes_inicio-$dia_inicio 00:00:00";
        $fecha_final   = "$anio_fin-$mes_fin-$dia_fin 23:59:59";
        $sWhere .= " AND f.fecha_factura BETWEEN '$fecha_inicial' AND '$fecha_final'";
    }

    $sWhere .= " GROUP BY d.id_producto";

    include 'pagination.php'; // Paginación
    $page      = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page  = 100;
    $adjacents = 4;
    $offset    = ($page - 1) * $per_page;

    // Contar filas
    $count_query = mysqli_query($conexion, "SELECT COUNT(*) AS numrows FROM $tables WHERE $sWhere");
    if ($row = mysqli_fetch_array($count_query)) { $numrows = $row['numrows']; } 
    else { die(mysqli_error($conexion)); }

    $total_pages = ceil($numrows / $per_page);
    $reload = '../rep_ventas.php';

    // Consulta principal
    $query = mysqli_query($conexion, "SELECT d.*, p.codigo_producto, p.nombre_producto, p.costo_producto 
                                     FROM $tables WHERE $sWhere LIMIT $offset,$per_page");
    if (!$query) { die(mysqli_error($conexion)); }

    if ($numrows > 0) {
        ?>
        <div class="table-responsive">
            <table class="table table-condensed table-hover table-striped table-sm">
                <tr>
                    <th class='text-center'>Código</th>
                    <th>Producto</th>
                    <th>Cant.</th>
                    <th>Costo Promedio</th>
                    <th>Total Costo</th>
                    <th>Desc. %</th>
                    <th>Total Vendido</th>
                    <th>Utilidad</th>
                </tr>
        <?php
        $finales = 0;
        $simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);

        while ($row = mysqli_fetch_array($query)) {
            $id_producto     = $row['id_producto'];
            $codigo_producto = $row['codigo_producto'];
            $nombre_producto = $row['nombre_producto'];

            // Calcular costo promedio ponderado usando kardex
            $sql_kardex = mysqli_query($conexion, "SELECT * FROM kardex WHERE producto_kardex='$id_producto' ORDER BY id_kardex ASC");
            if (!$sql_kardex) die("Error KARDEX: " . mysqli_error($conexion));

            $stock_total = 0;
            $costo_total = 0;
            $costo_promedio = $row['costo_producto']; // fallback

            while ($mov = mysqli_fetch_array($sql_kardex)) {
                // Entrada
                if ($mov['cant_entrada'] > 0) {
                    $costo_total += $mov['cant_entrada'] * $mov['costo_entrada'];
                    $stock_total += $mov['cant_entrada'];
                    $costo_promedio = $stock_total > 0 ? $costo_total / $stock_total : $mov['costo_entrada'];
                }
                // Salida
                if ($mov['cant_salida'] > 0) {
                    $stock_total -= $mov['cant_salida'];
                    $costo_total -= $mov['cant_salida'] * $costo_promedio;
                }
            }

            // Totales con descuento en porcentaje
            $sql_totales = mysqli_query($conexion, "SELECT SUM(d.cantidad) AS cant, AVG(d.desc_venta) AS d, SUM(d.importe_venta) AS pv 
                                                    FROM detalle_fact_ventas d
                                                    INNER JOIN facturas_ventas f ON d.id_factura=f.id_factura
                                                    WHERE d.id_producto='$id_producto' 
                                                    AND f.fecha_factura BETWEEN '$fecha_inicial' AND '$fecha_final'");
            $rw = mysqli_fetch_array($sql_totales);
            $cantidad       = $rw['cant'];
            $desc_porcentaje = $rw['d']; // ahora es porcentaje
            $total_bruto     = $rw['pv'];

            // Aplicar descuento como porcentaje
            $total_vendido = $total_bruto * (1 - $desc_porcentaje / 100);

            $total_costo = $cantidad * $costo_promedio;
            $utilidad    = $total_vendido - $total_costo;
            $finales++;
            ?>
                <tr>
                    <td class='text-center'><label class='badge badge-purple'><?php echo $codigo_producto; ?></label></td>
                    <td><?php echo $nombre_producto; ?></td>
                    <td><span class="badge badge-success"><?php echo $cantidad; ?></span></td>
                    <td class='text-left'><?php echo $simbolo_moneda . number_format($costo_promedio, 2); ?></td>
                    <td><b><?php echo $simbolo_moneda . number_format($total_costo, 2); ?></b></td>
                    <td><?php echo number_format($desc_porcentaje, 2) . " %"; ?></td>
                    <td><b><?php echo $simbolo_moneda . number_format($total_vendido, 2); ?></b></td>
                    <td><b><?php echo $simbolo_moneda . number_format($utilidad, 2); ?></b></td>
                </tr>
            <?php
        }
        ?>
            </table>
        </div>

        <div class="box-footer clearfix" align="right">
        <?php
        $inicios = $offset + 1;
        $finales += $inicios - 1;
        echo "Mostrando $inicios al $finales de $numrows registros";
        echo paginate($reload, $page, $total_pages, $adjacents);
        ?>
        </div>
        <?php
    } else {
        echo "<div class='alert alert-warning'>No hay registros.</div>";
    }
}
?>
