<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
	header("location: ../../login.php");
	exit;
}
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
$nombre_users          = get_row('users', 'nombre_users', 'id_users', $user_id);
$apellido_users        = get_row('users', 'apellido_users', 'id_users', $user_id);
if ($cargo_users == 1) {
	$est = "";
} else {
	$est = "disabled";
}
get_cadena($user_id);
$modulo = "Facturacion";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$nombre_usuario = get_row('users', 'usuario_users', 'id_users', $user_id);
$comp_id        = get_row('perfil', 'comp_id', 'id_perfil', 1);
$doc_cliente    = get_row('perfil', 'doc_cliente', 'id_perfil', 1);
//consulta para elegir el comprobante
$query = $conexion->query("select * from comprobantes");
$tipo  = array();
while ($r = $query->fetch_object()) {
	$tipo[] = $r;
}
$identificacion01 = $conexion->query("SELECT * FROM dte_identificacion WHERE tipo_dte = '01' LIMIT 1")->fetch_assoc();
$emisor           = $conexion->query("SELECT * FROM emisor LIMIT 1")->fetch_assoc();
$receptor         = $conexion->query("SELECT * FROM receptor LIMIT 1")->fetch_assoc();
// Supón que tienes guardado:
$depto = $receptor['departamento'] ?? '';
$muni = $receptor['municipio'] ?? '';

// Busca el último correlativo usado para ese tipo de DTE y ese punto de venta
$tipoDte = '01'; // O lo que venga del formulario/filtro

// 🔥 OBTENER CÓDIGOS DINÁMICOS DESDE LA BASE DE DATOS
$codEstablecimiento = $emisor['cod_establecimiento'] ?? 'S001';
$codPuntoVenta = $emisor['cod_punto_venta'] ?? 'P001';

// Generar patrón de búsqueda con códigos dinámicos
$like = "DTE-{$tipoDte}-{$codEstablecimiento}{$codPuntoVenta}-%";

$query = "SELECT numero_control FROM facturas_dte 
          WHERE tipo_dte = '$tipoDte' AND numero_control LIKE '$like'
          ORDER BY id DESC LIMIT 1";
$result = mysqli_query($conexion, $query);

$nextCorrelativo = 1;
if ($row = mysqli_fetch_assoc($result)) {
    if (preg_match('/-(\d{15})$/', $row['numero_control'], $matches)) {
        $lastCorrelativo = (int)$matches[1];
        $nextCorrelativo = $lastCorrelativo + 1;
    }
}

// Ahora generas el número de control
$numeroControlSiguiente = sprintf("DTE-%02d-%s%s-%015d", $tipoDte, $codEstablecimiento, $codPuntoVenta, $nextCorrelativo);


// Este es el de prueba numero de control
$tipoDte = intval($datos['identificacion']['tipoDte'] ?? 1); // o el tipoDte que quieras usar
$codPuntoVenta = intval($datos['emisor']['codPuntoVentaMH'] ?? 1);
$correlativo = intval($datos['correlativo'] ?? 31);
$numeroControl = $datos['identificacion']['numeroControl']
    ?? sprintf("DTE-%02d-%s%s-%015d", $tipoDte, $codEstablecimiento, $codPuntoVenta, $correlativo);

$query = "SELECT codigo, descripcion FROM catalogo_forma_pago ORDER BY codigo ASC";
$result = mysqli_query($conexion, $query);
?>

<?php require 'includes/header_start.php'; ?>
<style>
    :root {
        --primary-color: #2c5aa0;
        --primary-light: #3d6bb5;
        --primary-dark: #1e3d6f;
        --secondary-color: #28a745;
        --accent-color: #17a2b8;
        --warning-color: #ffc107;
        --danger-color: #dc3545;
        --light-bg: #f8f9fa;
        --white: #ffffff;
        --border-radius: 12px;
        --border-radius-sm: 8px;
        --box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        --box-shadow-sm: 0 2px 10px rgba(0, 0, 0, 0.05);
        --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        --gradient-primary: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
        --gradient-success: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        --gradient-info: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    }
    body {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .container {
        background: var(--white);
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
        margin: 20px auto;
        overflow: hidden;
    }
    .portlet {
        border: none;
        box-shadow: var(--box-shadow);
        border-radius: var(--border-radius);
        overflow: hidden;
        background: var(--white);
    }
    .portlet-heading {
        background: var(--gradient-primary) !important;
        padding: 25px 30px;
        border: none;
        position: relative;
        overflow: hidden;
    }
    .portlet-heading::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="20" cy="20" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="80" cy="40" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="40" cy="80" r="1" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.3;
    }
    .portlet-title {
        color: var(--white) !important;
        font-size: 1.8rem;
        font-weight: 700;
        margin: 0;
        position: relative;
        z-index: 1;
        display: flex;
        align-items: center;
        gap: 12px;
    }
    .portlet-title::before {
        content: '🛒';
        font-size: 1.5rem;
    }
    .card-box {
        background: var(--white);
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow-sm);
        border: 1px solid rgba(44, 90, 160, 0.1);
        padding: 30px;
        margin-bottom: 25px;
        transition: var(--transition);
        position: relative;
        overflow: hidden;
    }
    .card-box::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: var(--gradient-primary);
    }
    .card-box:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(44, 90, 160, 0.15);
    }
    .form-group label {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 8px;
        font-size: 0.95rem;
        display: flex;
        align-items: center;
        gap: 6px;
    }
    .required-badge {
        color: var(--danger-color);
        font-size: 1.1em;
        font-weight: bold;
    }
    .form-control {
        border: 2px solid #e9ecef;
        border-radius: var(--border-radius-sm);
        padding: 12px 16px;
        font-size: 0.95rem;
        transition: var(--transition);
        background: var(--white);
        box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.06);
    }
    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 0.2rem rgba(44, 90, 160, 0.15);
        background: var(--white);
        transform: translateY(-1px);
    }
    .form-control:hover:not(:focus) {
        border-color: #ced4da;
        transform: translateY(-1px);
    }
    .btn {
        padding: 12px 24px;
        border-radius: var(--border-radius-sm);
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: var(--transition);
        border: none;
        position: relative;
        overflow: hidden;
        font-size: 0.9rem;
    }
    .btn::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        transition: left 0.5s;
    }
    .btn:hover::before {
        left: 100%;
    }
    .btn-success {
        background: var(--gradient-success);
        box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
    }
    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(40, 167, 69, 0.4);
    }
    .btn-primary {
        background: var(--gradient-primary);
        box-shadow: 0 4px 15px rgba(44, 90, 160, 0.3);
    }
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(44, 90, 160, 0.4);
    }
    .btn-outline-info {
        border: 2px solid var(--accent-color);
        color: var(--accent-color);
        background: transparent;
        font-weight: 600;
    }
    .btn-outline-info:hover {
        background: var(--accent-color);
        color: var(--white);
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(23, 162, 184, 0.3);
    }
    .btn-danger {
        background: linear-gradient(135deg, var(--danger-color) 0%, #e74c3c 100%);
        color: var(--white);
        padding: 8px 12px;
        font-size: 0.8rem;
        border-radius: 50%;
        width: 35px;
        height: 35px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .btn-danger:hover {
        transform: scale(1.1) rotate(5deg);
        box-shadow: 0 4px 15px rgba(220, 53, 69, 0.4);
    }
    /*ordenar los botones*/
    /* Estilo base */
    .action-btn {
        font-size: 0.85rem;
        padding: 18px 32px;
        height: 60px;
        min-width: 250px;
        border-radius: 10px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        margin: 6px; /* 💡 separa siempre un poco */
    }

    /* Responsive para móviles */
    @media (max-width: 576px) {
        #action-buttons {
            flex-direction: column !important;
            align-items: center !important;
        }

        .action-btn {
            width: 90%;
            min-width: unset;
            margin: 8px 0; /* 🧼 espacio arriba y abajo */
        }
    }
    /* End Boton */


    .items-table {
        border-radius: var(--border-radius);
        overflow: hidden;
        box-shadow: var(--box-shadow-sm);
        background: var(--white);
        margin-bottom: 0;
    }
    .items-table thead th {
        background: var(--primary-color); /* azul sólido */
        color: var(--white);
        font-weight: 700;
        text-align: center;
        border: none;
        font-size: 0.9rem;
        padding: 18px 12px;
        letter-spacing: 0.5px;
        text-transform: uppercase;
        position: relative;
    }
    .items-table thead th::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 2px;
        background: rgba(255, 255, 255, 0.3);
    }
    .items-table tbody tr {
        transition: var(--transition);
        border-bottom: 1px solid #f1f3f4;
    }
    .items-table tbody tr:hover {
        background: linear-gradient(135deg, rgba(44, 90, 160, 0.02) 0%, rgba(44, 90, 160, 0.05) 100%);
        transform: translateX(2px);
    }
    .items-table tbody td {
        padding: 15px 12px;
        vertical-align: middle;
        border: none;
    }
    .resumen-dte {
        margin-top: 25px;
        margin-bottom: 0;
    }
    .resumen-table {
        min-width: 350px;
        max-width: 450px;
        margin-left: auto;
        margin-right: 0;
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
        background: var(--white);
        overflow: hidden;
        border: none;
    }
    .resumen-table th {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        font-weight: 600;
        text-align: right;
        vertical-align: middle;
        color: #495057;
        border: none;
        padding: 15px 20px;
        font-size: 0.9rem;
    }
    .resumen-table td {
        text-align: right;
        font-weight: 700;
        font-size: 1.1em;
        vertical-align: middle;
        padding: 15px 20px;
        border: none;
        background: var(--white);
    }
    .resumen-table tr:last-child td {
        background: var(--gradient-primary);
        color: var(--white);
        font-size: 1.3em;
        font-weight: 800;
    }
    .resumen-table tr:last-child th {
        background: var(--gradient-primary);
        color: var(--white);
        font-weight: 700;
    }
    .item-section, .doc-rel-section {
        border: 2px dashed rgba(44, 90, 160, 0.2);
        padding: 25px;
        margin-bottom: 20px;
        border-radius: var(--border-radius);
        background: linear-gradient(135deg, rgba(44, 90, 160, 0.02) 0%, rgba(44, 90, 160, 0.05) 100%);
        position: relative;
        transition: var(--transition);
    }
    .item-section:hover, .doc-rel-section:hover {
        border-color: rgba(44, 90, 160, 0.3);
        background: linear-gradient(135deg, rgba(44, 90, 160, 0.05) 0%, rgba(44, 90, 160, 0.08) 100%);
    }
    .ui-autocomplete {
        position: absolute !important;
        z-index: 99999 !important;
        max-height: 250px;
        overflow-y: auto;
        overflow-x: hidden;
        background: var(--white);
        border: 2px solid var(--primary-color);
        border-radius: var(--border-radius-sm);
        font-size: 14px;
        box-shadow: 0 8px 25px rgba(44, 90, 160, 0.2);
    }
    .ui-menu-item-wrapper {
        padding: 12px 16px;
        cursor: pointer;
        border-bottom: 1px solid #f1f3f4;
        transition: var(--transition);
    }
    .ui-menu-item-wrapper:hover {
        background: var(--gradient-primary);
        color: var(--white);
        transform: translateX(3px);
    }
    .ui-menu-item-wrapper:last-child {
        border-bottom: none;
    }
    .ui-helper-hidden-accessible {
        display: none;
    }
    .table-responsive {
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow-sm);
        overflow: hidden;
        margin-bottom: 25px;
    }
    .form-text {
        color: #6c757d;
        font-size: 0.85rem;
        margin-top: 6px;
        font-style: italic;
    }
    .alert {
        border-radius: var(--border-radius);
        border: none;
        box-shadow: var(--box-shadow-sm);
        padding: 20px;
        margin-bottom: 25px;
    }
    .alert-warning {
        background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
        color: #856404;
        border-left: 4px solid var(--warning-color);
    }
    .alert-danger {
        background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
        color: #721c24;
        border-left: 4px solid var(--danger-color);
    }
    pre {
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: var(--border-radius-sm);
        padding: 20px;
        font-size: 0.85rem;
        max-height: 300px;
        overflow-y: auto;
        color: #495057;
    }
    .widget-chart {
        position: relative;
    }
    .row {
        margin-bottom: 15px;
    }
    .form-group {
        margin-bottom: 20px;
    }
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    .card-box {
        animation: fadeInUp 0.6s ease-out;
    }
    .portlet {
        animation: fadeInUp 0.4s ease-out;
    }
    @media (max-width: 768px) {
        .card-box {
            padding: 20px;
        }
        .portlet-heading {
            padding: 20px;
        }
        .portlet-title {
            font-size: 1.5rem;
        }
        .resumen-table {
            min-width: 100%;
            margin: 0;
        }
        .btn {
            padding: 10px 16px;
            font-size: 0.85rem;
        }
    }
    .loading-skeleton {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: loading 1.5s infinite;
    }
    @keyframes loading {
        0% {
            background-position: 200% 0;
        }
        100% {
            background-position: -200% 0;
        }
    }
    h3, h4, h5 {
        color: #2c3e50;
        font-weight: 700;
        margin-bottom: 20px;
    }
    .item-row {
        transition: var(--transition);
    }
    .item-row:hover {
        background: linear-gradient(135deg, rgba(44, 90, 160, 0.02) 0%, rgba(44, 90, 160, 0.05) 100%);
    }
    #overlay-loading {
        backdrop-filter: blur(5px);
        background: rgba(44, 90, 160, 0.1);
    }
    select.form-control {
        cursor: pointer;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m6 8 4 4 4-4'/%3e%3c/svg%3e");
        background-position: right 12px center;
        background-repeat: no-repeat;
        background-size: 16px 12px;
        padding-right: 40px;
    }
    .form-group label[for*="numeroControl"]::before { content: '🔢 '; }
    .form-group label[for*="codigoGeneracion"]::before { content: '🆔 '; }
    .form-group label[for*="Nombre"]::before { content: '👤 '; }
    .form-group label[for*="Direccion"]::before { content: '📍 '; }
    .form-group label[for*="Telefono"]::before { content: '📞 '; }
    .form-group label[for*="Correo"]::before { content: '📧 '; }
    .form-group label[for*="condicionOperacion"]::before { content: '💳 '; }
    .form-group label[for*="tipoPago"]::before { content: '💰 '; }
    #result {
        margin-top: 25px;
        border-radius: var(--border-radius);
        overflow: hidden;
        box-shadow: var(--box-shadow);
        background: var(--white);
        border: none;
    }
    #result h3 {
        background: var(--gradient-primary);
        color: var(--white);
        padding: 20px;
        margin: 0 0 20px 0;
        font-size: 1.3rem;
    }
    #result pre {
        margin: 20px;
        max-height: 400px;
    }
    .form-group, .form-group.row {
        margin-bottom: 8px !important;
    }
    .form-control {
        padding: 8px 12px !important;
        font-size: 0.95rem;
    }
    .receptor-card .form-group label {
        margin-bottom: 4px !important;
    }
    .items-table tbody td {
        padding-top: 8px;
        padding-bottom: 8px;
    }
    .table-sm input,
    .table-sm select {
    font-size: 14px !important;
    padding: 2px 4px !important;
    }

    #recibido.input-error {
    border: 2px solid #dc3545 !important;
    background-color: #fff0f0 !important;
    box-shadow: 0 0 8px rgba(220, 53, 69, 0.5);
    transition: all 0.3s ease;
}
</style>
<?php require 'includes/header_end.php'; ?>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">

<!-- Begin page -->
<div id="wrapper" class="forced enlarged">
	<!-- DESACTIVA EL MENU -->

	<?php require 'includes/menu.php'; ?>

	<!-- ============================================================== -->
	<!-- Start right Content here -->
	<!-- ============================================================== -->
	<div class="content-page">
		<!-- Start content -->
         <?php verificarEstadoCaja($conexion);?>
		<div class="content">
			<div class="container-fluid px-0">
				<?php if ($permisos_ver == 1) {
				?>
					<div class="col-lg-12">
						<div class="portlet">
							<div class="portlet-heading bg-primary">
								<h3 class="portlet-title">
									Consumidor Final
								</h3>
								<div class="portlet-widgets">
									
								</div>
								<div class="clearfix"></div>
							</div>
							<div id="bg-primary" class="panel-collapse collapse show">
								<div class="portlet-body">
									<div class="row">
										<div class="col-lg-8">
											<div style=" background-color:#f8f9f9; border-radius: 5px; border: 1px solid #39c;" class="card-box">

												<div class="widget-chart">
                            <form id="dte01Form">
                                                <div class="row">
                                                <div class="form-group col-md-4 d-none">
                                                    <label for="ambiente01">Ambiente: <span class="required-badge">*</span></label>
                                                    <select class="form-control" id="ambiente01" name="ambiente" required>
                                                        <option value="00" <?php if(($identificacion01['ambiente'] ?? '') === '00') echo 'selected'; ?>>00 - Pruebas</option>
                                                        <option value="01" <?php if(($identificacion01['ambiente'] ?? '') === '01') echo 'selected'; ?>>01 - Producción</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4 d-none">
                                                    <label for="versionDte01">Versión: <span class="required-badge">*</span></label>
                                                    <input type="text" class="form-control" id="versionDte01" name="identificacion[version]" value="<?php echo htmlspecialchars($identificacion01['version'] ?? ''); ?>" readonly required>
                                                </div>
                                                <div class="form-group col-md-4 d-none">
                                                    <label for="tipoDte01">Tipo de DTE: <span class="required-badge">*</span></label>
                                                    <input type="text" class="form-control" id="tipoDte01" name="tipoDte" value="<?php echo htmlspecialchars($identificacion01['tipo_dte'] ?? ''); ?>" readonly required>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="form-group col-md-6">
                                                    <label for="numeroControl01">Número de Control: <span class="required-badge">*</span></label>
                                                    <input type="text" class="form-control" id="numeroControl01" name="identificacion[numeroControl]" value="<?php echo htmlspecialchars($numeroControlSiguiente); ?>" readonly required>
                                                    <small class="form-text text-muted">Formato: DTE-TipoDTE-CódigoEstablecimiento-NúmeroCorrelativo</small>
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="codigoGeneracion01">Código de Generación (UUID): <span class="required-badge">*</span></label>
                                                    <input type="text" class="form-control" id="codigoGeneracion01" name="identificacion[codigoGeneracion]" value="" readonly required>
                                                    <small class="form-text text-muted">Debe ser un UUID único por DTE. Se generará automáticamente si se deja vacío.</small>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="form-group col-md-3">
                                                    <label for="identificacion_tipoModelo">Tipo Modelo <span class="required-badge">*</span></label>
                                                    <select class="form-control" id="identificacion_tipoModelo" name="identificacion[tipoModelo]" required>
                                                        <option value="1" <?php if(($identificacion01['tipo_modelo'] ?? '') === '1') echo 'selected'; ?>>1 - Normal</option>
                                                        <option value="2" <?php if(($identificacion01['tipo_modelo'] ?? '') === '2') echo 'selected'; ?>>2 - Contingencia</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="identificacion_tipoOperacion">Tipo Operación <span class="required-badge">*</span></label>
                                                    <select class="form-control" id="identificacion_tipoOperacion" name="identificacion[tipoOperacion]" required>
                                                        <option value="1" <?php if(($identificacion01['tipo_operacion'] ?? '') === '1') echo 'selected'; ?>>1 - En línea</option>
                                                        <option value="2" <?php if(($identificacion01['tipo_operacion'] ?? '') === '2') echo 'selected'; ?>>2 - Contingencia</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="identificacion_tipoContingencia">Tipo Contingencia</label>
                                                    <select class="form-control" id="identificacion_tipoContingencia" name="identificacion[tipoContingencia]">
                                                        <option value="">N/A</option>
                                                        <option value="1" <?php if(($identificacion01['tipo_contingencia'] ?? '') === '1') echo 'selected'; ?>>1 - Fallo de sistema</option>
                                                        <option value="2" <?php if(($identificacion01['tipo_contingencia'] ?? '') === '2') echo 'selected'; ?>>2 - Corte energía</option>
                                                        <option value="3" <?php if(($identificacion01['tipo_contingencia'] ?? '') === '3') echo 'selected'; ?>>3 - Fallo internet</option>
                                                        <option value="4" <?php if(($identificacion01['tipo_contingencia'] ?? '') === '4') echo 'selected'; ?>>4 - Otros</option>
                                                        <option value="5" <?php if(($identificacion01['tipo_contingencia'] ?? '') === '5') echo 'selected'; ?>>5 - Otro especificar</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="identificacion_motivoContin">Motivo Contingencia</label>
                                                    <input type="text" class="form-control" id="identificacion_motivoContin" name="identificacion[motivoContin]" maxlength="150" placeholder="Obligatorio si contingencia = 5">
                                                </div>
                                            </div>
                                            <input type="date" class="form-control" id="fecEmi01" name="identificacion[fecEmi]" value="" required hidden>
                                            <input type="time" class="form-control" id="horEmi01" name="identificacion[horEmi]" value="" required hidden>
                                            <input type="text" class="form-control" id="tipoMoneda01" name="identificacion[tipoMoneda]" value="<?php echo htmlspecialchars($identificacion01['moneda'] ?? ''); ?>" required hidden>
                                            <!--<div class="row">
                                                <div class="form-group col-md-4">
                                                    <label for="fecEmi01">Fecha Emisión: <span class="required-badge">*</span></label>
                                                    <input type="date" class="form-control" id="fecEmi01" name="identificacion[fecEmi]" value="" required>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="horEmi01">Hora Emisión: <span class="required-badge">*</span></label>
                                                    <input type="time" class="form-control" id="horEmi01" name="identificacion[horEmi]" value="" required>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="tipoMoneda01">Moneda: <span class="required-badge">*</span></label>
                                                    <input type="text" class="form-control" id="tipoMoneda01" name="identificacion[tipoMoneda]" value="<?php echo htmlspecialchars($identificacion01['moneda'] ?? ''); ?>" required>
                                                </div>
                                            </div>-->
                                            <div class="form-group col-md-6">
                                                <label for="searchItemInput01">Buscar y Agregar Ítem Existente:</label>
                                                <input type="text" id="searchItemInput01" class="form-control" placeholder="Escribe código o descripción del ítem">
                                                <small class="form-text text-muted">Empieza a escribir para buscar ítems existentes y agregarlos rápidamente.</small>
                                            </div>

                                            <div id="items-container-01" class="mb-4">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered table-sm items-table table-striped">
                                                        <thead class="thead-light">
                                                          <tr class="table-dark text-center align-middle">
                                                            <th style="width: 4%;">#</th>
                                                            <!-- <th style="width: 6%;">Tipo</th> -->
                                                            <th style="width: 10%;">Código</th>
                                                            <th style="width: 30%;">Descripción</th>
                                                            <th style="width: 8%;">Cant.</th>
                                                            <th style="width: 10%;">Unidad</th>
                                                            <th style="width: 12%;">Precio Unitario</th>
                                                            <th style="width: 10%;">Descuento</th>
                                                            <!-- <th style="width: 10%;">No Sujeta</th> -->
                                                            <th style="width: 10%;">Venta Exenta</th>
                                                            <th style="width: 10%;">Venta Gravada</th>
                                                            <th style="width: 6%;"></th> <!-- Para botones de acción -->
                                                        </tr>

                                                        </thead>
                                                        <tbody>
                                                            <!-- Aquí van los items -->
                                                        </tbody>
                                                    </table>
                                                   <div class="resumen-dte mt-3">
                                                    <h4 class="mb-3" style="text-align: right; font-weight: 700;">Resumen</h4>
                                                    <table class="table table-bordered resumen-table mb-0" style="max-width: 400px; float: right; background: #fff; border-radius: 12px; box-shadow: 0 2px 12px #eee;">
                                                        <tbody>
                                                            <tr>
                                                                <th style="width:70%; text-align: right; background:#f8f8fa;">TOTAL GRAVADAS</th>
                                                                <td style="text-align: right; font-weight: bold;" id="totalGravadaResumen">0.00</td>
                                                            </tr>
                                                            <tr>
                                                                <th style="width:70%; text-align: right; background:#f8f8fa;">VENTAS NO SUJETAS</th>
                                                                <td style="text-align: right; font-weight: bold;" id="totalVentaNoSujeta">0.00</td>
                                                            </tr>
                                                            <tr>
                                                                <th style="width:70%; text-align: right; background:#f8f8fa;">VENTAS EXENTAS</th>
                                                                <td style="text-align: right; font-weight: bold;" id="totalVentaExenta">0.00</td>
                                                            </tr>
                                                           <!-- <tr>
                                                                <th style="text-align: right; background:#f8f8fa;">SubTotal Ventas</th>
                                                                <td style="text-align: right; font-weight: bold;" id="subTotalVentasResumen">0.00</td>
                                                            </tr>-->
                                                            <tr>
                                                                <th style="width:70%; text-align: right; background:#f8f8fa;">IVA RETENIDO</th>
                                                                <td style="text-align: right; font-weight: bold;" id="totalIvareti">0.00</td>
                                                            </tr>
                                                            <tr>
                                                                <th style="text-align: right; background:#f8f8fa;">SUBTOTAL</th>
                                                                <td style="text-align: right; font-weight: bold;" id="subTotalResumen">0.00</td>
                                                            </tr>
                                                            <tr>
                                                                <th style="width:70%; text-align: right; background:#f8f8fa;">DESCUENTO</th>
                                                                <td style="text-align: right; font-weight: bold;" id="totalDescuento">0.00</td>
                                                            </tr>
                                                            <tr>
                                                                <th style="text-align: right; background: var(--gradient-primary); color: #fff;">TOTAL A PAGAR</th>
                                                                <td style="text-align: right; font-weight: bold; background: var(--gradient-primary); color: #fff;" id="montoTotalOperacionResumen">0.00</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                    <div style="clear:both"></div>
                                                     <!-- Campo Efectivo Recibido alineado a la derecha -->
                                                        <div style="max-width: 250px; float: right; margin-top: 15px;">
                                                            <label for="recibido" style="font-weight: 600; font-size: 16px; color: #2c3e50;">Efectivo Recibido</label>
                                                            <div class="input-group input-group-lg">
                                                                <input type="number" step="0.01" class="form-control" id="recibido" name="recibido" placeholder="0.00" style="font-size: 20px; font-weight: 600; text-align: right;">

                                                            </div>
                                                        </div>
                                                        <div style="clear: both;"></div>
                                                </div>


                                                </div>
                                            </div>

                                                <!-- <button type="button" id="addItemBtn01" class="btn btn-secondary">Agregar Otro Item</button> -->
                                                    <div class="form-group col-md-12">
                                                            <label for="observaciones01">Observaciones:</label>
                                                            <textarea class="form-control" id="observaciones01" name="extension[observaciones]" rows="3"></textarea>
                                                        </div>
                                               
											</div>
                                                
											</div>
                                                
										</div>

										<div class="col-lg-4">
											<div style=" background-color:#f8f9f9; border-radius: 5px; border: 1px solid #39c;" class="card-box">
												<div class="widget-chart">
                                                    <input type="text" class="form-control" id="emisorNit01" name="emisor[nit]" value="<?php echo htmlspecialchars($emisor['nit_emisor'] ?? ''); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisorNrc01" name="emisor[nrc]" value="<?php echo htmlspecialchars($emisor['nrc_emisor'] ?? ''); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisorNombre01" name="emisor[nombre]" value="<?php echo htmlspecialchars($emisor['razon_social'] ?? ''); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisorNombreComercial01" name="emisor[nombreComercial]" value="<?php echo htmlspecialchars($emisor['nombre_comercial'] ?? ''); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisorCodActividad01" name="emisor[codActividad]" value="<?php echo htmlspecialchars($emisor['cod_actividad_economica'] ?? ''); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisorDescActividad01" name="emisor[descActividad]" value="<?php echo htmlspecialchars($emisor['descripcion_actividad'] ?? ''); ?>" required hidden>

                                                    <select class="form-control" id="emisor_tipoEstablecimiento" name="emisor[tipoEstablecimiento]" required hidden>
                                                        <option value="01" <?php if(($emisor['tipo_establecimiento'] ?? '') === '01') echo 'selected'; ?>>01 - Casa Matriz</option>
                                                        <option value="02" <?php if(($emisor['tipo_establecimiento'] ?? '') === '02') echo 'selected'; ?>>02 - Sucursal</option>
                                                        <option value="04" <?php if(($emisor['tipo_establecimiento'] ?? '') === '04') echo 'selected'; ?>>04 - Oficina</option>
                                                        <option value="07" <?php if(($emisor['tipo_establecimiento'] ?? '') === '07') echo 'selected'; ?>>07 - Otro</option>
                                                        <option value="20" <?php if(($emisor['tipo_establecimiento'] ?? '') === '20') echo 'selected'; ?>>20 - Otros</option>
                                                    </select>

                                                    <input type="text" class="form-control" id="emisor_codEstableMH01" name="emisor[codEstableMH]" value="<?php echo htmlspecialchars($emisor['cod_establecimiento_mh'] ?? 'null'); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisor_codEstable01" name="emisor[codEstable]" value="<?php echo htmlspecialchars($emisor['cod_establecimiento'] ?? 'null'); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisor_codPuntoVentaMH" name="emisor[codPuntoVentaMH]" value="<?php echo htmlspecialchars($emisor['cod_punto_venta_mh'] ?? 'null'); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisor_codPuntoVenta" name="emisor[codPuntoVenta]" value="<?php echo htmlspecialchars($emisor['cod_punto_venta'] ?? 'null'); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisorDireccion01" name="emisor[direccion][complemento]" value="<?php echo htmlspecialchars($emisor['direccion_emisor'] ?? ''); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisorDepto01" name="emisor[departamento]" value="<?php echo htmlspecialchars($emisor['departamento_emisor'] ?? ''); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisorMuni01" name="emisor[municipio]" value="<?php echo htmlspecialchars($emisor['municipio_emisor'] ?? ''); ?>" required hidden>
                                                    <input type="text" class="form-control" id="emisorTelefono01" name="emisor[telefono]" value="<?php echo htmlspecialchars($emisor['telefono_emisor'] ?? ''); ?>" hidden>
                                                    <input type="email" class="form-control" id="emisorCorreo01" name="emisor[correo]" value="<?php echo htmlspecialchars($emisor['correo_emisor'] ?? ''); ?>" hidden>
                                                        <div class="form-group row" style="margin-bottom: 10px;">
                                                            <div class="col-md-12">
                                                                <input type="text" id="buscarReceptor" class="form-control" placeholder="Buscar por nombre, DUI, NIT...">
                                                                <input type="hidden" id="receptor_id" name="receptor[id]" value="<?php echo $receptor['id'] ?? 1; ?>">
                                                            </div>
                                                        </div>
                                                        <div class="form-group row" style="margin-bottom: 18px;">
                                                            <div class="col-md-12" style="text-align: right;">
                                                                <button type="button" class="btn btn-outline-info" id="nuevoReceptorBtn" style="width: 100%; font-weight: bold; font-size: 1.1em; margin-top: 5px; margin-bottom: 10px;">
                                                                    <i class="fa fa-user-plus"></i> Nuevo Receptor
                                                                </button>
                                                            </div>
                                                        </div>

													
														<div class="form-group row">
															<div class="form-group col-md-6">
                                                                <label for="receptorNombre01">Nombre Receptor:</label>
                                                                <input type="text" class="form-control" id="receptorNombre01" name="receptor[nombre]" value="<?php echo htmlspecialchars($receptor['nombre_receptor'] ?? ''); ?>" required>
                                                            </div>
                                                              <div class="form-group col-md-6">
                                                                <label for="receptorTipoDocumento01">Tipo Documento Receptor:</label>
                                                                <select class="form-control" id="receptorTipoDocumento01" name="receptor[tipoDocumento]" required>
                                                                     <option value="36"  <?php if(($receptor['tipo_documento'] ?? '') === '36') echo 'selected'; ?>>36 - NIT</option>
                                                                    <option value="13"  <?php if(($receptor['tipo_documento'] ?? '') === '13') echo 'selected'; ?>>13 - DUI</option>
                                                                    <option value="02"  <?php if(($receptor['tipo_documento'] ?? '') === '02') echo 'selected'; ?>>02 - Carnet de residente</option>
                                                                    <option value="03"  <?php if(($receptor['tipo_documento'] ?? '') === '03') echo 'selected'; ?>>03 - Pasaporte</option>
                                                                    <option value="37"  <?php if(($receptor['tipo_documento'] ?? '') === '37') echo 'selected'; ?>>37 - Otros</option>
                                                                </select>
                                                            </div>
														</div>
                                                        <div class="form-group row">
                                                            <div class="form-group col-md-6">
                                                                <label for="receptorNumDocumento01">Número Documento Receptor:</label>
                                                                <input type="text" class="form-control" id="receptorNumDocumento01" name="receptor[numDocumento]" value="<?php echo htmlspecialchars($receptor['numero_documento'] ?? ''); ?>" required>
                                                                <small class="form-text text-muted">Usar 99999999-9 para Consumidor Final. Solo el DUI lleva guión; NIT y otros documentos sin guiones.</small>
                                                            </div>
                                                             <div class="form-group col-md-6">
                                                                <label for="receptorDireccion01">Dirección Receptor:</label>
                                                                <input type="text" class="form-control" id="receptorDireccion01" name="receptor[direccion][complemento]" value="<?php echo htmlspecialchars($receptor['direccion_receptor'] ?? ''); ?>">
                                                            </div>
                                                        </div>

                                                    <?php
                                                    // Ejemplo de cómo sacar nombre por código
                                                    $codigo_depto = $receptor['departamento_receptor'] ?? '';
                                                    $codigo_muni = $receptor['municipio_receptor'] ?? '';
                                                    $nombre_depto = '';
                                                    $nombre_muni = '';

                                                    // Saca el nombre del departamento
                                                    if ($codigo_depto) {
                                                        $q = $conexion->query("SELECT nombre FROM departamentos WHERE codigo = '$codigo_depto' LIMIT 1");
                                                        $nombre_depto = $q && $q->num_rows ? $q->fetch_assoc()['nombre'] : '';
                                                    }
                                                    // Saca el nombre del municipio (ojo: se busca por código Y departamento) #receptorNumDocumento01
                                                    if ($codigo_muni && $codigo_depto) {
                                                        $q = $conexion->query("SELECT nombre FROM municipios WHERE codigo = '$codigo_muni' AND codigo_departamento = '$codigo_depto' LIMIT 1");
                                                        $nombre_muni = $q && $q->num_rows ? $q->fetch_assoc()['nombre'] : '';
                                                    }
                                                    ?>
                                                    <div class="form-group row">
                                                        <div class="form-group col-md-6">
                                                            <label for="receptorDepto01">Departamento Receptor:</label>
                                                            <!-- muestra nombre y select editable -->
                                                            <select class="form-control" id="receptorDepto01" name="receptor[direccion][departamento]" required>
                                                                <?php
                                                                $depto_q = $conexion->query("SELECT codigo, nombre FROM departamentos ORDER BY nombre");
                                                                echo '<option value="">Seleccione...</option>';
                                                                while($d = $depto_q->fetch_assoc()){
                                                                    $sel = ($d['codigo'] == $codigo_depto) ? 'selected' : '';
                                                                    echo "<option value=\"{$d['codigo']}\" $sel>{$d['nombre']}</option>";
                                                                }
                                                                ?>
                                                            </select>
                                                            <?php if($nombre_depto): ?>
                                                                <small class="form-text text-muted">Actual: <?php echo htmlspecialchars($nombre_depto); ?></small>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="receptorMuni01">Municipio Receptor:</label>
                                                            <select class="form-control" id="receptorMuni01" name="receptor[direccion][municipio]" required>
                                                                <?php
                                                                $muni_q = $conexion->query("SELECT codigo, nombre FROM municipios WHERE codigo_departamento='$codigo_depto' ORDER BY nombre");
                                                                echo '<option value="">Seleccione...</option>';
                                                                while($m = $muni_q->fetch_assoc()){
                                                                    $sel = ($m['codigo'] == $codigo_muni) ? 'selected' : '';
                                                                    echo "<option value=\"{$m['codigo']}\" $sel>{$m['nombre']}</option>";
                                                                }
                                                                ?>
                                                            </select>
                                                            <?php if($nombre_muni): ?>
                                                                <small class="form-text text-muted">Actual: <?php echo htmlspecialchars($nombre_muni); ?></small>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                            <div class="form-group col-md-6">
                                                                    <label for="receptorTelefono01">Teléfono Receptor:</label>
                                                                    <input type="text" class="form-control" id="receptorTelefono01" name="receptor[telefono]" value="<?php echo htmlspecialchars($receptor['telefono_receptor'] ?? ''); ?>">
                                                                </div>
                                                            <div class="form-group col-md-6">
                                                                    <label for="receptorCorreo01">Correo Receptor:</label>
                                                                    <input type="text" class="form-control" id="receptorCorreo01" name="receptor[correo]" value="<?php echo htmlspecialchars($receptor['correo_receptor'] ?? ''); ?>">
                                                                </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <div class="form-group col-md-6">
                                                            <label for="condicionOperacion01">Condición Operación: <span class="required-badge">*</span></label>
                                                            <select class="form-control" id="condicionOperacion01" name="resumen[condicionOperacion]" required>
                                                                <option value="1">1 - Contado</option>
                                                                <option value="2">2 - Crédito</option>
                                                                <option value="3">3 - Otros</option>
                                                            </select>
                                                        </div>
                                                        
                                                            <div class="form-group col-md-6">
                                                                <label for="tipoPago01">Formas de Pago: <span class="required-badge">*</span></label>
                                                                   <select class="form-control" id="tipoPago01" name="resumen[tipoPago]" required>
                                                                    <option value="">-- Seleccione forma de pago --</option>
                                                                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                                                                        <option value="<?= htmlspecialchars($row['codigo']) ?>"
                                                                            <?= ($row['codigo'] === '01') ? 'selected' : '' ?>>
                                                                            <?= htmlspecialchars($row['descripcion']) ?>
                                                                        </option>
                                                                    <?php endwhile; ?>
                                                                </select>
                                                            </div>
                                                        </div>
													<div class="col-md-12 d-flex justify-content-center flex-wrap gap-3 mt-3" id="action-buttons">
                                                        <button type="submit" class="btn btn-success action-btn">
                                                            <i class="fa fa-paper-plane"></i> Enviar DTE a Hacienda
                                                        </button>
                                                        <button type="button" class="btn btn-primary action-btn generate-json-btn">
                                                            <i class="fa fa-code"></i> Generar JSON
                                                        </button>
                                                    </div>
								                </form>
												</div>
                                                
											</div>
                                            <div class="card" id="result">
                                                    <h3>Resultado de la Operación</h3>
                                                    <pre>Aquí aparecerá la respuesta.</pre>
                                                </div>

										</div>

                                        

									</div>
									<!-- end row -->


								</div>
							</div>
						</div>
					</div>
				<?php
				} else {
				?>
					<section class="content">
						<div class="alert alert-danger" align="center">
							<h3>Acceso denegado! </h3>
							<p>No cuentas con los permisos necesario para acceder a este módulo.</p>
						</div>
					</section>
				<?php
				}
				?>

			</div>
			<!-- end container -->
		</div>
		<!-- end content -->

		<?php require 'includes/pie.php'; ?>

	</div>
	<!-- ============================================================== -->
	<!-- End Right content here -->
	<!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui-->
<!-- ============================================================== -->
 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<!-- ============================================================== -->
 <script>
    // --- Funciones Auxiliares (fuera del DOMContentLoaded) ---

    const generateUUID = () => {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
            var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
            return v.toString(16);
        }).toUpperCase();
    };

    function calcularVentaGravada(fila) {
        const cantidadInput = fila.querySelector('input[name*="[cantidad]"]');
        const precioUnitarioInput = fila.querySelector('input[name*="[precioUni]"]');
        const ventaGravadaInput = fila.querySelector('input[name*="[ventaGravada]"]');

        if (!cantidadInput || !precioUnitarioInput || !ventaGravadaInput) {
            console.warn("No se encontraron todos los campos necesarios para el cálculo de venta gravada en esta fila.");
            return;
        }

        const cantidad = parseFloat(cantidadInput.value) || 0;
        const precioUnitario = parseFloat(precioUnitarioInput.value) || 0;

        const ventaGravada = cantidad * precioUnitario;

        ventaGravadaInput.value = ventaGravada.toFixed(2);
    }

    function agregarFilaItem(formId, itemData = {}) {
    const tbody = document.querySelector(`#items-container-${formId.replace('dte', '').replace('Form', '')} tbody`);
    if (!tbody) {
        console.error('Error: No se encontró el <tbody> de la tabla de ítems para el formulario:', formId);
        return;
    }

    const nuevoIndice = tbody.children.length;

    // OBTIENE nombre bonito y código
    const unidadMedidaCodigo = itemData.unidad_medida || '59';
    const unidadMedidaNombre = itemData.unidad_nombre || unidadMedidaCodigo;

    const tipoItem = itemData.tipo_item || '1';
    const codigo = itemData.codigo || '';
    const descripcion = itemData.descripcion || '';
    //const cantidad = itemData.cantidad || '1';
    const cantidad = '1';
    const precioUnitario = itemData.precio_unitario || '0.00';
    const montoDescuento = itemData.monto_descuento || '0.00';
    const ventaNoSujeta = itemData.venta_no_sujeta || '0.00';
    const ventaExenta = itemData.venta_exenta || '0.00';
    const ventaGravada = itemData.venta_gravada || '0.00';

    const nuevaFila = document.createElement('tr');
    nuevaFila.classList.add('item-row');
    nuevaFila.setAttribute('data-item-index', nuevoIndice);

    nuevaFila.innerHTML = `
        <td>${nuevoIndice + 1}</td>
        <td>
                <select class="form-control" id="detalle_tipoItem_${nuevoIndice}" name="items[${nuevoIndice}][tipoItem]" required hidden>
                    <option value="1" ${tipoItem == '1' ? 'selected' : ''}>1 - Bien</option>
                    <option value="2" ${tipoItem == '2' ? 'selected' : ''}>2 - Servicio</option>
                </select>
                <input type="text" class="form-control" id="item${formId.replace('dte', '').replace('Form', '')}_${nuevoIndice}_codigo" name="items[${nuevoIndice}][codigo]" value="${codigo}">
        </td>
        <td>
                <input type="text" class="form-control form-control-sm w-100 text-sm" id="item${formId.replace('dte', '').replace('Form', '')}_${nuevoIndice}_descripcion" name="items[${nuevoIndice}][descripcion]" value="${descripcion}" required>
        </td>
        <td>
                <input type="number" class="form-control form-control-sm w-100 text-sm" id="item${formId.replace('dte', '').replace('Form', '')}_${nuevoIndice}_cantidad" name="items[${nuevoIndice}][cantidad]" value="${cantidad}" step="0.01" required>
        </td>
        <td>
                <input type="hidden" name="items[${nuevoIndice}][uniMedida]" value="${unidadMedidaCodigo}">
                <span>${unidadMedidaNombre}</span>
        </td>
        <td>
                <input type="number" class="form-control form-control-sm w-100 text-sm" id="item${formId.replace('dte', '').replace('Form', '')}_${nuevoIndice}_precioUni" name="items[${nuevoIndice}][precioUni]" value="${precioUnitario}" step="0.01" required>
        </td>
        <td>
                <input type="number" class="form-control form-control-sm w-100 text-sm" id="item${formId.replace('dte', '').replace('Form', '')}_${nuevoIndice}_montoDescu" name="items[${nuevoIndice}][montoDescu]" value="${montoDescuento}" step="0.01">
        </td>
         <td>
                 <input type="number" class="form-control form-control-sm w-100 text-sm" id="item${formId.replace('dte', '').replace('Form', '')}_${nuevoIndice}_ventaExenta" name="items[${nuevoIndice}][ventaExenta]" value="${ventaExenta}" step="0.01" readonly>
        </td>
        <td>
                <input type="number" class="form-control" id="detalle_ventaNoSuj_${nuevoIndice}" name="items[${nuevoIndice}][ventaNoSuj]" value="${ventaNoSujeta}" step="0.01" required hidden>
               
                <input type="number" class="form-control form-control-sm w-100 text-sm" id="item${formId.replace('dte', '').replace('Form', '')}_${nuevoIndice}_ventaGravada" name="items[${nuevoIndice}][ventaGravada]" value="${ventaGravada}" step="0.01" readonly>
                <!--<small class="form-text text-muted">No debe ser 0 si gravado.</small>-->
        </td>
        
            <input type="hidden" name="items[${nuevoIndice}][ivaItem]" value="0.00">

        <td class="item-row-actions align-middle">
            <div class="d-flex gap-2 align-items-center">
                <select class="form-control  text-sm tipo-venta-select" name="items[${nuevoIndice}][tipoVenta]">
                    <option value="gravado" selected>Gravado</option>
                    <option value="exento">Exento</option>
                </select>
                <button type="button" class="btn btn-danger btn-sm remove-btn" data-type="item" title="Eliminar">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </td>

    `;

    tbody.appendChild(nuevaFila);
    configurarCalculoVentaGravada(nuevaFila);
    reindexarElementos(formId, 'items');
    actualizarResumenDTE01();

    const inputs = nuevaFila.querySelectorAll('input, select');
    inputs.forEach(input => {
        input.addEventListener('input', () => {
            calcularTotalesPorFila(nuevaFila);
            actualizarResumenDTE01(); // tu función de resumen actualizarTotalesItem
        });
    });

}

function calcularTotalesPorFila(fila) {
    const cantidad = parseFloat(fila.querySelector('[name$="[cantidad]"]')?.value || 0);
    const precioUnitario = parseFloat(fila.querySelector('[name$="[precioUni]"]')?.value || 0);
    const tipoVenta = fila.querySelector('.tipo-venta-select')?.value || 'gravado';
    const ventaGravadaInput = fila.querySelector('[name$="[ventaGravada]"]');
    const ventaExentaInput = fila.querySelector('[name$="[ventaExenta]"]');
    const ivaItemHidden = fila.querySelector('[name$="[ivaItem]"]') || document.createElement("input");

    const total = cantidad * precioUnitario;

    if (tipoVenta === 'gravado') {
        //const base = total / 1.13; // OJO ESTE ES INPORTANTE POR LO DEL IVA
        const base = total;
        const iva = total - base;
        ventaGravadaInput.value = base.toFixed(2);
        ventaExentaInput.value = "0.00";
        ivaItemHidden.value = iva.toFixed(2);
    } else {
        ventaGravadaInput.value = "0.00";
        ventaExentaInput.value = total.toFixed(2);
        ivaItemHidden.value = "0.00";
    }
}


    function agregarFilaDocumentoRelacionado(formId) {
        const tbody = document.querySelector(`#docs-rel-container-${formId.replace('dte', '').replace('Form', '')} tbody`);
        if (!tbody) {
            console.error('Error: No se encontró el <tbody> de la tabla de documentos relacionados para el formulario:', formId);
            return;
        }

        const nuevoIndice = tbody.children.length;
        const nuevaFila = document.createElement('tr');
        nuevaFila.classList.add('doc-rel-row', 'new-item');
        nuevaFila.setAttribute('data-item-index', nuevoIndice);

        const dteTypeForDocRel = formId.replace('dte', '').replace('Form', '');
        const now = new Date();
        const year = now.getFullYear();
        const month = String(now.getMonth() + 1).padStart(2, '0');
        const day = String(now.getDate()).padStart(2, '0');

        nuevaFila.innerHTML = `
            <td>${nuevoIndice + 1}</td>
            <td>
                <div class="form-group">
                    <select id="docrel${dteTypeForDocRel}_${nuevoIndice}_tipoDocumento" name="documentosRelacionados[${nuevoIndice}][tipoDocumento]" required>
                        <option value="01">01 - Factura Consumidor Final</option>
                        <option value="03">03 - Comprobante de Crédito Fiscal</option>
                        <option value="05">05 - Nota de Crédito</option>
                        <option value="06">06 - Nota de Débito</option>
                    </select>
                </div>
            </td>
            <td>
                <div class="form-group">
                    <input type="text" id="docrel${dteTypeForDocRel}_${nuevoIndice}_numDocumento" name="documentosRelacionados[${nuevoIndice}][numeroDocumento]" value="" required>
                </div>
            </td>
            <td>
                <div class="form-group">
                    <input type="date" id="docrel${dteTypeForDocRel}_${nuevoIndice}_fechaEmision" name="documentosRelacionados[${nuevoIndice}][fechaEmision]" value="${year}-${month}-${day}" required>
                </div>
            </td>
            <td class="doc-rel-row-actions">
                <button type="button" class="remove-btn btn-danger" data-type="doc-rel">X</button>
            </td>
        `;
        tbody.appendChild(nuevaFila);
        reindexarElementos(formId, 'docs-rel');
        setTimeout(() => {
            nuevaFila.classList.remove('new-item');
        }, 300);
    }

    function reindexarElementos(formId, itemType) {
        const tbody = document.querySelector(`#${itemType}-container-${formId.replace('dte', '').replace('Form', '')} tbody`);
        if (!tbody) return;

        const filas = tbody.querySelectorAll(`.${itemType === 'items' ? 'item-row' : 'doc-rel-row'}`);

        filas.forEach((fila, index) => {
            const celdaNumero = fila.querySelector('td:first-child');
            if (celdaNumero) {
                celdaNumero.textContent = index + 1;
            }

            fila.setAttribute('data-item-index', index);

            fila.querySelectorAll('input, select, textarea').forEach(input => {
                const nombreActual = input.name;
                if (nombreActual) {
                    const partesNombre = nombreActual.match(/([^[]+)\[(\d+)\](.+)?/);
                    if (partesNombre) {
                        input.name = `${partesNombre[1]}[${index}]${partesNombre[3] || ''}`;
                    }
                }
                const idActual = input.id;
                if (idActual) {
                    const idParts = idActual.match(/(.+)_(\d+)$/);
                    if (idParts) {
                        input.id = `${idParts[1]}_${index}`;
                    }
                }
            });

            if (itemType === 'items') {
                configurarCalculoVentaGravada(fila);
            }
//OJO ESTE PONERLOS EN TODOS LOS DTES
            const botonEliminar = fila.querySelector('.remove-btn');
                if (botonEliminar) {
                    botonEliminar.onclick = () => {
                        Swal.fire({
                            title: '¿Eliminar ítem?',
                            text: "Esta acción no se puede deshacer.",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#6c757d',
                            confirmButtonText: 'Sí, eliminar',
                            cancelButtonText: 'Cancelar',
                            backdrop: true
                        }).then((result) => {
                            if (result.isConfirmed) {
                                if (tbody.children.length > 1) {
                                    fila.remove();
                                    reindexarElementos(formId, itemType);
                                    actualizarResumenDTE01(); // ← también refresca el resumen
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Eliminado',
                                        text: 'El ítem fue eliminado correctamente.',
                                        timer: 1200,
                                        showConfirmButton: false
                                    });
                                } else {
                                    Swal.fire({
                                        icon: 'info',
                                        title: '⚠️ Atención',
                                        text: 'Debe haber al menos un ítem en la tabla.',
                                        confirmButtonColor: '#3085d6'
                                    });
                                }
                            }
                        });
                    };
                }
// END
        });
    }

    function configurarCalculoVentaGravada(fila) {
    const cantidadInput = fila.querySelector('input[name*="[cantidad]"]');
    const precioUnitarioInput = fila.querySelector('input[name*="[precioUni]"]');
    const montoDescuentoInput = fila.querySelector('input[name*="[montoDescu]"]'); // <-- para detectar descuento
    const ventaExentaInput = fila.querySelector('input[name*="[ventaExenta]"]'); // <-- para detectar ventaExenta

    if (cantidadInput && precioUnitarioInput) {
        // Eliminar listeners previos para evitar duplicados si la fila se reindexa
        cantidadInput.removeEventListener('input', cantidadInput._currentListener);
        precioUnitarioInput.removeEventListener('input', precioUnitarioInput._currentListener);

        // Crear nuevos listeners que actualizan venta gravada y resumen result.success
        const onChange = () => {
            calcularVentaGravada(fila);
            actualizarResumenDTE01();
        };

        cantidadInput.addEventListener('input', onChange);
        precioUnitarioInput.addEventListener('input', onChange);

        cantidadInput._currentListener = onChange;
        precioUnitarioInput._currentListener = onChange;

        // Si también quieres refrescar cuando se cambia el descuento:
        if(montoDescuentoInput){
            montoDescuentoInput.removeEventListener('input', montoDescuentoInput._currentListener);
            montoDescuentoInput.addEventListener('input', onChange);
            montoDescuentoInput._currentListener = onChange;
        }

        if(ventaExentaInput){
            ventaExentaInput.removeEventListener('input', ventaExentaInput._currentListener);
            ventaExentaInput.addEventListener('input', onChange);
            ventaExentaInput._currentListener = onChange;
        }

        // Calcular valores una vez al configurar
        calcularVentaGravada(fila);
        actualizarResumenDTE01();
    }
}



    // --- Tu código principal (dentro de DOMContentLoaded) ---
    document.addEventListener('DOMContentLoaded', () => {
        const getActiveForm = () => {
            const activeTabButton = document.querySelector('.tab-button.active');
            const tabId = activeTabButton.dataset.tab;
            return document.querySelector(`#${tabId} form`);
        };

        const setInitialFormValues = (formId) => {
            const form = document.getElementById(formId);
            if (form) {
                const dteType = formId.replace('dte', '').replace('Form', '');
                const fecEmi = form.querySelector(`#fecEmi${dteType}`);
                const horEmi = form.querySelector(`#horEmi${dteType}`);
                const codigoGeneracion = form.querySelector(`#codigoGeneracion${dteType}`);

                const now = new Date();
                const year = now.getFullYear();
                const month = String(now.getMonth() + 1).padStart(2, '0');
                const day = String(now.getDate()).padStart(2, '0');
                const hours = String(now.getHours()).padStart(2, '0');
                const minutes = String(now.getMinutes()).padStart(2, '0');

                if (fecEmi) fecEmi.value = `${year}-${month}-${day}`;
                if (horEmi) horEmi.value = `${hours}:${minutes}`;
                if (codigoGeneracion) codigoGeneracion.value = generateUUID();

                const docRelFechaEmision = form.querySelector(`#docrel${dteType}_1_fechaEmision`);
                if (docRelFechaEmision) docRelFechaEmision.value = `${year}-${month}-${day}`;
                
                const searchInput = form.querySelector(`#searchItemInput${dteType}`);
                if (searchInput) {
                    // Solo inicializar autocomplete si no ha sido inicializado antes
                    if (!$(searchInput).data('ui-autocomplete')) {
                        $(searchInput).autocomplete({
                            source: function(request, response) {
                                $.ajax({
                                    url: '../ajax/buscar_item.php',
                                    dataType: 'json',
                                    data: {
                                        term: request.term
                                    },
                                    success: function(data) {
                                        response($.map(data, function(item) {
                                            return {
                                                label: `${item.codigo} - ${item.descripcion} (Precio: $${item.precio_unitario})`,
                                                value: item.descripcion,
                                                data: item
                                            };
                                        }));
                                    },
                                    error: function(xhr, status, error) {
                                        console.error("Error al buscar ítems:", status, error);
                                    }
                                });
                            },
                            minLength: 2,
                            select: function(event, ui) {
                                const itemSeleccionado = ui.item.data;
                                agregarFilaItem(formId, itemSeleccionado);
                                $(this).val('');
                                return false;
                            }
                        });
                    }
                }

                const addItemBtn = form.querySelector(`#addItemBtn${dteType}`);
                if (addItemBtn) {
                    if (!addItemBtn.dataset.listenerAdded) {
                        addItemBtn.addEventListener('click', () => {
                            agregarFilaItem(formId);
                        });
                        addItemBtn.dataset.listenerAdded = 'true';
                    }
                }

                const addDocRelBtn = form.querySelector(`#addDocRelBtn${dteType}`);
                if (addDocRelBtn) {
                    if (!addDocRelBtn.dataset.listenerAdded) {
                        addDocRelBtn.addEventListener('click', () => {
                            agregarFilaDocumentoRelacionado(formId);
                        });
                        addDocRelBtn.dataset.listenerAdded = 'true';
                    }
                }
                
                reindexarElementos(formId, 'items');
                reindexarElementos(formId, 'docs-rel');
            }
        };

        // Inicializa todos los formularios al cargar la página
        setInitialFormValues('dte01Form');
        //setInitialFormValues('dte03Form');
        //setInitialFormValues('dte05Form');
        //setInitialFormValues('dte06Form');


        // --- MODIFICACIÓN CLAVE AQUÍ: Validar ítems antes de procesar DTE ---
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function(event) {
                event.preventDefault();
                const currentFormId = form.id;
                const tbodyItems = document.querySelector(
                    `#items-container-${currentFormId.replace('dte', '').replace('Form', '')} tbody`
                );

                if (!tbodyItems || tbodyItems.children.length === 0) {
                     Swal.fire({
                    icon: 'warning',
                    title: '🛑 Atención',
                    html: '<b>Debe agregar al menos un ítem</b> antes de enviar la factura.',
                    showClass: {
                        popup: 'animate__animated animate__fadeInDown'
                    },
                    hideClass: {
                        popup: 'animate__animated animate__fadeOutUp'
                    },
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'Ok, entendido'
                });

                    return;
                }

                // En versiones anteriores gurdaba el receptor aqui se quito porque se hizo todo con el DteModel
               processDTE(currentFormId, 'enviar_mh');

            });
        });

         document.querySelector('.generate-json-btn').addEventListener('click', async () => {
            const form = document.getElementById('dte01Form');
            const tbodyItems = document.querySelector('#items-container-01 tbody');

            if (!tbodyItems || tbodyItems.children.length === 0) {
               Swal.fire({
                    icon: 'warning',
                    title: '🛑 Atención',
                    html: '<b>Debe agregar al menos un ítem</b> antes de enviar la factura.',
                    showClass: {
                        popup: 'animate__animated animate__fadeInDown'
                    },
                    hideClass: {
                        popup: 'animate__animated animate__fadeOutUp'
                    },
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'Ok, entendido'
                });


                return;
            }
            await processDTE('dte01Form', 'generar_json');
        });

        async function processDTE(formId, action) {
            const form = document.getElementById(formId);
            const resultDiv = document.getElementById('result');
            resultDiv.innerHTML = `<h3>Procesando...</h3><pre>Enviando solicitud al servidor.</pre>`;

            const formData = new FormData(form);
            const data = {};

            function setNestedValue(obj, path, value) {
                let current = obj;
                const parts = path.match(/[^[\]]+/g);

                for (let i = 0; i < parts.length; i++) {
                    const part = parts[i];
                    if (i === parts.length - 1) {
                        current[part] = value;
                    } else {
                        if (!(part in current)) {
                            current[part] = isNaN(parts[i+1]) ? {} : [];
                        }
                        current = current[part];
                    }
                }
            }

            for (const [name, value] of formData.entries()) {
                setNestedValue(data, name, value);
            }

            data.tipoDte = form.querySelector('input[name="tipoDte"]').value;
            data.ambiente = form.querySelector('select[name="ambiente"]').value
              // VALIDACIÓN DE EFECTIVO RECIBIDO Y CAMBIO ANTES DE ENVIAR A HACIENDA
            const recibidoInput = document.getElementById('recibido');
                const totalOperacion = parseFloat(document.getElementById('montoTotalOperacionResumen')?.innerText || 0);
                const recibido = parseFloat(recibidoInput?.value || 0);
                const cambio = recibido - totalOperacion;

                if (isNaN(recibido) || recibido < totalOperacion) {
                    // Aplicar estilo de error al input
                    recibidoInput.classList.add('input-error');
                    
                    // Hacer focus para corregir
                    recibidoInput.focus();

                    // Mostrar alerta
                    await Swal.fire({
                        icon: 'error',
                        title: 'Efectivo insuficiente',
                        html: `
                            <p><strong>Total a Pagar:</strong> $${totalOperacion.toFixed(2)}</p>
                            <p style="font-size: 18px; color: #28a745;"><strong>Recibido:</strong> $${isNaN(recibido) ? '—' : recibido.toFixed(2)}</p>
                        `
                    });

                    // Remover error al modificar el valor
                    recibidoInput.addEventListener('input', function limpiarError() {
                        recibidoInput.classList.remove('input-error');
                        recibidoInput.removeEventListener('input', limpiarError);
                    });

                    return; // Detiene el proceso
                }
                // Confirmar con el usuario antes de enviar a Hacienda
                const confirmar = await Swal.fire({
                    icon: 'question',
                    title: '¿Confirmar envío a Hacienda?',
                    html: `
                        <p><strong>Total a Pagar:</strong> $${totalOperacion.toFixed(2)}</p>
                        <p><strong>Recibido:</strong> $${recibido.toFixed(2)}</p>
                        <p style="font-size: 18px; color: #28a745;"><strong>Cambio:</strong> $${cambio.toFixed(2)}</p>
                    `,
                    showCancelButton: true,
                    confirmButtonText: 'Enviar DTE',
                    cancelButtonText: 'Cancelar'
                });

                if (!confirmar.isConfirmed) {
                    return; // Canceló, no se envía
                }
             mostrarOverlayCarga();
            try {
                const response = await fetch(`procesar_dte_mod.php?action=${action}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(data)
                });

                const result = await response.json();
/** LA CONTINGENCIA */
             if (result.success) {
                // 🟡 Caso especial: DTE en contingencia (tipoModelo == 2) OJO AQUI ESTA LA MODIFICACION DE CONTIGENCIA 
                if (action === 'enviar_mh' && result.message.includes('contingencia')) {
                    ocultarOverlayCarga(); // ⬅️ PRIMERO se oculta el overlay
                    limpiarTablaItems(formId);
                    limpiarResumenDTE();
                                    // 🧾 Abrir ticket también en contingencia
                    if (result.dte_enviado?.identificacion?.numeroControl) {
                        window.open(
                            'ticket.php?numero_control=' + encodeURIComponent(result.dte_enviado.identificacion.numeroControl),
                            '_blank',
                            'width=440,height=930'
                        );
                    }
                    // ⏳ Espera antes de recargar
                    setTimeout(() => {
                        location.reload();
                    }, 5500)
                    resultDiv.innerHTML = `
                        <div class="alert alert-warning">
                            <h4><b>⚠️ DTE en Contingencia</b></h4>
                            <p>El DTE fue <b>guardado localmente</b> pero <b>no fue enviado a Hacienda</b> porque fue emitido en modo contingencia.</p>
                        </div>
                        <h4>JSON DTE Guardado:</h4>
                        <pre>${JSON.stringify(result.dte_enviado, null, 2)}</pre>
                    `;
                    return; // ⛔ Salimos para evitar ejecutar el flujo de envío
                }

                // 🟢 Si solo se pidió generar el JSON
                if (action === 'generar_json') {
                     ocultarOverlayCarga(); // 👈 🔥 AGREGALO AQUÍ
                    resultDiv.innerHTML = `
                        <h3>DTE JSON Generado:</h3>
                        <pre>${JSON.stringify(result.dte, null, 2)}</pre>
                    `;
                    return;
                }

                // ✅ Flujo normal: DTE enviado a Hacienda
                resultDiv.innerHTML = `
                    <h3>✅ Respuesta del Ministerio de Hacienda:</h3>
                    <pre>${JSON.stringify(result.response_mh, null, 2)}</pre>
                    <h4>JSON DTE Enviado:</h4>
                    <pre>${JSON.stringify(result.dte_enviado, null, 2)}</pre>
                `;

                // 🔄 Limpiar tabla y resumen si fue exitoso
                if (result.response_mh && result.response_mh.status === "OK") {
                    limpiarTablaItems(formId);
                    limpiarResumenDTE();
                    ocultarOverlayCarga();

                    // ⏳ Espera antes de recargar
                    setTimeout(() => {
                        location.reload();
                    }, 5500);
                }

                // 🧾 Abrir ticket si hay número de control
                if (result.dte_enviado && result.dte_enviado.identificacion && result.dte_enviado.identificacion.numeroControl) {
                    window.open(
                        'ticket.php?numero_control=' + encodeURIComponent(result.dte_enviado.identificacion.numeroControl),
                        '_blank',
                        'width=440,height=930'
                    );
                }
 }
 /** END CONTINGENCIA */
 else {
                       resultDiv.innerHTML = `
                                <div style="
                                    font-family: Arial, sans-serif;
                                    background-color: #f8d7da;
                                    color: #721c24;
                                    border: 1px solid #f5c6cb;
                                    padding: 16px;
                                    border-radius: 6px;
                                    margin-top: 15px;
                                ">
                                    <h4 style="margin-top: 0; font-weight: bold;">❌ Error del Ministerio de Hacienda</h4>
                                    <p style="margin: 8px 0;"><strong>Detalle:</strong> ${result.error}</p>

                                    ${result.response_mh ? `
                                    <div style="margin-top: 12px;">
                                        <h5 style="margin: 0 0 6px;">📄 Respuesta técnica:</h5>
                                        <pre style="
                                            background-color: #fff;
                                            border: 1px solid #ccc;
                                            padding: 10px;
                                            border-radius: 4px;
                                            font-size: 13px;
                                            color: #333;
                                            max-height: 250px;
                                            overflow-y: auto;
                                        ">
                            ${JSON.stringify(result.response_mh, null, 2)}
                                        </pre>
                                    </div>` : ''}
                                </div>
                            `;
                }
            } catch (error) {
                resultDiv.innerHTML = `
                    <h3>Error de Conexión o Procesamiento:</h3>
                    <p>Ocurrió un error al intentar comunicarse con el servidor o al procesar la respuesta.</p>
                    <p>Detalles: ${error.message}</p>
                `;
                console.error('Fetch error:', error);
            }
             ocultarOverlayCarga(); // <-- SIEMPRE oculta el overlay al terminar
        }

        // Tab switching logic
        document.querySelectorAll('.tab-button').forEach(button => {
            button.addEventListener('click', () => {
                const targetTabId = button.dataset.tab;

                document.querySelectorAll('.tab-button').forEach(btn => btn.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));

                button.classList.add('active');
                document.getElementById(targetTabId).classList.add('active');

                const formId = targetTabId.replace('tab-', '') + 'Form';
                setInitialFormValues(formId);
            });
        });
//ESTOS EN TODOS LOS DTE TAMBIEN
        document.body.addEventListener('click', function(e) {
            if (e.target.tagName === 'INPUT' && e.target.type === 'number') {
                e.target.select();
            }
        });
//END
    });

    function limpiarTablaItems(formId) {
    const tbody = document.querySelector(`#items-container-${formId.replace('dte', '').replace('Form', '')} tbody`);
    if (tbody) {
        // Borra todas las filas
        while (tbody.firstChild) {
            tbody.removeChild(tbody.firstChild);
        }
        // Puedes agregar una fila vacía automática si quieres:
        // agregarFilaItem(formId); // <- Si quieres dejar siempre una fila lista
    }
}

function limpiarResumenDTE() {
    document.getElementById('totalGravadaResumen').textContent = '0.00';
    //document.getElementById('subTotalVentasResumen').textContent = '0.00';
    document.getElementById('subTotalResumen').textContent = '0.00';
    document.getElementById('montoTotalOperacionResumen').textContent = '0.00';
}


function actualizarResumenDTE01() {
    const filas = document.querySelectorAll('#items-container-01 tbody tr');
    let totalGravada = 0;
    let totalExenta = 0;
    let totalNoSujeta = 0;
    let totalDescuento = 0;

    filas.forEach((fila, index) => {
        const ventaGravadaInput = fila.querySelector(`input[name="items[${index}][ventaGravada]"]`);
        const ventaExentaInput = fila.querySelector(`input[name="items[${index}][ventaExenta]"]`);
        const ventaNoSujInput = fila.querySelector(`input[name="items[${index}][ventaNoSuj]"]`);
        const montoDescuentoInput = fila.querySelector(`input[name="items[${index}][montoDescu]"]`);

        const ventaGravada = parseFloat(ventaGravadaInput?.value || 0);
        const ventaExenta = parseFloat(ventaExentaInput?.value || 0);
        const ventaNoSuj = parseFloat(ventaNoSujInput?.value || 0);
        const montoDescuento = parseFloat(montoDescuentoInput?.value || 0);

        totalGravada += ventaGravada;
        totalExenta += ventaExenta;
        totalNoSujeta += ventaNoSuj;
        totalDescuento += montoDescuento;
    });

    const subTotal = totalGravada + totalExenta + totalNoSujeta - totalDescuento;
    const montoTotalOperacion = subTotal;

    // Mostrar en resumen
    document.getElementById('totalGravadaResumen').textContent = totalGravada.toFixed(2);
    document.getElementById('totalVentaExenta').textContent = totalExenta.toFixed(2);
    document.getElementById('totalVentaNoSujeta').textContent = totalNoSujeta.toFixed(2);
    document.getElementById('totalDescuento').textContent = totalDescuento.toFixed(2);
    document.getElementById('subTotalResumen').textContent = subTotal.toFixed(2);
    document.getElementById('montoTotalOperacionResumen').textContent = montoTotalOperacion.toFixed(2);
}


$(function() {
    $("#buscarReceptor").autocomplete({
        source: function(request, response) {
            $.ajax({
                url: '../ajax/buscar_receptor.php',
                type: 'GET',
                dataType: 'json',
                data: { term: request.term },
                success: function(data) {
                    if(data.length === 0) {
                        data.push({
                            label: "➕ Crear nuevo receptor...",
                            value: "",
                            id: 0
                        });
                    }
                    response(data);
                }
            });
        },
        minLength: 2,
        select: function(event, ui) {
    if (ui.item.id == 0) {
        $("#modalNuevoReceptor").modal("show");
        $("#buscarReceptor").val("");
        return false;
    }

    $("#receptor_id").val(ui.item.id);

    $.getJSON('../ajax/get_receptor.php', { id: ui.item.id }, function(data) {
        console.log('Respuesta get_receptor.php:', data); // <-- AGREGA ESTO

        // Verifica si hay error o está vacío
        if (!data || !data.nombre_receptor) {
            alert("No se encontraron datos del receptor. ¿Está bien el ID?");
            return;
        }

        $("#receptorNombre01").val(data.nombre_receptor);
        $("#receptorTipoDocumento01").val(data.tipo_documento);
        $("#receptorNumDocumento01").val(data.numero_documento);
        $("#receptorDireccion01").val(data.direccion_receptor);

        $("#receptorDepto01").val(data.departamento_receptor).trigger('change');
        setTimeout(function() {
            $("#receptorMuni01").val(data.municipio_receptor);
        }, 600);
        // NUEVO: Carga teléfono y correo
        $("#receptorTelefono01").val(data.telefono_receptor);
        $("#receptorCorreo01").val(data.correo_receptor);
    });

    $("#buscarReceptor").val(ui.item.label);
    return false;
}

    });

    // Cuando cambias departamento, carga municipios
    $('#receptorDepto01').change(function() {
        var dep = $(this).val();
        $('#receptorMuni01').html('<option value="">Cargando...</option>');
        if(dep != '') {
            $.ajax({
                url: '../ajax/municipios_por_departamento.php',
                type: 'POST',
                data: {codigo_departamento: dep},
                dataType: 'json',
                success: function(resp) {
                    let html = '<option value="">-- Seleccione --</option>';
                    $.each(resp, function(i, municipio){
                        html += '<option value="'+municipio.codigo+'">'+municipio.nombre+'</option>';
                    });
                    $('#receptorMuni01').html(html);
                }
            });
        } else {
            $('#receptorMuni01').html('<option value="">-- Seleccione un departamento primero --</option>');
        }
    });

    // Formato automático para DUI: 99999999-9
    /*$('#receptorNumDocumento01').on('input', function() {
        let valor = this.value.replace(/[^0-9]/g, ''); // Solo números
        if (valor.length > 9) valor = valor.slice(0, 9);
        if (valor.length > 8) valor = valor.slice(0, 8) + '-' + valor.slice(8);
        this.value = valor;
    });*/
});

$("#nuevoReceptorBtn").on("click", function() {
    $("#receptor_id").val('');
    $("#receptorNombre01").val('');
    $("#receptorTipoDocumento01").val('');
    $("#receptorNumDocumento01").val('');
    $("#receptorDireccion01").val('');
    $("#receptorDepto01").val('').change();
    $("#receptorMuni01").html('<option value="">Seleccione...</option>');
    $("#receptorTelefono01").val('');
    $("#receptorCorreo01").val('');
    $("#receptorNombre01").focus();
});


function guardarReceptorSiNoExiste(callback) {
    var datos = {
        nombre_receptor: $("#receptorNombre01").val(),
        tipo_documento: $("#receptorTipoDocumento01").val(),
        numero_documento: $("#receptorNumDocumento01").val(),
        direccion_receptor: $("#receptorDireccion01").val(),
        departamento_receptor: $("#receptorDepto01").val(),
        municipio_receptor: $("#receptorMuni01").val(),
        telefono_receptor: $("#receptorTelefono01").val(),
        correo_receptor: $("#receptorCorreo01").val()
    };
    $.ajax({
        url: '../ajax/guardar_receptorx.php',
        type: 'POST',
        data: datos,
        dataType: 'json',
      success: function(resp) {
    if(resp.success){
        if(resp.ya_existe){
            $.Notification.notify(
                "info", // tipo: success | error | info | warning
                "bottom center",
                "NOTIFICACIÓN",
                "⚠️ El receptor ya existía y fue seleccionado."
            );
        } else {
            $.Notification.notify(
                "success",
                "bottom center",
                "NOTIFICACIÓN",
                "✅ Receptor guardado correctamente."
            );
        }
        if (callback) callback(true, resp.id_receptor);
    } else {
        $.Notification.notify(
            "error",
            "bottom center",
            "NOTIFICACIÓN",
            "❌ No se pudo guardar el receptor: " + (resp.error || 'Error desconocido.')
        );
        if (callback) callback(false);
    }
}

    });
}

function crearOverlayCarga() {
    // Evita duplicados
    if (document.getElementById('overlay-loading')) return;

    const overlay = document.createElement('div');
    overlay.id = 'overlay-loading';
    overlay.style.cssText = `
        position: fixed;
        top: 0; left: 0; width: 100vw; height: 100vh;
        background: rgba(44, 90, 160, 0.9);
        backdrop-filter: blur(5px);
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
        z-index: 9999;
        transition: opacity 0.3s ease-in-out;
        opacity: 0;
        pointer-events: none;
    `;

    overlay.innerHTML = `
        <div style="text-align: center; background: rgba(255, 255, 255, 0.95); padding: 40px; border-radius: 20px; box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);">
            <div style="width: 80px; height: 80px; border: 4px solid #f3f3f3; border-top: 4px solid #2c5aa0; border-radius: 50%; animation: spin 1s linear infinite; margin: 0 auto 20px;"></div>
            <div style="color: #2c3e50; margin-top: 15px; font-size: 1.4em; font-weight: 600;">
                🔄 Procesando solicitud...
                <div style="font-size: 0.9em; opacity: 0.7; margin-top: 8px; font-weight: 400;">Por favor, espere unos segundos</div>
            </div>
        </div>
        <style>
            @keyframes spin {
                0% { transform: rotate(0deg); }
                100% { transform: rotate(360deg); }
            }
        </style>
    `;

    document.body.appendChild(overlay);

    // Mostrar con animación suave
    requestAnimationFrame(() => {
        overlay.style.opacity = '1';
        overlay.style.pointerEvents = 'auto';
    });
}
function mostrarOverlayCarga() {
    crearOverlayCarga();
    var overlay = document.getElementById('overlay-loading');
    overlay.style.display = 'flex';
}

function ocultarOverlayCarga() {
    var overlay = document.getElementById('overlay-loading');
    if (overlay) overlay.style.display = 'none';
}

</script>
<!-- FIN -->


<?php require 'includes/footer_end.php'
?>