<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
    header("location: ../../login.php");
    exit;
}

/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Caja";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$Caja = 1;
$fecha_actual = date('Y-m-d');
$hora_actual = date('H:i');
?>
<?php require 'includes/header_start.php';?>
<style>
    :root {
        --primary-color: #2c5aa0;
        --primary-light: #3d6bb5;
        --primary-dark: #1e3d6f;
        --secondary-color: #28a745;
        --accent-color: #17a2b8;
        --warning-color: #ffc107;
        --danger-color: #dc3545;
        --light-bg: #f8f9fa;
        --white: #ffffff;
        --border-radius: 12px;
        --border-radius-sm: 8px;
        --box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        --box-shadow-sm: 0 2px 10px rgba(0, 0, 0, 0.05);
        --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        --gradient-primary: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
        --gradient-success: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        --gradient-info: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    }

    body {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .container {
        background: var(--white);
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
        margin: 20px auto;
        overflow: hidden;
    }

    .portlet {
        border: none;
        box-shadow: var(--box-shadow);
        border-radius: var(--border-radius);
        overflow: hidden;
        background: var(--white);
    }

    .portlet-heading {
        background: var(--gradient-primary) !important;
        padding: 25px 30px;
        border: none;
        position: relative;
        overflow: hidden;
    }

    .portlet-heading::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="20" cy="20" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="80" cy="40" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="40" cy="80" r="1" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.3;
    }

    .portlet-title {
        color: var(--white) !important;
        font-size: 1.8rem;
        font-weight: 700;
        margin: 0;
        position: relative;
        z-index: 1;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .portlet-title::before {
        content: '🗃️';
        font-size: 1.5rem;
    }

    .card-box {
        background: var(--white);
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow-sm);
        border: 1px solid rgba(44, 90, 160, 0.1);
        padding: 30px;
        margin-bottom: 25px;
        transition: var(--transition);
        position: relative;
        overflow: hidden;
    }

    .card-box::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: var(--gradient-primary);
    }

    .card-box:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(44, 90, 160, 0.15);
    }

    .form-group label {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 8px;
        font-size: 0.95rem;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .required-badge {
        color: var(--danger-color);
        font-size: 1.1em;
        font-weight: bold;
    }

    .form-control {
        border: 2px solid #e9ecef;
        border-radius: var(--border-radius-sm);
        padding: 12px 16px;
        font-size: 0.95rem;
        transition: var(--transition);
        background: var(--white);
        box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.06);
    }

    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 0.2rem rgba(44, 90, 160, 0.15);
        background: var(--white);
        transform: translateY(-1px);
    }

    .form-control:hover:not(:focus) {
        border-color: #ced4da;
        transform: translateY(-1px);
    }

    .btn {
        padding: 12px 24px;
        border-radius: var(--border-radius-sm);
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: var(--transition);
        border: none;
        position: relative;
        overflow: hidden;
        font-size: 0.9rem;
    }

   

    .btn:hover::before {
        left: 100%;
    }

    .btn-success {
        background: var(--gradient-success);
        box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
    }

    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(40, 167, 69, 0.4);
    }

    .btn-primary {
        background: var(--gradient-primary);
        box-shadow: 0 4px 15px rgba(44, 90, 160, 0.3);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(44, 90, 160, 0.4);
    }

    .btn-outline-info {
        border: 2px solid var(--accent-color);
        color: var(--accent-color);
        background: transparent;
        font-weight: 600;
    }

    .btn-outline-info:hover {
        background: var(--accent-color);
        color: var(--white);
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(23, 162, 184, 0.3);
    }

    .btn-danger {
        background: linear-gradient(135deg, var(--danger-color) 0%, #e74c3c 100%);
        color: var(--white);
        padding: 8px 12px;
        font-size: 0.8rem;
        border-radius: 50%;
       /* width: 80px;*/
        height: 35px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .btn-danger:hover {
        transform: scale(1.1) rotate(5deg);
        box-shadow: 0 4px 15px rgba(220, 53, 69, 0.4);
    }

       /* Estilo base */
    .action-btn {
        font-size: 0.85rem;
        padding: 18px 32px;
        height: 60px;
        min-width: 250px;
        border-radius: 10px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        margin: 6px; /* 💡 separa siempre un poco */
    }

    /* Responsive para móviles */
    @media (max-width: 576px) {
        #action-buttons {
            flex-direction: column !important;
            align-items: center !important;
        }

        .action-btn {
            width: 90%;
            min-width: unset;
            margin: 8px 0; /* 🧼 espacio arriba y abajo */
        }
    }
    /* End Boton */

    .items-table {
        border-radius: var(--border-radius);
        overflow: hidden;
        box-shadow: var(--box-shadow-sm);
        background: var(--white);
        margin-bottom: 0;
    }

    .items-table thead th {
        background: var(--primary-color); /* azul sólido */
        color: var(--white);
        font-weight: 700;
        text-align: center;
        border: none;
        font-size: 0.9rem;
        padding: 18px 12px;
        letter-spacing: 0.5px;
        text-transform: uppercase;
        position: relative;
    }

    .items-table thead th::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 2px;
        background: rgba(255, 255, 255, 0.3);
    }

    .items-table tbody tr {
        transition: var(--transition);
        border-bottom: 1px solid #f1f3f4;
    }

 

 

    .item-section, .doc-rel-section {
        border: 2px dashed rgba(44, 90, 160, 0.2);
        padding: 25px;
        margin-bottom: 20px;
        border-radius: var(--border-radius);
        background: linear-gradient(135deg, rgba(44, 90, 160, 0.02) 0%, rgba(44, 90, 160, 0.05) 100%);
        position: relative;
        transition: var(--transition);
    }

    .item-section:hover, .doc-rel-section:hover {
        border-color: rgba(44, 90, 160, 0.3);
        background: linear-gradient(135deg, rgba(44, 90, 160, 0.05) 0%, rgba(44, 90, 160, 0.08) 100%);
    }

    .ui-autocomplete {
        position: absolute !important;
        z-index: 99999 !important;
        max-height: 250px;
        overflow-y: auto;
        overflow-x: hidden;
        background: var(--white);
        border: 2px solid var(--primary-color);
        border-radius: var(--border-radius-sm);
        font-size: 14px;
        box-shadow: 0 8px 25px rgba(44, 90, 160, 0.2);
    }

    .ui-menu-item-wrapper {
        padding: 12px 16px;
        cursor: pointer;
        border-bottom: 1px solid #f1f3f4;
        transition: var(--transition);
    }

    .ui-menu-item-wrapper:hover {
        background: var(--gradient-primary);
        color: var(--white);
        transform: translateX(3px);
    }

    .ui-menu-item-wrapper:last-child {
        border-bottom: none;
    }

    .ui-helper-hidden-accessible {
        display: none;
    }

    .table-responsive {
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow-sm);
        overflow: hidden;
        margin-bottom: 25px;
    }

    .form-text {
        color: #6c757d;
        font-size: 0.85rem;
        margin-top: 6px;
        font-style: italic;
    }

    .alert {
        border-radius: var(--border-radius);
        border: none;
        box-shadow: var(--box-shadow-sm);
        padding: 20px;
        margin-bottom: 25px;
    }

    .alert-warning {
        background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
        color: #856404;
        border-left: 4px solid var(--warning-color);
    }

    .alert-danger {
        background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
        color: #721c24;
        border-left: 4px solid var(--danger-color);
    }

    pre {
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: var(--border-radius-sm);
        padding: 20px;
        font-size: 0.85rem;
        max-height: 300px;
        overflow-y: auto;
        color: #495057;
    }

    .widget-chart {
        position: relative;
    }

    .row {
        margin-bottom: 15px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    /* Animaciones */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .card-box {
        animation: fadeInUp 0.6s ease-out;
    }

    .portlet {
        animation: fadeInUp 0.4s ease-out;
    }

 

    /* Efectos de carga */
    .loading-skeleton {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: loading 1.5s infinite;
    }

    @keyframes loading {
        0% {
            background-position: 200% 0;
        }
        100% {
            background-position: -200% 0;
        }
    }

    /* Mejoras en la tipografía */
    h3, h4, h5 {
        color: #2c3e50;
        font-weight: 700;
        margin-bottom: 20px;
    }

    /* Efectos hover para las filas de la tabla */
    .item-row {
        transition: var(--transition);
    }

    .item-row:hover {
        background: linear-gradient(135deg, rgba(44, 90, 160, 0.02) 0%, rgba(44, 90, 160, 0.05) 100%);
    }

    /* Estilos para el overlay de carga */
    #overlay-loading {
        backdrop-filter: blur(5px);
        background: rgba(44, 90, 160, 0.1);
    }

    /* Mejoras en los selects */
    select.form-control {
        cursor: pointer;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m6 8 4 4 4-4'/%3e%3c/svg%3e");
        background-position: right 12px center;
        background-repeat: no-repeat;
        background-size: 16px 12px;
        padding-right: 40px;
    }
</style>
<?php require 'includes/header_end.php';?>

<!-- Begin page -->
<div id="wrapper" class="forced enlarged"> <!-- DESACTIVA EL MENU -->

	<?php require 'includes/menu.php';?>

	<!-- ============================================================== -->
	<!-- Start right Content here -->
	<!-- ============================================================== -->
	<div class="content-page">
		<!-- Start content -->
		<div class="content">
			<div class="container-fluid px-0">
				<?php if ($permisos_ver == 1) {
    ?>
					<div class="col-lg-12">
						<div class="portlet">
							<div class="portlet-heading bg-primary">
								<h3 class="portlet-title">
Apertura/Cierre de Caja
								</h3>
								<div class="portlet-widgets">
									<a href="javascript:;" data-toggle="reload"><i class="ion-refresh"></i></a>
									<span class="divider"></span>
									<a data-toggle="collapse" data-parent="#accordion1" href="#bg-primary"><i class="ion-minus-round"></i></a>
									<span class="divider"></span>
									<a href="#" data-toggle="remove"><i class="ion-close-round"></i></a>
								</div>
								<div class="clearfix"></div>
							</div>
							<div id="bg-primary" class="panel-collapse collapse show">
								<div class="portlet-body">
									<?php
if ($permisos_editar == 1) {
        include '../modal/apertura_caja.php';
        include "../modal/cerrar_caja.php";
        //include "../modal/corte_caja.php";
        //include "../modal/egresos_caja.php";
        //include "../modal/eliminar_marca.php";
    }
    ?>
            <div class="row">
				<div class="col-lg-3">
                <div class="widget-bg-color-icon card-box">
													<div class="text-center">
														<?php if ($permisos_editar == 1) {?>
															<button type="button" class="btn btn-success btn-block btn-lg waves-effect waves-light" href="#" data-toggle="modal" data-target="#nuevaCaja" data-toggle="tooltip" title="Apertura de Caja" style="text-align: center;font-size: 15px;"><span class="fa fa-sign-in"></span> Apertura de Caja</button>
                                                            <?php }
    if ($permisos_eliminar == 1) {?>
															
														<?php }?>
													</div>
													<div class="clearfix"></div>
												</div>

                </div>
                <div class="col-lg-9">
									<form class="form-horizontal" role="form" id="datos_cotizacion">

										<div class="form-group row">

											<div class="col-xs-6">
												<div class="input-group">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control daterange pull-right" value="<?php echo "01" . date('/m/Y') . ' - ' . date('d/m/Y'); ?>" id="range" readonly>
                                                    <span class="input-group-btn">
														<button class="btn btn-primary" type="button" onclick='load(1);'><i class='fa fa-search'></i></button>
													</span>
												</div><!-- /input-group -->
											</div>
											<div class="col-xs-1">
												<div id="loader" class="text-center"></div>
											</div>
										</div>
									</form>
                        
									<div class="datos_ajax_delete"></div><!-- Carga los datos ajax -->
									<div class='outer_div'></div><!-- Carga los datos ajax -->

                </div>
                </div>
								</div>
							</div>
						</div>
					</div>

					<?php
} else {
    ?>
					<section class="content">
						<div class="alert alert-danger" align="center">
							<h3>Acceso denegado! </h3>
							<p>No cuentas con los permisos necesario para acceder a este módulo.</p>
						</div>
					</section>
					<?php
}
?>


			</div>
			<!-- end container -->
		</div>
		<!-- end content -->

		<?php require 'includes/pie.php';?>

	</div>
	<!-- ============================================================== -->
	<!-- End Right content here -->
	<!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui -->
<!-- ============================================================== -->
<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<script type="text/javascript" src="../../js/cierre_caja.js"></script>
<script>
//Date range picker
$('.daterange').daterangepicker({
	buttonClasses: ['btn', 'btn-sm'],
	applyClass: 'btn-success',
	cancelClass: 'btn-default',
	locale: {
		format: "DD/MM/YYYY",
		separator: " - ",
		applyLabel: "Aplicar",
		cancelLabel: "Cancelar",
		fromLabel: "Desde",
		toLabel: "Hasta",
		customRangeLabel: "Custom",
		daysOfWeek: [
		"Do",
		"Lu",
		"Ma",
		"Mi",
		"Ju",
		"Vi",
		"Sa"
		],
		monthNames: [
		"Enero",
		"Febrero",
		"Marzo",
		"Abril",
		"Mayo",
		"Junio",
		"Julio",
		"Agosto",
		"Septiembre",
		"Octubre",
		"Noviembre",
		"Diciembre"
		],
		firstDay: 1
	},
	opens: "right"

});
</script>
<script>
function print_corte(caja_id) {
	if (caja_id) {
		$.ajax({
			url: '../pdf/documentos/imprimir_xz.php',
			type: 'POST',
			data: { caja_id: caja_id },
			dataType: 'html',
			success: function(response) {
				const win = window.open('', 'CorteCaja', 'width=900,height=600');
				win.document.write(`
					<html>
						<head>
							<title>Ticket Corte de Caja</title>
							<style>
								body {
									font-family: 'Courier New', monospace;
									font-size: 10px;
									margin: 0;
									padding: 0;
								}
								.ticket {
									width: 250px;
									padding: 5px;
								}
								.center { text-align: center; }
								.bold { font-weight: bold; }
								.line {
									border-top: 1px dashed #000;
									margin: 5px 0;
								}
								.row {
									display: flex;
									justify-content: space-between;
								}
								img.logo {
									max-width: 100px;
									margin-bottom: 5px;
								}
							</style>
						</head>
						<body onload="window.print(); setTimeout(() => window.close(), 500);">
							${response}
						</body>
					</html>
				`);
				win.document.close();
				win.focus();
			},
			error: function(err) {
				alert('Error al generar el corte de caja');
			}
		});
	}
}
</script>

<script>
// print order function
function print_stock(caja_id) {
	if (fecha) {
		//$('#cerrarCaja').modal('hide');
		//$('#modal_vuelto').modal('hide');//CIERRA LA MODAL
		$.ajax({
			url: '../pdf/documentos/imprimir_stock.php',
			type: 'post',
			data: {
				caja_id: caja_id
			},
			dataType: 'text',
			success: function(response) {
				var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
				mywindow.document.write('<html><head><title>Inventario</title>');
				mywindow.document.write('</head><body>');
				mywindow.document.write(response);
				mywindow.document.write('</body></html>');
                mywindow.document.close(); // necessary for IE >= 10
                mywindow.focus(); // necessary for IE >= 10
                mywindow.print();
                mywindow.close();
				//window.location.href = '../html/control_mesas.php';
            } // /success function

        }); // /ajax function to fetch the printable order
    } // /if orderId
} // /print order function

// print order function
function print_cant_venta(caja_id) {
	if (fecha) {
		//$('#cerrarCaja').modal('hide');
		//$('#modal_vuelto').modal('hide');//CIERRA LA MODAL
		$.ajax({
			url: '../pdf/documentos/imprimir_stockVentas.php',
			type: 'post',
			data: {
				caja_id: caja_id
			},
			dataType: 'text',
			success: function(response) {
				var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
				mywindow.document.write('<html><head><title>Inventario</title>');
				mywindow.document.write('</head><body>');
				mywindow.document.write(response);
				mywindow.document.write('</body></html>');
                mywindow.document.close(); // necessary for IE >= 10
                mywindow.focus(); // necessary for IE >= 10
                mywindow.print();
                mywindow.close();
				//window.location.href = '../html/control_mesas.php';
            } // /success function

        }); // /ajax function to fetch the printable order
    } // /if orderId
} // /print order function


</script>


<?php require 'includes/footer_end.php'
?>

