<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
    header("location: ../../login.php");
    exit;
}
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Ordenes";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$title          = "Ventas";
$Ventas         = 1;
$nombre_usuario = get_row('users', 'usuario_users', 'id_users', $user_id);

if (isset($_GET['id_factura'])) {
    $id_factura  = intval($_GET['id_factura']);
    $campos      = "clientes.id_cliente, clientes.nombre_cliente, clientes.nrc_cliente, clientes.email_cliente, facturas_ordenes.id_vendedor, facturas_ordenes.fecha_factura, facturas_ordenes.condiciones, facturas_ordenes.validez, facturas_ordenes.numero_factura, facturas_ordenes.detalle_vehiculo, facturas_ordenes.servicio, facturas_ordenes.precio_servicio";
    $sql_factura = mysqli_query($conexion, "select $campos from facturas_ordenes, clientes where facturas_ordenes.id_cliente=clientes.id_cliente and id_factura='" . $id_factura . "'");
    $count       = mysqli_num_rows($sql_factura);
    if ($count == 1) {
        $rw_factura                 = mysqli_fetch_array($sql_factura);
        $id_cliente                 = $rw_factura['id_cliente'];
        $nombre_cliente             = $rw_factura['nombre_cliente'];
        $fiscal_cliente             = $rw_factura['nrc_cliente'];
        $email_cliente              = $rw_factura['email_cliente'];
        $id_vendedor_db             = $rw_factura['id_vendedor'];
        $fecha_factura              = date("d/m/Y", strtotime($rw_factura['fecha_factura']));
        $condiciones                = $rw_factura['condiciones'];
        $validez                    = $rw_factura['validez'];
        $numero_factura             = $rw_factura['numero_factura'];
        $orden             = $rw_factura['numero_factura'];
        $detalle   = $rw_factura['detalle_vehiculo'];
        $prec   = $rw_factura['precio_servicio'];
        $_SESSION['id_factura']     = $id_factura;
        $_SESSION['numero_factura'] = $numero_factura;
    } else {
        //header("location: bitacora_ordenes.php");
        exit;
    }
} else {
    header("location: bitacora_ordenes.php");
    exit;
}
//consulta para elegir el comprobante
$query = $conexion->query("select * from comprobantes");
$tipo  = array();
while ($r = $query->fetch_object()) {
    $tipo[] = $r;
}
$query = "SELECT codigo, descripcion FROM catalogo_forma_pago ORDER BY codigo ASC";
$result = mysqli_query($conexion, $query);
?>

<?php require 'includes/header_start.php'; ?>

<?php require 'includes/header_end.php'; ?>

<!-- Begin page -->
<div id="wrapper" class="forced enlarged">

    <?php require 'includes/menu.php'; ?>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">
            <div class="container">
                <?php if ($permisos_ver == 1) {
                ?>
                    <div class="col-lg-12">
                        <div class="portlet">
                            <div class="portlet-heading bg-primary">
                                <h3 class="portlet-title">
                                    Editar Servicio <?php echo $orden; ?>
                                </h3>
                                <div class="portlet-widgets">
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <div id="bg-primary" class="panel-collapse collapse show">
                                <div class="portlet-body">
                                    <?php
                                    include "../modal/buscar_productos_ventas.php";
                                    include "../modal/registro_cliente.php";
                                    include "../modal/registro_producto.php";
                                    include "../modal/caja.php";
                                    ?>
                                    <div class="row">
                                        <div class="col-lg-8">
                                            <div class="card-box">

                                                <div class="widget-chart">
                                                    <div id="resultados_ajaxf" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->
                                                    <form class="form-horizontal" role="form" id="barcode_form">

                                                        <div class="row">
                                                            <div class="col-md-1">
                                                                <div class="form-group">
                                                                    <label for="mod_estado" class="control-label">CANT:</label>
                                                                    <input style=" background-color:#A9DFBF; border-radius: 5px; border: 1px solid #39c; text-align: center;" type="numbers" class="form-control" id="barcode_qty" value="1" autocomplete="off" onClick="this.select()">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label for="mod_tipo" class="control-label">SERVICIO:</label>
                                                                    <input style=" background-color:#FADBD8; border-radius: 5px; border: 1px solid #39c;" type="text" class="form-control" onkeyup="this.value = this.value.toUpperCase();" id="barcode" autocomplete="off" tabindex="1" autofocus="true">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="form-group">
                                                                    <label for="mod_tipo" class="control-label">PRECIO $:</label>
                                                                    <input style=" background-color:#FFD54F; border-radius: 5px; border: 1px solid #39c;" type="text" class="form-control" id="barcode_precio" autocomplete="off" tabindex="1" autofocus="true">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group"><br>
                                                                    <button type="submit" class="btn btn-danger btn-block"><span class="fa fa-plus"></span> AGREGAR</button>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="form-group"><br>
                                                                    <button type="button" accesskey="a" class="btn btn-primary btn-block waves-effect waves-light" data-toggle="modal" data-target="#buscar">
                                                                        <span class="fa fa-seach"></span> BUSCAR
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                    <div id="resultados" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->


                                                </div>
                                            </div>

                                        </div>

                                        <div class="col-lg-4">
                                            <div class="card-box">
                                                <div class="widget-chart">
                                                    <div class="editar_factura" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->
                                                    <form role="form" id="datos_factura">
                                                </div>
                                                <input id="id_vendedor" name="id_vendedor" type='hidden' value="<?php echo $id_vendedor_db; ?>">
                                                <div class="form-group row">
                                                    <label class="col-2 col-form-label"></label>
                                                    <div class="col-12">
                                                        <label for="cotizacion">CLIENTE</label>
                                                        <div class="input-group">
                                                            <input style=" background-color:#D4E6F1; border-radius: 5px; border: 1px solid #39c;" type="text" id="nombre_cliente" class="form-control" required value="<?php echo $nombre_cliente; ?>" tabindex="2">
                                                            <span class="input-group-btn">
                                                                <button type="button" class="btn waves-effect waves-light btn-success" data-toggle="modal" data-target="#nuevoCliente">
                                                                    <li class="fa fa-plus"></li>
                                                                </button>
                                                            </span>
                                                            <input id="id_cliente" name="id_cliente" type='hidden' value="<?php echo $id_cliente; ?>">
                                                            <input id="factura_id" name="factura_id" type='hidden' value="<?php echo $id_factura; ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="cotizacion">ORDEN</label>
                                                            <input type="text" class="form-control" autocomplete="off" id="cotizacion" name="cotizacion" value="<?php echo $numero_factura; ?>" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="validez">GARANTIA</label>
                                                            <input type="number" class="form-control" autocomplete="off" id="validez" name="validez" value="<?php echo $validez; ?>">

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="mod_estado" class="control-label">DETALLE:</label>
                                                            <textarea style=" background-color:#FFF176; border-radius: 5px; border: 1px solid #39c;" class="form-control" onkeyup="this.value = this.value.toUpperCase();" id="detalle" autocomplete="off" tabindex="1" autofocus="true" require><?php echo $detalle; ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="id_comp" class="control-label">FACTURA:</label>
                                                            <select id="id_comp" class="form-control" name="id_comp" required autocomplete="off" onchange="getval(this);" require>
                                                                <option value="">-SELECCIONE-</option>
                                                                <?php foreach ($tipo as $c) : ?>
                                                                    <option value="<?php echo $c->id_comp; ?>"><?php echo $c->nombre_comp; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="fiscal">NO.FACTURA</label>
                                                            <div id="outer_comprobante"></div><!-- Carga los datos ajax -->
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                           	<label for="tipoPago">Formas de Pago: <span class="required-badge">*</span></label>
                                                                   <select class="form-control" id="tipoPago" name="tipoPago" required>
                                                                    <option value="">-- Seleccione forma de pago --</option>
                                                                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                                                                        <option value="<?= htmlspecialchars($row['codigo']) ?>"
                                                                            <?= ($row['codigo'] === '01') ? 'selected' : '' ?>>
                                                                            <?= htmlspecialchars($row['descripcion']) ?>
                                                                        </option>
                                                                    <?php endwhile; ?>
                                                                </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <div id="resultados3"></div><!-- Carga los datos ajax del incremento de la fatura -->
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="button" class="btn btn-danger btn-lg btn-block waves-effect waves-light" aria-haspopup="true" aria-expanded="false" id="btn_actualizar"><span class="fa fa-refresh"></span> ACTUALIZAR</button>
                                                <?php if ($permisos_editar == 1) { ?>
                                                    <button type="button" class="btn btn-success btn-lg btn-block waves-effect waves-light" id="btn_guardar"><span class="ti-shopping-cart-full"></span> FACTURAR</button>

                                                <?php }
                                                if ($permisos_eliminar == 1) { ?>

                                                <?php } ?>

                                                </form>

                                            </div>
                                        </div>

                                    </div>

                                </div>
                                <!-- end row -->


                            </div>
                        </div>
                    </div>
            </div>
        <?php
                } else {
        ?>
            <section class="content">
                <div class="alert alert-danger" align="center">
                    <h3>Acceso denegado! </h3>
                    <p>No cuentas con los permisos necesario para acceder a este módulo.</p>
                </div>
            </section>
        <?php
                }
        ?>

        </div>
        <!-- end container -->
    </div>
    <!-- end content -->

    <?php require 'includes/pie.php'; ?>

</div>
<!-- ============================================================== -->
<!-- End Right content here -->
<!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui-->
<!-- ============================================================== -->
<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<script type="text/javascript" src="../../js/editar_ordenes.js"></script>
<!-- ============================================================== -->
<!-- Codigos Para el Auto complete de Clientes -->
<script>
    $(function() {
        $("#nombre_cliente").autocomplete({
            source: "../ajax/autocomplete/clientes.php",
            minLength: 2,
            select: function(event, ui) {
                event.preventDefault();
                $('#id_cliente').val(ui.item.id_cliente);
                $('#nombre_cliente').val(ui.item.nombre_cliente);
                $('#rnc').val(ui.item.fiscal_cliente);
                $.Notification.notify('custom', 'bottom right', 'EXITO!', 'CLIENTE AGREGADO CORRECTAMENTE')
            }
        });
    });

    $("#nombre_cliente").on("keydown", function(event) {
        if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE) {
            $("#id_cliente").val("");
            $("#rnc").val("");
            $("#resultados4").load("../ajax/tipo_doc.php");
        }
        if (event.keyCode == $.ui.keyCode.DELETE) {
            $("#nombre_cliente").val("");
            $("#id_cliente").val("");
            $("#rnc").val("");
        }
    });
</script>
<!-- FIN -->
<script>
    // print order function
    function printOrder(id_factura) {
        $('#modal_vuelto').modal('hide'); //CIERRA LA MODAL
        if (id_factura) {
            $.ajax({
                url: '../pdf/documentos/imprimir_venta.php',
                type: 'post',
                data: {
                    id_factura: id_factura
                },
                dataType: 'text',
                success: function(response) {
                    var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
                    mywindow.document.write('<html><head><title>Facturación</title>');
                    mywindow.document.write('</head><body>');
                    mywindow.document.write(response);
                    mywindow.document.write('</body></html>');
                    mywindow.document.close(); // necessary for IE >= 10
                    mywindow.focus(); // necessary for IE >= 10
                    mywindow.print();
                    mywindow.close();
                } // /success function

            }); // /ajax function to fetch the printable order
        } // /if orderId
    } // /print order function
</script>
<script>
    // print order function
    function printFactura(id_factura) {
        $('#modal_vuelto').modal('hide');
        if (id_factura) {
            $.ajax({
                url: '../pdf/documentos/imprimir_factura_venta.php',
                type: 'post',
                data: {
                    id_factura: id_factura
                },
                dataType: 'text',
                success: function(response) {
                    var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
                    mywindow.document.write('<html><head><title>Facturación</title>');
                    mywindow.document.write('</head><body>');
                    mywindow.document.write(response);
                    mywindow.document.write('</body></html>');
                    mywindow.document.close(); // necessary for IE >= 10
                    mywindow.focus(); // necessary for IE >= 10
                    mywindow.print();
                    mywindow.close();
                } // /success function

            }); // /ajax function to fetch the printable order
        } // /if orderId
    } // /print order function
</script>
<script>
    function obtener_caja(user_id) {
        $(".outer_div3").load("../modal/carga_caja.php?user_id=" + user_id); //carga desde el ajax
    }

    function showDiv(select) {
        if (select.value == 4) {
            $("#resultados3").load("../ajax/carga_prima.php");
        } else {
            $("#resultados3").load("../ajax/carga_resibido.php");
        }
    }

    function comprobar(select) {
        var rnc = $("#rnc").val();
        if (select.value == 1 && rnc == '') {
            $.Notification.notify('warning', 'bottom center', 'NOTIFICACIÓN', 'AL CLIENTE SELECCIONADO NO SE LE PUEDE IMPRIR LA FACTURA, NO TIENE RNC/DEDULA REGISTRADO')
            $("#resultados4").load("../ajax/tipo_doc.php");
        } else {
            //$("#resultados3").load("../ajax/carga_resibido.php");
        }
    }

    function getval(sel) {
        $.Notification.notify('success', 'bottom center', 'NOTIFICACIÓN', 'CAMBIO DE COMPROBANTE')
        $("#outer_comprobante").load("../ajax/carga_correlativos.php?id_comp=" + sel.value);

    }
    $(document).ready(function() {
        $(".UpperCase").on("keypress", function() {
            $input = $(this);
            setTimeout(function() {
                $input.val($input.val().toUpperCase());
            }, 50);
        })
    })
</script>

<?php require 'includes/footer_end.php'
?>