<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
    header("location: ../../login.php");
    exit;
}
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
get_cadena($user_id);
$modulo = "Ventas";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$title          = "Ventas";
$nombre_usuario = get_row('users', 'usuario_users', 'id_users', $user_id);
$doc_cliente    = get_row('perfil', 'doc_cliente', 'id_perfil', 1);

if (isset($_GET['id_factura'])) {
    $id_factura  = intval($_GET['id_factura']);
    $campos      = "numero_factura, id_vendedor, fecha_factura, condiciones, estado_factura, id_sucursal, id_sucursal2";
    $sql_factura = mysqli_query($conexion, "select $campos from facturas_traslados where id_factura='" . $id_factura . "'");
    $count       = mysqli_num_rows($sql_factura);
    if ($count == 1) {
        $rw_factura                 = mysqli_fetch_array($sql_factura);
        $suc_origen                 = $rw_factura['id_sucursal'];
        $suc_destino                 = $rw_factura['id_sucursal2'];
        $id_vendedor_db             = $rw_factura['id_vendedor'];
        $fecha_factura              = date("d/m/Y", strtotime($rw_factura['fecha_factura']));
        $condiciones                = $rw_factura['condiciones'];
        $estado_factura             = $rw_factura['estado_factura'];
        $numero_factura             = $rw_factura['numero_factura'];
        $_SESSION['id_factura']     = $id_factura;
        $_SESSION['numero_factura'] = $numero_factura;
        $nom_origen = get_row('sucursales', 'nombre_sucursal', 'id_sucursal', $suc_origen);
        $nom_destino = get_row('sucursales', 'nombre_sucursal', 'id_sucursal', $suc_destino);
        if ($estado_factura == 1) {
            $desable = "disabled";
            $titulo = "ACEPTADO";
        } else {
            $desable = "";
            $titulo = "PROCESADO";
        }
    } else {
        header("location: bitacora_traslados.php");
        exit;
    }
} else {
    header("location: bitacora_traslados.php");
    exit;
}
?>

<?php require 'includes/header_start.php'; ?>

<?php require 'includes/header_end.php'; ?>

<!-- Begin page -->
<div id="wrapper" class="forced enlarged">

    <?php require 'includes/menu.php'; ?>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">
            <div class="container">
                <?php if ($permisos_ver == 1) {

                ?>
                    <div class="col-lg-12">
                        <div class="portlet">
                            <div class="portlet-heading bg-primary">
                                <h3 class="portlet-title">
                                    Editar Traslado
                                </h3>
                                <div class="portlet-widgets">
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <div id="bg-primary" class="panel-collapse collapse show">
                                <div class="portlet-body">
                                    <?php
                                    include "../modal/buscar_productos_ventas.php";
                                    ?>
                                    <div class="row">
                                        <div class="col-lg-8">
                                            <div class="card-box">

                                                <div class="widget-chart">
                                                    <div id="resultados_ajaxf" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->
                                                    <form class="form-horizontal" role="form" id="barcode_form">
                                                        <div class="form-group row">
                                                            <label for="barcode_qty" class="col-md-1 control-label">Cant:</label>
                                                            <div class="col-md-2">
                                                                <input type="text" class="form-control" style=" background-color:#A9DFBF; border-radius: 5px; border: 1px solid #39c; text-align: center;" id="barcode_qty" value="1" autocomplete="off">
                                                            </div>

                                                            <label for="condiciones" class="control-label">Codigo:</label>
                                                            <div class="col-md-5" align="left">
                                                                <div class="input-group">
                                                                    <input type="text" class="form-control" style=" background-color:#FADBD8; border-radius: 5px; border: 1px solid #39c;" id="barcode" autocomplete="off" tabindex="1" autofocus="true">
                                                                    <span class="input-group-btn">
                                                                        <button type="submit" class="btn btn-default"><span class="fa fa-barcode"></span></button>
                                                                    </span>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <button type="button" accesskey="a" class="btn btn-primary waves-effect waves-light" data-toggle="modal" data-target="#buscar">
                                                                    <span class="fa fa-search"></span> Buscar
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </form>

                                                    <div id="resultados" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->

                                                </div>
                                            </div>

                                        </div>

                                        <div class="col-lg-4">
                                            <div class="card-box">
                                                <div class="widget-chart">
                                                    <div class="editar_factura" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->
                                                    <form role="form" id="datos_factura">
                                                        <input id="id_vendedor" name="id_vendedor" type='hidden' value="<?php echo $id_vendedor_db; ?>">
                                                        <div class="form-group row">
                                                            <div class="col-12">
                                                                <label for="fiscal">SUCURSAL ORIGEN:</label>
                                                                <div class="input-group">
                                                                    <input style=" background-color:#D4E6F1; border-radius: 5px; border: 1px solid #39c;" type="text" id="nombre_sucursal1" class="form-control" placeholder="Buscar Sucursal" required tabindex="2" value="<?php echo $nom_origen; ?>" onClick="this.select()">
                                                                    <input id="id_sucursal1" name="id_sucursal1" type='hidden' value="<?php echo $suc_origen; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-12">
                                                                <label for="fiscal">SUCURSAL DESTINO:</label>
                                                                <div class="input-group">
                                                                    <input style=" background-color:#E8DAEF; border-radius: 5px; border: 1px solid #39c;" type="text" id="nombre_sucursal2" class="form-control" placeholder="Buscar sucursal" required tabindex="2" value="<?php echo $nom_destino; ?>" onClick="this.select()">
                                                                    <input id="id_sucursal2" name="id_sucursal2" type='hidden' value="<?php echo $suc_destino; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label for="fiscal">Factura</label>
                                                                    <input type="text" class="form-control" autocomplete="off" id="factura" name="factura" value="<?php echo $numero_factura; ?>" readonly>
                                                                    <input type="hidden" class="form-control" autocomplete="off" id="id_factura" name="id_factura" value="<?php echo $id_factura; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label for="fiscal">Pago</label>
                                                                    <select class='form-control input-sm' id="condiciones" name="condiciones">
                                                                        <option value="1" <?php if ($condiciones == 1) {
                                                                                                echo "selected";
                                                                                            } ?>>Efectivo</option>
                                                                        <option value="2" <?php if ($condiciones == 2) {
                                                                                                echo "selected";
                                                                                            } ?>>Cheque</option>
                                                                        <option value="3" <?php if ($condiciones == 3) {
                                                                                                echo "selected";
                                                                                            } ?>>Transferencia bancaria</option>
                                                                        <option value="4" <?php if ($condiciones == 4) {
                                                                                                echo "selected";
                                                                                            } ?>>Crédito</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label for="resibido">Estado Traslado</label>
                                                                    <select class='form-control' id="estado_factura" name="estado_factura">
                                                                        <option value="0" <?php if ($estado_factura == 0) {
                                                                                                echo "selected";
                                                                                            } ?>>Pendiente</option>
                                                                        <option value="1" <?php if ($estado_factura == 1) {
                                                                                                echo "selected";
                                                                                            } ?>>Resibido</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <button type="button" class="btn btn-success waves-effect waves-light" aria-haspopup="true" aria-expanded="false" id="btn_actualizar"><span class="fa fa-refresh"></span> ACTUALIZAR</button>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <button type="button" class="btn btn-danger waves-effect waves-light" id="btn_guardar" <?php echo $desable; ?>><span class="ti-shopping-cart-full"></span> <?php echo $titulo; ?></button>
                                                            </div>
                                                        </div>
                                                    </form>

                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                    <!-- end row -->


                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                } else {
                ?>
                    <section class="content">
                        <div class="alert alert-danger" align="center">
                            <h3>Acceso denegado! </h3>
                            <p>No cuentas con los permisos necesario para acceder a este módulo.</p>
                        </div>
                    </section>
                <?php
                }
                ?>

            </div>
            <!-- end container -->
        </div>
        <!-- end content -->

        <?php require 'includes/pie.php'; ?>

    </div>
    <!-- ============================================================== -->
    <!-- End Right content here -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui-->
<!-- ============================================================== -->
<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<script type="text/javascript" src="../../js/editar_traslado.js"></script>
<!-- ============================================================== -->
<!-- Codigos Para el Auto complete de Clientes -->
<script>
    $(function() {
        $("#nombre_cliente").autocomplete({
            source: "../ajax/autocomplete/clientes.php",
            minLength: 2,
            select: function(event, ui) {
                event.preventDefault();
                $('#id_sucursal').val(ui.item.id_sucursal);
                $('#nombre_cliente').val(ui.item.nombre_cliente);
                $('#tel1').val(ui.item.fiscal_cliente);
            }
        });
    });

    $("#nombre_cliente").on("keydown", function(event) {
        if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE) {
            $("#id_sucursal").val("");
            $("#tel1").val("");
        }
        if (event.keyCode == $.ui.keyCode.DELETE) {
            $("#nombre_cliente").val("");
            $("#id_sucursal").val("");
            $("#tel1").val("");
        }
    });
</script>
<!-- FIN -->
<script>
    // print order function
    function printOrder(id_factura) {
        if (id_factura) {
            $.ajax({
                url: '../pdf/documentos/imprimir_venta_edit.php',
                type: 'post',
                data: {
                    id_factura: id_factura
                },
                dataType: 'text',
                success: function(response) {
                    var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
                    mywindow.document.write('<html><head><title>Facturación</title>');
                    mywindow.document.write('</head><body>');
                    mywindow.document.write(response);
                    mywindow.document.write('</body></html>');
                    mywindow.document.close(); // necessary for IE >= 10
                    mywindow.focus(); // necessary for IE >= 10
                    mywindow.print();
                    mywindow.close();
                } // /success function

            }); // /ajax function to fetch the printable order
        } // /if orderId
    } // /print order function
</script>
<script>
    // print order function
    function printFactura(id_factura) {
        if (id_factura) {
            $.ajax({
                url: '../pdf/documentos/imprimir_traslado.php',
                type: 'post',
                data: {
                    id_factura: id_factura
                },
                dataType: 'text',
                success: function(response) {
                    var mywindow = window.open('', 'Stock Management System', 'height=400,width=600');
                    mywindow.document.write('<html><head><title>Facturación</title>');
                    mywindow.document.write('</head><body>');
                    mywindow.document.write(response);
                    mywindow.document.write('</body></html>');
                    mywindow.document.close(); // necessary for IE >= 10
                    mywindow.focus(); // necessary for IE >= 10
                    mywindow.print();
                    mywindow.close();
                } // /success function

            }); // /ajax function to fetch the printable order
        } // /if orderId
    } // /print order function
</script>

<?php require 'includes/footer_end.php'
?>