<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
	header("location: ../../login.php");
	exit;
}
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
get_cadena($user_id);
$modulo = "Productos";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
if (isset($_GET['id'])) {
	$id_producto  = intval($_GET['id']);
	$sql = mysqli_query($conexion, "select * from productos where id_producto='$id_producto'");
	$count        = mysqli_num_rows($sql);
	if ($count == 1) {
		$rw     = mysqli_fetch_array($sql);
		$nombre         = $rw['nombre_producto'];
		$stock          = $rw['stock_producto'];
		$image_path     = $rw['image_path'];
		$_SESSION['id'] = $id_producto;
	} else {
		header("location: ../html/productos.php");
		exit;
	}
} else {
	header("location: ../html/productos.php");
	exit;
}
?>

<?php require 'includes/header_start.php'; ?>

<?php require 'includes/header_end.php'; ?>

<!-- Begin page -->
<div id="wrapper" class="forced enlarged">

	<?php require 'includes/menu.php'; ?>

	<!-- ============================================================== -->
	<!-- Start right Content here -->
	<!-- ============================================================== -->
	<div class="content-page">
		<!-- Start content -->
		<div class="content">
			<div class="container">
				<?php if ($permisos_ver == 1) {
				?>
					<div class="col-lg-12">
						<div class="portlet">
							<div class="portlet-heading bg-primary">
								<h3 class="portlet-title">
									Kardex de Productos
								</h3>
								<div class="portlet-widgets">
									<a href="javascript:;" data-toggle="reload"><i class="ion-refresh"></i></a>
									<span class="divider"></span>
									<a data-toggle="collapse" data-parent="#accordion1" href="#bg-primary"><i class="ion-minus-round"></i></a>
									<span class="divider"></span>
									<a href="#" data-toggle="remove"><i class="ion-close-round"></i></a>
								</div>
								<div class="clearfix"></div>
							</div>
							<div id="bg-primary" class="panel-collapse collapse show">
								<div class="portlet-body">
									<div class="form-group row">
										<div class="col-md-3">
											<span id="loader"></span>
										</div>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-lg-3">
									<div class="col-lg-12 col-md-6">
										<div class="widget-bg-color-icon card-box">
											<!--<img class="card-img-top img-fluid" src="../../assets/images/small/img2.jpg" alt="Card image cap">-->
											<?php
											if ($image_path == null) {
												echo '<img class="card-img-top img-fluid" src="../../img/productos/default.jpg">';
											} else {
												echo '<img src="' . $image_path . '" class="card-img-top img-fluid">';
											}

											?>
											<div class="text-center">
												<div class="alert alert-danger" align="center">
													<strong>Existencia: <?php echo $stock; ?></strong>
												</div>
											</div>
											<div class="clearfix"></div>
										</div>
									</div>
									<div class="clearfix"></div>
								</div>
								<div class="col-lg-9">
									<div class="panel panel-color panel-info">
										<div class="panel-body">
											<form class="form-horizontal" role="form" id="datos_cotizacion">
												<div class="form-group row">
													<div class="col-xs-4">
														<div class="input-group">
															<div class="input-group-addon">
																<i class="fa fa-calendar"></i>
															</div>
															<input type="text" class="form-control daterange pull-right" value="<?php echo "01" . date('/m/Y') . ' - ' . date('d/m/Y'); ?>" id="range" readonly>
															<span class="input-group-btn">
																<button class="btn btn-outline-info btn-rounded waves-effect waves-light" type="button" onclick='load(1);'><i class='fa fa-search'></i></button>
															</span>

														</div><!-- /input-group -->
													</div>
													<div class="col-xs-4">
														<div id="loader" class="text-left"></div>
													</div>
													<div class="col-xs-4">
														<div class="btn-group dropdown">
															<button type="button" class="btn btn-default btn-rounded dropdown-toggle waves-effect waves-light" data-toggle="dropdown" aria-expanded="false"> <i class='fa fa-print'></i> <i class="caret"></i> Imprimir</button>
															<div class="dropdown-menu dropdown-menu-right">
																<?php if ($permisos_editar == 1) { ?>
																	<a class="dropdown-item" href="#" data-toggle="modal" data-target="#editarLinea" onclick="reporte();"><i class='fa fa-edit'></i> Imprimir</a>
																	<!--<a class="dropdown-item" href="#" data-toggle="modal" data-target="#editarLinea" onclick="reporte_excel();"><i class='fa fa-edit'></i> Excel</a>-->
																<?php } ?>
															</div>
														</div>
													</div>

												</div>
											</form>
											<div class="col-md-12" align="center">
												<div id="resultados_ajax"></div>
												<div class="clearfix"></div>
												<table>
													<tr>
														<th>Nombre de Producto: <b><?php echo $nombre; ?></b></th>
													</tr>
												</table>
												<div class='outer_div'></div><!-- Carga los datos ajax -->
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>

				<?php
				} else {
				?>
					<section class="content">
						<div class="alert alert-danger" align="center">
							<h3>Acceso denegado! </h3>
							<p>No cuentas con los permisos necesario para acceder a este módulo.</p>
						</div>
					</section>
				<?php
				}
				?>

			</div>
			<!-- end container -->
		</div>
		<!-- end content -->

		<?php require 'includes/pie.php'; ?>

	</div>
	<!-- ============================================================== -->
	<!-- End Right content here -->
	<!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui -->
<!-- ============================================================== -->
<script type="text/javascript" src="../../js/kardex.js"></script>
<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<!-- Codigos Para el Auto complete de Clientes -->
<script>
	$(function() {
		//Initialize Select2 Elements
		$(".select2").select2();
	});
	$(function() {
		load(1);

		//Date range picker
		$('.daterange').daterangepicker({
			buttonClasses: ['btn', 'btn-sm'],
			applyClass: 'btn-success',
			cancelClass: 'btn-default',
			locale: {
				format: "DD/MM/YYYY",
				separator: " - ",
				applyLabel: "Aplicar",
				cancelLabel: "Cancelar",
				fromLabel: "Desde",
				toLabel: "Hasta",
				customRangeLabel: "Custom",
				daysOfWeek: [
					"Do",
					"Lu",
					"Ma",
					"Mi",
					"Ju",
					"Vi",
					"Sa"
				],
				monthNames: [
					"Enero",
					"Febrero",
					"Marzo",
					"Abril",
					"Mayo",
					"Junio",
					"Julio",
					"Agosto",
					"Septiembre",
					"Octubre",
					"Noviembre",
					"Diciembre"
				],
				firstDay: 1
			},
			opens: "right"

		});
	});

	function load(page) {
		var q = $("#q").val();
		var tipo = $("#tipo").val();
		var trans = $("#trans").val();
		var range = $("#range").val();
		var parametros = {
			"action": "ajax",
			"page": page,
			'tipo': tipo,
			'trans': trans,
			'range': range,
			'q': q,
		};
		$("#loader").fadeIn('slow');
		$.ajax({
			url: '../ajax/kardex_producto.php',
			data: parametros,
			beforeSend: function(objeto) {
				$("#loader").html("<img src='../../img/ajax-loader.gif'>");
			},
			success: function(data) {
				$(".outer_div").html(data).fadeIn('slow');
				$("#loader").html("");
			}
		})
	}
</script>
<script>
	function reporte() {
		var daterange = $("#range").val();
		var employee_id = $("#employee_id").val();

		VentanaCentrada('../reportes/rep_kardex.php?daterange=' + daterange, 'Reporte', '', '800', '600', 'true');
	}
</script>
<!-- FIN -->

<?php require 'includes/footer_end.php'
?>