<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
	header("location: ../../login.php");
	exit;
}
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";
//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
if ($cargo_users == 1) {
	$est = "";
} else {
	$est = "disabled";
}
get_cadena($user_id);
$modulo = "Compras";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$title         = "Compras";
$pacientes     = 1;
$doc_proveedor = get_row('perfil', 'doc_proveedor', 'id_perfil', 1);
$nom           = get_row('users', 'nombre_users', 'id_users', $user_id);
$ape           = get_row('users', 'apellido_users', 'id_users', $user_id);

//consulta para elegir el impuesto en la modal
$query    = $conexion->query("select * from impuestos");
$impuesto = array();
while ($r = $query->fetch_object()) {
	$impuesto[] = $r;
}
//Categorias
$query  = $conexion->query("select * from lineas order by nombre_linea");
$categoria = array();
while ($r = $query->fetch_object()) {
	$categoria[] = $r;
}
//Sub categoria
//Categorias
$query  = $conexion->query("select * from sub_lineas order by nombre_linea2");
$subcat = array();
while ($r = $query->fetch_object()) {
	$subcat[] = $r;
}

?>

<?php require 'includes/header_start.php'; ?>

<?php require 'includes/header_end.php'; ?>

<!-- Begin page -->
<div id="wrapper" class="forced enlarged">
	<!-- DESACTIVA EL MENU -->

	<?php require 'includes/menu.php'; ?>

	<!-- ============================================================== -->
	<!-- Start right Content here -->
	<!-- ============================================================== -->
	<div class="content-page">
		<!-- Start content -->
		 <?php verificarEstadoCaja($conexion, $sucursal_users);?>
		<div class="content">
			<div class="container">
				<?php if ($permisos_ver == 1) {
				?>
					<div class="col-lg-12">
						<div class="portlet">
							<div class="portlet-heading bg-primary">
								<h3 class="portlet-title">
									Nueva Compra
								</h3>
								<div class="portlet-widgets">
									<a href="javascript:;" data-toggle="reload"><i class="ion-refresh"></i></a>
									<span class="divider"></span>
									<a data-toggle="collapse" data-parent="#accordion1" href="#bg-primary"><i class="ion-minus-round"></i></a>
									<span class="divider"></span>
									<a href="#" data-toggle="remove"><i class="ion-close-round"></i></a>
								</div>
								<div class="clearfix"></div>
							</div>
							<div id="bg-primary" class="panel-collapse collapse show">
								<div class="portlet-body">
									<?php
									include "../modal/buscar_productos_compras.php";
									include "../modal/registro_proveedor.php";
									include "../modal/registro_producto.php";
									//include "../modal/caja.php";
									?>
									<div class="row">
										<div class="col-lg-8">
											<div style=" background-color:#EFEBE9; border-radius: 5px; border: 1px solid #39c;" class="card-box">
												<div class="widget-chart">
													<div id="resultados_ajaxf" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->

													<form class="form-horizontal" role="form" id="barcode_form">
														<div class="form-group row">
															<label for="barcode_qty" class="col-md-1 control-label">CANT:</label>
															<div class="col-md-2">
																<input type="text" style=" background-color:#A9DFBF; border-radius: 5px; border: 1px solid #39c; text-align: center;" class="form-control" id="barcode_qty" value="1" autocomplete="off">
															</div>
															<label for="condiciones" class="control-label">CODIGO:</label>
															<div class="col-md-4" align="left">
																<div class="input-group">
																	<input type="text" style=" background-color:#FADBD8; border-radius: 5px; border: 1px solid #39c;" class="form-control" id="barcode" autocomplete="off" tabindex="1" autofocus="true">
																	<span class="input-group-btn">
																		<button type="submit" class="btn btn-default"><span class="fa fa-barcode"></span></button>
																	</span>
																</div>
															</div>
															<div class="col-md-2">
																<button type="button" accesskey="a" class="btn btn-primary waves-effect waves-light" data-toggle="modal" data-target="#buscar" title="Buscar Producto">
																	<span class="fa fa-search"></span> Buscar
																</button>
															</div>
															<div class="col-md-1">
																<button type="button" accesskey="a" class="btn btn-success waves-effect waves-light" data-toggle="modal" data-target="#nuevoProducto" title="Agregar Nuevo Producto">
																	<span class="fa fa-plus"></span> Nuevo
																</button>
															</div>
														</div>
													</form>
													
													<div id="resultados" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->

												</div>
											</div>

										</div>

										<div class="col-lg-4">
											<div style=" background-color:#EFEBE9; border-radius: 5px; border: 1px solid #39c;" class="card-box">

												<div class="widget-chart">
													<form role="form">
														<div class="form-group row">
															<label class="col-2 col-form-label"></label>
															<div class="col-12">
																<label for="fiscal">PROVEEDOR</label>
																<div class="input-group">
																	<input type="text" style=" background-color:#D4E6F1; border-radius: 5px; border: 1px solid #39c;" id="nombre_proveedor" class="form-control" placeholder="Buscar Proveedor" required tabindex="2">
																	<span class="input-group-btn">
																		<button type="button" class="btn waves-effect waves-light btn-success" data-toggle="modal" data-target="#nuevoProveedor" title="Agregar Proveedor">
																			<li class="fa fa-plus"></li>
																		</button>
																	</span>
																	<input id="id_proveedor" name="id_proveedor" type='hidden'>
																</div>
															</div>
														</div>
														<div class="row">
															<div class="col-md-6">
																<div class="form-group">
																	<label for="fiscal">NO. FACTURA</label>
																	<div id="f_resultado"></div><!-- Carga los datos ajax del incremento de la fatura -->
																</div>
															</div>
															<div class="col-md-6">
																<div class="form-group">
																	<label for="ref">REFERENCIA</label>
																	<input type="text" class="form-control" autocomplete="off" id="ref" name="ref">
																</div>
															</div>
														</div>

														<div class="row">
															<div class="col-md-6">
																<div class="form-group">
																	<label for="fiscal">PAGO</label>
																	<select class='form-control input-sm' id="condiciones" name="condiciones" onchange="showDiv(this)">
																		<option value="1">Efectivo</option>
																		<option value="2">Cheque</option>
																		<option value="3">Transferencia bancaria</option>
																		<option value="4">Crédito</option>
																	</select>
																</div>
															</div>
															<div class="col-md-6">
																<div class="form-group">
																	<div id="resultados2"></div><!-- Carga los datos ajax del incremento de la fatura -->
																</div>
															</div>

														</div>
														<div class="row">
															<div class="col-md-12">
																<div class="form-group">
																	<label for="fiscal">TIPO FACTURA</label>
																	<select class='form-control input-sm' id="tipo_factura" name="tipo_factura" onchange="cargarArchivoFactura()">
																		<option value="cf">Consumidor</option>
																		<option value="ccf">Credito Fiscal</option>
																	</select>
																</div>
															</div>
														</div>
														<div class="row">
															<div class="col-md-6">
																<div class="form-group">
																	<label for="fecha">FECHA</label>
																	<input type="date" class="form-control" id="fecha" name="fecha" required tabindex="4">
																</div>
															</div>
															<div class="col-md-6">
																<div class="form-group">
																	<label for="fecha">EMPLEADO</label>
																	<input type="text" class="form-control" autocomplete="off" id="vendedor" name="vendedor" value="<?php echo $nom . ' ' . $ape; ?>" readonly="">
																</div>
															</div>
														</div>

														<?php if ($permisos_editar == 1) { ?>
															<div class="col-md-12" align="center">
																<button type="button" id="guardar_factura_btn" class="btn btn-danger btn-block btn-lg waves-effect waves-light">
															<span class="fa fa-print"></span> Guardar
															</button>
															</div>
																

														<?php } ?>
													</form>

												</div>
											</div>

										</div>

									</div>
									<!-- end row -->


								</div>
							</div>
						</div>
					</div>
				<?php
				} else {
				?>
					<section class="content">
						<div class="alert alert-danger" align="center">
							<h3>Acceso denegado! </h3>
							<p>No cuentas con los permisos necesario para acceder a este módulo.</p>
						</div>
					</section>
				<?php
				}
				?>

			</div>
			<!-- end container -->
		</div>
		<!-- end content -->

		<?php require 'includes/pie.php'; ?>

	</div>
	<!-- ============================================================== -->
	<!-- End Right content here -->
	<!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui -->
<!-- ============================================================== -->
<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<script type="text/javascript" src="../../js/compra.js"></script>
<!-- ============================================================== -->
<!-- Codigos Para el Auto complete de proveedores -->
<script>
	$(function() {
		$("#nombre_proveedor").autocomplete({
			source: "../ajax/autocomplete/proveedor.php",
			minLength: 2,
			select: function(event, ui) {
				event.preventDefault();
				$('#id_proveedor').val(ui.item.id_proveedor);
				$('#nombre_proveedor').val(ui.item.nombre_proveedor);
				$('#tel1').val(ui.item.fiscal_proveedor);
				$.Notification.notify('custom', 'bottom right', 'EXITO!', 'PROVEEDOR AGREGADO CORRECTAMENTE')

			}
		});


	});

	$("#nombre_proveedor").on("keydown", function(event) {
		if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE) {
			$("#id_proveedor").val("");
			$("#tel1").val("");

		}
		if (event.keyCode == $.ui.keyCode.DELETE) {
			$("#nombre_proveedor").val("");
			$("#id_proveedor").val("");
			$("#tel1").val("");
		}
	});
</script>
<!-- FIN -->
<script>
	function showDiv(select) {
		if (select.value == 4) {
			$("#resultados2").load("../ajax/carga_prima2.php");
		} else {
			$("#resultados2").load("../ajax/carga_resibido2.php");
		}
	}

	function cargarArchivoFactura() {
    var tipoFactura = $("#tipo_factura").val();
    var url = (tipoFactura === "cf") ? "../ajax/agregar_tmp_compra.php" : "../ajax/agregar_tmp_compraCredito.php";
    
    $("#resultados").load(url, function(response, status, xhr) {
        if (status == "error") {
            console.log("Error al cargar el archivo: " + xhr.status + " " + xhr.statusText);
        }
    });
}

$(document).ready(function() {
    // Cargar al cambiar la selección
    $("#tipo_factura").change(cargarArchivoFactura);
    
    // Cargar al inicio
    cargarArchivoFactura();
});


$("#guardar_factura_btn").click(function () {
    $('#guardar_factura_btn').attr("disabled", true);

    var id_proveedor = $("#id_proveedor").val();
    if (id_proveedor === "") {
        $.Notification.notify('error', 'bottom center', 'NOTIFICACIÓN', 'DEBE SELECCIONAR UN PROVEEDOR VALIDO');
        $("#nombre_proveedor").focus();
        $('#guardar_factura_btn').attr("disabled", false);
        return;
    }

    var datos = {
        id_proveedor: $("#id_proveedor").val(),
        ref: $("#ref").val(),
        condiciones: $("#condiciones").val(),
        tipo_factura: $("#tipo_factura").val(),
        fecha: $("#fecha").val(),
        vendedor: $("#vendedor").val(),
        factura: $("#factura").val(),
        resibido: $("#resibido").val(),
        iva: $("#iva").val()
    };

    $.ajax({
        type: "POST",
        url: "../ajax/guardar_compra.php",
        data: datos,
        beforeSend: function () {
            $("#resultados_ajaxf").html('<img src="../../img/ajax-loader.gif"> Cargando...');
        },
        success: function (datos) {
            $("#resultados_ajaxf").html(datos);
            $('#guardar_factura_btn').attr("disabled", false);

            // Espera 1 segundo para mostrar el mensaje y luego refresca la página completa
            setTimeout(function() {
                location.reload();
            }, 1000);
        }
    });
});



</script>
<?php require 'includes/footer_end.php'
?>