<?php
session_start();
if (!isset($_SESSION['user_login_status']) and $_SESSION['user_login_status'] != 1) {
    header("location: ../../login.php");
    exit;
}
/* Connect To Database*/
require_once "../db.php"; //Contiene las variables de configuracion para conectar a la base de datos
require_once "../php_conexion.php"; //Contiene funcion que conecta a la base de datos
//Archivo de funciones PHP
require_once "../funciones.php";

//Inicia Control de Permisos
include "../permisos.php";
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
if ($cargo_users == 1) {
    $est = "";
} else {
    $est = "disabled";
}
get_cadena($user_id);
$modulo = "Ordenes";
permisos($modulo, $cadena_permisos);
//Finaliza Control de Permisos
$title          = "Ventas";
$nombre_usuario = get_row('users', 'usuario_users', 'id_users', $user_id);
$nom            = get_row('users', 'nombre_users', 'id_users', $user_id);
$ape            = get_row('users', 'apellido_users', 'id_users', $user_id);
$doc_cliente = get_row('perfil', 'doc_cliente', 'id_perfil', 1);
$cliente = mysqli_query($conexion, "select * from perfil, clientes where perfil.cliente_id= clientes.id_cliente  and perfil.id_perfil=1");
$row           = mysqli_fetch_array($cliente);
?>

<?php require 'includes/header_start.php'; ?>

<?php require 'includes/header_end.php'; ?>

<!-- Begin page -->
<div id="wrapper" class="forced enlarged">
    <!-- DESACTIVA EL MENU -->
    <?php require 'includes/menu.php'; ?>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
          <?php verificarEstadoCaja($conexion, $sucursal_users);?>
        <div class="content">
            <div class="container">
                <?php if ($permisos_ver == 1) {
                ?>
                    <div class="col-lg-12">
                        <div class="portlet">
                            <div class="portlet-heading bg-primary">
                                <h3 class="portlet-title">
                                    Nueva Orden/Servicio
                                </h3>
                                <div class="portlet-widgets">
                                    <a href="javascript:;" data-toggle="reload"><i class="ion-refresh"></i></a>
                                    <span class="divider"></span>
                                    <a data-toggle="collapse" data-parent="#accordion1" href="#bg-primary"><i class="ion-minus-round"></i></a>
                                    <span class="divider"></span>
                                    <a href="#" data-toggle="remove"><i class="ion-close-round"></i></a>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <div id="bg-primary" class="panel-collapse collapse show">
                                <div class="portlet-body">
                                    <?php
                                    include "../modal/buscar_productos_ventas.php";
                                    include "../modal/registro_cliente.php";
                                    include "../modal/registro_producto.php";

                                    ?>
                                    <div class="row">
                                        <div class="col-lg-8">
                                            <div style=" background-color:#EFEBE9; border-radius: 5px; border: 1px solid #39c;" class="card-box">

                                                <div class="widget-chart">
                                                    <div id="resultados_ajaxf" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->
                                                    <form role="form" id="barcode_form">
                                                        <div class="row">
                                                            <div class="col-md-1">
                                                                <div class="form-group">
                                                                    <label for="mod_estado" class="control-label">CANT:</label>
                                                                    <input style=" background-color:#A9DFBF; border-radius: 5px; border: 1px solid #39c; text-align: center;" type="numbers" class="form-control" id="barcode_qty" value="1" autocomplete="off" onClick="this.select()">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label for="mod_tipo" class="control-label">SERVICIO:</label>
                                                                    <input style=" background-color:#FADBD8; border-radius: 5px; border: 1px solid #39c;" type="text" class="form-control" onkeyup="this.value = this.value.toUpperCase();" id="barcode" autocomplete="off" tabindex="1" autofocus="true">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="form-group">
                                                                    <label for="mod_tipo" class="control-label">PRECIO $:</label>
                                                                    <input style=" background-color:#FFD54F; border-radius: 5px; border: 1px solid #39c;" type="text" class="form-control" id="barcode_precio" autocomplete="off" tabindex="1" autofocus="true">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group"><br>
                                                                    <button type="submit" class="btn btn-danger btn-block"><span class="fa fa-plus"></span> AGREGAR</button>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="form-group"><br>
                                                                    <button type="button" accesskey="a" class="btn btn-primary btn-block waves-effect waves-light" data-toggle="modal" data-target="#buscar">
                                                                        <span class="fa fa-seach"></span> BUSCAR
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>

                                                    <div id="resultados" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->

                                                </div>
                                            </div>

                                        </div>

                                        <div class="col-lg-4">
                                            <div style=" background-color:#EFEBE9; border-radius: 5px; border: 1px solid #39c;" class="card-box">
                                                <div class="widget-chart">
                                                    <form role="form" id="datos_factura">
                                                        <div class="form-group row">
                                                            <label class="col-2 col-form-label"></label>
                                                            <div class="col-12">
                                                                <label for="fiscal">CLIENTE</label>
                                                                <div class="input-group">
                                                                    <input style=" background-color:#D4E6F1; border-radius: 5px; border: 1px solid #39c;" type="text" id="nombre_cliente" class="form-control" placeholder="Buscar Cliente" value="<?php echo $row["nombre_cliente"]; ?>" required tabindex="2">
                                                                    <span class="input-group-btn">
                                                                        <button type="button" class="btn waves-effect waves-light btn-success" data-toggle="modal" data-target="#nuevoCliente">
                                                                            <li class="fa fa-plus"></li>
                                                                        </button>
                                                                    </span>
                                                                    <input id="id_cliente" name="id_cliente" type='hidden' value="<?php echo $row["id_cliente"]; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label for="mod_estado" class="control-label">DETALLE DE SERVICIO:</label>
                                                                    <textarea style=" background-color:#FFF176; border-radius: 5px; border: 1px solid #39c;" class="form-control" onkeyup="this.value = this.value.toUpperCase();" id="detalle" autocomplete="off" tabindex="1" autofocus="true" require></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label for="fiscal">ORDEN</label>
                                                                    <div id="f_resultado"></div><!-- Carga los datos ajax del incremento de la fatura -->
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label for="condiciones">PAGO</label>
                                                                    <select class="form-control input-sm condiciones" id="condiciones" name="condiciones" onchange="showDiv(this)">
                                                                        <option value="1">Contado</option>
                                                                        <option value="4">Crédito</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label for="validez">GARANTIA</label>
                                                                    <input type="number" class="form-control" autocomplete="off" id="validez" name="validez" value="1">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label for="fecha">EMPLEADO</label>
                                                                    <input type="text" class="form-control" autocomplete="off" id="vendedor" name="vendedor" value="<?php echo $nom . ' ' . $ape; ?>" readonly="">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12" align="center">
                                                            <button type="submit" id="btn_orden" class="btn btn-danger btn-lg btn-block waves-effect waves-light" aria-haspopup="true" aria-expanded="false"><span class="fa fa-save"></span> Guardar</button>
                                                        </div>
                                                    </form><br>
                                                    <div class="table-responsive">
                                                        <table class="table table-sm no-margin table-striped">
                                                            <thead>
                                                                <tr>
                                                                    <th colspan="3" style="text-align:center;">MODIFICAR ORDEN</th>
                                                                </tr>
                                                                <tr>
                                                                    <th>ORDEN</th>
                                                                    <th>CLIENTE</th>
                                                                    <th class=" text-center">TOTAL</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                latest_ordenes();
                                                                ?>
                                                            </tbody>
                                                        </table>
                                                    </div><!-- /.table-responsive -->

                                                </div>
                                            </div>

                                        </div>


                                    </div>
                                    <!-- end row -->


                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                } else {
                ?>
                    <section class="content">
                        <div class="alert alert-danger" align="center">
                            <h3>Acceso denegado! </h3>
                            <p>No cuentas con los permisos necesario para acceder a este módulo.</p>
                        </div>
                    </section>
                <?php
                }
                ?>

            </div>
            <!-- end container -->
        </div>
        <!-- end content -->

        <?php require 'includes/pie.php'; ?>

    </div>
    <!-- ============================================================== -->
    <!-- End Right content here -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php require 'includes/footer_start.php'
?>
<!-- ============================================================== -->
<!-- Todo el codigo js aqui-->
<!-- ============================================================== -->
<script type="text/javascript" src="../../js/VentanaCentrada.js"></script>
<script type="text/javascript" src="../../js/ordenes.js"></script>
<!-- ============================================================== -->
<!-- Codigos Para el Auto complete de Clientes -->
<script>
    $(function() {
        $("#nombre_cliente").autocomplete({
            source: "../ajax/autocomplete/clientes.php",
            minLength: 2,
            select: function(event, ui) {
                event.preventDefault();
                $('#id_cliente').val(ui.item.id_cliente);
                $('#nombre_cliente').val(ui.item.nombre_cliente);
                $('#tel1').val(ui.item.fiscal_cliente);
                $('#em').val(ui.item.email_cliente);
                $.Notification.notify('success', 'bottom right', 'EXITO!', 'CLIENTE AGREGADO CORRECTAMENTE')
            }
        });
    });

    $("#nombre_cliente").on("keydown", function(event) {
        if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE) {
            $("#id_cliente").val("");
            $("#tel1").val("");
            $("#em").val("");
        }
        if (event.keyCode == $.ui.keyCode.DELETE) {
            $("#nombre_cliente").val("");
            $("#id_cliente").val("");
            $("#tel1").val("");
            $("#em").val("");
        }
    });
</script>
<!-- FIN -->
<script>
    // print order function
    function printFactura(id_factura) {
        $('#modal_vuelto').modal('hide');
        if (id_factura) {
            $.ajax({
                url: '../pdf/documentos/imprimir_cotizacion.php',
                type: 'post',
                data: {
                    id_factura: id_factura
                },
                dataType: 'text',
                success: function(response) {
                    var WinPrint = window.open('', 'COTIZACION', 'width=800,height=650');
                    WinPrint.document.write(response);
                    WinPrint.document.close();
                    mywindow.document.close(); // necessary for IE >= 10
                    mywindow.focus(); // necessary for IE >= 10
                    mywindow.print();
                    mywindow.close();
                } // /success function

            }); // /ajax function to fetch the printable order
        } // /if orderId
    } // /print order function
</script>
<script>
    $(document).ready(function() {
        $(".UpperCase").on("keypress", function() {
            $input = $(this);
            setTimeout(function() {
                $input.val($input.val().toUpperCase());
            }, 50);
        })
    })

    function obtener_caja(user_id) {
        $(".outer_div3").load("../modal/carga_caja.php?user_id=" + user_id); //carga desde el ajax
    }
</script>
<script>
    function showDiv(select) {
        if (select.value == 4) {
            $("#resultados3").load("../ajax/carga_prima.php");
        } else {
            $("#resultados3").load("../ajax/carga_resibido.php");
        }
    }
</script>

<?php require 'includes/footer_end.php'
?>