<?php 
include '../ajax/is_logged.php'; // Verifica si está logueado
?>
<style type="text/css" media="print">
    #Imprime {
        height: auto;
        width: 377px;
        margin: 0px;
        padding: 0px;
        float: left;
        font-family: "Verdana", cursive;
        font-size: 12px;
        color: #000;
    }
    @page {
        margin: 0;
    }
    /* Ocultar el botón cuando se imprima */
    .no-print {
        display: none !important;
    }
</style>

<style>
/* Estilo del botón solo en pantalla */
#printBtn {
    background: #007bff;
    border: none;
    color: #fff;
    padding: 6px 12px;
    border-radius: 4px;
    cursor: pointer;
    font-size: 14px;
    margin-bottom: 10px;
}
#printBtn:hover {
    background: #0056b3;
}
</style>

<?php
/* Conexión BD */
require_once "../db.php"; 
require_once "../php_conexion.php"; 
include "../funciones.php";

$simbolo_moneda = get_row('perfil', 'moneda', 'id_perfil', 1);

$id_factura = intval($_GET['id_factura']);
$factura_id = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST["id_factura"], ENT_QUOTES)));

/* Datos empresa */
$sql = mysqli_query($conexion, "SELECT * FROM perfil");
$rw  = mysqli_fetch_array($sql);
$bussines_name = $rw["nombre_empresa"];
$giro          = $rw["giro_empresa"];
$fiscal        = $rw["fiscal_empresa"];
$address       = $rw["direccion"];
$city          = $rw["ciudad"];
$state         = $rw["estado"];
$phone         = $rw["telefono"];

/* Datos factura */
$sql_factura    = mysqli_query($conexion, "SELECT * FROM facturas_ventas f, users u WHERE f.id_vendedor=u.id_users AND f.id_factura='".$factura_id."'");
$rw_factura     = mysqli_fetch_array($sql_factura);
$nombre_users   = $rw_factura['nombre_users'];
$fecha_factura  = date("d/m/Y", strtotime($rw_factura['fecha_factura']));
$hora_factura   = date('H:i:s', strtotime($rw_factura['fecha_factura']));
$numero_factura = $rw_factura['numero_factura'];
$resibido       = $rw_factura['recibido'];

/* Datos cliente */
$sql_cliente    = mysqli_query($conexion, "SELECT * FROM facturas_ventas f, clientes c WHERE f.id_cliente=c.id_cliente AND f.id_factura='".$factura_id."'");
$rw_cliente     = mysqli_fetch_array($sql_cliente);
$nombre_cliente = $rw_cliente['nombre_cliente'];
$telefono_cliente = $rw_cliente['telefono_cliente'];
?>

<!-- Botón para imprimir -->
<div class="no-print" style="text-align:right; margin:10px;">
    <button id="printBtn" onclick="window.print()">🖨️ Imprimir</button>
</div>

<div id="Imprime">
    <table width="100%" border="0">
        <tr>
            <td colspan="3" align="center">
                <div style="font-size:22px"><strong><?php echo $bussines_name; ?></strong></div>
                <div style="font-size:16px"><strong><?php echo $giro; ?></strong></div>
                <div style="font-size:14px"><strong>NIT: <?php echo $fiscal; ?></strong></div>
                <div style="font-size:14px;"><?php echo $address; ?></div>
                <div style="font-size:14px;"><?php echo $city . ' ' . $state; ?></div>
                <div style="font-size:14px;">Tel: <?php echo $phone; ?></div>
            </td>
        </tr>
        <tr><td colspan="3"><center>-----------------------------------------</center></td></tr>
        <tr>
            <td colspan="3">
                Ticket: <?php echo $numero_factura; ?><br>
                Cajero: <?php echo $nombre_users; ?><br>
                Fecha: <?php echo $fecha_factura . ' ' . $hora_factura; ?><br>
                Cliente: <?php echo $nombre_cliente; ?><br>
                Teléfono: <?php echo $telefono_cliente; ?><br>
            </td>
        </tr>
        <tr><td colspan="3"><center>==============================</center></td></tr>
        <tr>
            <td><strong>Cant.</strong></td>
            <td><strong>Descrip.</strong></td>
            <td><strong>Precio Total</strong></td>
        </tr>
        <tr><td colspan="3"><center>==============================</center></td></tr>

        <?php
        $nums          = 1;
        $impuesto      = get_row('perfil', 'impuesto', 'id_perfil', 1);
        $sumador_total = 0;
        $t_iva         = 0;

        $sql = mysqli_query($conexion, "SELECT * FROM productos p, detalle_fact_ventas d, facturas_ventas f 
                                        WHERE p.id_producto=d.id_producto 
                                        AND d.numero_factura=f.numero_factura 
                                        AND f.id_factura='".$factura_id."'");

        while ($row = mysqli_fetch_array($sql)) {
            $cantidad        = $row['cantidad'];
            $desc_tmp        = $row['desc_venta'];
            $nombre_producto = $row['nombre_producto'];

            $precio_venta   = $row['precio_venta'];
            $precio_total   = $precio_venta * $cantidad;
            $final_items    = rebajas($precio_total, $desc_tmp); 
            $precio_total_f = number_format($final_items, 2);
            $sumador_total += $final_items;
            ?>
            <tr>
                <td><?php echo $cantidad; ?></td>
                <td><?php echo $nombre_producto; ?></td>
                <td><?php echo $simbolo_moneda.' '.$precio_total_f; ?></td>
            </tr>
        <?php } 

        $subtotal      = number_format($sumador_total, 2, '.', '');
        $total_iva     = ($subtotal * $impuesto) / 100;
        $total_factura = $subtotal;
        $cambio        = $resibido - $total_factura;
        ?>
        <tr><td colspan="3"><center>-----------------------------------------</center></td></tr>
        <tr><td colspan="2">TOTAL:</td><td><?php echo $simbolo_moneda.' '.number_format($total_factura,2); ?></td></tr>
        <tr><td colspan="2">PAGO:</td><td><?php echo $simbolo_moneda.' '.number_format($resibido,2); ?></td></tr>
        <tr><td colspan="2">VUELTO:</td><td><?php echo $simbolo_moneda.' '.number_format($cambio,2); ?></td></tr>
        <tr><td colspan="3"><center>-----------------------------------------</center></td></tr>
        <tr><td colspan="3"><center>* GRACIAS POR SU COMPRA *</center></td></tr>
        <tr><td colspan="3"><center>* HORARIOS DE ATENCIÓN *</center></td></tr>
        <tr><td colspan="3"><center>LUNES A SÁBADO 8:00 AM - 6:00 PM</center></td></tr>
        <tr><td colspan="3"><center>DOMINGO 8:00 AM - 4:00 PM</center></td></tr>
    </table>
</div>
