<?php
include '../../ajax/is_logged.php';
?>
<style type="text/css" media="print">
    #Imprime {
        height: auto;
        width: 377px;
        margin: 0px;
        padding: 0px;
        float: left;
        font-family: 'Arial Black', 'Arial Bold', sans-serif;
        font-size: 14px;
        font-weight: bold;
        color: #000;
    }
    @page {
        margin: 0;
    }
    .ticket-container {
        width: 377px;
        font-size: 14px;
        font-family: 'Arial Black', 'Arial Bold', sans-serif;
    }
    .business-info {
        text-align: center;
        font-size: 16px;
        font-weight: bold;
    }
    .business-info strong {
        display: block;
        font-size: 18px;
    }
    .business-info .sub-info {
        font-size: 14px;
    }
    .divider {
        text-align: center;
        border-top: 1px dashed #000;
        margin: 10px 0;
    }
    .order-info {
        text-align: center;
        margin-top: 5px;
        font-size: 16px;
        font-weight: bold;
    }
    .totals {
        text-align: right;
        font-size: 14px;
        font-weight: bold;
    }
    .total-row {
        display: flex;
        justify-content: space-between;
        margin: 5px 0;
    }
    .total-row .label {
        flex: 2;
        text-align: left;
    }
    .total-row .value {
        flex: 1;
        text-align: right;
    }
</style>
<?php
/* Connect To Database*/
require_once "../../db.php";
require_once "../../php_conexion.php";
include "../../funciones.php";
$moneda = get_row('perfil', 'moneda', 'id_perfil', 1);
$id_caja = intval($_REQUEST['caja_id']);
$user_id = $_SESSION['id_users'];
$cargo_users = $_SESSION['cargo_users'];
$sucursal_users = $_SESSION['sucursal_users'];
$sucursal = get_row('sucursales', 'nombre_sucursal', 'id_sucursal', $sucursal_users);
/*Datos de la empresa*/
$sql           = mysqli_query($conexion, "SELECT * FROM perfil");
$rw            = mysqli_fetch_array($sql);
$moneda        = $rw["moneda"];
$bussines_name = $rw["nombre_empresa"];
$giro          = $rw["giro_empresa"];
$fiscal        = $rw["fiscal_empresa"];
$address       = $rw["direccion"];
$city          = $rw["ciudad"];
$state         = $rw["estado"];
//$postal_code   = $rw["codigo_postal"];
$phone         = $rw["telefono"];
$email         = $rw["email"];
$logo_url      = $rw["logo_url"];
$users         = intval($_SESSION['id_users']);
/*Fin datos empresa*/
$totalEfectivo = 0;
$totalTarjeta = 0;
$totalTrans = 0;
$totalDomicilio = 0;
$totalDonaciones = 0;
$totalVenta = 0;

$orderSql = "SELECT * FROM facturas_ventas WHERE control_caja = $id_caja ";
$orderQuery = $conexion->query($orderSql);
while ($row = $orderQuery->fetch_assoc()) {
    switch ($row['pago_codigo']) {
        case 1:
            $totalEfectivo += $row['monto_factura'];
            break;
        case 2:
            $totalTarjeta += $row['monto_factura'];
            break;
        case 5:
            $totalTrans += $row['monto_factura'];
            break;
        case 3:
            $totalDomicilio += $row['monto_factura'];
            break;
        case 6:
            $totalDonaciones += $row['monto_factura'];
            break;
    }
    $totalVenta += $row['monto_factura'];
}

$orderCompras = "SELECT SUM(monto_factura) AS total_compras FROM facturas_compras WHERE control_caja='$id_caja'";
$resultado = $conexion->query($orderCompras);
if ($resultado) {
    $row = $resultado->fetch_assoc();
    $totalCompras = floatval($row['total_compras']);  
} 
$totalAbonos = 0;
$orderAbonos = "SELECT SUM(abono) AS total_abono FROM creditos_abonos WHERE control_caja='$id_caja'";
$resultadoAbonos = $conexion->query($orderAbonos);
if ($resultadoAbonos) {
    $row = $resultadoAbonos->fetch_assoc();
    $totalAbonos = floatval($row['total_abono']);  
} 

// Preparar la consulta SQL para evitar inyección SQL
$orderEgreso = "SELECT SUM(monto_caja) AS total, operacion_caja 
                FROM caja_chica 
                WHERE control_caja = ? 
                GROUP BY operacion_caja";

$stmt = $conexion->prepare($orderEgreso);
$stmt->bind_param("s", $id_caja);
$stmt->execute();
$resul = $stmt->get_result();

// Inicializar variables
$totalIngreso = 0;
$totalSalida = 0;

// Procesar resultados correctamente
if ($resul) {
    while ($row = $resul->fetch_assoc()) {
        if ($row['operacion_caja'] == 1) {
            $totalIngreso += floatval($row['total']);
        } elseif ($row['operacion_caja'] == 0) {
            $totalSalida += floatval($row['total']);
        }
    }
}

// Calcular totales
$entrada = $totalIngreso;
$salidas = $totalCompras + $totalSalida;
$totalGeneral = ($totalVenta - $salidas)+$entrada+$totalAbonos;


$query = "SELECT `caja_id`,`num_caja`,`fecha`,`hora_ap`,`s_inicial`,`ing_efectivo`,`ing_cheque`,`ing_transf`,`egresos`,`h_cierre`,`total_caja`,`empleado_id`,`estado_caja`,`faltante`,`cambio` FROM `detalle_caja` WHERE caja_id=$id_caja";
$result = $conexion->query($query);
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $caja_id = $row["caja_id"];
    $num_caja = $row["num_caja"];
    $caja_inicial = $row["s_inicial"];
    $fecha = $row["fecha"];
    $hora_ap = $row["hora_ap"];
    $ing_efectivo = $row["ing_efectivo"];
    $ing_cheque = $row["ing_cheque"];
    $ing_transf = $row["ing_transf"];
    $egresos = $row["egresos"];
    $h_cierre = $row["h_cierre"];
    $total_caja = $row["total_caja"];
    $empleado_id = $row["empleado_id"];
    $estado_caja = $row["estado_caja"];
    $faltante = $row["faltante"];
    $cambio = $row["cambio"];
    $usuario = get_row('users', 'usuario_users', 'id_users', $empleado_id);
    if ($estado_caja > 0) {
        $estado = 'CERRADA';
    } else {
        $estado = 'APERTURADA';
    }

    $conexion->close();
?>
<page pageset='new' backtop='10mm' backbottom='10mm' backleft='20mm' backright='20mm' footer='page'>
<!DOCTYPE html>
<html>
<head>
    <title>Ticket de Corte de Caja</title>
</head>
<body>
<div class="ticket-container">

    <div class="business-info">
            <strong><?php echo $bussines_name; ?></strong>
            <div class="sub-info"><?php echo $giro; ?></div>
            <div class="sub-info">NIT: <?php echo $fiscal; ?></div>
            <div class="sub-info"><?php echo $address; ?></div>
            <div class="sub-info"><?php echo $city . ' ' . $state; ?></div>
            <div class="sub-info">Tel: <?php echo $phone; ?></div>
        </div>
    
    <div class="divider"></div>

    <div class="order-info">
        <h4>Ticket de Corte de Caja</h4>
    </div>

    <div class="divider"></div>

    <div class="totals">
        <div class="total-row">
            <div class="label">Fecha:</div>
            <div class="value"><?php echo $fecha; ?></div>
        </div>
        <div class="total-row">
            <div class="label">Hora Apertura:</div>
            <div class="value"><?php echo $hora_ap; ?></div>
        </div>
        <div class="total-row">
            <div class="label">Usuario:</div>
            <div class="value"><?php echo $usuario; ?></div>
        </div>

        <div class="divider"></div>

        <div class="total-row">
            <div class="label">Apertura Caja:</div>
            <div class="value"><?php echo $moneda.' '. formato($caja_inicial); ?></div>
        </div>
        <div class="total-row">
            <div class="label">Total Ventas:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalVenta); ?></div>
        </div>
        <div class="total-row">
            <div class="label">Ventas Efectivo:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalEfectivo); ?></div>
        </div>
        <div class="total-row">
            <div class="label">Ventas Tarjeta:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalTarjeta); ?></div>
        </div>
        <div class="total-row">
            <div class="label">Ventas Trans.:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalTrans); ?></div>
        </div>
        <div class="total-row">
            <div class="label">Abonos CxC.:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalAbonos); ?></div>
        </div>
      <!--  <div class="total-row">
            <div class="label">Domicilio.:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalDomicilio); ?></div>
        </div>
        <div class="total-row">
            <div class="label">Donaciones.:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalDonaciones); ?></div>
        </div>-->
        <div class="total-row">
            <div class="label">Efectivo Contado:</div>
            <div class="value"><?php echo $moneda.' '. formato($ing_efectivo); ?></div>
        </div>

        <div class="divider"></div>

        <div class="total-row">
            <div class="label">Total Compras:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalCompras); ?></div>
        </div>
        <div class="total-row">
            <div class="label">Total de Egresos:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalSalida); ?></div>
        </div>
        <div class="total-row">
            <div class="label">Total de Ingresos:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalIngreso); ?></div>
        </div>

        <div class="divider"></div>

        <div class="total-row">
            <div class="label">Cambio:</div>
            <div class="value"><?php echo $moneda.' '. formato($cambio); ?></div>
        </div>

        <div class="divider"></div>

        <div class="total-row">
            <div class="label">Total de Caja:</div>
            <div class="value"><?php echo $moneda.' '. formato($totalGeneral+$caja_inicial-$cambio); ?></div>
        </div>
        <div class="total-row">
            <div class="label">Faltante:</div>
            <div class="value"><?php echo $moneda.' '. formato($faltante); ?></div>
        </div>

        <div class="divider"></div>

        <div class="total-row">
            <div class="label">Hora de Cierre:</div>
            <div class="value"><?php echo $h_cierre; ?></div>
        </div>
        <div class="total-row">
            <div class="label">Estado de Caja:</div>
            <div class="value"><?php echo $estado; ?></div>
        </div>
    </div>
</div>
</body>
</html>
<?php
} else {
    echo "<script>alert('No se encontraron resultados para mostrar datos')</script>";
    echo "<script>window.close();</script>";
}
?>
</page>