<?php
session_start();
require '../config.php'; // Asegúrate de que este archivo configure la conexión PDO
require '../functions.php'; // Incluye funciones adicionales si las necesitas

// Verificar si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../clientes/crud_clientes.php');
    exit;
}

// Verificar si se ha recibido el id_cliente por GET
if (!isset($_GET['id_cliente']) || !filter_var($_GET['id_cliente'], FILTER_VALIDATE_INT)) {
    echo "<script>
            alert('No se ha especificado un cliente válido.');
            window.location.href = '../clientes/crud_clientes.php';
          </script>";
    exit;
}

$id_cliente = (int)$_GET['id_cliente']; // Asegurarse de que el ID sea un entero

// Consultar los detalles del cliente
try {
    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE id_cliente = :id_cliente");
    $stmt->bindParam(':id_cliente', $id_cliente, PDO::PARAM_INT);
    $stmt->execute();
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verificar si se encontró el cliente
    if (!$cliente) {
        echo "<script>
                alert('No se encontró un Cliente con el ID especificado.');
                window.location.href = '../clientes/crud_clientes.php';
              </script>";
        exit;
    }
} catch (PDOException $e) {
    echo "<script>
            alert('Error: " . $e->getMessage() . "');
            window.location.href = '../clientes/crud_clientes.php';
          </script>";
    exit;
}

// Obtener la lista de categorías de documentos
try {
    $stmt = $pdo->prepare("SELECT id_doc, descripcion FROM cat_documentos");
    $stmt->execute();
    $categorias = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "<script>
            alert('Error: " . $e->getMessage() . "');
            window.location.href = '../index.php';
          </script>";
    exit;
}

$_SESSION['id_cliente'] = $id_cliente;
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Archivos Rentas de Autos</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.5/dist/fullcalendar.min.css" rel="stylesheet">
     <!-- SweetAlert2 CSS -->
     <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <style>
        .main-content {
            padding: 2rem;
        }
       
        #calendar {
            max-width: 1100px;
            margin: 0 auto;
        }
        .card {
            margin-bottom: 20px;
        }
        .input-group .form-control {
            border-right: 0;
        }
        .input-group .input-group-append .btn {
            border-left: 0;
        }
        .form-inline .form-control {
            width: auto;
        }
    </style>
</head>
<body>
    <?php include '../menu.php'; ?>

    <div class="main-content">
        <div class="d-flex align-items-center justify-content-center p-3 my-3 text-white bg-dark rounded shadow-sm">
    <div class="lh-1 text-center">
        <h2 class="mb-4 text-center">
            <i class="fas fa-file-alt"></i> <!-- Icono de FontAwesome -->
            Documentos de Pacientes
        </h2>
    </div>
</div>

            <div class="row">
                <!-- Detalles del Cliente -->
                <div class="col-lg-4 mb-4">
                <div class="card">
                    <div class="card-body text-center">
                        <!-- Ícono grande de usuario -->
                        <i class="fa fa-user fa-5x"></i> <!-- Clase 'fa-5x' hace que el ícono sea grande -->

                        <h5 class="card-title mt-3"><?php echo $cliente['nombre'] . ' ' . $cliente['apellido']; ?></h5>
                        <a href="../clientes/crud_clientes.php" class="btn btn-primary mt-3">
                            <i class="fa fa-reply"></i> Regresar
                        </a>
                    </div>
                </div>


                    <!-- Filtros de búsqueda -->
                    <div class="card">
                        <div class="card-body">
                            <div class="form-group">
                                <input type="text" id="busquedaNombre" placeholder="Buscar por nombre del archivo" class="form-control">
                            </div>
                            <div class="form-group">
                                <select id="busquedaEstudios" class="form-control">
                                    <option value="">Selecciona categoría</option>
                                    <option value="">Todos</option>
                                    <?php foreach ($categorias as $categoria): ?>
                                        <option value="<?= $categoria['id_doc']; ?>"><?= $categoria['descripcion']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Lista de Archivos -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            Archivos
                        </div>
                        <div class="card-body">
                            <div class="form-group row">
                                <div class="col-xs-2">
                                    <button type="button" class="btn btn-success" data-toggle="modal" data-target="#myModal">
                                        <i class="fa fa-plus"></i> Nuevo Archivo
                                    </button>
                                </div>
                            </div>
                            <div id="archivos-lista" class="mt-3">
                                <!-- La lista de archivos se cargará aquí -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

                    <!-- Modal -->
                    <div class="modal fade" id="myModal">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">Subir Archivo</h4>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                </div>
                                <form id="formulario" enctype="multipart/form-data">
                                    <div class="modal-body">
                                        <div class="form-group">
                                            <input type="file" name="archivo" id="archivo" class="form-control-file" require>
                                        </div>
                                        <div class="form-group">
                                        <label for="editIDEstudios">Categoria de Estudios:</label>
                                        <select class="form-control" id="id_estudios" name="id_estudios">
                                                <?php
                                                try {
                                                    // Realiza la consulta a la base de datos para obtener los datos de la tabla cat_documentos
                                                    $stmt = $pdo->prepare("SELECT id_doc, descripcion FROM cat_documentos");
                                                    $stmt->execute();
                                                    $documentos = $stmt->fetchAll(PDO::FETCH_ASSOC);

                                                    // Verifica si hay resultados y crea las opciones del campo desplegable
                                                    if ($documentos) {
                                                        foreach ($documentos as $documento) {
                                                            echo "<option value='" . htmlspecialchars($documento['id_doc'], ENT_QUOTES, 'UTF-8') . "'>" 
                                                                . htmlspecialchars($documento['descripcion'], ENT_QUOTES, 'UTF-8') . "</option>";
                                                        }
                                                    } else {
                                                        // Manejar el caso en el que no hay resultados
                                                        echo "<option value=''>No se encontraron estudios</option>";
                                                    }
                                                } catch (PDOException $e) {
                                                    // Manejar errores de consulta
                                                    echo "<option value=''>Error al cargar estudios</option>";
                                                    error_log("Error al realizar la consulta: " . $e->getMessage());
                                                }
                                                ?>
                                            </select>

                                        </div>
                                        <div id="mensaje" class="alert" role="alert">
                                        </div>

                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" id="subir_datos" class="btn btn-primary">Subir</button>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

        
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.5/dist/fullcalendar.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
     <!-- SweetAlert2 JS -->
     <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script type="text/javascript" src="files.js"></script>
</body>
</html>
